/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.TailSuspendCalls;
import org.jetbrains.kotlin.backend.common.TailSuspendCallsCollectorKt;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrElementBuilder;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOriginImpl;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.TransformKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.MemoryOptimizedCollectionUtilKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 F*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0003FGHB\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H$J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H$J,\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018H$J\u001c\u0010\u001b\u001a\u00020\u0014*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fH$J\u001e\u0010 \u001a\u00020\u00142\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020%H$J\u001c\u0010&\u001a\u00020\u001f*\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u001fH\u0014J\u0010\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\n\u0012\u0004\u0012\u00020/\u0018\u00010\"2\u0006\u00100\u001a\u000201H\u0002J\f\u00102\u001a\u000203*\u000204H\u0004J\u001e\u00105\u001a\u00020\u00142\u0006\u00106\u001a\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u00020409H\u0002J\u0010\u0010?\u001a\u00020@2\u0006\u00106\u001a\u000207H\u0002J\"\u0010A\u001a\u00020\u001a*\u00020B2\u0006\u0010C\u001a\u00020\u000b2\u0006\u0010D\u001a\u00020)2\u0006\u0010E\u001a\u000203R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\n\u001a\u00020\u000bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010:\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020=X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering;", "C", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "stateMachineMethodName", "Lorg/jetbrains/kotlin/name/Name;", "getStateMachineMethodName", "()Lorg/jetbrains/kotlin/name/Name;", "getCoroutineBaseClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "nameForCoroutineClass", "buildStateMachine", "", "stateMachineFunction", "transformingFunction", "argumentToPropertiesMap", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "generateCoroutineStart", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder;", "invokeSuspendFunction", "receiver", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "initializeStateMachine", "coroutineConstructors", "", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "coroutineClassThis", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "generateDelegatedCall", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "expectedType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "delegatingCall", "lower", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "tryTransformSuspendFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "isReturnIfSuspendedCall", "", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "simplifyTailSuspendCalls", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "tailSuspendCalls", "", "symbols", "Lorg/jetbrains/kotlin/backend/common/ir/Symbols;", "getContinuationSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "continuationClassSymbol", "buildCoroutine", "Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$BuiltCoroutine;", "addField", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "name", "type", "isMutable", "Companion", "BuiltCoroutine", "CoroutineBuilder", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nAbstractSuspendFunctionsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractSuspendFunctionsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering\n+ 2 LowerUtils.kt\norg/jetbrains/kotlin/backend/common/lower/LowerUtilsKt\n+ 3 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBuilderKt\n+ 4 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n*L\n1#1,282:1\n96#2:283\n245#3,5:284\n76#4:289\n77#4:297\n1563#5:290\n1634#5,3:291\n1878#5,3:294\n74#6,4:298\n*S KotlinDebug\n*F\n+ 1 AbstractSuspendFunctionsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering\n*L\n117#1:283\n117#1:284,5\n117#1:289\n117#1:297\n120#1:290\n120#1:291,3\n124#1:294,3\n268#1:298,4\n*E\n"})
public abstract class AbstractSuspendFunctionsLowering<C extends CommonBackendContext>
implements FileLoweringPass {
    @NotNull
    protected static final Companion Companion = new Companion(null);
    @NotNull
    private final C context;
    @NotNull
    private final Symbols symbols;
    @NotNull
    private final IrSimpleFunctionSymbol getContinuationSymbol;
    @NotNull
    private final IrClassSymbol continuationClassSymbol;
    @NotNull
    private static final IrStatementOriginImpl STATEMENT_ORIGIN_COROUTINE_IMPL = new IrStatementOriginImpl("COROUTINE_IMPL");
    @NotNull
    private static final IrDeclarationOriginImpl DECLARATION_ORIGIN_COROUTINE_IMPL = new IrDeclarationOriginImpl("COROUTINE_IMPL", false, 2, null);

    public AbstractSuspendFunctionsLowering(@NotNull C context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        this.context = context;
        this.symbols = ((LoweringContext)this.context).getIr().getSymbols();
        this.getContinuationSymbol = this.symbols.getGetContinuation();
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrFail(((IrSimpleFunction)this.getContinuationSymbol.getOwner()).getReturnType());
        Intrinsics.checkNotNull((Object)irClassifierSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrClassSymbol");
        this.continuationClassSymbol = (IrClassSymbol)irClassifierSymbol;
    }

    @NotNull
    public final C getContext() {
        return this.context;
    }

    @NotNull
    protected abstract Name getStateMachineMethodName();

    @NotNull
    protected abstract IrClassSymbol getCoroutineBaseClass(@NotNull IrFunction var1);

    @NotNull
    protected abstract Name nameForCoroutineClass(@NotNull IrFunction var1);

    protected abstract void buildStateMachine(@NotNull IrFunction var1, @NotNull IrFunction var2, @NotNull Map<IrValueParameter, ? extends IrField> var3);

    protected abstract void generateCoroutineStart(@NotNull IrBlockBodyBuilder var1, @NotNull IrFunction var2, @NotNull IrExpression var3);

    protected abstract void initializeStateMachine(@NotNull List<? extends IrConstructor> var1, @NotNull IrValueDeclaration var2);

    @NotNull
    protected IrExpression generateDelegatedCall(@NotNull IrBuilderWithScope $this$generateDelegatedCall, @NotNull IrType expectedType, @NotNull IrExpression delegatingCall) {
        Intrinsics.checkNotNullParameter((Object)$this$generateDelegatedCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        Intrinsics.checkNotNullParameter((Object)delegatingCall, (String)"delegatingCall");
        return delegatingCall;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        TransformKt.transformDeclarationsFlat(irFile, (Function1<? super IrDeclaration, ? extends List<? extends IrDeclaration>>)((Function1)new Function1<IrElement, List<? extends IrDeclaration>>((Object)this){

            public final List<IrDeclaration> invoke(IrElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return AbstractSuspendFunctionsLowering.access$tryTransformSuspendFunction((AbstractSuspendFunctionsLowering)this.receiver, p0);
            }
        }));
        IrVisitorsKt.acceptVoid((IrElement)irFile, new IrVisitorVoid(this){
            final /* synthetic */ AbstractSuspendFunctionsLowering<C> this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                IrVisitorsKt.acceptChildrenVoid(element, this);
            }

            public void visitClass(IrClass declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                IrVisitorsKt.acceptChildrenVoid((IrElement)declaration, this);
                if (!Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)AbstractSuspendFunctionsLowering.Companion.getDECLARATION_ORIGIN_COROUTINE_IMPL())) {
                    TransformKt.transformDeclarationsFlat(declaration, (Function1<? super IrDeclaration, ? extends List<? extends IrDeclaration>>)((Function1)new Function1<IrElement, List<? extends IrDeclaration>>(this.this$0){

                        public final List<IrDeclaration> invoke(IrElement p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            return AbstractSuspendFunctionsLowering.access$tryTransformSuspendFunction((AbstractSuspendFunctionsLowering)this.receiver, p0);
                        }
                    }));
                }
            }
        });
    }

    private final List<IrDeclaration> tryTransformSuspendFunction(IrElement element) {
        List list;
        IrSimpleFunction irSimpleFunction = element instanceof IrSimpleFunction ? (IrSimpleFunction)element : null;
        if (irSimpleFunction == null) {
            return null;
        }
        IrSimpleFunction function = irSimpleFunction;
        if (!function.isSuspend() || function.getModality() == Modality.ABSTRACT) {
            return null;
        }
        TailSuspendCalls tailSuspendCalls = TailSuspendCallsCollectorKt.collectTailSuspendCalls(this.context, function);
        Set<IrCall> tailSuspendCalls2 = tailSuspendCalls.component1();
        boolean hasNotTailSuspendCalls = tailSuspendCalls.component2();
        if (hasNotTailSuspendCalls) {
            Object[] objectArray = new IrDeclaration[]{this.buildCoroutine(function).getClazz(), function};
            list = kotlin.collections.CollectionsKt.listOf((Object[])objectArray);
        } else {
            this.simplifyTailSuspendCalls(function, tailSuspendCalls2);
            list = null;
        }
        return list;
    }

    protected final boolean isReturnIfSuspendedCall(@NotNull IrCall $this$isReturnIfSuspendedCall) {
        Intrinsics.checkNotNullParameter((Object)$this$isReturnIfSuspendedCall, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isReturnIfSuspendedCall.getSymbol(), (Object)((LoweringContext)this.context).getIr().getSymbols().getReturnIfSuspended());
    }

    private final void simplifyTailSuspendCalls(IrSimpleFunction irFunction, Set<? extends IrCall> tailSuspendCalls) {
        if (tailSuspendCalls.isEmpty()) {
            return;
        }
        DeclarationIrBuilder irBuilder = LowerUtilsKt.createIrBuilder$default((LoweringContext)this.context, (IrSymbol)irFunction.getSymbol(), 0, 0, 6, null);
        IrBody irBody = irFunction.getBody();
        Intrinsics.checkNotNull((Object)irBody);
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(this, tailSuspendCalls, irBuilder, irFunction){
            final /* synthetic */ AbstractSuspendFunctionsLowering<C> this$0;
            final /* synthetic */ Set<IrCall> $tailSuspendCalls;
            final /* synthetic */ DeclarationIrBuilder $irBuilder;
            final /* synthetic */ IrSimpleFunction $irFunction;
            {
                this.this$0 = $receiver;
                this.$tailSuspendCalls = $tailSuspendCalls;
                this.$irBuilder = $irBuilder;
                this.$irFunction = $irFunction;
            }

            public IrExpression visitCall(IrCall expression) {
                IrExpression irExpression;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                if (this.this$0.isReturnIfSuspendedCall(expression)) {
                    E e = expression.getArguments().get(0);
                    Intrinsics.checkNotNull(e);
                    irExpression = (IrExpression)e;
                } else {
                    irExpression = expression;
                }
                IrExpression shortCut = irExpression;
                IrElementTransformerVoidKt.transformChildrenVoid(shortCut, this);
                return !IrUtilsKt.isSuspend(expression) || !this.$tailSuspendCalls.contains(expression) ? shortCut : (IrExpression)ExpressionHelpersKt.irReturn((IrBuilderWithScope)LowerUtilsKt.at((IrBuilder)this.$irBuilder, expression), this.this$0.generateDelegatedCall(this.$irBuilder, this.$irFunction.getReturnType(), shortCut));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final BuiltCoroutine buildCoroutine(IrSimpleFunction irFunction) {
        void $this$buildCoroutine_u24lambda_u244_u24lambda_u243_u24lambda_u242;
        Collection<IrType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$buildCoroutine_u24lambda_u244_u24lambda_u243;
        void this_$iv$iv$iv;
        void startOffset$iv$iv;
        void $this$irBlockBody$iv$iv;
        BuiltCoroutine builtCoroutine;
        BuiltCoroutine coroutine = builtCoroutine = new CoroutineBuilder(irFunction).build();
        boolean bl = false;
        DeclarationIrBuilder irBuilder = LowerUtilsKt.createIrBuilder((LoweringContext)this.context, (IrSymbol)irFunction.getSymbol(), irFunction.getStartOffset(), irFunction.getEndOffset());
        IrGeneratorWithScope $this$irBlockBody$iv = irBuilder;
        boolean $i$f$irBlockBody = false;
        IrGeneratorWithScope irGeneratorWithScope = $this$irBlockBody$iv;
        int n = ((IrElement)irFunction).getStartOffset();
        int endOffset$iv$iv = ((IrElement)irFunction).getEndOffset();
        boolean $i$f$irBlockBody2 = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
        boolean $i$f$blockBody = false;
        void var14_14 = this_$iv$iv$iv;
        IrSimpleFunction irSimpleFunction = irFunction;
        boolean bl2 = false;
        IrConstructor constructor = coroutine.getConstructor();
        Object object = irFunction.getTypeParameters();
        IrConstructorSymbol irConstructorSymbol = constructor.getSymbol();
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$buildCoroutine_u24lambda_u244_u24lambda_u243;
        IrFunction irFunction2 = coroutine.getStateMachineFunction();
        void var22_22 = $this$buildCoroutine_u24lambda_u244_u24lambda_u243;
        AbstractSuspendFunctionsLowering abstractSuspendFunctionsLowering = this;
        boolean $i$f$map22 = false;
        void var25_26 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(IrTypesKt.makeNullable(IrTypesKt.getDefaultType((IrTypeParameter)it)));
        }
        collection = (List)destination$iv$iv;
        Object $i$f$map22 = object = ExpressionHelpersKt.irCallConstructor(irBuilderWithScope, irConstructorSymbol, (List<? extends IrType>)collection);
        boolean bl4 = false;
        List<IrValueParameter> functionParameters = irFunction.getParameters();
        Iterable $this$forEachIndexed$iv = functionParameters;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void argument;
            int n2;
            if ((n2 = index$iv++) < 0) {
                kotlin.collections.CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter = (IrValueParameter)item$iv;
            int index = n2;
            boolean bl5 = false;
            $this$buildCoroutine_u24lambda_u244_u24lambda_u243_u24lambda_u242.getArguments().set(index, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildCoroutine_u24lambda_u244_u24lambda_u243, (IrValueDeclaration)argument));
        }
        $this$buildCoroutine_u24lambda_u244_u24lambda_u243_u24lambda_u242.getArguments().set(functionParameters.size(), ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildCoroutine_u24lambda_u244_u24lambda_u243, this.getContinuationSymbol, ((IrSimpleFunction)this.getContinuationSymbol.getOwner()).getReturnType(), kotlin.collections.CollectionsKt.listOf((Object)irFunction.getReturnType())));
        irBuilderWithScope = Unit.INSTANCE;
        abstractSuspendFunctionsLowering.generateCoroutineStart((IrBlockBodyBuilder)var22_22, irFunction2, (IrExpression)object);
        irSimpleFunction.setBody(this_$iv$iv$iv.doBuild());
        return builtCoroutine;
    }

    @NotNull
    public final IrField addField(@NotNull IrClass $this$addField, @NotNull Name name, @NotNull IrType type, boolean isMutable) {
        IrField irField;
        Intrinsics.checkNotNullParameter((Object)$this$addField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        IrClass klass = $this$addField;
        IrFactory $this$buildField$iv = $this$addField.getFactory();
        boolean $i$f$buildField = false;
        IrFieldBuilder $this$buildField_u24lambda_u244$iv = new IrFieldBuilder();
        boolean bl = false;
        IrFieldBuilder $this$addField_u24lambda_u245 = $this$buildField_u24lambda_u244$iv;
        boolean bl2 = false;
        $this$addField_u24lambda_u245.setStartOffset(klass.getStartOffset());
        $this$addField_u24lambda_u245.setEndOffset(klass.getEndOffset());
        $this$addField_u24lambda_u245.setOrigin(DECLARATION_ORIGIN_COROUTINE_IMPL);
        $this$addField_u24lambda_u245.setName(name);
        $this$addField_u24lambda_u245.setType(type);
        $this$addField_u24lambda_u245.setVisibility(DescriptorVisibilities.PRIVATE);
        $this$addField_u24lambda_u245.setFinal(!isMutable);
        IrField it = irField = DeclarationBuildersKt.buildField($this$buildField$iv, $this$buildField_u24lambda_u244$iv);
        boolean bl3 = false;
        it.setParent($this$addField);
        IrUtilsKt.addChild($this$addField, it);
        return irField;
    }

    public static final /* synthetic */ List access$tryTransformSuspendFunction(AbstractSuspendFunctionsLowering $this, IrElement element) {
        return $this.tryTransformSuspendFunction(element);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$BuiltCoroutine;", "", "clazz", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "stateMachineFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)V", "getClazz", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getConstructor", "()Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getStateMachineFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "ir.backend.common"})
    private static final class BuiltCoroutine {
        @NotNull
        private final IrClass clazz;
        @NotNull
        private final IrConstructor constructor;
        @NotNull
        private final IrFunction stateMachineFunction;

        public BuiltCoroutine(@NotNull IrClass clazz, @NotNull IrConstructor constructor, @NotNull IrFunction stateMachineFunction) {
            Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
            Intrinsics.checkNotNullParameter((Object)stateMachineFunction, (String)"stateMachineFunction");
            this.clazz = clazz;
            this.constructor = constructor;
            this.stateMachineFunction = stateMachineFunction;
        }

        @NotNull
        public final IrClass getClazz() {
            return this.clazz;
        }

        @NotNull
        public final IrConstructor getConstructor() {
            return this.constructor;
        }

        @NotNull
        public final IrFunction getStateMachineFunction() {
            return this.stateMachineFunction;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0084\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$Companion;", "", "<init>", "()V", "STATEMENT_ORIGIN_COROUTINE_IMPL", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "getSTATEMENT_ORIGIN_COROUTINE_IMPL", "()Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "DECLARATION_ORIGIN_COROUTINE_IMPL", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "getDECLARATION_ORIGIN_COROUTINE_IMPL", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "ir.backend.common"})
    protected static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IrStatementOriginImpl getSTATEMENT_ORIGIN_COROUTINE_IMPL() {
            return STATEMENT_ORIGIN_COROUTINE_IMPL;
        }

        @NotNull
        public final IrDeclarationOriginImpl getDECLARATION_ORIGIN_COROUTINE_IMPL() {
            return DECLARATION_ORIGIN_COROUTINE_IMPL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$CoroutineBuilder;", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)V", "getIrFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "functionParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "coroutineClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "coroutineClassThis", "continuationType", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "argumentToPropertiesMap", "", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "coroutineBaseClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "coroutineBaseClassConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "coroutineConstructors", "", "build", "Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$BuiltCoroutine;", "buildConstructor", "buildInvokeSuspendMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "stateMachineFunction", "ir.backend.common"})
    @SourceDebugExtension(value={"SMAP\nAbstractSuspendFunctionsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractSuspendFunctionsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$CoroutineBuilder\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 3 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 7 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 8 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n*L\n1#1,282:1\n50#2,4:283\n284#2,4:322\n238#2,4:345\n16#3:287\n16#3:326\n16#3:349\n16#3:353\n1634#4,2:288\n1636#4:291\n1285#4,2:292\n1299#4,4:294\n626#4,12:310\n1634#4,3:327\n1878#4,3:341\n1634#4,3:350\n1634#4,3:354\n1#5:290\n350#6,12:298\n427#7,10:330\n76#8:340\n77#8:344\n*S KotlinDebug\n*F\n+ 1 AbstractSuspendFunctionsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$CoroutineBuilder\n*L\n143#1:283,4\n185#1:322,4\n228#1:345,4\n152#1:287\n197#1:326\n246#1:349\n254#1:353\n152#1:288,2\n152#1:291\n162#1:292,2\n162#1:294,4\n174#1:310,12\n197#1:327,3\n214#1:341,3\n246#1:350,3\n254#1:354,3\n165#1:298,12\n207#1:330,10\n207#1:340\n207#1:344\n*E\n"})
    private final class CoroutineBuilder {
        @NotNull
        private final IrFunction irFunction;
        @NotNull
        private final List<IrValueParameter> functionParameters;
        @NotNull
        private final IrClass coroutineClass;
        @NotNull
        private final IrValueParameter coroutineClassThis;
        @NotNull
        private final IrSimpleType continuationType;
        @NotNull
        private final Map<IrValueParameter, IrField> argumentToPropertiesMap;
        @NotNull
        private final IrClassSymbol coroutineBaseClass;
        @NotNull
        private final IrConstructor coroutineBaseClassConstructor;
        @NotNull
        private final List<IrConstructor> coroutineConstructors;

        /*
         * WARNING - void declaration
         */
        public CoroutineBuilder(IrFunction irFunction) {
            void $this$single$iv;
            Sequence<IrConstructor> $this$associateWith$iv;
            Iterator $this$mapTo$iv$iv;
            void $this$memoryOptimizedMap$iv;
            AbstractSuspendFunctionsLowering $this$coroutineClass_u24lambda_u243;
            Object $this$buildClass$iv;
            void $this$coroutineClass_u24lambda_u240;
            Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
            this.irFunction = irFunction;
            this.functionParameters = this.irFunction.getParameters();
            IrFactory irFactory = ((LoweringContext)AbstractSuspendFunctionsLowering.this.getContext()).getIrFactory();
            Object object = AbstractSuspendFunctionsLowering.this;
            boolean $i$f$buildClass = false;
            Object $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
            boolean $i$a$-run-DeclarationBuildersKt$buildClass$2$iv22 = false;
            IrClassBuilder irClassBuilder = $this$buildClass_u24lambda_u241$iv;
            CoroutineBuilder coroutineBuilder = this;
            boolean $i$a$-buildClass-AbstractSuspendFunctionsLowering$CoroutineBuilder$coroutineClass$22 = false;
            $this$coroutineClass_u24lambda_u240.setStartOffset(this.irFunction.getStartOffset());
            $this$coroutineClass_u24lambda_u240.setEndOffset(this.irFunction.getEndOffset());
            $this$coroutineClass_u24lambda_u240.setOrigin(Companion.getDECLARATION_ORIGIN_COROUTINE_IMPL());
            $this$coroutineClass_u24lambda_u240.setName(((AbstractSuspendFunctionsLowering)object).nameForCoroutineClass(this.irFunction));
            $this$coroutineClass_u24lambda_u240.setVisibility(DescriptorVisibilities.PRIVATE);
            $this$buildClass$iv = DeclarationBuildersKt.buildClass((IrFactory)$this$buildClass$iv, (IrClassBuilder)$this$buildClass_u24lambda_u241$iv);
            object = $this$buildClass$iv;
            boolean bl = false;
            ((IrDeclarationBase)((Object)$this$coroutineClass_u24lambda_u243)).setParent(this.irFunction.getParent());
            IrUtilsKt.createThisReceiverParameter((IrClass)((Object)$this$coroutineClass_u24lambda_u243));
            $this$buildClass_u24lambda_u241$iv = this.irFunction.getTypeParameters();
            void $i$a$-run-DeclarationBuildersKt$buildClass$2$iv22 = $this$coroutineClass_u24lambda_u243;
            boolean $i$f$memoryOptimizedMap = false;
            Iterable $i$a$-buildClass-AbstractSuspendFunctionsLowering$CoroutineBuilder$coroutineClass$22 = (Iterable)$this$memoryOptimizedMap$iv;
            Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
            boolean $i$f$mapTo2 = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void typeParam;
                IrTypeParameter irTypeParameter;
                Object item$iv$iv = iterator.next();
                IrTypeParameter irTypeParameter2 = (IrTypeParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                IrTypeParameter $this$coroutineClass_u24lambda_u243_u24lambda_u242_u24lambda_u241 = irTypeParameter = IrUtilsKt.copyToWithoutSuperTypes$default((IrTypeParameter)typeParam, (IrTypeParametersContainer)((Object)$this$coroutineClass_u24lambda_u243), 0, null, 6, null);
                boolean bl3 = false;
                $this$coroutineClass_u24lambda_u243_u24lambda_u242_u24lambda_u241.setSuperTypes(MemoryOptimizedCollectionUtilKt.memoryOptimizedPlus($this$coroutineClass_u24lambda_u243_u24lambda_u242_u24lambda_u241.getSuperTypes(), typeParam.getSuperTypes()));
                collection.add(irTypeParameter);
            }
            $i$a$-run-DeclarationBuildersKt$buildClass$2$iv22.setTypeParameters(CollectionsKt.compactIfPossible((List)((List)destination$iv$iv)));
            coroutineBuilder.coroutineClass = $this$buildClass$iv;
            IrValueParameter irValueParameter = this.coroutineClass.getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter);
            this.coroutineClassThis = irValueParameter;
            $this$buildClass$iv = new IrType[]{this.irFunction.getReturnType()};
            this.continuationType = IrTypesKt.typeWith((IrClassifierSymbol)AbstractSuspendFunctionsLowering.this.continuationClassSymbol, $this$buildClass$iv);
            $this$buildClass$iv = this.functionParameters;
            $this$coroutineClass_u24lambda_u243 = AbstractSuspendFunctionsLowering.this;
            coroutineBuilder = this;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                IrValueParameter $i$f$mapTo2 = (IrValueParameter)element$iv$iv;
                Object t = element$iv$iv;
                Map map = result$iv;
                boolean bl4 = false;
                IrField irField = $this$coroutineClass_u24lambda_u243.addField(this.coroutineClass, it.getName(), it.getType(), false);
                map.put(t, irField);
            }
            coroutineBuilder.argumentToPropertiesMap = result$iv;
            this.coroutineBaseClass = AbstractSuspendFunctionsLowering.this.getCoroutineBaseClass(this.irFunction);
            $this$associateWith$iv = IrUtilsKt.getConstructors((IrClass)this.coroutineBaseClass.getOwner());
            coroutineBuilder = this;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrConstructor it = (IrConstructor)element$iv;
                boolean bl5 = false;
                if (!IrUtilsKt.hasShape$default(it, false, false, 0, 1, null, 23, null)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            coroutineBuilder.coroutineBaseClassConstructor = single$iv;
            this.coroutineConstructors = new ArrayList();
        }

        @NotNull
        public final IrFunction getIrFunction() {
            return this.irFunction;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BuiltCoroutine build() {
            void $this$single$iv;
            Object[] objectArray = new IrType[]{IrTypesKt.getDefaultType(this.coroutineBaseClass)};
            this.coroutineClass.setSuperTypes(kotlin.collections.CollectionsKt.mutableListOf((Object[])objectArray));
            IrConstructor coroutineConstructor = this.buildConstructor();
            Iterable iterable = IrUtilsKt.simpleFunctions((IrDeclarationContainer)((Object)this.coroutineBaseClass.getOwner()));
            AbstractSuspendFunctionsLowering abstractSuspendFunctionsLowering = AbstractSuspendFunctionsLowering.this;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)abstractSuspendFunctionsLowering.getStateMachineMethodName())) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            IrSimpleFunction superInvokeSuspendFunction = single$iv;
            IrSimpleFunction invokeSuspendMethod = this.buildInvokeSuspendMethod(superInvokeSuspendFunction, this.coroutineClass);
            IrUtilsKt.addFakeOverrides$default(this.coroutineClass, AbstractSuspendFunctionsLowering.this.getContext().getTypeSystem(), null, null, 6, null);
            AbstractSuspendFunctionsLowering.this.initializeStateMachine(this.coroutineConstructors, this.coroutineClassThis);
            return new BuiltCoroutine(this.coroutineClass, coroutineConstructor, invokeSuspendMethod);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final IrConstructor buildConstructor() {
            void $this$buildConstructor_u24lambda_u2412_u24lambda_u2411_u24lambda_u249;
            void $this$buildConstructor_u24lambda_u2412_u24lambda_u2411;
            IrDelegatingConstructorCall irDelegatingConstructorCall;
            void this_$iv$iv;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv;
            void $this$memoryOptimizedMap$iv;
            IrFactory $this$buildConstructor$iv = ((LoweringContext)AbstractSuspendFunctionsLowering.this.getContext()).getIrFactory();
            boolean $i$f$buildConstructor = false;
            IrFunctionBuilder $this$buildConstructor_u24lambda_u2424$iv = new IrFunctionBuilder();
            boolean bl = false;
            Object $this$buildConstructor_u24lambda_u247 = $this$buildConstructor_u24lambda_u2424$iv;
            boolean bl2 = false;
            ((IrElementBuilder)$this$buildConstructor_u24lambda_u247).setStartOffset(this.irFunction.getStartOffset());
            ((IrElementBuilder)$this$buildConstructor_u24lambda_u247).setEndOffset(this.irFunction.getEndOffset());
            ((IrDeclarationBuilder)$this$buildConstructor_u24lambda_u247).setOrigin(Companion.getDECLARATION_ORIGIN_COROUTINE_IMPL());
            ((IrDeclarationBuilder)$this$buildConstructor_u24lambda_u247).setVisibility(this.irFunction.getVisibility());
            ((IrFunctionBuilder)$this$buildConstructor_u24lambda_u247).setReturnType(IrUtilsKt.getDefaultType(this.coroutineClass));
            ((IrFunctionBuilder)$this$buildConstructor_u24lambda_u247).setPrimary(true);
            IrConstructor irConstructor = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv, $this$buildConstructor_u24lambda_u2424$iv);
            AbstractSuspendFunctionsLowering abstractSuspendFunctionsLowering = AbstractSuspendFunctionsLowering.this;
            IrConstructor $this$buildConstructor_u24lambda_u2412 = irConstructor;
            boolean bl3 = false;
            $this$buildConstructor_u24lambda_u2412.setParent(this.coroutineClass);
            ((Collection)this.coroutineClass.getDeclarations()).add($this$buildConstructor_u24lambda_u2412);
            ((Collection)this.coroutineConstructors).add($this$buildConstructor_u24lambda_u2412);
            $this$buildConstructor_u24lambda_u247 = this.functionParameters;
            IrConstructor irConstructor2 = $this$buildConstructor_u24lambda_u2412;
            boolean $i$f$memoryOptimizedMap = false;
            Iterable iterable = (Iterable)$this$memoryOptimizedMap$iv;
            Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void parameter;
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv2;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(IrUtilsKt.copyTo$default((IrValueParameter)parameter, $this$buildConstructor_u24lambda_u2412, Companion.getDECLARATION_ORIGIN_COROUTINE_IMPL(), 0, 0, null, null, null, null, null, false, false, false, IrParameterKind.Regular, 4092, null));
            }
            irConstructor2.setParameters(CollectionsKt.compactIfPossible((List)((List)destination$iv$iv)));
            IrValueParameter continuationParameter = this.coroutineBaseClassConstructor.getParameters().get(0);
            $this$buildConstructor_u24lambda_u2412.setParameters(MemoryOptimizedCollectionUtilKt.memoryOptimizedPlus($this$buildConstructor_u24lambda_u2412.getParameters(), (Object)IrUtilsKt.copyTo$default(continuationParameter, $this$buildConstructor_u24lambda_u2412, Companion.getDECLARATION_ORIGIN_COROUTINE_IMPL(), 0, 0, null, null, this.continuationType, null, null, false, false, false, null, 8124, null)));
            DeclarationIrBuilder irBuilder = LowerUtilsKt.createIrBuilder((LoweringContext)abstractSuspendFunctionsLowering.getContext(), (IrSymbol)$this$buildConstructor_u24lambda_u2412.getSymbol(), $this$buildConstructor_u24lambda_u2412.getStartOffset(), $this$buildConstructor_u24lambda_u2412.getEndOffset());
            IrBuilderWithScope $this$irBlockBody_u24default$iv = irBuilder;
            int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
            boolean $i$f$irBlockBody = false;
            item$iv$iv2 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            void bl4 = this_$iv$iv;
            irConstructor2 = $this$buildConstructor_u24lambda_u2412;
            boolean bl5 = false;
            IrValueParameter completionParameter = (IrValueParameter)kotlin.collections.CollectionsKt.last($this$buildConstructor_u24lambda_u2412.getParameters());
            IrDelegatingConstructorCall irDelegatingConstructorCall2 = irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$buildConstructor_u24lambda_u2412_u24lambda_u2411, this.coroutineBaseClassConstructor);
            void var20_28 = $this$buildConstructor_u24lambda_u2412_u24lambda_u2411;
            boolean bl6 = false;
            $this$buildConstructor_u24lambda_u2412_u24lambda_u2411_u24lambda_u249.getArguments().set(0, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildConstructor_u24lambda_u2412_u24lambda_u2411, completionParameter));
            var20_28.unaryPlus(irDelegatingConstructorCall);
            $this$buildConstructor_u24lambda_u2412_u24lambda_u2411.unaryPlus(BuildersKt.IrInstanceInitializerCallImpl($this$buildConstructor_u24lambda_u2412_u24lambda_u2411.getStartOffset(), $this$buildConstructor_u24lambda_u2412_u24lambda_u2411.getEndOffset(), this.coroutineClass.getSymbol(), $this$buildConstructor_u24lambda_u2412_u24lambda_u2411.getContext().getIrBuiltIns().getUnitType()));
            Iterable $this$forEachIndexed$iv = this.functionParameters;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void parameter;
                int n;
                if ((n = index$iv++) < 0) {
                    kotlin.collections.CollectionsKt.throwIndexOverflow();
                }
                IrValueParameter irValueParameter = (IrValueParameter)item$iv;
                int index = n;
                boolean bl7 = false;
                $this$buildConstructor_u24lambda_u2412_u24lambda_u2411.unaryPlus(ExpressionHelpersKt.irSetField$default((IrBuilderWithScope)$this$buildConstructor_u24lambda_u2412_u24lambda_u2411, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildConstructor_u24lambda_u2412_u24lambda_u2411, this.coroutineClassThis), (IrField)MapsKt.getValue(this.argumentToPropertiesMap, (Object)parameter), ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildConstructor_u24lambda_u2412_u24lambda_u2411, $this$buildConstructor_u24lambda_u2412.getParameters().get(index)), null, 8, null));
            }
            irConstructor2.setBody(this_$iv$iv.doBuild());
            return irConstructor;
        }

        /*
         * WARNING - void declaration
         */
        private final IrSimpleFunction buildInvokeSuspendMethod(IrSimpleFunction stateMachineFunction, IrClass coroutineClass) {
            Collection<IrValueParameter> collection;
            IrValueParameter parameter;
            Collection collection2;
            Iterable $this$mapTo$iv$iv;
            Collection $this$memoryOptimizedMap$iv;
            void $this$buildFun$iv;
            Object object = ((LoweringContext)AbstractSuspendFunctionsLowering.this.getContext()).getIrFactory();
            AbstractSuspendFunctionsLowering abstractSuspendFunctionsLowering = AbstractSuspendFunctionsLowering.this;
            boolean $i$f$buildFun = false;
            Object $this$buildFun_u24lambda_u2420$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$buildInvokeSuspendMethod_u24lambda_u2413 = $this$buildFun_u24lambda_u2420$iv;
            boolean $i$a$-buildFun-AbstractSuspendFunctionsLowering$CoroutineBuilder$buildInvokeSuspendMethod$function$22 = false;
            $this$buildInvokeSuspendMethod_u24lambda_u2413.setStartOffset(this.irFunction.getStartOffset());
            $this$buildInvokeSuspendMethod_u24lambda_u2413.setEndOffset(this.irFunction.getEndOffset());
            $this$buildInvokeSuspendMethod_u24lambda_u2413.setOrigin(Companion.getDECLARATION_ORIGIN_COROUTINE_IMPL());
            $this$buildInvokeSuspendMethod_u24lambda_u2413.setName(stateMachineFunction.getName());
            $this$buildInvokeSuspendMethod_u24lambda_u2413.setVisibility(stateMachineFunction.getVisibility());
            $this$buildInvokeSuspendMethod_u24lambda_u2413.setReturnType(((LoweringContext)abstractSuspendFunctionsLowering.getContext()).getIrBuiltIns().getAnyNType());
            $this$buildInvokeSuspendMethod_u24lambda_u2413.setInline(stateMachineFunction.isInline());
            $this$buildInvokeSuspendMethod_u24lambda_u2413.setExternal(stateMachineFunction.isExternal());
            $this$buildInvokeSuspendMethod_u24lambda_u2413.setTailrec(stateMachineFunction.isTailrec());
            $this$buildInvokeSuspendMethod_u24lambda_u2413.setSuspend(stateMachineFunction.isSuspend());
            $this$buildInvokeSuspendMethod_u24lambda_u2413.setOperator(false);
            $this$buildInvokeSuspendMethod_u24lambda_u2413.setExpect(stateMachineFunction.isExpect());
            $this$buildInvokeSuspendMethod_u24lambda_u2413.setFakeOverride(false);
            Object $this$buildInvokeSuspendMethod_u24lambda_u2417 = object = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u2420$iv);
            boolean bl2 = false;
            ((IrDeclarationBase)$this$buildInvokeSuspendMethod_u24lambda_u2417).setParent(coroutineClass);
            ((Collection)coroutineClass.getDeclarations()).add($this$buildInvokeSuspendMethod_u24lambda_u2417);
            $this$buildFun_u24lambda_u2420$iv = stateMachineFunction.getTypeParameters();
            Object object2 = $this$buildInvokeSuspendMethod_u24lambda_u2417;
            boolean $i$f$memoryOptimizedMap = false;
            Iterable $i$a$-buildFun-AbstractSuspendFunctionsLowering$CoroutineBuilder$buildInvokeSuspendMethod$function$22 = $this$memoryOptimizedMap$iv;
            Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IrTypeParameter irTypeParameter;
                IrTypeParameter irTypeParameter2 = (IrTypeParameter)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl3 = false;
                IrTypeParameter $this$buildInvokeSuspendMethod_u24lambda_u2417_u24lambda_u2415_u24lambda_u2414 = irTypeParameter = IrUtilsKt.copyToWithoutSuperTypes$default((IrTypeParameter)((Object)parameter), (IrTypeParametersContainer)$this$buildInvokeSuspendMethod_u24lambda_u2417, 0, Companion.getDECLARATION_ORIGIN_COROUTINE_IMPL(), 2, null);
                boolean bl4 = false;
                $this$buildInvokeSuspendMethod_u24lambda_u2417_u24lambda_u2415_u24lambda_u2414.setSuperTypes(MemoryOptimizedCollectionUtilKt.memoryOptimizedPlus($this$buildInvokeSuspendMethod_u24lambda_u2417_u24lambda_u2415_u24lambda_u2414.getSuperTypes(), ((IrTypeParameter)((Object)parameter)).getSuperTypes()));
                collection2.add(irTypeParameter);
            }
            object2.setTypeParameters(CollectionsKt.compactIfPossible((List)((List)destination$iv$iv)));
            ((IrFunction)$this$buildInvokeSuspendMethod_u24lambda_u2417).setParameters(kotlin.collections.CollectionsKt.plus((Collection)((IrFunction)$this$buildInvokeSuspendMethod_u24lambda_u2417).getParameters(), (Object)IrUtilsKt.createDispatchReceiverParameterWithClassParent$default((IrFunction)$this$buildInvokeSuspendMethod_u24lambda_u2417, null, 1, null)));
            $this$memoryOptimizedMap$iv = IrUtilsKt.getNonDispatchParameters(stateMachineFunction);
            collection2 = ((IrFunction)$this$buildInvokeSuspendMethod_u24lambda_u2417).getParameters();
            object2 = $this$buildInvokeSuspendMethod_u24lambda_u2417;
            $i$f$memoryOptimizedMap = false;
            $this$mapTo$iv$iv = $this$memoryOptimizedMap$iv;
            destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                parameter = (IrValueParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl5 = false;
                collection.add(IrUtilsKt.copyTo$default(parameter, (IrFunction)$this$buildInvokeSuspendMethod_u24lambda_u2417, Companion.getDECLARATION_ORIGIN_COROUTINE_IMPL(), 0, 0, null, null, null, null, null, false, false, false, null, 8188, null));
            }
            collection = CollectionsKt.compactIfPossible((List)((List)destination$iv$iv));
            ((IrFunction)object2).setParameters(kotlin.collections.CollectionsKt.plus((Collection)collection2, (Iterable)collection));
            ((IrSimpleFunction)$this$buildInvokeSuspendMethod_u24lambda_u2417).setOverriddenSymbols(MemoryOptimizedCollectionUtilKt.memoryOptimizedPlus(((IrSimpleFunction)$this$buildInvokeSuspendMethod_u24lambda_u2417).getOverriddenSymbols(), (Object)stateMachineFunction.getSymbol()));
            Object function = object;
            AbstractSuspendFunctionsLowering.this.buildStateMachine((IrFunction)function, this.irFunction, this.argumentToPropertiesMap);
            return function;
        }
    }
}

