/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.XTestCompositeNode;
import com.intellij.xdebugger.XTestContainer;
import com.intellij.xdebugger.XTestEvaluationCallback;
import com.intellij.xdebugger.XTestValueNode;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.frame.XStackFrameContainerEx;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.Promise;
import org.junit.Assert;

@TestOnly
public class XDebuggerTestUtil {
    public static final int TIMEOUT_MS = 25000;

    XDebuggerTestUtil() {
    }

    public static List<? extends XLineBreakpointType.XLineBreakpointVariant> computeLineBreakpointVariants(Project project, VirtualFile file, int line) {
        return XDebuggerTestUtil.computeLineBreakpointVariants(project, file, line, 0);
    }

    public static List<? extends XLineBreakpointType.XLineBreakpointVariant> computeLineBreakpointVariants(Project project, VirtualFile file, int line, int column) {
        return (List)ReadAction.compute(() -> {
            List types = (List)((StreamEx)StreamEx.of((Object[])XDebuggerUtil.getInstance().getLineBreakpointTypes()).filter(type -> type.canPutAt(file, line, project))).collect(Collectors.toCollection(SmartList::new));
            return XDebuggerUtilImpl.getLineBreakpointVariantsSync((Project)project, (List)types, (XSourcePosition)XSourcePositionImpl.create((VirtualFile)file, (int)line, (int)column));
        });
    }

    @Nullable
    public static XLineBreakpoint toggleBreakpoint(Project project, VirtualFile file, int line) {
        XDebuggerUtilImpl debuggerUtil = (XDebuggerUtilImpl)XDebuggerUtil.getInstance();
        Promise breakpointPromise = (Promise)WriteAction.computeAndWait(() -> debuggerUtil.toggleAndReturnLineBreakpoint(project, file, line, false));
        try {
            return (XLineBreakpoint)breakpointPromise.blockingGet(25000);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public static <P extends XBreakpointProperties> XBreakpoint<P> insertBreakpoint(Project project, P properties, Class<? extends XBreakpointType<XBreakpoint<P>, P>> typeClass) {
        return XDebuggerManager.getInstance((Project)project).getBreakpointManager().addBreakpoint((XBreakpointType)XBreakpointType.EXTENSION_POINT_NAME.findExtension(typeClass), properties);
    }

    public static void removeBreakpoint(@NotNull Project project, @NotNull VirtualFile file, int line) {
        if (project == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(1);
        }
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
        WriteAction.runAndWait(() -> {
            XLineBreakpoint breakpoint = Arrays.stream(XDebuggerUtil.getInstance().getLineBreakpointTypes()).map(t -> breakpointManager.findBreakpointAtLine(t, file, line)).filter(Predicates.nonNull()).findFirst().orElse(null);
            Assert.assertNotNull((Object)breakpoint);
            breakpointManager.removeBreakpoint((XBreakpoint)breakpoint);
        });
    }

    @Nullable
    public static XExecutionStack getActiveThread(@NotNull XDebugSession session) {
        if (session == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(2);
        }
        return session.getSuspendContext().getActiveExecutionStack();
    }

    public static List<XExecutionStack> collectThreads(@NotNull XDebugSession session) {
        if (session == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(3);
        }
        return XDebuggerTestUtil.collectThreads(session, 25000);
    }

    public static List<XExecutionStack> collectThreads(@NotNull XDebugSession session, int timeoutMs) {
        if (session == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(4);
        }
        return (List)XDebuggerTestUtil.collectThreadsWithErrors((XDebugSession)session, (int)timeoutMs).first;
    }

    public static Pair<List<XExecutionStack>, String> collectThreadsWithErrors(@NotNull XDebugSession session) {
        if (session == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(5);
        }
        return XDebuggerTestUtil.collectThreadsWithErrors(session, 25000);
    }

    public static Pair<List<XExecutionStack>, String> collectThreadsWithErrors(@NotNull XDebugSession session, int timeoutMs) {
        if (session == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(6);
        }
        XTestExecutionStackContainer container = new XTestExecutionStackContainer();
        session.getSuspendContext().computeExecutionStacks((XSuspendContext.XExecutionStackContainer)container);
        return container.waitFor(timeoutMs);
    }

    public static List<XStackFrame> collectFrames(@NotNull XDebugSession session) {
        if (session == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(7);
        }
        return XDebuggerTestUtil.collectFrames(null, session);
    }

    public static List<XStackFrame> collectFrames(@Nullable XExecutionStack thread, @NotNull XDebugSession session) {
        if (session == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(8);
        }
        return XDebuggerTestUtil.collectFrames(thread == null ? Objects.requireNonNull(XDebuggerTestUtil.getActiveThread(session)) : thread);
    }

    public static String getFramePresentation(XStackFrame frame) {
        TextTransferable.ColoredStringBuilder builder = new TextTransferable.ColoredStringBuilder();
        frame.customizePresentation((ColoredTextContainer)builder);
        return builder.getBuilder().toString();
    }

    public static List<XStackFrame> collectFrames(@NotNull XExecutionStack thread) {
        if (thread == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(9);
        }
        return XDebuggerTestUtil.collectFrames(thread, 50000L);
    }

    public static List<XStackFrame> collectFrames(XExecutionStack thread, long timeout) {
        return (List)XDebuggerTestUtil.collectFramesWithError((XExecutionStack)thread, (long)timeout).first;
    }

    public static Pair<List<XStackFrame>, String> collectFramesWithError(XExecutionStack thread, long timeout) {
        XTestStackFrameContainer container = new XTestStackFrameContainer();
        thread.computeStackFrames(0, (XExecutionStack.XStackFrameContainer)container);
        return container.waitFor(timeout);
    }

    public static Pair<List<XStackFrame>, XStackFrame> collectFramesWithSelected(@NotNull XDebugSession session, long timeout) {
        if (session == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(10);
        }
        return XDebuggerTestUtil.collectFramesWithSelected(Objects.requireNonNull(XDebuggerTestUtil.getActiveThread(session)), timeout);
    }

    public static Pair<List<XStackFrame>, XStackFrame> collectFramesWithSelected(XExecutionStack thread, long timeout) {
        XTestStackFrameContainer container = new XTestStackFrameContainer();
        thread.computeStackFrames(0, (XExecutionStack.XStackFrameContainer)container);
        List all = (List)container.waitFor((long)timeout).first;
        return Pair.create((Object)all, (Object)container.frameToSelect);
    }

    public static XStackFrame getFrameAt(@NotNull XDebugSession session, int frameIndex) {
        if (session == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(11);
        }
        return XDebuggerTestUtil.getFrameAt(Objects.requireNonNull(XDebuggerTestUtil.getActiveThread(session)), frameIndex);
    }

    public static XStackFrame getFrameAt(@NotNull XExecutionStack thread, int frameIndex) {
        if (thread == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(12);
        }
        return frameIndex == 0 ? thread.getTopFrame() : XDebuggerTestUtil.collectFrames(thread).get(frameIndex);
    }

    @NotNull
    public static List<XValue> collectChildren(XValueContainer value2) {
        List<XValue> list = new XTestCompositeNode(value2).collectChildren();
        if (list == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public static Pair<List<XValue>, String> collectChildrenWithError(XValueContainer value2) {
        Pair<List<XValue>, String> pair = new XTestCompositeNode(value2).collectChildrenWithError();
        if (pair == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(14);
        }
        return pair;
    }

    public static Pair<XValue, String> evaluate(XDebugSession session, XExpression expression) {
        return XDebuggerTestUtil.evaluate(session, expression, 25000L);
    }

    public static Pair<XValue, String> evaluate(XDebugSession session, String expression) {
        return XDebuggerTestUtil.evaluate(session, (XExpression)XExpressionImpl.fromText((String)expression), 25000L);
    }

    public static Pair<XValue, String> evaluate(XDebugSession session, String expression, long timeout) {
        return XDebuggerTestUtil.evaluate(session, (XExpression)XExpressionImpl.fromText((String)expression), timeout);
    }

    private static Pair<XValue, String> evaluate(XDebugSession session, XExpression expression, long timeout) {
        XStackFrame frame = session.getCurrentStackFrame();
        Assert.assertNotNull((Object)frame);
        XDebuggerEvaluator evaluator = frame.getEvaluator();
        Assert.assertNotNull((Object)evaluator);
        XTestEvaluationCallback callback = new XTestEvaluationCallback();
        evaluator.evaluate(expression, (XDebuggerEvaluator.XEvaluationCallback)callback, session.getCurrentPosition());
        return callback.waitFor(timeout);
    }

    public static void waitForSwing() throws InterruptedException {
        Semaphore s = new Semaphore();
        s.down();
        ApplicationManager.getApplication().invokeLater(() -> s.up());
        s.waitForUnsafe();
        UIUtil.invokeAndWaitIfNeeded(() -> {});
    }

    @NotNull
    public static XValue findVar(Collection<? extends XValue> vars, String name) {
        StringBuilder names = new StringBuilder();
        for (XValue xValue : vars) {
            if (!(xValue instanceof XNamedValue)) continue;
            String eachName = ((XNamedValue)xValue).getName();
            if (eachName.equals(name)) {
                XValue xValue2 = xValue;
                if (xValue2 == null) {
                    XDebuggerTestUtil.$$$reportNull$$$0(15);
                }
                return xValue2;
            }
            if (!names.isEmpty()) {
                names.append(", ");
            }
            names.append(eachName);
        }
        throw new AssertionError((Object)("var '" + name + "' not found among " + names));
    }

    public static XTestValueNode computePresentation(@NotNull XValue value2) {
        if (value2 == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(16);
        }
        return XDebuggerTestUtil.computePresentation(value2, 25000L);
    }

    public static XTestValueNode computePresentation(XValue value2, long timeout) {
        XTestValueNode node = new XTestValueNode();
        if (value2 instanceof XNamedValue) {
            node.myName = ((XNamedValue)value2).getName();
        }
        value2.computePresentation((XValueNode)node, XValuePlace.TREE);
        node.waitFor(timeout);
        return node;
    }

    @Nullable
    public static <T> T waitFor(@NotNull Future<T> future, long timeoutInMillis) {
        if (future == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(17);
        }
        return XDebuggerTestUtil.waitFor(remaining -> {
            try {
                return future.get((long)remaining, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                throw new InterruptedException();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause != null) {
                    ExceptionUtil.rethrow((Throwable)cause);
                }
                throw new RuntimeException(e);
            }
        }, timeoutInMillis);
    }

    public static boolean waitFor(@NotNull java.util.concurrent.Semaphore semaphore, long timeoutInMillis) {
        if (semaphore == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(18);
        }
        return XDebuggerTestUtil.waitFor(remaining -> {
            if (semaphore.tryAcquire((long)remaining, TimeUnit.MILLISECONDS)) {
                return true;
            }
            throw new InterruptedException();
        }, timeoutInMillis) == Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static <T> T waitFor(@NotNull ThrowableConvertor<? super Long, T, ? extends InterruptedException> waitFunction, long timeoutInMillis) {
        if (waitFunction == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(19);
        }
        long end = System.currentTimeMillis() + timeoutInMillis;
        XDebuggerTestUtil.flushEventQueue();
        long remaining = timeoutInMillis;
        while (remaining > 0L) {
            try {
                Object object = waitFunction.convert((Object)Math.min(10L, remaining));
                return (T)object;
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                XDebuggerTestUtil.flushEventQueue();
            }
            remaining = end - System.currentTimeMillis();
        }
        return null;
    }

    public static void markValue(XValueMarkers<?, ?> markers, @NotNull XValue value2, @NotNull ValueMarkup markup) {
        if (value2 == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(20);
        }
        if (markup == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(21);
        }
        try {
            markers.markValue(value2, markup).blockingGet(25000);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    private static void flushEventQueue() {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            UIUtil.dispatchAllInvocationEvents();
        } else {
            UIUtil.pump();
        }
    }

    @NotNull
    public static String getConsoleText(@NotNull ConsoleViewImpl consoleView) {
        if (consoleView == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(22);
        }
        WriteAction.runAndWait(() -> consoleView.flushDeferredText());
        String string = consoleView.getEditor().getDocument().getText();
        if (string == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    public static <T extends XBreakpointType> XBreakpoint addBreakpoint(@NotNull Project project, @NotNull Class<T> exceptionType, @NotNull XBreakpointProperties properties) {
        if (project == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(24);
        }
        if (exceptionType == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(25);
        }
        if (properties == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(26);
        }
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
        Ref breakpoint = Ref.create(null);
        XBreakpointUtil.breakpointTypes().select(exceptionType).findFirst().ifPresent(type -> breakpoint.set((Object)breakpointManager.addBreakpoint(type, properties)));
        return (XBreakpoint)breakpoint.get();
    }

    public static void removeAllBreakpoints(@NotNull Project project) {
        if (project == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(27);
        }
        XDebuggerUtilImpl.removeAllBreakpoints((Project)project);
    }

    public static XBreakpoint<?>[] getBreakpoints(XBreakpointManager breakpointManager) {
        return breakpointManager.getAllBreakpoints();
    }

    public static <B extends XBreakpoint<?>> void setDefaultBreakpointEnabled(@NotNull Project project, Class<? extends XBreakpointType<B, ?>> bpTypeClass, boolean enabled) {
        if (project == null) {
            XDebuggerTestUtil.$$$reportNull$$$0(28);
        }
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
        XBreakpointType bpType = XDebuggerUtil.getInstance().findBreakpointType(bpTypeClass);
        Set defaultBreakpoints = breakpointManager.getDefaultBreakpoints(bpType);
        for (XBreakpoint defaultBreakpoint : defaultBreakpoints) {
            defaultBreakpoint.setEnabled(enabled);
        }
    }

    public static void setBreakpointCondition(Project project, int line, String condition) {
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
        for (XBreakpoint<?> breakpoint : XDebuggerTestUtil.getBreakpoints(breakpointManager)) {
            XLineBreakpoint lineBreakpoint;
            if (!(breakpoint instanceof XLineBreakpoint) || (lineBreakpoint = (XLineBreakpoint)breakpoint).getLine() != line) continue;
            WriteAction.runAndWait(() -> lineBreakpoint.setCondition(condition));
        }
    }

    public static void setBreakpointLogExpression(Project project, int line, String logExpression) {
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
        for (XBreakpoint<?> breakpoint : XDebuggerTestUtil.getBreakpoints(breakpointManager)) {
            XLineBreakpoint lineBreakpoint;
            if (!(breakpoint instanceof XLineBreakpoint) || (lineBreakpoint = (XLineBreakpoint)breakpoint).getLine() != line) continue;
            WriteAction.runAndWait(() -> {
                lineBreakpoint.setLogExpression(logExpression);
                lineBreakpoint.setLogMessage(true);
            });
        }
    }

    public static void disposeDebugSession(XDebugSession debugSession) {
        WriteAction.runAndWait(() -> {
            XDebugSessionImpl session = (XDebugSessionImpl)debugSession;
            Disposer.dispose((Disposable)session.getSessionTab());
            Disposer.dispose((Disposable)session.getConsoleView());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 14, 15, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/XDebuggerTestUtil";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semaphore";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "waitFunction";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markup";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/XDebuggerTestUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "collectChildren";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectChildrenWithError";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findVar";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "removeBreakpoint";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getActiveThread";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectThreads";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectThreadsWithErrors";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectFrames";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectFramesWithSelected";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFrameAt";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 23: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "computePresentation";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "waitFor";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "markValue";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleText";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addBreakpoint";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "removeAllBreakpoints";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultBreakpointEnabled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 14, 15, 23 -> new IllegalStateException(string);
        };
    }

    public static class XTestExecutionStackContainer
    extends XTestContainer<XExecutionStack>
    implements XSuspendContext.XExecutionStackContainer {
        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                XTestExecutionStackContainer.$$$reportNull$$$0(0);
            }
            this.setErrorMessage(errorMessage);
        }

        public void addExecutionStack(@NotNull List<? extends XExecutionStack> executionStacks, boolean last) {
            if (executionStacks == null) {
                XTestExecutionStackContainer.$$$reportNull$$$0(1);
            }
            this.addChildren(executionStacks, last);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executionStacks";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/XDebuggerTestUtil$XTestExecutionStackContainer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "errorOccurred";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addExecutionStack";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class XTestStackFrameContainer
    extends XTestContainer<XStackFrame>
    implements XStackFrameContainerEx {
        public volatile XStackFrame frameToSelect;

        public void addStackFrames(@NotNull List<? extends XStackFrame> stackFrames, boolean last) {
            if (stackFrames == null) {
                XTestStackFrameContainer.$$$reportNull$$$0(0);
            }
            this.addChildren(stackFrames, last);
        }

        public void addStackFrames(@NotNull List<? extends XStackFrame> stackFrames, @Nullable XStackFrame toSelect, boolean last) {
            if (stackFrames == null) {
                XTestStackFrameContainer.$$$reportNull$$$0(1);
            }
            if (toSelect != null) {
                this.frameToSelect = toSelect;
            }
            this.addChildren(stackFrames, last);
        }

        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                XTestStackFrameContainer.$$$reportNull$$$0(2);
            }
            this.setErrorMessage(errorMessage);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stackFrames";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/XDebuggerTestUtil$XTestStackFrameContainer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addStackFrames";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "errorOccurred";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class XTestNavigatable
    implements XNavigatable {
        private XSourcePosition myPosition;

        public void setSourcePosition(@Nullable XSourcePosition sourcePosition) {
            this.myPosition = sourcePosition;
        }

        public XSourcePosition getPosition() {
            return this.myPosition;
        }
    }
}

