/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.analysis.AnalysisScope;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPassFactory;
import com.intellij.codeInsight.highlighting.actions.HighlightUsagesAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.IntentionSource;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.IntentionListStep;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewDiffResult;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewPopupUpdateProcessor;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.actions.CleanupInspectionIntention;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.find.FindManager;
import com.intellij.find.actions.SearchTarget2UsageTarget;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerBase;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.api.UsageOptions;
import com.intellij.find.usages.impl.AllSearchOptions;
import com.intellij.find.usages.impl.ImplKt;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.searcheverywhere.ClassSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SymbolSearchEverywhereContributor;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.mock.MockProgressIndicator;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.impl.ReferencesKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SchemeMetaInfo;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ProjectRootManagerComponent;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryTableTracker;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.vfs.impl.VirtualFilePointerTracker;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.transformer.TextPresentationTransformers;
import com.intellij.platform.testFramework.core.FileComparisonFailedError;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.StubTextInconsistencyException;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.api.RenameTarget;
import com.intellij.refactoring.rename.impl.RenameKt;
import com.intellij.testFramework.EditorTestUtil;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.ExpectedHighlightingData;
import com.intellij.testFramework.FileTreeAccessFilter;
import com.intellij.testFramework.HeavyPlatformTestCase;
import com.intellij.testFramework.HighlightTestInfo;
import com.intellij.testFramework.IndexingTestUtil;
import com.intellij.testFramework.InspectionTestUtil;
import com.intellij.testFramework.InspectionsKt;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.TestActionEvent;
import com.intellij.testFramework.TestDataFile;
import com.intellij.testFramework.TreeNodeTester;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.CodeInsightTestUtil;
import com.intellij.testFramework.fixtures.EditorTestFixture;
import com.intellij.testFramework.fixtures.HeavyIdeaTestFixture;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.testFramework.fixtures.impl.GlobalInspectionContextForTests;
import com.intellij.testFramework.fixtures.impl.LightTempDirTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.TempDirTestFixtureImpl;
import com.intellij.testFramework.utils.inlays.CaretAndInlaysInfo;
import com.intellij.testFramework.utils.inlays.InlayHintsChecker;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.ref.Reference;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.tree.TreeNode;
import kotlin.UninitializedPropertyAccessException;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;
import org.junit.Assert;

@TestOnly
public class CodeInsightTestFixtureImpl
extends BaseFixture
implements CodeInsightTestFixture {
    private static final Logger LOG = Logger.getInstance(CodeInsightTestFixtureImpl.class);
    private static final com.intellij.util.Function<IntentionAction, String> INTENTION_NAME_FUN = intentionAction -> "\"" + intentionAction.getText() + "\"";
    private static final String RAINBOW = "rainbow";
    private static final String FOLD = "fold";
    private final IdeaProjectTestFixture myProjectFixture;
    private final TempDirTestFixture myTempDirFixture;
    private PsiManagerImpl myPsiManager;
    private VirtualFile myFile;
    private PsiFile myPsiFile;
    private PsiFile[] myAllPsiFiles;
    private Editor editor;
    private EditorTestFixture myEditorTestFixture;
    private String myTestDataPath;
    private VirtualFileFilter myVirtualFileFilter;
    private boolean myAllowDirt;
    private boolean caresAboutInjection;
    private boolean myReadEditorMarkupModel;
    private VirtualFilePointerTracker myVirtualFilePointerTracker;
    private LibraryTableTracker myLibraryTableTracker;
    private SelectionAndCaretMarkupApplyPolicy mySelectionAndCaretMarkupApplyPolicy;

    public CodeInsightTestFixtureImpl(@NotNull IdeaProjectTestFixture projectFixture2, @NotNull TempDirTestFixture tempDirTestFixture) {
        if (projectFixture2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(0);
        }
        if (tempDirTestFixture == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(1);
        }
        this.myVirtualFileFilter = new FileTreeAccessFilter();
        this.caresAboutInjection = true;
        this.mySelectionAndCaretMarkupApplyPolicy = SelectionAndCaretMarkupApplyPolicy.UPDATE_FILE_AND_KEEP_DOCUMENT_CLEAN;
        this.myProjectFixture = projectFixture2;
        this.myTempDirFixture = tempDirTestFixture;
    }

    private void setFileAndEditor(@NotNull VirtualFile file, @NotNull Editor editor2) {
        if (file == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(3);
        }
        this.myFile = file;
        this.editor = editor2;
        this.myEditorTestFixture = new EditorTestFixture(this.getProject(), editor2, file);
        this.myPsiFile = (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findFile(this.myFile));
    }

    private void clearFileAndEditor() {
        this.myFile = null;
        this.editor = null;
        this.myEditorTestFixture = null;
        this.myPsiFile = null;
        this.myAllPsiFiles = null;
    }

    private static void addGutterIconRenderer(GutterMark renderer, int offset, @NotNull Map<? super Integer, List<GutterMark>> result) {
        if (result == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(4);
        }
        if (renderer == null) {
            return;
        }
        List renderers = result.computeIfAbsent((Integer)offset, __ -> new SmartList());
        renderers.add(renderer);
    }

    private static @Unmodifiable @NotNull List<HighlightInfo> removeDuplicatedRangesForInjected(@NotNull List<HighlightInfo> infos) {
        if (infos == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(5);
        }
        infos = new ArrayList<HighlightInfo>(infos);
        infos.sort((o1, o2) -> {
            int i2 = o1.startOffset - o2.startOffset;
            return i2 != 0 ? i2 : o1.getSeverity().myVal - o2.getSeverity().myVal;
        });
        HighlightInfo prevInfo = null;
        Iterator<HighlightInfo> it = infos.iterator();
        while (it.hasNext()) {
            HighlightInfo info = it.next();
            if (prevInfo != null && info.getSeverity() == HighlightInfoType.SYMBOL_TYPE_SEVERITY && info.getDescription() == null && info.startOffset == prevInfo.startOffset && info.endOffset == prevInfo.endOffset) {
                it.remove();
            }
            prevInfo = info.type == HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT ? info : null;
        }
        List<HighlightInfo> list = infos;
        if (list == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @TestOnly
    @NotNull
    public static @Unmodifiable List<HighlightInfo> instantiateAndRun(@NotNull PsiFile file, @NotNull Editor editor2, int @NotNull [] toIgnore, boolean canChangeDocument) {
        if (file == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(7);
        }
        if (editor2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(8);
        }
        if (toIgnore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(9);
        }
        return CodeInsightTestFixtureImpl.instantiateAndRun(file, editor2, toIgnore, canChangeDocument, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    @NotNull
    public static @Unmodifiable List<HighlightInfo> instantiateAndRun(@NotNull PsiFile psiFile, @NotNull Editor editor2, int @NotNull [] toIgnore, boolean canChangeDocument, boolean readEditorMarkupModel) {
        if (psiFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(10);
        }
        if (editor2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(11);
        }
        if (toIgnore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(12);
        }
        SmartPsiElementPointer filePointer = (SmartPsiElementPointer)ReadAction.compute(() -> SmartPointerManager.createPointer((PsiElement)psiFile));
        Project project = psiFile.getProject();
        CodeInsightTestFixtureImpl.ensureIndexesUpToDate(project);
        VirtualFile virtualFile = filePointer.getVirtualFile();
        if (!((Boolean)ReadAction.compute(() -> ProblemHighlightFilter.shouldHighlightFile((PsiFile)Objects.requireNonNull((PsiFile)filePointer.getElement())))).booleanValue()) {
            boolean inSource = (Boolean)ReadAction.compute(() -> ProjectRootManager.getInstance((Project)project).getFileIndex().isInSource(virtualFile));
            throw new IllegalStateException("ProblemHighlightFilter.shouldHighlightFile('" + filePointer.getElement() + "') == false, so can't highlight it." + (String)(inSource ? "" : " Maybe it's because " + virtualFile + " is outside source folders? (source folders: " + (String)ReadAction.compute(() -> Arrays.toString(ProjectRootManager.getInstance((Project)project).getContentSourceRoots())) + ")"));
        }
        DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project);
        TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(editor2);
        DaemonCodeAnalyzerSettings settings = DaemonCodeAnalyzerSettings.getInstance();
        ProjectInspectionProfileManager.getInstance((Project)project);
        Throwable exception = null;
        int retries = 1000;
        for (int i2 = 0; i2 < retries; ++i2) {
            ArrayList<HighlightInfo> arrayList;
            try {
                settings.forceUseZeroAutoReparseDelay(true);
                ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
                EdtTestUtil.runInEdtAndWait(() -> {
                    PsiFile file = (PsiFile)filePointer.getElement();
                    Assert.assertNotNull((Object)file);
                    codeAnalyzer.runPasses(file, editor2.getDocument(), textEditor, toIgnore, canChangeDocument, null);
                    IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
                    if (policy != null) {
                        policy.waitForHighlighting(project, editor2);
                    }
                    IdentifierHighlighterPassFactory.waitForIdentifierHighlighting();
                    CodeInsightTestFixtureImpl.waitForLazyQuickFixesUnderCaret(psiFile, editor2);
                    UIUtil.dispatchAllInvocationEvents();
                    Segment focusModeRange = editor2 instanceof EditorImpl ? ((EditorImpl)editor2).getFocusModeRange() : null;
                    int startOffset = focusModeRange != null ? focusModeRange.getStartOffset() : 0;
                    int endOffset = focusModeRange != null ? focusModeRange.getEndOffset() : editor2.getDocument().getTextLength();
                    DaemonCodeAnalyzerEx.processHighlights((Document)editor2.getDocument(), (Project)project, null, (int)startOffset, (int)endOffset, (Processor)Processors.cancelableCollectProcessor((Collection)infos));
                    if (readEditorMarkupModel) {
                        MarkupModelEx markupModel = (MarkupModelEx)editor2.getMarkupModel();
                        DaemonCodeAnalyzerEx.processHighlights((MarkupModelEx)markupModel, (Project)project, null, (int)startOffset, (int)endOffset, (Processor)Processors.cancelableCollectProcessor((Collection)infos));
                    }
                });
                ArrayList<HighlightInfo> arrayList2 = infos;
                arrayList = arrayList2;
            }
            catch (ProcessCanceledException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause != e && cause.getClass() != Throwable.class) {
                    exception = cause;
                    break;
                }
                exception = e;
                EdtTestUtil.runInEdtAndWait(() -> {
                    PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                    UIUtil.dispatchAllInvocationEvents();
                });
                continue;
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
            finally {
                settings.forceUseZeroAutoReparseDelay(false);
            }
            if (arrayList == null) {
                CodeInsightTestFixtureImpl.$$$reportNull$$$0(13);
            }
            return arrayList;
        }
        ExceptionUtil.rethrow(exception);
        throw new AssertionError("Unable to highlight after " + retries + " retries", exception);
    }

    public static void ensureIndexesUpToDate(@NotNull Project project) {
        if (project == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(14);
        }
        IndexingTestUtil.waitUntilIndexesAreReady(project);
        if (!DumbService.isDumb((Project)project)) {
            ReadAction.run(() -> {
                for (FileBasedIndexExtension extension : FileBasedIndexExtension.EXTENSION_POINT_NAME.getExtensionList()) {
                    FileBasedIndex.getInstance().ensureUpToDate(extension.getName(), project, null);
                }
            });
        }
    }

    @TestOnly
    @NotNull
    public static @Unmodifiable List<IntentionAction> getAvailableIntentions(@NotNull Editor editor2, @NotNull PsiFile psiFile) {
        IdeaTestExecutionPolicy current;
        if (editor2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(15);
        }
        if (psiFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(16);
        }
        if ((current = IdeaTestExecutionPolicy.current()) != null) {
            current.waitForHighlighting(psiFile.getProject(), editor2);
        }
        CodeInsightTestFixtureImpl.waitForLazyQuickFixesUnderCaret(psiFile, editor2);
        ArrayList<IntentionAction> result = new ArrayList<IntentionAction>();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            IntentionListStep intentionListStep = CodeInsightTestFixtureImpl.getIntentionListStep(editor2, psiFile);
            for (Map.Entry entry : intentionListStep.getActionsWithSubActions().entrySet()) {
                result.add((IntentionAction)entry.getKey());
                result.addAll((Collection)entry.getValue());
            }
        });
        ArrayList<IntentionAction> arrayList = result;
        if (arrayList == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @RequiresEdt
    @NotNull
    private static IntentionListStep getIntentionListStep(@NotNull Editor editor2, @NotNull PsiFile file) {
        if (editor2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(18);
        }
        if (file == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(19);
        }
        CachedIntentions cachedIntentions = ShowIntentionActionsHandler.calcCachedIntentions((Project)file.getProject(), (Editor)editor2, (PsiFile)file);
        return new IntentionListStep(null, editor2, file, file.getProject(), cachedIntentions);
    }

    public static void waitForLazyQuickFixesUnderCaret(@NotNull PsiFile file, @NotNull Editor editor2) {
        if (file == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(20);
        }
        if (editor2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(21);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            assert (!ApplicationManager.getApplication().isWriteAccessAllowed()) : "must not call under write action";
            Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (!((Boolean)ReadAction.compute(() -> file.getProject().isDisposed() || editor2.isDisposed())).booleanValue()) {
                    DaemonCodeAnalyzerImpl.waitForLazyQuickFixesUnderCaret((PsiFile)file, (Editor)editor2);
                }
            });
            try {
                while (!future.isDone()) {
                    try {
                        future.get(10L, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException timeoutException) {
                        // empty catch block
                    }
                    UIUtil.dispatchAllInvocationEvents();
                }
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        DaemonCodeAnalyzerImpl.waitForLazyQuickFixesUnderCaret((PsiFile)file, (Editor)editor2);
    }

    @Override
    @NotNull
    public String getTempDirPath() {
        String string = this.myTempDirFixture.getTempDirPath();
        if (string == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Override
    @NotNull
    public TempDirTestFixture getTempDirFixture() {
        TempDirTestFixture tempDirTestFixture = this.myTempDirFixture;
        if (tempDirTestFixture == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(23);
        }
        return tempDirTestFixture;
    }

    @Override
    @NotNull
    public VirtualFile copyFileToProject(@NotNull String sourcePath) {
        if (sourcePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(24);
        }
        VirtualFile virtualFile = this.copyFileToProject(sourcePath, sourcePath);
        if (virtualFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(25);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile copyFileToProject(@NotNull String sourcePath, @NotNull String targetPath) {
        File candidate;
        String testDataPath;
        File sourceFile;
        if (sourcePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(26);
        }
        if (targetPath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(27);
        }
        if (!(sourceFile = new File(testDataPath = this.getTestDataPath(), FileUtil.toSystemDependentName((String)sourcePath))).exists() && (candidate = new File(sourcePath)).isAbsolute()) {
            sourceFile = candidate;
            if (FileUtil.pathsEqual((String)targetPath, (String)sourcePath)) {
                Path testDataPathObj = Paths.get(testDataPath, new String[0]);
                Path targetPathObj = Paths.get(targetPath, new String[0]);
                if (targetPathObj.startsWith(testDataPathObj) && !targetPathObj.equals(testDataPathObj)) {
                    targetPath = testDataPathObj.relativize(targetPathObj).toString();
                } else {
                    throw new IllegalArgumentException("Cannot guess target path for '" + sourcePath + "'; please specify explicitly");
                }
            }
        }
        targetPath = FileUtil.toSystemIndependentName((String)targetPath);
        VirtualFile targetFile = this.myTempDirFixture.getFile(targetPath);
        if (!sourceFile.exists() && targetFile != null && targetPath.equals(sourcePath)) {
            VirtualFile virtualFile = targetFile;
            if (virtualFile == null) {
                CodeInsightTestFixtureImpl.$$$reportNull$$$0(28);
            }
            return virtualFile;
        }
        CodeInsightTestFixtureImpl.assertFileEndsWithCaseSensitivePath(sourceFile);
        Assert.assertTrue((String)("Cannot find source file: " + sourceFile + "; test data path: " + testDataPath + "; sourcePath: " + sourcePath), (boolean)sourceFile.exists());
        Assert.assertTrue((String)("Not a file: " + sourceFile), (boolean)sourceFile.isFile());
        if (targetFile == null) {
            targetFile = this.myTempDirFixture.createFile(targetPath);
            VfsTestUtil.assertFilePathEndsWithCaseSensitivePath(targetFile, sourcePath);
            targetFile.putUserData(VfsTestUtil.TEST_DATA_FILE_PATH, (Object)sourceFile.getAbsolutePath());
        }
        CodeInsightTestFixtureImpl.copyContent(sourceFile, targetFile);
        IndexingTestUtil.waitUntilIndexesAreReady(this.getProject());
        VirtualFile virtualFile = targetFile;
        if (virtualFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(29);
        }
        return virtualFile;
    }

    private static void assertFileEndsWithCaseSensitivePath(@NotNull File sourceFile) {
        if (sourceFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(30);
        }
        try {
            String sourceName = sourceFile.getPath();
            File realFile = sourceFile.getCanonicalFile();
            String realFileName = realFile.getPath();
            if (!sourceName.equals(realFileName) && sourceName.equalsIgnoreCase(realFileName)) {
                Assert.fail((String)("Please correct case-sensitivity of path to prevent test failure on case-sensitive file systems:\n     path " + sourceFile.getPath() + "\nreal path " + realFile.getPath()));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("sourceFile=" + sourceFile, e);
        }
    }

    private static void copyContent(@NotNull File sourceFile, @NotNull VirtualFile targetFile) {
        if (sourceFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(31);
        }
        if (targetFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(32);
        }
        try {
            WriteAction.runAndWait(() -> {
                targetFile.setBinaryContent(FileUtil.loadFileBytes((File)sourceFile));
                FileDocumentManager.getInstance().reloadFiles(new VirtualFile[]{targetFile});
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public VirtualFile copyDirectoryToProject(@NotNull String sourcePath, @NotNull String targetPath) {
        if (sourcePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(33);
        }
        if (targetPath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(34);
        }
        String testDataPath = this.getTestDataPath();
        File fromFile = new File(testDataPath + "/" + sourcePath);
        if (this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
            VirtualFile file = this.myTempDirFixture.copyAll(fromFile.getPath(), targetPath);
            IndexingTestUtil.waitUntilIndexesAreReady(this.getProject());
            VirtualFile virtualFile = file;
            if (virtualFile == null) {
                CodeInsightTestFixtureImpl.$$$reportNull$$$0(35);
            }
            return virtualFile;
        }
        File targetFile = new File(this.getTempDirPath() + "/" + targetPath);
        try {
            FileUtil.copyDir((File)fromFile, (File)targetFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(targetFile);
        Assert.assertNotNull((Object)file);
        file.refresh(false, true);
        IndexingTestUtil.waitUntilIndexesAreReady(this.getProject());
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        if (policy != null) {
            PsiDirectory directory = (PsiDirectory)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findDirectory(file));
            Assert.assertNotNull((Object)directory);
            policy.testDirectoryConfigured(directory);
        }
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(36);
        }
        return virtualFile;
    }

    @Override
    public void enableInspections(InspectionProfileEntry ... inspections) {
        if (inspections == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(37);
        }
        this.assertInitialized();
        InspectionsKt.enableInspectionTools(this.getProject(), this.myProjectFixture.getTestRootDisposable(), inspections);
    }

    @Override
    @SafeVarargs
    public final void enableInspections(Class<? extends LocalInspectionTool> ... inspections) {
        if (inspections == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(38);
        }
        this.enableInspections(Arrays.asList(inspections));
    }

    @Override
    public void enableInspections(@NotNull Collection<Class<? extends LocalInspectionTool>> inspections) {
        if (inspections == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(39);
        }
        List<InspectionProfileEntry> tools = InspectionTestUtil.instantiateTools(inspections);
        this.enableInspections(tools.toArray(new InspectionProfileEntry[0]));
    }

    @Override
    public void disableInspections(InspectionProfileEntry ... inspections) {
        if (inspections == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(40);
        }
        InspectionsKt.disableInspections(this.getProject(), inspections);
    }

    @Override
    public void enableInspections(InspectionToolProvider ... providers) {
        if (providers == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(41);
        }
        List<Class<? extends LocalInspectionTool>> classes = Stream.of(providers).flatMap(p -> Stream.of(p.getInspectionClasses())).filter(LocalInspectionTool.class::isAssignableFrom).collect(Collectors.toList());
        this.enableInspections(classes);
    }

    @Override
    public long testHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, String ... filePaths) {
        if (filePaths == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(42);
        }
        if (filePaths.length > 0) {
            this.configureByFilesInner(filePaths);
        }
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings);
    }

    @Override
    public long testHighlightingAllFiles(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, String ... paths) {
        if (paths == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(43);
        }
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings, Stream.of(paths).map(this::copyFileToProject));
    }

    @Override
    public long testHighlightingAllFiles(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, VirtualFile ... files) {
        if (files == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(44);
        }
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings, Stream.of(files));
    }

    private long collectAndCheckHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, @NotNull Stream<? extends VirtualFile> files) {
        if (files == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(45);
        }
        record FileHighlighting(PsiFile file, Editor editor, ExpectedHighlightingData data) {
        }
        List<FileHighlighting> data = files.map(file -> {
            PsiFile psiFile = this.myPsiManager.findFile(file);
            Assert.assertNotNull((Object)psiFile);
            Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(psiFile);
            Assert.assertNotNull((Object)document);
            ExpectedHighlightingData datum = new ExpectedHighlightingData(document, checkWarnings, checkWeakWarnings, checkInfos, false);
            datum.init();
            return new FileHighlighting(psiFile, this.createEditor((VirtualFile)file), datum);
        }).toList();
        long elapsed = 0L;
        for (FileHighlighting highlighting : data) {
            this.setFileAndEditor(highlighting.file().getVirtualFile(), highlighting.editor());
            elapsed += this.collectAndCheckHighlighting(highlighting.data());
        }
        return elapsed;
    }

    @Override
    public long checkHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings) {
        return this.checkHighlighting(checkWarnings, checkInfos, checkWeakWarnings, false);
    }

    @Override
    public long checkHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, boolean ignoreExtraHighlighting) {
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings, ignoreExtraHighlighting);
    }

    @Override
    public long checkHighlighting() {
        return this.checkHighlighting(true, false, true);
    }

    @Override
    public long testHighlighting(String ... filePaths) {
        if (filePaths == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(46);
        }
        return this.testHighlighting(true, false, true, filePaths);
    }

    @Override
    public long testHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, @NotNull VirtualFile file) {
        if (file == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(47);
        }
        this.openFileInEditor(file);
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings);
    }

    @Override
    @NotNull
    public HighlightTestInfo testFile(String ... filePath) {
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(48);
        }
        return new HighlightTestInfo(this.myProjectFixture.getTestRootDisposable(), filePath){

            @Override
            public HighlightTestInfo doTest() {
                CodeInsightTestFixtureImpl.this.configureByFiles(this.filePaths);
                ExpectedHighlightingData data = new ExpectedHighlightingData(CodeInsightTestFixtureImpl.this.editor.getDocument(), this.checkWarnings, this.checkWeakWarnings, this.checkInfos, false);
                if (this.checkSymbolNames) {
                    data.checkSymbolNames();
                }
                data.init();
                CodeInsightTestFixtureImpl.this.collectAndCheckHighlighting(data);
                return this;
            }
        };
    }

    @Override
    public void openFileInEditor(@NotNull VirtualFile file) {
        if (file == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(49);
        }
        this.setFileAndEditor(file, this.createEditor(file));
    }

    @Override
    public void testInspection(@NotNull String testDir, @NotNull InspectionToolWrapper<?, ?> toolWrapper) {
        if (testDir == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(50);
        }
        if (toolWrapper == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(51);
        }
        VirtualFile sourceDir = this.copyDirectoryToProject(new File(testDir, "src").getPath(), "");
        this.testInspection(testDir, toolWrapper, sourceDir);
    }

    @Override
    public void testInspection(@NotNull String testDir, @NotNull InspectionToolWrapper<?, ?> toolWrapper, @NotNull VirtualFile sourceDir) {
        if (testDir == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(52);
        }
        if (toolWrapper == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(53);
        }
        if (sourceDir == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(54);
        }
        PsiDirectory psiDirectory = this.getPsiManager().findDirectory(sourceDir);
        Assert.assertNotNull((Object)psiDirectory);
        AnalysisScope scope = new AnalysisScope(psiDirectory);
        scope.invalidate();
        GlobalInspectionContextForTests globalContext = InspectionsKt.createGlobalContextForTool(scope, this.getProject(), Collections.singletonList(toolWrapper));
        InspectionTestUtil.runTool(toolWrapper, scope, globalContext);
        InspectionTestUtil.compareToolResults((GlobalInspectionContextImpl)globalContext, toolWrapper, false, new File(this.getTestDataPath(), testDir).getPath());
    }

    @Override
    @NotNull
    public PsiSymbolReference findSingleReferenceAtCaret() {
        PsiFile file = this.getFile();
        Assert.assertNotNull((Object)file);
        PsiSymbolReference psiSymbolReference = (PsiSymbolReference)UsefulTestCase.assertOneElement(ReferencesKt.referencesAt((PsiFile)file, (int)this.getCaretOffset()));
        if (psiSymbolReference == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(55);
        }
        return psiSymbolReference;
    }

    @Override
    @Nullable
    public PsiReference getReferenceAtCaretPosition(String ... filePaths) {
        if (filePaths == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(56);
        }
        if (filePaths.length > 0) {
            this.configureByFilesInner(filePaths);
        }
        return (PsiReference)ReadAction.compute(() -> this.getFile().findReferenceAt(this.editor.getCaretModel().getOffset()));
    }

    @Override
    @NotNull
    public PsiReference getReferenceAtCaretPositionWithAssertion(String ... filePaths) {
        if (filePaths == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(57);
        }
        PsiReference reference = this.getReferenceAtCaretPosition(filePaths);
        Assert.assertNotNull((String)("no reference found in " + this.getFile() + " at " + this.editor.getCaretModel().getLogicalPosition() + ", there's just " + ReadAction.compute(() -> this.getFile().findElementAt(this.editor.getCaretModel().getOffset()))), (Object)reference);
        PsiReference psiReference = reference;
        if (psiReference == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(58);
        }
        return psiReference;
    }

    @Override
    @NotNull
    public List<IntentionAction> getAvailableIntentions(String ... filePaths) {
        if (filePaths == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(59);
        }
        if (filePaths.length > 0) {
            this.configureByFilesInner(filePaths);
        }
        List<IntentionAction> list = this.getAvailableIntentions();
        if (list == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(60);
        }
        return list;
    }

    @Override
    @NotNull
    public List<IntentionAction> getAllQuickFixes(String ... filePaths) {
        if (filePaths == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(61);
        }
        if (filePaths.length != 0) {
            this.configureByFilesInner(filePaths);
        }
        List<IntentionAction> list = this.myEditorTestFixture.getAllQuickFixes();
        if (list == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(62);
        }
        return list;
    }

    @Override
    @NotNull
    public @Unmodifiable List<IntentionAction> getAvailableIntentions() {
        this.doHighlighting();
        return CodeInsightTestFixtureImpl.getAvailableIntentions((Editor)ReadAction.compute(() -> this.getHostEditor()), (PsiFile)ReadAction.compute(() -> this.getHostFileAtCaret()));
    }

    @NotNull
    private Editor getHostEditor() {
        Editor editor2 = InjectedLanguageEditorUtil.getTopLevelEditor((Editor)this.getEditor());
        if (editor2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(63);
        }
        return editor2;
    }

    @NotNull
    private PsiFile getHostFileAtCaret() {
        PsiFile psiFile = Objects.requireNonNull(PsiUtilBase.getPsiFileInEditor((Editor)this.getHostEditor(), (Project)this.getProject()));
        if (psiFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(64);
        }
        return psiFile;
    }

    @Override
    @NotNull
    public @Unmodifiable List<IntentionAction> filterAvailableIntentions(@NotNull String hint) {
        if (hint == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(65);
        }
        List list = ContainerUtil.filter(this.getAvailableIntentions(), action -> action.getText().startsWith(hint));
        if (list == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(66);
        }
        return list;
    }

    @Override
    @NotNull
    public IntentionAction findSingleIntention(@NotNull String hint) {
        List<IntentionAction> list;
        if (hint == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(67);
        }
        if ((list = this.filterAvailableIntentions(hint)).isEmpty()) {
            Assert.fail((String)("\"" + hint + "\" not in [" + StringUtil.join(this.getAvailableIntentions(), INTENTION_NAME_FUN, (String)", ") + "]"));
        } else if (list.size() > 1) {
            Assert.fail((String)("Too many intentions found for \"" + hint + "\": [" + StringUtil.join(list, INTENTION_NAME_FUN, (String)", ") + "]"));
        }
        IntentionAction intentionAction = UsefulTestCase.assertOneElement(list);
        if (intentionAction == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(68);
        }
        return intentionAction;
    }

    @Override
    public IntentionAction getAvailableIntention(@NotNull String intentionName, String ... filePaths) {
        List<IntentionAction> intentions;
        IntentionAction action;
        if (intentionName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(69);
        }
        if (filePaths == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(70);
        }
        if ((action = CodeInsightTestUtil.findIntentionByText(intentions = this.getAvailableIntentions(filePaths), intentionName)) == null) {
            LOG.debug(intentionName + " not found among " + StringUtil.join(intentions, IntentionAction::getText, (String)","));
        }
        return action;
    }

    @Override
    public void checkPreviewAndLaunchAction(@NotNull IntentionAction action) {
        if (action == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(71);
        }
        if (CodeInsightTestFixtureImpl.skipPreview(action)) {
            this.launchAction(action);
        } else {
            String text = this.getIntentionPreviewText(action);
            Assert.assertNotNull((String)action.getText(), (Object)text);
            this.launchAction(action);
            NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
            Assert.assertEquals((String)action.getText(), (Object)InjectedLanguageManager.getInstance((Project)this.getProject()).getTopLevelFile((PsiElement)this.getFile()).getText(), (Object)text);
        }
    }

    private static boolean skipPreview(@NotNull IntentionAction action) {
        if (action == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(72);
        }
        return IntentionActionDelegate.unwrap((IntentionAction)action) instanceof CleanupInspectionIntention;
    }

    @Override
    @Nullable
    public String getIntentionPreviewText(@NotNull IntentionAction action) {
        if (action == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(73);
        }
        try {
            return (String)ReadAction.nonBlocking(() -> IntentionPreviewPopupUpdateProcessor.getPreviewText((Project)this.getProject(), (IntentionAction)action, (PsiFile)this.getFile(), (Editor)this.getEditor())).submit((Executor)AppExecutorUtil.getAppExecutorService()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public String getIntentionPreviewText(@NotNull String hint) {
        IntentionActionWithTextCaching action;
        if (hint == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(74);
        }
        if ((action = this.findCachingAction(hint)) == null) {
            return null;
        }
        IntentionPreviewInfo info = IntentionPreviewPopupUpdateProcessor.getPreviewInfo((Project)this.getProject(), (IntentionAction)action.getAction(), (PsiFile)this.getFile(), (Editor)this.getEditor(), (int)action.getFixOffset());
        return info == IntentionPreviewInfo.EMPTY ? null : ((IntentionPreviewDiffResult)info).getNewText();
    }

    @Override
    public void launchAction(@NotNull String hint) {
        IntentionActionWithTextCaching action;
        if (hint == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(75);
        }
        if ((action = this.findCachingAction(hint)) == null) {
            throw new IllegalArgumentException();
        }
        ShowIntentionActionsHandler.chooseActionAndInvoke((PsiFile)this.getHostFile(), (Editor)this.getHostEditor(), (IntentionAction)action.getAction(), (String)action.getText(), (int)action.getFixOffset(), (IntentionSource)IntentionSource.CONTEXT_ACTIONS);
    }

    @Nullable
    private IntentionActionWithTextCaching findCachingAction(@NotNull String hint) {
        if (hint == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(76);
        }
        this.doHighlighting();
        List list = CodeInsightTestFixtureImpl.getIntentionListStep(this.getEditor(), this.getFile()).getValues();
        return (IntentionActionWithTextCaching)ContainerUtil.find((Iterable)list, caching -> caching.getAction().getText().startsWith(hint));
    }

    @Override
    public void checkIntentionPreviewHtml(@NotNull IntentionAction action, @NotNull @Language(value="HTML") String expected) {
        IntentionPreviewInfo info;
        if (action == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(77);
        }
        if (expected == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(78);
        }
        try {
            info = (IntentionPreviewInfo)ReadAction.nonBlocking(() -> IntentionPreviewPopupUpdateProcessor.getPreviewInfo((Project)this.getProject(), (IntentionAction)action, (PsiFile)this.getFile(), (Editor)this.getEditor())).submit((Executor)AppExecutorUtil.getAppExecutorService()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        Assert.assertTrue((String)action.getText(), (boolean)(info instanceof IntentionPreviewInfo.Html));
        Assert.assertEquals((String)action.getText(), (Object)expected, (Object)((IntentionPreviewInfo.Html)info).content().toString());
    }

    @Override
    public void launchAction(@NotNull IntentionAction action) {
        if (action == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(79);
        }
        EdtTestUtil.runInEdtAndWait(() -> CodeInsightTestFixtureImpl.invokeIntention(action, this.getHostFileAtCaret(), this.getHostEditor()));
    }

    @Override
    public void testCompletion(String @NotNull [] filesBefore, @NotNull @TestDataFile String fileAfter) {
        if (fileAfter == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(80);
        }
        if (filesBefore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(81);
        }
        this.testCompletionTyping(filesBefore, "", fileAfter);
    }

    @Override
    public void testCompletionTyping(String @NotNull [] filesBefore, @NotNull String toType, @NotNull String fileAfter) {
        if (toType == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(82);
        }
        if (fileAfter == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(83);
        }
        if (filesBefore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(84);
        }
        this.assertInitialized();
        this.configureByFiles(filesBefore);
        this.complete(CompletionType.BASIC);
        this.type(toType);
        try {
            this.checkResultByFile(fileAfter);
        }
        catch (RuntimeException e) {
            System.out.println("LookupElementStrings = " + this.getLookupElementStrings());
            throw e;
        }
    }

    protected void assertInitialized() {
        Assert.assertNotNull((String)"setUp() hasn't been called", (Object)this.myPsiManager);
    }

    @Override
    public void testCompletion(@NotNull String fileBefore, @NotNull String fileAfter, String ... additionalFiles) {
        if (fileBefore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(85);
        }
        if (fileAfter == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(86);
        }
        if (additionalFiles == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(87);
        }
        this.testCompletionTyping(fileBefore, "", fileAfter, additionalFiles);
    }

    @Override
    public void testCompletionTyping(@NotNull @TestDataFile String fileBefore, @NotNull String toType, @NotNull @TestDataFile String fileAfter, String ... additionalFiles) {
        if (fileBefore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(88);
        }
        if (toType == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(89);
        }
        if (fileAfter == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(90);
        }
        if (additionalFiles == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(91);
        }
        this.testCompletionTyping((String[])ArrayUtil.reverseArray((Object[])((String[])ArrayUtil.append((Object[])additionalFiles, (Object)fileBefore))), toType, fileAfter);
    }

    @Override
    public void testCompletionVariants(@NotNull String fileBefore, String ... expectedItems) {
        if (fileBefore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(92);
        }
        if (expectedItems == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(93);
        }
        this.assertInitialized();
        List<String> result = this.getCompletionVariants(fileBefore);
        Assert.assertNotNull(result);
        UsefulTestCase.assertSameElements(result, expectedItems);
    }

    @Override
    public @Unmodifiable List<String> getCompletionVariants(String ... filesBefore) {
        if (filesBefore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(94);
        }
        this.assertInitialized();
        this.configureByFiles(filesBefore);
        LookupElement[] items = this.complete(CompletionType.BASIC);
        Assert.assertNotNull((String)"No lookup was shown, probably there was only one lookup element that was inserted automatically", (Object)items);
        return this.getLookupElementStrings();
    }

    @Override
    @Nullable
    public @Unmodifiable List<String> getLookupElementStrings() {
        this.assertInitialized();
        return this.myEditorTestFixture.getLookupElementStrings();
    }

    @Override
    public void finishLookup(char completionChar) {
        this.myEditorTestFixture.finishLookup(completionChar);
    }

    @Override
    public void testRename(@NotNull String fileBefore, @NotNull String fileAfter, @NotNull String newName, String ... additionalFiles) {
        if (fileBefore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(95);
        }
        if (fileAfter == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(96);
        }
        if (newName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(97);
        }
        if (additionalFiles == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(98);
        }
        this.assertInitialized();
        this.configureByFiles((String[])ArrayUtil.reverseArray((Object[])((String[])ArrayUtil.append((Object[])additionalFiles, (Object)fileBefore))));
        this.testRename(fileAfter, newName);
    }

    @Override
    public void testRenameUsingHandler(@NotNull String fileBefore, @NotNull String fileAfter, @NotNull String newName, String ... additionalFiles) {
        if (fileBefore == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(99);
        }
        if (fileAfter == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(100);
        }
        if (newName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(101);
        }
        if (additionalFiles == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(102);
        }
        this.assertInitialized();
        this.configureByFiles((String[])ArrayUtil.reverseArray((Object[])((String[])ArrayUtil.append((Object[])additionalFiles, (Object)fileBefore))));
        this.testRenameUsingHandler(fileAfter, newName);
    }

    @Override
    public void testRenameUsingHandler(@NotNull String fileAfter, @NotNull String newName) {
        if (fileAfter == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(103);
        }
        if (newName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(104);
        }
        this.renameElementAtCaretUsingHandler(newName);
        this.checkResultByFile(fileAfter);
    }

    @Override
    public void testRename(@NotNull String fileAfter, @NotNull String newName) {
        if (fileAfter == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(105);
        }
        if (newName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(106);
        }
        this.renameElementAtCaret(newName);
        this.checkResultByFile(fileAfter);
    }

    @Override
    @NotNull
    public PsiElement getElementAtCaret() {
        this.assertInitialized();
        PsiElement psiElement = this.myEditorTestFixture.getElementAtCaret();
        if (psiElement == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(107);
        }
        return psiElement;
    }

    @Override
    public void renameElementAtCaret(@NotNull String newName) {
        if (newName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(108);
        }
        this.renameElement(this.getElementAtCaret(), newName);
    }

    @Override
    public void renameElementAtCaretUsingHandler(@NotNull String newName) {
        if (newName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(109);
        }
        DataContext editorContext = EditorUtil.getEditorDataContext((Editor)this.editor);
        DataContext context2 = CustomizedDataContext.withSnapshot((DataContext)editorContext, sink -> sink.set(PsiElementRenameHandler.DEFAULT_NAME, (Object)newName));
        RenameHandler renameHandler = RenameHandlerRegistry.getInstance().getRenameHandler(context2);
        Assert.assertNotNull((String)"No handler for this context", (Object)renameHandler);
        renameHandler.invoke(this.getProject(), this.editor, this.getFile(), context2);
    }

    @Override
    public void renameElement(@NotNull PsiElement element, @NotNull String newName) {
        if (element == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(110);
        }
        if (newName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(111);
        }
        boolean searchInComments = false;
        boolean searchTextOccurrences = false;
        this.renameElement(element, newName, false, false);
    }

    @Override
    public void renameElement(@NotNull PsiElement element, @NotNull String newName, boolean searchInComments, boolean searchTextOccurrences) {
        PsiElement substitution;
        if (element == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(112);
        }
        if (newName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(113);
        }
        if ((substitution = RenamePsiElementProcessor.forElement((PsiElement)element).substituteElementToRename(element, this.editor)) == null) {
            return;
        }
        new RenameProcessor(this.getProject(), substitution, newName, searchInComments, searchTextOccurrences).run();
    }

    @Override
    public void renameTarget(@NotNull RenameTarget renameTarget, @NotNull String newName) {
        if (renameTarget == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(114);
        }
        if (newName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(115);
        }
        RenameKt.renameAndWait((Project)this.getProject(), (RenameTarget)renameTarget, (String)newName);
    }

    @Override
    public <T extends PsiElement> T findElementByText(@NotNull String text, @NotNull Class<T> elementClass) {
        if (text == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(116);
        }
        if (elementClass == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(117);
        }
        return this.myEditorTestFixture.findElementByText(text, elementClass);
    }

    @Override
    public void type(char c) {
        this.assertInitialized();
        this.myEditorTestFixture.type(c);
    }

    @Override
    public void type(@NotNull String s) {
        if (s == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(118);
        }
        this.myEditorTestFixture.type(s);
    }

    @Override
    public void performEditorAction(@NotNull String actionId, @Nullable AnActionEvent actionEvent) {
        if (actionId == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(119);
        }
        this.assertInitialized();
        EdtTestUtil.runInEdtAndWait(() -> this.myEditorTestFixture.performEditorAction(actionId, actionEvent));
    }

    @Override
    @NotNull
    public Presentation testAction(@NotNull AnAction action) {
        if (action == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(120);
        }
        AnActionEvent e = TestActionEvent.createTestEvent(action);
        ActionUtil.performDumbAwareUpdate((AnAction)action, (AnActionEvent)e, (boolean)false);
        if (e.getPresentation().isEnabled()) {
            ActionUtil.performActionDumbAwareWithCallbacks((AnAction)action, (AnActionEvent)e);
        }
        Presentation presentation = e.getPresentation();
        if (presentation == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(121);
        }
        return presentation;
    }

    @Override
    @NotNull
    public Collection<UsageInfo> testFindUsages(String ... fileNames) {
        if (fileNames == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(122);
        }
        this.assertInitialized();
        if (fileNames.length > 0) {
            this.configureByFiles(fileNames);
        }
        int flags = 3;
        PsiElement targetElement = TargetElementUtil.findTargetElement((Editor)this.getEditor(), (int)flags);
        Assert.assertNotNull((String)"Cannot find referenced element", (Object)targetElement);
        Collection<UsageInfo> collection = this.findUsages(targetElement);
        if (collection == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(123);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<Usage> testFindUsagesUsingAction(String ... fileNames) {
        if (fileNames == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(124);
        }
        this.assertInitialized();
        if (fileNames.length > 0) {
            this.configureByFiles(fileNames);
        }
        EdtTestUtil.runInEdtAndWait(() -> {
            this.myEditorTestFixture.performEditorAction("FindUsages");
            FindUsagesManager.waitForAsyncTaskCompletion((Project)this.getProject());
        });
        Disposer.register((Disposable)this.getTestRootDisposable(), () -> {
            Content selectedContent;
            UsageViewContentManager usageViewManager = UsageViewContentManager.getInstance((Project)this.getProject());
            while ((selectedContent = usageViewManager.getSelectedContent()) != null) {
                usageViewManager.closeContent(selectedContent);
            }
        });
        Collection collection = (Collection)EdtTestUtil.runInEdtAndGet(() -> {
            UsageView view;
            NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
            long startMillis = System.currentTimeMillis();
            boolean viewWasInitialized = false;
            while ((view = UsageViewManager.getInstance((Project)this.getProject()).getSelectedUsageView()) == null || view.isSearchInProgress()) {
                IdeEventQueue.getInstance().flushQueue();
                if ((viewWasInitialized |= view != null) || System.currentTimeMillis() - startMillis <= TimeUnit.SECONDS.toMillis(10L)) continue;
                Assert.fail((String)"UsageView wasn't shown");
                return Collections.emptyList();
            }
            return view.getUsages();
        });
        if (collection == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(125);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<UsageInfo> findUsages(@NotNull PsiElement targetElement) {
        if (targetElement == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(126);
        }
        Collection<UsageInfo> collection = this.findUsages(targetElement, null);
        if (collection == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(127);
        }
        return collection;
    }

    @Override
    @NotNull
    public String getUsageViewTreeTextRepresentation(@NotNull Collection<? extends UsageInfo> usages) {
        if (usages == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(128);
        }
        UsageViewImpl usageView = (UsageViewImpl)UsageViewManager.getInstance((Project)this.getProject()).createUsageView(UsageTarget.EMPTY_ARRAY, ContainerUtil.map(usages, usage -> new UsageInfo2UsageAdapter(usage)).toArray(Usage.EMPTY_ARRAY), new UsageViewPresentation(), null);
        String string = this.getUsageViewTreeTextRepresentation(usageView);
        if (string == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(129);
        }
        return string;
    }

    @Override
    @NotNull
    public String getUsageViewTreeTextRepresentation(@NotNull List<UsageTarget> usageTargets, @NotNull Collection<? extends Usage> usages) {
        if (usageTargets == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(130);
        }
        if (usages == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(131);
        }
        UsageViewImpl usageView = (UsageViewImpl)UsageViewManager.getInstance((Project)this.getProject()).createUsageView(usageTargets.toArray(UsageTarget.EMPTY_ARRAY), usages.toArray(Usage.EMPTY_ARRAY), new UsageViewPresentation(), null);
        String string = this.getUsageViewTreeTextRepresentation(usageView);
        if (string == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(132);
        }
        return string;
    }

    @Override
    @NotNull
    public String getUsageViewTreeTextRepresentation(@NotNull PsiElement targetElement) {
        if (targetElement == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(133);
        }
        FindUsagesManager usagesManager = ((FindManagerImpl)FindManager.getInstance((Project)this.getProject())).getFindUsagesManager();
        FindUsagesHandler handler = usagesManager.getFindUsagesHandler(targetElement, false);
        Assert.assertNotNull((String)("Cannot find handler for: " + targetElement), (Object)handler);
        UsageViewImpl usageView = (UsageViewImpl)usagesManager.doFindUsages(handler.getPrimaryElements(), handler.getSecondaryElements(), (FindUsagesHandlerBase)handler, handler.getFindUsagesOptions(), false);
        String string = this.getUsageViewTreeTextRepresentation(usageView);
        if (string == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(134);
        }
        return string;
    }

    @Override
    @NotNull
    public String getUsageViewTreeTextRepresentation(@NotNull SearchTarget target) {
        if (target == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(135);
        }
        Project project = this.getProject();
        SearchScope searchScope = (SearchScope)ObjectUtils.coalesce((Object)target.getMaximalSearchScope(), (Object)GlobalSearchScope.allScope((Project)project));
        AllSearchOptions allOptions = new AllSearchOptions(UsageOptions.createOptions((SearchScope)searchScope), Boolean.valueOf(true));
        List<SearchTarget2UsageTarget> usageTargets = List.of(new SearchTarget2UsageTarget(project, target, allOptions));
        Collection usages = ImplKt.buildUsageViewQuery((Project)this.getProject(), (SearchTarget)target, (AllSearchOptions)allOptions).findAll();
        String string = this.getUsageViewTreeTextRepresentation(usageTargets, usages);
        if (string == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(136);
        }
        return string;
    }

    @NotNull
    public Collection<UsageInfo> findUsages(@NotNull PsiElement targetElement, @Nullable SearchScope scope) {
        if (targetElement == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(137);
        }
        Project project = this.getProject();
        FindUsagesHandler handler = ((FindManagerImpl)FindManager.getInstance((Project)project)).getFindUsagesManager().getFindUsagesHandler(targetElement, false);
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor(Collections.synchronizedList(new ArrayList()));
        Assert.assertNotNull((String)("Cannot find handler for: " + targetElement), (Object)handler);
        PsiElement[] psiElements = (PsiElement[])ArrayUtil.mergeArrays((Object[])handler.getPrimaryElements(), (Object[])handler.getSecondaryElements());
        FindUsagesOptions options = handler.getFindUsagesOptions(null);
        if (scope != null) {
            options.searchScope = scope;
        }
        for (PsiElement psiElement : psiElements) {
            handler.processElementUsages(psiElement, (Processor)processor, options);
        }
        Collection collection = processor.getResults();
        if (collection == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(138);
        }
        return collection;
    }

    @Override
    public RangeHighlighter @NotNull [] testHighlightUsages(String ... files) {
        if (files == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(139);
        }
        this.configureByFiles(files);
        this.testAction((AnAction)new HighlightUsagesAction());
        Editor editor2 = this.getEditor();
        RangeHighlighter[] rangeHighlighterArray = editor2.getMarkupModel().getAllHighlighters();
        if (rangeHighlighterArray == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(140);
        }
        return rangeHighlighterArray;
    }

    @Override
    public void moveFile(@NotNull String filePath, @NotNull String to, String ... additionalFiles) {
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(141);
        }
        if (to == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(142);
        }
        if (additionalFiles == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(143);
        }
        this.assertInitialized();
        Project project = this.getProject();
        this.configureByFiles((String[])ArrayUtil.reverseArray((Object[])((String[])ArrayUtil.append((Object[])additionalFiles, (Object)filePath))));
        VirtualFile file = this.findFileInTempDir(to);
        Assert.assertNotNull((String)("Directory " + to + " not found"), (Object)file);
        Assert.assertTrue((String)(to + " is not a directory"), (boolean)file.isDirectory());
        PsiDirectory directory = this.myPsiManager.findDirectory(file);
        new MoveFilesOrDirectoriesProcessor(project, new PsiElement[]{this.getFile()}, directory, false, false, null, null).run();
    }

    @Override
    @Nullable
    public GutterMark findGutter(@NotNull String filePath) {
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(144);
        }
        this.configureByFilesInner(filePath);
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.doHighlighting();
        CodeInsightTestFixtureImpl.processGuttersAtCaret(this.editor, this.getProject(), (Processor<? super GutterMark>)processor);
        return (GutterMark)processor.getFoundValue();
    }

    @Override
    @NotNull
    public List<GutterMark> findGuttersAtCaret() {
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.doHighlighting();
        CodeInsightTestFixtureImpl.processGuttersAtCaret(this.editor, this.getProject(), (Processor<? super GutterMark>)processor);
        return new ArrayList<GutterMark>(processor.getResults());
    }

    @NotNull
    public List<GutterMark> findGuttersAtCaret(@NotNull String filePath) {
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(145);
        }
        this.configureByFilesInner(filePath);
        List<GutterMark> list = this.findGuttersAtCaret();
        if (list == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(146);
        }
        return list;
    }

    public static boolean processGuttersAtCaret(Editor editor2, Project project, @NotNull Processor<? super GutterMark> processor) {
        RangeHighlighter[] highlighters;
        if (processor == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(147);
        }
        int offset = editor2.getCaretModel().getOffset();
        for (RangeHighlighter highlighter : highlighters = DocumentMarkupModel.forDocument((Document)editor2.getDocument(), (Project)project, (boolean)true).getAllHighlighters()) {
            GutterIconRenderer renderer = highlighter.getGutterIconRenderer();
            if (renderer == null || editor2.getDocument().getLineNumber(offset) != editor2.getDocument().getLineNumber(highlighter.getStartOffset()) || processor.process((Object)renderer)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public @Unmodifiable List<GutterMark> findAllGutters(@NotNull String filePath) {
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(148);
        }
        this.configureByFilesInner(filePath);
        List<GutterMark> list = this.findAllGutters();
        if (list == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(149);
        }
        return list;
    }

    @Override
    @NotNull
    public @Unmodifiable List<GutterMark> findAllGutters() {
        RangeHighlighter[] highlighters;
        Project project = this.getProject();
        TreeMap result = new TreeMap();
        List<HighlightInfo> infos = this.doHighlighting();
        for (HighlightInfo info : infos) {
            CodeInsightTestFixtureImpl.addGutterIconRenderer(info.getGutterIconRenderer(), info.startOffset, result);
        }
        for (RangeHighlighter highlighter : highlighters = DocumentMarkupModel.forDocument((Document)this.editor.getDocument(), (Project)project, (boolean)true).getAllHighlighters()) {
            if (!highlighter.isValid()) continue;
            CodeInsightTestFixtureImpl.addGutterIconRenderer((GutterMark)highlighter.getGutterIconRenderer(), highlighter.getStartOffset(), result);
        }
        List list = ContainerUtil.concat(result.values());
        if (list == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(150);
        }
        return list;
    }

    @Override
    public PsiFile addFileToProject(@NotNull String relativePath, @NotNull String fileText) {
        if (relativePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(151);
        }
        if (fileText == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(152);
        }
        this.assertInitialized();
        return this.addFileToProject(this.getTempDirPath(), relativePath, fileText);
    }

    protected PsiFile addFileToProject(@NotNull String rootPath, @NotNull String relativePath, @NotNull String fileText) {
        if (rootPath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(153);
        }
        if (relativePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(154);
        }
        if (fileText == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(155);
        }
        try {
            VirtualFile file = (VirtualFile)WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> {
                try {
                    VirtualFile f = this.myTempDirFixture instanceof LightTempDirTestFixtureImpl ? this.myTempDirFixture.createFile(relativePath, fileText) : (this.myProjectFixture instanceof HeavyIdeaTestFixture ? ((HeavyIdeaTestFixture)this.myProjectFixture).addFileToProject(rootPath, relativePath, fileText).getViewProvider().getVirtualFile() : this.myTempDirFixture.createFile(relativePath, fileText));
                    this.prepareVirtualFile(f);
                    VirtualFile virtualFile = f;
                    return virtualFile;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    PsiManager.getInstance((Project)this.getProject()).dropPsiCaches();
                    IndexingTestUtil.waitUntilIndexesAreReady(this.getProject());
                }
            });
            return (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findFile(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> void registerExtension(@NotNull ExtensionsArea area, @NotNull ExtensionPointName<T> epName, @NotNull T extension) {
        if (area == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(156);
        }
        if (epName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(157);
        }
        if (extension == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(158);
        }
        this.assertInitialized();
        area.getExtensionPoint(epName).registerExtension(extension, this.myProjectFixture.getTestRootDisposable());
    }

    @Override
    @NotNull
    public PsiManager getPsiManager() {
        PsiManagerImpl psiManagerImpl = this.myPsiManager;
        if (psiManagerImpl == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(159);
        }
        return psiManagerImpl;
    }

    @Override
    public LookupElement[] complete(@NotNull CompletionType type) {
        if (type == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(160);
        }
        return this.myEditorTestFixture.complete(type);
    }

    @Override
    public LookupElement[] complete(@NotNull CompletionType type, int invocationCount) {
        if (type == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(161);
        }
        this.assertInitialized();
        return this.myEditorTestFixture.complete(type, invocationCount);
    }

    @Override
    public LookupElement @Nullable [] completeBasic() {
        return this.myEditorTestFixture.completeBasic();
    }

    @Override
    @NotNull
    public final List<LookupElement> completeBasicAllCarets(@Nullable Character charToTypeIfOnlyOneOrNoCompletion, @Nullable Character charToTypeIfMultipleCompletions) {
        List<LookupElement> list = this.myEditorTestFixture.completeBasicAllCarets(charToTypeIfOnlyOneOrNoCompletion, charToTypeIfMultipleCompletions);
        if (list == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(162);
        }
        return list;
    }

    @Override
    @NotNull
    public final List<LookupElement> completeBasicAllCarets(@Nullable Character charToTypeAfterCompletion) {
        return this.completeBasicAllCarets(charToTypeAfterCompletion, charToTypeAfterCompletion);
    }

    @Override
    public void saveText(@NotNull VirtualFile file, @NotNull String text) {
        if (file == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(163);
        }
        if (text == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(164);
        }
        try {
            WriteAction.runAndWait(() -> VfsUtil.saveText((VirtualFile)file, (String)text));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public LookupElement @Nullable [] getLookupElements() {
        return this.myEditorTestFixture.getLookupElements();
    }

    @Override
    public void checkResult(@NotNull String expectedText) {
        if (expectedText == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(165);
        }
        this.checkResult(expectedText, false);
    }

    @Override
    public void checkResult(@NotNull String expectedText, boolean stripTrailingSpaces) {
        IdeaTestExecutionPolicy policy;
        if (expectedText == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(166);
        }
        if ((policy = IdeaTestExecutionPolicy.current()) != null) {
            policy.beforeCheckResult(this.getFile());
        }
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> {
            PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
            EditorUtil.fillVirtualSpaceUntilCaret((Editor)this.getHostEditor());
            this.checkResult("TEXT", stripTrailingSpaces, SelectionAndCaretMarkupLoader.fromText(expectedText), this.getHostFile().getText());
        });
    }

    @Override
    public void checkResult(@NotNull String filePath, @NotNull String expectedText, boolean stripTrailingSpaces) {
        IdeaTestExecutionPolicy policy;
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(167);
        }
        if (expectedText == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(168);
        }
        if ((policy = IdeaTestExecutionPolicy.current()) != null) {
            policy.beforeCheckResult(this.getFile());
        }
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> {
            PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
            PsiFile psiFile = this.getFileToCheck(filePath);
            this.checkResult("TEXT", stripTrailingSpaces, SelectionAndCaretMarkupLoader.fromText(expectedText), psiFile.getText());
        });
    }

    @Override
    public void checkResultByFile(@NotNull String expectedFile) {
        if (expectedFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(169);
        }
        this.checkResultByFile(expectedFile, false);
    }

    @Override
    public void checkResultByFile(@NotNull String expectedFile, boolean ignoreTrailingWhitespaces) {
        if (expectedFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(170);
        }
        this.assertInitialized();
        ApplicationManager.getApplication().invokeAndWait(() -> this.checkResultByFile(expectedFile, this.getHostFile(), ignoreTrailingWhitespaces));
    }

    @Override
    public void checkResultByFile(@NotNull String filePath, @NotNull String expectedFile, boolean ignoreTrailingWhitespaces) {
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(171);
        }
        if (expectedFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(172);
        }
        this.assertInitialized();
        ApplicationManager.getApplication().invokeAndWait(() -> this.checkResultByFile(expectedFile, this.getFileToCheck(filePath), ignoreTrailingWhitespaces));
    }

    private PsiFile getFileToCheck(String filePath) {
        String path = filePath.replace(File.separatorChar, '/');
        VirtualFile copy = this.findFileInTempDir(path);
        Assert.assertNotNull((String)("could not find results file " + path), (Object)copy);
        PsiFile psiFile = this.myPsiManager.findFile(copy);
        Assert.assertNotNull((String)copy.getPath(), (Object)psiFile);
        return psiFile;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        EdtTestUtil.runInEdtAndWait(() -> {
            this.myProjectFixture.setUp();
            this.myTempDirFixture.setUp();
            VirtualFile tempDir2 = this.myTempDirFixture.getFile("");
            Assert.assertNotNull((Object)tempDir2);
            HeavyPlatformTestCase.synchronizeTempDirVfs(tempDir2);
            this.myPsiManager = (PsiManagerImpl)PsiManager.getInstance((Project)this.getProject());
            InspectionsKt.configureInspections((InspectionProfileEntry[])LocalInspectionTool.EMPTY_ARRAY, this.getProject(), this.myProjectFixture.getTestRootDisposable());
            DaemonCodeAnalyzerImpl daemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.getProject());
            daemonCodeAnalyzer.prepareForTest();
            DaemonCodeAnalyzerSettings.getInstance().setImportHintEnabled(false);
            CodeInsightTestFixtureImpl.ensureIndexesUpToDate(this.getProject());
            CodeStyle.setTemporarySettings((Project)this.getProject(), (CodeStyleSettings)CodeStyle.createTestSettings());
            IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
            if (policy != null) {
                policy.setUp(this.getProject(), this.getTestRootDisposable(), this.getTestDataPath());
            }
            ActionUtil.performActionDumbAwareWithCallbacks((AnAction)new EmptyAction(true), (AnActionEvent)AnActionEvent.createFromDataContext((String)"", null, (DataContext)DataContext.EMPTY_CONTEXT));
        });
        for (Module module2 : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            ModuleRootManager.getInstance((Module)module2).orderEntries().getAllLibrariesAndSdkClassesRoots();
        }
        if (this.shouldTrackVirtualFilePointers()) {
            this.myVirtualFilePointerTracker = new VirtualFilePointerTracker();
        }
        this.myLibraryTableTracker = new LibraryTableTracker();
        IndexingTestUtil.waitUntilIndexesAreReady(this.getProject());
    }

    protected boolean shouldTrackVirtualFilePointers() {
        return true;
    }

    @Override
    public void tearDown() throws Exception {
        AtomicReference projectRootManagerComponentRef = new AtomicReference();
        RunAll.runAll(() -> EdtTestUtil.runInEdtAndWait(() -> {
            DaemonCodeAnalyzerSettings daemonCodeAnalyzerSettings;
            Project project;
            if (ApplicationManager.getApplication() == null) {
                return;
            }
            try {
                project = this.myProjectFixture.getProject();
            }
            catch (AssertionError | UninitializedPropertyAccessException ignore) {
                project = null;
            }
            if (project != null) {
                CodeStyle.dropTemporarySettings((Project)project);
                AutoPopupController autoPopupController = (AutoPopupController)project.getServiceIfCreated(AutoPopupController.class);
                if (autoPopupController != null) {
                    autoPopupController.cancelAllRequests();
                }
            }
            if ((daemonCodeAnalyzerSettings = (DaemonCodeAnalyzerSettings)ApplicationManager.getApplication().getServiceIfCreated(DaemonCodeAnalyzerSettings.class)) != null) {
                daemonCodeAnalyzerSettings.setImportHintEnabled(true);
            }
            if (project != null) {
                this.closeOpenFiles();
                ((DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project)).cleanupAfterTest();
                ((ProjectRootManagerImpl)ProjectRootManager.getInstance((Project)project)).clearScopesCachesForModules();
                projectRootManagerComponentRef.set((ProjectRootManagerComponent)ObjectUtils.tryCast((Object)ProjectRootManager.getInstance((Project)project), ProjectRootManagerComponent.class));
            }
        }), () -> {
            this.clearFileAndEditor();
            this.myPsiManager = null;
        }, () -> this.disposeRootDisposable(), () -> EdtTestUtil.runInEdtAndWait(() -> this.myProjectFixture.tearDown()), () -> EdtTestUtil.runInEdtAndWait(() -> this.myTempDirFixture.tearDown()), () -> super.tearDown(), () -> {
            ProjectRootManagerComponent projectRootManagerComponent = projectRootManagerComponentRef.getAndSet(null);
            if (projectRootManagerComponent != null) {
                projectRootManagerComponent.disposeVirtualFilePointersAfterTest();
            }
            if (this.myVirtualFilePointerTracker != null) {
                this.myVirtualFilePointerTracker.assertPointersAreDisposed();
            }
        }, () -> {
            if (this.myLibraryTableTracker != null) {
                this.myLibraryTableTracker.assertDisposed();
            }
        });
    }

    private void closeOpenFiles() {
        Project project = this.getProject();
        if (project == null) {
            return;
        }
        LookupManager.hideActiveLookup((Project)project);
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        FileEditorManagerEx.getInstanceEx((Project)project).closeAllFiles();
        EditorHistoryManager.getInstance((Project)project).removeAllFiles();
    }

    private PsiFile @NotNull [] configureByFilesInner(String ... filePaths) {
        if (filePaths == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(173);
        }
        this.assertInitialized();
        this.clearFileAndEditor();
        this.myAllPsiFiles = new PsiFile[filePaths.length];
        for (int i2 = filePaths.length - 1; i2 >= 0; --i2) {
            this.myAllPsiFiles[i2] = this.configureByFileInner(filePaths[i2]);
        }
        if (this.myAllPsiFiles == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(174);
        }
        return this.myAllPsiFiles;
    }

    @Override
    public PsiFile configureByFile(@NotNull String file) {
        if (file == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(175);
        }
        this.configureByFilesInner(file);
        return this.getFile();
    }

    @Override
    public PsiFile @NotNull [] configureByFiles(String ... files) {
        if (files == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(176);
        }
        return this.configureByFilesInner(files);
    }

    @Override
    public PsiFile configureByText(@NotNull FileType fileType, @NotNull String text) {
        if (fileType == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(177);
        }
        if (text == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(178);
        }
        this.assertInitialized();
        String extension = fileType.getDefaultExtension();
        CodeInsightTestFixtureImpl.associateExtensionTemporarily(fileType, extension, this.getTestRootDisposable());
        String fileName = "aaa." + extension;
        return this.configureByText(fileName, text);
    }

    public static void associateExtensionTemporarily(@NotNull FileType fileType, @NotNull String extension, @NotNull Disposable parentDisposable) {
        FileTypeManager fileTypeManager;
        if (fileType == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(179);
        }
        if (extension == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(180);
        }
        if (parentDisposable == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(181);
        }
        if (!fileType.equals((fileTypeManager = FileTypeManager.getInstance()).getFileTypeByExtension(extension))) {
            WriteAction.runAndWait(() -> {
                fileTypeManager.associateExtension(fileType, extension);
                IndexingTestUtil.waitUntilIndexesAreReadyInAllOpenedProjects();
            });
            Disposer.register((Disposable)parentDisposable, () -> WriteAction.runAndWait(() -> {
                fileTypeManager.removeAssociatedExtension(fileType, extension);
                IndexingTestUtil.waitUntilIndexesAreReadyInAllOpenedProjects();
            }));
        }
    }

    @Override
    public PsiFile configureByText(@NotNull String fileName, @NotNull String text) {
        if (fileName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(182);
        }
        if (text == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(183);
        }
        this.assertInitialized();
        VirtualFile vFile = this.createFile(fileName, text);
        return this.configureInner(vFile, SelectionAndCaretMarkupLoader.fromFile(vFile));
    }

    @Override
    public VirtualFile createFile(@NotNull String fileName, @NotNull String text) {
        if (fileName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(184);
        }
        if (text == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(185);
        }
        this.assertInitialized();
        try {
            VirtualFile createdFile = (VirtualFile)WriteCommandAction.writeCommandAction((Project)this.getProject()).compute(() -> {
                VirtualFile file;
                if (this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
                    VirtualFile root = LightPlatformTestCase.getSourceRoot();
                    root.refresh(false, false);
                    file = root.findOrCreateChildData((Object)this, fileName);
                    Assert.assertNotNull((String)(fileName + " not found in " + root.getPath()), (Object)file);
                } else if (this.myTempDirFixture instanceof TempDirTestFixtureImpl) {
                    Path tempFile = ((TempDirTestFixtureImpl)this.myTempDirFixture).createTempFile(fileName);
                    file = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)tempFile.toString()));
                    Assert.assertNotNull((String)(tempFile + " not found"), (Object)file);
                } else {
                    file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(this.getTempDirPath(), fileName));
                    Assert.assertNotNull((String)(fileName + " not found in " + this.getTempDirPath()), (Object)file);
                }
                this.prepareVirtualFile(file);
                Document document = FileDocumentManager.getInstance().getCachedDocument(file);
                if (document != null) {
                    PsiDocumentManager.getInstance((Project)this.getProject()).doPostponedOperationsAndUnblockDocument(document);
                    FileDocumentManager.getInstance().saveDocument(document);
                }
                VfsUtil.saveText((VirtualFile)file, (String)text);
                return file;
            });
            IndexingTestUtil.waitUntilIndexesAreReady(this.getProject());
            return createdFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Document getDocument(@NotNull PsiFile file) {
        if (file == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(186);
        }
        this.assertInitialized();
        return PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file);
    }

    private PsiFile configureByFileInner(@NotNull String filePath) {
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(187);
        }
        this.assertInitialized();
        VirtualFile file = this.copyFileToProject(filePath);
        return this.configureByFileInner(file);
    }

    @Override
    public PsiFile configureFromTempProjectFile(@NotNull String filePath) {
        VirtualFile fileInTempDir;
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(188);
        }
        if ((fileInTempDir = this.findFileInTempDir(filePath)) == null) {
            throw new IllegalArgumentException("Could not find file in temp dir: " + filePath);
        }
        return this.configureByFileInner(fileInTempDir);
    }

    @Override
    public void configureFromExistingVirtualFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(189);
        }
        this.configureByFileInner(virtualFile);
    }

    private PsiFile configureByFileInner(@NotNull VirtualFile copy) {
        if (copy == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(190);
        }
        return this.configureInner(copy, SelectionAndCaretMarkupLoader.fromFile(copy));
    }

    private PsiFile configureInner(@NotNull VirtualFile copy, @NotNull SelectionAndCaretMarkupLoader loader) {
        if (copy == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(191);
        }
        if (loader == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(192);
        }
        this.assertInitialized();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            IdeaTestExecutionPolicy policy;
            if (!copy.getFileType().isBinary()) {
                switch (this.mySelectionAndCaretMarkupApplyPolicy) {
                    case UPDATE_FILE_AND_KEEP_DOCUMENT_CLEAN: {
                        try {
                            ApplicationManager.getApplication().runWriteAction(() -> {
                                byte[] newBytes = loader.newFileText.getBytes(copy.getCharset());
                                if (copy.getFileSystem() instanceof ArchiveFileSystem) {
                                    Assert.assertArrayEquals((String)("Cannot modify file on read-only archive file system: " + copy.getPath()), (byte[])copy.contentsToByteArray(), (byte[])newBytes);
                                } else {
                                    copy.setBinaryContent(newBytes);
                                }
                                return null;
                            });
                            break;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    case UPDATE_DOCUMENT_AND_LEAVE_IT_DIRTY: {
                        Document document = FileDocumentManager.getInstance().getDocument(copy);
                        if (document == null) {
                            throw new IllegalStateException("Document not found: " + copy);
                        }
                        WriteAction.runAndWait(() -> {
                            String newText = loader.newDocumentText;
                            if (copy.getFileSystem() instanceof ArchiveFileSystem) {
                                Assert.assertEquals((String)("Cannot modify file on read-only archive file system: " + copy.getPath()), (Object)document.getText(), (Object)newText);
                            } else {
                                document.setText((CharSequence)newText);
                            }
                        });
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.valueOf((Object)this.mySelectionAndCaretMarkupApplyPolicy));
                    }
                }
            }
            this.setFileAndEditor(copy, this.createEditor(copy));
            if (this.editor == null) {
                Assert.fail((String)("editor couldn't be created for: " + copy.getPath() + ", use copyFileToProject() instead of configureByFile()"));
            }
            EditorTestUtil.setCaretsAndSelection(this.editor, loader.caretState);
            Module module2 = this.getModule();
            if (module2 != null) {
                FacetManager facetManager = FacetManager.getInstance((Module)module2);
                for (Facet facet : facetManager.getAllFacets()) {
                    facetManager.facetConfigurationChanged(facet);
                }
            }
            PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
            IndexingTestUtil.waitUntilIndexesAreReady(this.getProject());
            if (this.caresAboutInjection) {
                this.setupEditorForInjectedLanguage();
            }
            if ((policy = IdeaTestExecutionPolicy.current()) != null) {
                policy.testFileConfigured(this.getFile());
            }
        });
        return this.getFile();
    }

    protected void prepareVirtualFile(@NotNull VirtualFile file) {
        if (file == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(193);
        }
    }

    private void setupEditorForInjectedLanguage() {
        Editor editor2 = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)this.editor, (PsiFile)this.getFile());
        if (editor2 instanceof EditorWindow) {
            this.setFileAndEditor(((EditorWindow)editor2).getInjectedFile().getViewProvider().getVirtualFile(), editor2);
        }
    }

    @Override
    public VirtualFile findFileInTempDir(@NotNull String filePath) {
        if (filePath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(194);
        }
        if (this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
            return this.myTempDirFixture.getFile(filePath);
        }
        String fullPath = this.getTempDirPath() + "/" + filePath;
        VirtualFile copy = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath.replace(File.separatorChar, '/'));
        Assert.assertNotNull((String)("file " + fullPath + " not found"), (Object)copy);
        VfsTestUtil.assertFilePathEndsWithCaseSensitivePath(copy, filePath);
        return copy;
    }

    @NotNull
    protected Editor createEditor(@NotNull VirtualFile file) {
        if (file == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(195);
        }
        Project project = this.getProject();
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        Editor editor2 = fileEditorManager.openTextEditor(new OpenFileDescriptor(project, file), false);
        UIUtil.markAsFocused((JComponent)editor2.getContentComponent(), (boolean)true);
        DaemonCodeAnalyzerEx.getInstanceEx((Project)project).restart((Object)"CodeInsightTestFixtureImpl.createEditor");
        Editor editor3 = editor2;
        if (editor3 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(196);
        }
        return editor3;
    }

    private long collectAndCheckHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings) {
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings, false);
    }

    private long collectAndCheckHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, boolean ignoreExtraHighlighting) {
        if (this.editor == null) {
            throw new IllegalStateException("Fixture is not configured. Call something like configureByFile() or configureByText()");
        }
        ExpectedHighlightingData data = new ExpectedHighlightingData(this.editor.getDocument(), checkWarnings, checkWeakWarnings, checkInfos, ignoreExtraHighlighting);
        data.init();
        return this.collectAndCheckHighlighting(data);
    }

    private PsiFile getHostFile() {
        VirtualFile hostVFile = this.myFile instanceof VirtualFileWindow ? ((VirtualFileWindow)this.myFile).getDelegate() : this.myFile;
        return (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findFile(hostVFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long collectAndCheckHighlighting(@NotNull ExpectedHighlightingData data) {
        List<HighlightInfo> infos;
        if (data == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(197);
        }
        Project project = this.getProject();
        EdtTestUtil.runInEdtAndWait(() -> PsiDocumentManager.getInstance((Project)project).commitAllDocuments());
        PsiFileImpl file = (PsiFileImpl)this.getHostFile();
        FileElement hardRefToFileElement = file.calcTreeElement();
        CodeInsightTestFixtureImpl.ensureIndexesUpToDate(project);
        long start = System.currentTimeMillis();
        VirtualFileFilter fileTreeAccessFilter = this.myVirtualFileFilter;
        Disposable disposable = Disposer.newDisposable();
        if (fileTreeAccessFilter != null) {
            PsiManagerEx.getInstanceEx((Project)project).setAssertOnFileLoadingFilter(fileTreeAccessFilter, disposable);
        }
        try {
            infos = this.doHighlighting();
            infos = CodeInsightTestFixtureImpl.removeDuplicatedRangesForInjected(infos);
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
        long elapsed = System.currentTimeMillis() - start;
        data.checkResult((PsiFile)file, infos, file.getText());
        if (data.hasLineMarkers()) {
            Document document = this.getDocument(this.getFile());
            data.checkLineMarkers((PsiFile)file, DaemonCodeAnalyzerImpl.getLineMarkers((Document)document, (Project)this.getProject()), document.getText());
        }
        Reference.reachabilityFence(hardRefToFileElement);
        return elapsed;
    }

    public void setVirtualFileFilter(@Nullable VirtualFileFilter filter) {
        this.myVirtualFileFilter = filter;
    }

    @Override
    @NotNull
    public @Unmodifiable List<HighlightInfo> doHighlighting() {
        List<HighlightInfo> list = this.myEditorTestFixture.doHighlighting(this.myAllowDirt, this.myReadEditorMarkupModel);
        if (list == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(198);
        }
        return list;
    }

    @Override
    @NotNull
    public @Unmodifiable List<HighlightInfo> doHighlighting(@NotNull HighlightSeverity minimalSeverity) {
        if (minimalSeverity == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(199);
        }
        List list = ContainerUtil.filter(this.doHighlighting(), info -> info.getSeverity().compareTo(minimalSeverity) >= 0);
        if (list == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(200);
        }
        return list;
    }

    @Override
    @NotNull
    public String getTestDataPath() {
        String string = this.myTestDataPath;
        if (string == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(201);
        }
        return string;
    }

    @Override
    public void setTestDataPath(@NotNull String dataPath) {
        if (dataPath == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(202);
        }
        this.myTestDataPath = dataPath;
    }

    @Override
    public final Project getProject() {
        return this.myProjectFixture.getProject();
    }

    @Override
    public Module getModule() {
        return this.myProjectFixture.getModule();
    }

    @Override
    public Editor getEditor() {
        return this.editor;
    }

    @Override
    public int getCaretOffset() {
        return this.editor.getCaretModel().getOffset();
    }

    @Override
    public PsiFile getFile() {
        return this.myFile != null ? (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findFile(this.myFile)) : null;
    }

    @Override
    public void allowTreeAccessForFile(@NotNull VirtualFile file) {
        if (file == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(203);
        }
        assert (this.myVirtualFileFilter instanceof FileTreeAccessFilter) : "configured filter does not support this method";
        ((FileTreeAccessFilter)this.myVirtualFileFilter).allowTreeAccessForFile(file);
    }

    @Override
    public void allowTreeAccessForAllFiles() {
        assert (this.myVirtualFileFilter instanceof FileTreeAccessFilter) : "configured filter does not support this method";
        ((FileTreeAccessFilter)this.myVirtualFileFilter).allowTreeAccessForAllFiles();
    }

    private void checkResultByFile(@NotNull String expectedFile, @NotNull PsiFile originalFile, boolean stripTrailingSpaces) {
        IdeaTestExecutionPolicy policy;
        if (expectedFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(204);
        }
        if (originalFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(205);
        }
        if ((policy = IdeaTestExecutionPolicy.current()) != null) {
            policy.beforeCheckResult(this.getFile());
        }
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        if (!stripTrailingSpaces) {
            EditorUtil.fillVirtualSpaceUntilCaret((Editor)this.getHostEditor());
        }
        String psiFileText = originalFile.getText();
        String path = this.getTestDataPath() + "/" + expectedFile;
        String charset = Optional.ofNullable(originalFile.getVirtualFile()).map(f -> f.getCharset().name()).orElse(null);
        this.checkResult(expectedFile, stripTrailingSpaces, SelectionAndCaretMarkupLoader.fromFile(path, charset), psiFileText);
    }

    private void checkResult(@NotNull String expectedFile, boolean stripTrailingSpaces, @NotNull SelectionAndCaretMarkupLoader loader, @NotNull String actualDocumentText) {
        if (expectedFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(206);
        }
        if (loader == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(207);
        }
        if (actualDocumentText == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(208);
        }
        this.assertInitialized();
        Project project = this.getProject();
        Editor editor2 = this.getEditor();
        if (editor2 instanceof EditorWindow) {
            editor2 = ((EditorWindow)editor2).getDelegate();
        }
        UsefulTestCase.doPostponedFormatting(this.getProject());
        if (stripTrailingSpaces) {
            actualDocumentText = this.stripTrailingSpaces((String)actualDocumentText);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        String expectedText = loader.newDocumentText;
        if (stripTrailingSpaces) {
            expectedText = this.stripTrailingSpaces(expectedText);
        }
        if (!Objects.equals(expectedText, actualDocumentText = StringUtil.convertLineSeparators((String)actualDocumentText))) {
            if (loader.filePath == null) {
                throw new FileComparisonFailedError(expectedFile, expectedText, (String)actualDocumentText, null);
            }
            if (loader.caretState.hasExplicitCaret()) {
                int offset = editor2.getCaretModel().getOffset();
                if (offset > -1) {
                    if (offset > ((String)actualDocumentText).length()) {
                        actualDocumentText = (String)actualDocumentText + StringUtil.repeat((String)" ", (int)(offset - ((String)actualDocumentText).length()));
                    }
                    actualDocumentText = new StringBuilder((String)actualDocumentText).insert(offset, "<caret>").toString();
                }
                expectedText = loader.newDocumentText;
                if (stripTrailingSpaces) {
                    expectedText = this.stripTrailingSpaces(expectedText);
                }
            }
            throw new FileComparisonFailedError(expectedFile, expectedText, (String)actualDocumentText, loader.filePath);
        }
        EditorTestUtil.verifyCaretAndSelectionState(editor2, loader.caretState, expectedFile, loader.filePath);
    }

    @NotNull
    private String stripTrailingSpaces(@NotNull String actualText) {
        if (actualText == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(209);
        }
        Document document = EditorFactory.getInstance().createDocument((CharSequence)actualText);
        ((DocumentImpl)document).stripTrailingSpaces(this.getProject());
        String string = actualText = document.getText();
        if (string == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(210);
        }
        return string;
    }

    public void canChangeDocumentDuringHighlighting(boolean canI) {
        this.myAllowDirt = canI;
    }

    @NotNull
    public String getFoldingDescription(boolean withCollapseStatus) {
        Editor topEditor = this.getHostEditor();
        String string = (String)EdtTestUtil.runInEdtAndGet(() -> {
            IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
            if (policy != null) {
                policy.waitForHighlighting(this.getProject(), topEditor);
            }
            EditorTestUtil.buildInitialFoldingsInBackground(topEditor);
            return CodeInsightTestFixtureImpl.getFoldingData(topEditor, withCollapseStatus);
        });
        if (string == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(211);
        }
        return string;
    }

    @NotNull
    public static String getFoldingData(Editor topEditor, boolean withCollapseStatus) {
        return CodeInsightTestFixtureImpl.getTagsFromSegments(topEditor.getDocument().getText(), Arrays.asList(topEditor.getFoldingModel().getAllFoldRegions()), FOLD, foldRegion -> "text='" + foldRegion.getPlaceholderText() + "'" + (String)(withCollapseStatus ? " expand='" + foldRegion.isExpanded() + "'" : ""));
    }

    @NotNull
    public static <T extends Segment> String getTagsFromSegments(@NotNull String text, @NotNull Collection<? extends T> segments, @NotNull String tagName, @Nullable com.intellij.util.Function<? super T, String> attrCalculator) {
        if (text == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(212);
        }
        if (segments == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(213);
        }
        if (tagName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(214);
        }
        List borders = segments.stream().flatMap(region -> Stream.of(new Border(true, region.getStartOffset(), attrCalculator == null ? null : (String)attrCalculator.fun(region)), new Border(false, region.getEndOffset(), ""))).sorted().toList();
        StringBuilder result = new StringBuilder(text);
        for (Border border : borders) {
            StringBuilder info = new StringBuilder();
            info.append('<');
            if (border.isLeftBorder) {
                info.append(tagName);
                if (border.text != null) {
                    info.append(' ').append(border.text);
                }
            } else {
                info.append('/').append(tagName);
            }
            info.append('>');
            result.insert(border.offset, info);
        }
        String string = result.toString();
        if (string == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(215);
        }
        return string;
    }

    private void testFoldingRegions(@NotNull String verificationFileName, @Nullable String destinationFileName, boolean doCheckCollapseStatus) {
        String expectedContent;
        File verificationFile;
        if (verificationFileName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(216);
        }
        try {
            verificationFile = new File(verificationFileName);
            expectedContent = FileUtil.loadFile((File)verificationFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Assert.assertNotNull((Object)expectedContent);
        expectedContent = StringUtil.replace((String)expectedContent, (String)"\r", (String)"");
        String cleanContent = CodeInsightTestFixtureImpl.removeFoldingMarkers(expectedContent);
        if (destinationFileName == null) {
            String fileName = PathUtil.getFileName((String)verificationFileName);
            this.configureByText(fileName, cleanContent);
        } else {
            try {
                String tempDirPrefix = this.myTempDirFixture.getFile("").getUrl();
                if (destinationFileName.startsWith(tempDirPrefix)) {
                    VirtualFile file = this.myTempDirFixture.createFile(destinationFileName.substring(tempDirPrefix.length()), cleanContent);
                    Assert.assertNotNull((Object)file);
                    this.configureFromExistingVirtualFile(file);
                } else {
                    FileUtil.writeToFile((File)new File(destinationFileName), (String)cleanContent);
                    VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(destinationFileName);
                    Assert.assertNotNull((Object)file);
                    this.configureFromExistingVirtualFile(file);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        String actual = this.getFoldingDescription(doCheckCollapseStatus);
        if (!expectedContent.equals(actual)) {
            throw new FileComparisonFailedError(verificationFile.getName(), expectedContent, actual, verificationFile.getPath());
        }
    }

    @NotNull
    public static String removeFoldingMarkers(String expectedContent) {
        String string = expectedContent.replaceAll("<fold\\stext='[^']*'(\\sexpand='[^']*')*>", "").replace("</fold>", "");
        if (string == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(217);
        }
        return string;
    }

    @Override
    public void testFoldingWithCollapseStatus(@NotNull String verificationFileName) {
        if (verificationFileName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(218);
        }
        this.testFoldingRegions(verificationFileName, null, true);
    }

    @Override
    public void testFoldingWithCollapseStatus(@NotNull String verificationFileName, @Nullable String destinationFileName) {
        if (verificationFileName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(219);
        }
        this.testFoldingRegions(verificationFileName, destinationFileName, true);
    }

    @Override
    public void testFolding(@NotNull String verificationFileName) {
        if (verificationFileName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(220);
        }
        this.testFoldingRegions(verificationFileName, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithRainbowEnabled(boolean isRainbowOn, @NotNull Runnable runnable) {
        if (runnable == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(221);
        }
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        boolean isRainbowOnInScheme = RainbowHighlighter.isRainbowEnabled((TextAttributesScheme)globalScheme, null);
        try {
            RainbowHighlighter.setRainbowEnabled((SchemeMetaInfo)globalScheme, null, (Boolean)isRainbowOn);
            runnable.run();
        }
        finally {
            RainbowHighlighter.setRainbowEnabled((SchemeMetaInfo)globalScheme, null, (Boolean)isRainbowOnInScheme);
        }
    }

    @Override
    public void testRainbow(@NotNull String fileName, @NotNull String text, boolean isRainbowOn, boolean withColor) {
        if (fileName == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(222);
        }
        if (text == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(223);
        }
        CodeInsightTestFixtureImpl.runWithRainbowEnabled(isRainbowOn, () -> {
            String RB_PREFIF = "TEMP::RAINBOW_TEMP_";
            this.configureByText(fileName, text.replaceAll("<rainbow(\\scolor='[^']*')?>", "").replace("</rainbow>", ""));
            List highlighting = ContainerUtil.filter(this.doHighlighting(), info -> info.type == RainbowHighlighter.RAINBOW_ELEMENT);
            Assert.assertEquals((Object)text, (Object)CodeInsightTestFixtureImpl.getTagsFromSegments(this.editor.getDocument().getText(), highlighting, RAINBOW, highlightInfo -> {
                String name;
                if (!withColor) {
                    return null;
                }
                TextAttributesKey rb_key = highlightInfo.forcedTextAttributesKey;
                if (rb_key != null && (name = rb_key.getExternalName()).startsWith(RB_PREFIF)) {
                    int color = -16777215 + Integer.parseInt(name.substring(RB_PREFIF.length()));
                    return "color='" + Integer.toHexString(color) + "'";
                }
                TextAttributes attributes = highlightInfo.getTextAttributes(null, null);
                String color = attributes == null ? "null" : (attributes.getForegroundColor() == null ? "null" : Integer.toHexString(attributes.getForegroundColor().getRGB()));
                return "color='" + color + "'";
            }));
        });
    }

    @Override
    public void testInlays() {
        InlayHintsChecker checker = new InlayHintsChecker(this);
        try {
            checker.setUp();
            checker.checkParameterHints();
        }
        finally {
            checker.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testInlays(Function<? super Inlay<?>, String> inlayPresenter, Predicate<? super Inlay<?>> inlayFilter) {
        InlayHintsChecker checker = new InlayHintsChecker(this);
        try {
            checker.setUp();
            checker.checkInlays(inlayPresenter::apply, inlayFilter::test);
        }
        finally {
            checker.tearDown();
        }
    }

    @Override
    public void checkResultWithInlays(String text) {
        DocumentImpl checkDocument = new DocumentImpl(text);
        InlayHintsChecker checker = new InlayHintsChecker(this);
        CaretAndInlaysInfo inlaysAndCaretInfo = checker.extractInlaysAndCaretInfo((Document)checkDocument);
        this.checkResult(checkDocument.getText());
        checker.verifyInlaysAndCaretInfo(inlaysAndCaretInfo, text);
    }

    @Override
    public void assertPreferredCompletionItems(int selected, String ... expected) {
        if (expected == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(224);
        }
        this.myEditorTestFixture.assertPreferredCompletionItems(selected, expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void testStructureView(@NotNull Consumer<? super StructureViewComponent> consumer) {
        if (consumer == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(225);
        }
        Assert.assertNotNull((String)"configure first", (Object)this.myFile);
        FileEditor fileEditor = FileEditorManager.getInstance((Project)this.getProject()).getSelectedEditor(this.myFile);
        Assert.assertNotNull((String)("editor not opened for " + this.myFile), (Object)this.myFile);
        StructureViewBuilder builder = LanguageStructureViewBuilder.getInstance().getStructureViewBuilder(this.getFile());
        Assert.assertNotNull((String)("no builder for " + this.myFile), (Object)builder);
        StructureViewComponent component = null;
        try {
            component = (StructureViewComponent)builder.createStructureView(fileEditor, this.getProject());
            PlatformTestUtil.waitForPromise(component.rebuildAndUpdate());
            consumer.consume((Object)component);
            if (component == null) return;
        }
        catch (Throwable throwable) {
            if (component == null) throw throwable;
            Disposer.dispose(component);
            throw throwable;
        }
        Disposer.dispose((Disposable)component);
    }

    @Override
    public void setCaresAboutInjection(boolean caresAboutInjection) {
        this.caresAboutInjection = caresAboutInjection;
    }

    @Override
    public void setReadEditorMarkupModel(boolean readEditorMarkupModel) {
        this.myReadEditorMarkupModel = readEditorMarkupModel;
    }

    public LookupImpl getLookup() {
        return this.myEditorTestFixture.getLookup();
    }

    @Override
    @NotNull
    public List<Object> getGotoClassResults(@NotNull String pattern, boolean searchEverywhere, @Nullable PsiElement contextForSorting) {
        if (pattern == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(226);
        }
        SearchEverywhereContributor<Object> contributor = this.createMockClassSearchEverywhereContributor(searchEverywhere);
        ArrayList<Object> results = new ArrayList<Object>();
        contributor.fetchElements(pattern, (ProgressIndicator)new MockProgressIndicator(), (Processor)new CommonProcessors.CollectProcessor(results));
        ArrayList<Object> arrayList = results;
        if (arrayList == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(227);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<Object> getGotoSymbolResults(@NotNull String pattern, boolean searchEverywhere, @Nullable PsiElement contextForSorting) {
        if (pattern == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(228);
        }
        SearchEverywhereContributor<Object> contributor = this.createMockSymbolSearchEverywhereContributor(searchEverywhere);
        ArrayList<Object> results = new ArrayList<Object>();
        contributor.fetchElements(pattern, (ProgressIndicator)new MockProgressIndicator(), (Processor)new CommonProcessors.CollectProcessor(results));
        ArrayList<Object> arrayList = results;
        if (arrayList == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(229);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public @Unmodifiable List<Crumb> getBreadcrumbsAtCaret() {
        List<Crumb> list = this.myEditorTestFixture.getBreadcrumbsAtCaret();
        if (list == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(230);
        }
        return list;
    }

    private SearchEverywhereContributor<Object> createMockClassSearchEverywhereContributor(final boolean everywhere) {
        DataContext dataContext = SimpleDataContext.getProjectContext((Project)this.getProject());
        AnActionEvent event = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext);
        ClassSearchEverywhereContributor contributor = new ClassSearchEverywhereContributor(event){
            {
                super(arg0);
                this.myScopeDescriptor = new ScopeDescriptor((SearchScope)FindSymbolParameters.searchScopeFor((Project)this.myProject, (boolean)everywhere));
            }
        };
        Disposer.register((Disposable)this.getProjectDisposable(), (Disposable)contributor);
        return contributor;
    }

    private SearchEverywhereContributor<Object> createMockSymbolSearchEverywhereContributor(final boolean everywhere) {
        DataContext dataContext = SimpleDataContext.getProjectContext((Project)this.getProject());
        AnActionEvent event = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext);
        SymbolSearchEverywhereContributor contributor = new SymbolSearchEverywhereContributor(event){
            {
                super(arg0);
                this.myScopeDescriptor = new ScopeDescriptor((SearchScope)FindSymbolParameters.searchScopeFor((Project)this.myProject, (boolean)everywhere));
            }
        };
        Disposer.register((Disposable)this.getProjectDisposable(), (Disposable)contributor);
        return contributor;
    }

    protected void bringRealEditorBack() {
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        if (this.editor instanceof EditorWindow) {
            Document document = ((DocumentWindow)this.editor.getDocument()).getDelegate();
            this.setFileAndEditor(FileDocumentManager.getInstance().getFile(document), ((EditorWindow)this.editor).getDelegate());
        }
    }

    public static void invokeIntention(@NotNull IntentionAction action, @NotNull PsiFile file, @NotNull Editor editor2) {
        if (action == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(231);
        }
        if (file == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(232);
        }
        if (editor2 == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(233);
        }
        Project project = file.getProject();
        VirtualFile vFile = Objects.requireNonNull(InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)file)).getVirtualFile();
        CodeInsightTestFixtureImpl.withReadOnlyFile(vFile, project, () -> {
            try {
                ApplicationManager.getApplication().invokeLater(() -> {
                    try {
                        boolean executed = ShowIntentionActionsHandler.chooseActionAndInvoke((PsiFile)file, (Editor)editor2, (IntentionAction)action, (String)action.getText());
                        if (!executed) {
                            boolean available = action.isAvailable(project, editor2, file);
                            Assert.fail((String)("Quick fix '" + action.getText() + "' (" + action.getClass() + ") hasn't executed. isAvailable()=" + available));
                        }
                    }
                    catch (StubTextInconsistencyException e) {
                        PsiTestUtil.compareStubTexts(e);
                    }
                });
                UIUtil.dispatchAllInvocationEvents();
                CodeInsightTestFixtureImpl.checkPsiTextConsistency(project, vFile);
            }
            catch (AssertionError e) {
                ExceptionUtil.rethrowUnchecked((Throwable)ExceptionUtil.getRootCause((Throwable)((Object)e)));
                throw e;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean withReadOnlyFile(VirtualFile vFile, Project project, Runnable action) {
        boolean writable;
        if (PlatformUtils.isFleetBackend() && vFile.getFileSystem().isReadOnly()) {
            action.run();
            return false;
        }
        ReadonlyStatusHandlerImpl handler = (ReadonlyStatusHandlerImpl)ReadonlyStatusHandler.getInstance((Project)project);
        CodeInsightTestFixtureImpl.setReadOnly(vFile, true);
        handler.setClearReadOnlyInTests(true);
        try {
            action.run();
        }
        finally {
            writable = vFile.isWritable();
            handler.setClearReadOnlyInTests(false);
            CodeInsightTestFixtureImpl.setReadOnly(vFile, false);
        }
        return writable;
    }

    private static void checkPsiTextConsistency(@NotNull Project project, @NotNull VirtualFile vFile) {
        PsiFile topLevelPsi;
        if (project == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(234);
        }
        if (vFile == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(235);
        }
        PsiFile psiFile = topLevelPsi = vFile.isValid() ? PsiManager.getInstance((Project)project).findFile(vFile) : null;
        if (topLevelPsi != null) {
            if (Registry.is((String)"ide.check.structural.psi.text.consistency.in.tests")) {
                PsiTestUtil.checkPsiStructureWithCommit(topLevelPsi, PsiTestUtil::checkPsiMatchesTextIgnoringNonCode);
            } else {
                PsiTestUtil.checkStubsMatchText(topLevelPsi);
            }
        }
    }

    private static void setReadOnly(VirtualFile vFile, boolean readOnlyStatus) {
        try {
            WriteAction.runAndWait(() -> ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)vFile, (boolean)readOnlyStatus));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public String getUsageViewTreeTextRepresentation(@NotNull UsageViewImpl usageView) {
        if (usageView == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(236);
        }
        Disposer.register((Disposable)this.getTestRootDisposable(), (Disposable)usageView);
        usageView.expandAll();
        String string = TreeNodeTester.forNode((TreeNode)usageView.getRoot()).withPresenter(arg_0 -> ((UsageViewImpl)usageView).getNodeText(arg_0)).constructTextRepresentation();
        if (string == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(237);
        }
        return string;
    }

    @Override
    @NotNull
    public Disposable getProjectDisposable() {
        Disposable disposable = this.myProjectFixture.getTestRootDisposable();
        if (disposable == null) {
            CodeInsightTestFixtureImpl.$$$reportNull$$$0(238);
        }
        return disposable;
    }

    public void setSelectionAndCaretMarkupApplyPolicy(SelectionAndCaretMarkupApplyPolicy policy) {
        this.mySelectionAndCaretMarkupApplyPolicy = policy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 13, 17, 22, 23, 25, 28, 29, 35, 36, 55, 58, 60, 62, 63, 64, 66, 68, 107, 121, 123, 125, 127, 129, 132, 134, 136, 138, 140, 146, 149, 150, 159, 162, 174, 196, 198, 200, 201, 210, 211, 215, 217, 227, 229, 230, 237, 238 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFixture";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempDirTestFixture";
                break;
            }
            case 2: 
            case 7: 
            case 19: 
            case 20: 
            case 47: 
            case 49: 
            case 163: 
            case 175: 
            case 186: 
            case 193: 
            case 195: 
            case 203: 
            case 232: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 233: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 6: 
            case 13: 
            case 17: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 35: 
            case 36: 
            case 55: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 68: 
            case 107: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 132: 
            case 134: 
            case 136: 
            case 138: 
            case 140: 
            case 146: 
            case 149: 
            case 150: 
            case 159: 
            case 162: 
            case 174: 
            case 196: 
            case 198: 
            case 200: 
            case 201: 
            case 210: 
            case 211: 
            case 215: 
            case 217: 
            case 227: 
            case 229: 
            case 230: 
            case 237: 
            case 238: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 14: 
            case 234: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 24: 
            case 26: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePath";
                break;
            }
            case 27: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPath";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspections";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 42: 
            case 46: 
            case 56: 
            case 57: 
            case 59: 
            case 61: 
            case 70: 
            case 173: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 44: 
            case 45: 
            case 139: 
            case 176: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 48: 
            case 141: 
            case 144: 
            case 145: 
            case 148: 
            case 167: 
            case 171: 
            case 187: 
            case 188: 
            case 194: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDir";
                break;
            }
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceDir";
                break;
            }
            case 65: 
            case 67: 
            case 74: 
            case 75: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentionName";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 77: 
            case 79: 
            case 120: 
            case 231: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 78: 
            case 224: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 80: 
            case 83: 
            case 86: 
            case 90: 
            case 96: 
            case 100: 
            case 103: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileAfter";
                break;
            }
            case 81: 
            case 84: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesBefore";
                break;
            }
            case 82: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toType";
                break;
            }
            case 85: 
            case 88: 
            case 92: 
            case 95: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileBefore";
                break;
            }
            case 87: 
            case 91: 
            case 98: 
            case 102: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalFiles";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedItems";
                break;
            }
            case 97: 
            case 101: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 111: 
            case 113: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 110: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renameTarget";
                break;
            }
            case 116: 
            case 164: 
            case 178: 
            case 183: 
            case 185: 
            case 212: 
            case 223: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 122: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNames";
                break;
            }
            case 126: 
            case 133: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 128: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageTargets";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 151: 
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 152: 
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "epName";
                break;
            }
            case 158: 
            case 180: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 160: 
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 165: 
            case 166: 
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedText";
                break;
            }
            case 169: 
            case 170: 
            case 172: 
            case 204: 
            case 206: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedFile";
                break;
            }
            case 177: 
            case 179: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 181: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 182: 
            case 184: 
            case 222: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 189: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 190: 
            case 191: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 192: 
            case 207: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 197: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 199: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimalSeverity";
                break;
            }
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPath";
                break;
            }
            case 205: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 208: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualDocumentText";
                break;
            }
            case 209: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualText";
                break;
            }
            case 213: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segments";
                break;
            }
            case 214: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 216: 
            case 218: 
            case 219: 
            case 220: {
                objectArray2 = objectArray3;
                objectArray3[0] = "verificationFileName";
                break;
            }
            case 221: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 225: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 226: 
            case 228: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 235: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 236: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicatedRangesForInjected";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateAndRun";
                break;
            }
            case 17: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableIntentions";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirPath";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirFixture";
                break;
            }
            case 25: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFileToProject";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "copyDirectoryToProject";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "findSingleReferenceAtCaret";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceAtCaretPositionWithAssertion";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllQuickFixes";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostEditor";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostFileAtCaret";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAvailableIntentions";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "findSingleIntention";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementAtCaret";
                break;
            }
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "testAction";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "testFindUsages";
                break;
            }
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "testFindUsagesUsingAction";
                break;
            }
            case 127: 
            case 138: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 129: 
            case 132: 
            case 134: 
            case 136: 
            case 237: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsageViewTreeTextRepresentation";
                break;
            }
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "testHighlightUsages";
                break;
            }
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "findGuttersAtCaret";
                break;
            }
            case 149: 
            case 150: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllGutters";
                break;
            }
            case 159: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiManager";
                break;
            }
            case 162: {
                objectArray = objectArray2;
                objectArray2[1] = "completeBasicAllCarets";
                break;
            }
            case 174: {
                objectArray = objectArray2;
                objectArray2[1] = "configureByFilesInner";
                break;
            }
            case 196: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 198: 
            case 200: {
                objectArray = objectArray2;
                objectArray2[1] = "doHighlighting";
                break;
            }
            case 201: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDataPath";
                break;
            }
            case 210: {
                objectArray = objectArray2;
                objectArray2[1] = "stripTrailingSpaces";
                break;
            }
            case 211: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingDescription";
                break;
            }
            case 215: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagsFromSegments";
                break;
            }
            case 217: {
                objectArray = objectArray2;
                objectArray2[1] = "removeFoldingMarkers";
                break;
            }
            case 227: {
                objectArray = objectArray2;
                objectArray2[1] = "getGotoClassResults";
                break;
            }
            case 229: {
                objectArray = objectArray2;
                objectArray2[1] = "getGotoSymbolResults";
                break;
            }
            case 230: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreadcrumbsAtCaret";
                break;
            }
            case 238: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setFileAndEditor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addGutterIconRenderer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicatedRangesForInjected";
                break;
            }
            case 6: 
            case 13: 
            case 17: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 35: 
            case 36: 
            case 55: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 68: 
            case 107: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 132: 
            case 134: 
            case 136: 
            case 138: 
            case 140: 
            case 146: 
            case 149: 
            case 150: 
            case 159: 
            case 162: 
            case 174: 
            case 196: 
            case 198: 
            case 200: 
            case 201: 
            case 210: 
            case 211: 
            case 215: 
            case 217: 
            case 227: 
            case 229: 
            case 230: 
            case 237: 
            case 238: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "instantiateAndRun";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "ensureIndexesUpToDate";
                break;
            }
            case 15: 
            case 16: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableIntentions";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getIntentionListStep";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "waitForLazyQuickFixesUnderCaret";
                break;
            }
            case 24: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "copyFileToProject";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "assertFileEndsWithCaseSensitivePath";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "copyContent";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "copyDirectoryToProject";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "enableInspections";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "disableInspections";
                break;
            }
            case 42: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "testHighlighting";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "testHighlightingAllFiles";
                break;
            }
            case 45: 
            case 197: {
                objectArray = objectArray;
                objectArray[2] = "collectAndCheckHighlighting";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "testFile";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "openFileInEditor";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "testInspection";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceAtCaretPosition";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceAtCaretPositionWithAssertion";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getAllQuickFixes";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "filterAvailableIntentions";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "findSingleIntention";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableIntention";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "checkPreviewAndLaunchAction";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "skipPreview";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getIntentionPreviewText";
                break;
            }
            case 75: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "launchAction";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "findCachingAction";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "checkIntentionPreviewHtml";
                break;
            }
            case 80: 
            case 81: 
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "testCompletion";
                break;
            }
            case 82: 
            case 83: 
            case 84: 
            case 88: 
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "testCompletionTyping";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "testCompletionVariants";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionVariants";
                break;
            }
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "testRename";
                break;
            }
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "testRenameUsingHandler";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "renameElementAtCaret";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "renameElementAtCaretUsingHandler";
                break;
            }
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "renameElement";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "renameTarget";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "findElementByText";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "type";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "performEditorAction";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "testAction";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "testFindUsages";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "testFindUsagesUsingAction";
                break;
            }
            case 126: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 128: 
            case 130: 
            case 131: 
            case 133: 
            case 135: 
            case 236: {
                objectArray = objectArray;
                objectArray[2] = "getUsageViewTreeTextRepresentation";
                break;
            }
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "testHighlightUsages";
                break;
            }
            case 141: 
            case 142: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "findGutter";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "findGuttersAtCaret";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "processGuttersAtCaret";
                break;
            }
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "findAllGutters";
                break;
            }
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "addFileToProject";
                break;
            }
            case 156: 
            case 157: 
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 160: 
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "complete";
                break;
            }
            case 163: 
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "saveText";
                break;
            }
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 206: 
            case 207: 
            case 208: {
                objectArray = objectArray;
                objectArray[2] = "checkResult";
                break;
            }
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 204: 
            case 205: {
                objectArray = objectArray;
                objectArray[2] = "checkResultByFile";
                break;
            }
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "configureByFilesInner";
                break;
            }
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "configureByFile";
                break;
            }
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "configureByFiles";
                break;
            }
            case 177: 
            case 178: 
            case 182: 
            case 183: {
                objectArray = objectArray;
                objectArray[2] = "configureByText";
                break;
            }
            case 179: 
            case 180: 
            case 181: {
                objectArray = objectArray;
                objectArray[2] = "associateExtensionTemporarily";
                break;
            }
            case 184: 
            case 185: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 187: 
            case 190: {
                objectArray = objectArray;
                objectArray[2] = "configureByFileInner";
                break;
            }
            case 188: {
                objectArray = objectArray;
                objectArray[2] = "configureFromTempProjectFile";
                break;
            }
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "configureFromExistingVirtualFile";
                break;
            }
            case 191: 
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "configureInner";
                break;
            }
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "prepareVirtualFile";
                break;
            }
            case 194: {
                objectArray = objectArray;
                objectArray[2] = "findFileInTempDir";
                break;
            }
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 199: {
                objectArray = objectArray;
                objectArray[2] = "doHighlighting";
                break;
            }
            case 202: {
                objectArray = objectArray;
                objectArray[2] = "setTestDataPath";
                break;
            }
            case 203: {
                objectArray = objectArray;
                objectArray[2] = "allowTreeAccessForFile";
                break;
            }
            case 209: {
                objectArray = objectArray;
                objectArray[2] = "stripTrailingSpaces";
                break;
            }
            case 212: 
            case 213: 
            case 214: {
                objectArray = objectArray;
                objectArray[2] = "getTagsFromSegments";
                break;
            }
            case 216: {
                objectArray = objectArray;
                objectArray[2] = "testFoldingRegions";
                break;
            }
            case 218: 
            case 219: {
                objectArray = objectArray;
                objectArray[2] = "testFoldingWithCollapseStatus";
                break;
            }
            case 220: {
                objectArray = objectArray;
                objectArray[2] = "testFolding";
                break;
            }
            case 221: {
                objectArray = objectArray;
                objectArray[2] = "runWithRainbowEnabled";
                break;
            }
            case 222: 
            case 223: {
                objectArray = objectArray;
                objectArray[2] = "testRainbow";
                break;
            }
            case 224: {
                objectArray = objectArray;
                objectArray[2] = "assertPreferredCompletionItems";
                break;
            }
            case 225: {
                objectArray = objectArray;
                objectArray[2] = "testStructureView";
                break;
            }
            case 226: {
                objectArray = objectArray;
                objectArray[2] = "getGotoClassResults";
                break;
            }
            case 228: {
                objectArray = objectArray;
                objectArray[2] = "getGotoSymbolResults";
                break;
            }
            case 231: 
            case 232: 
            case 233: {
                objectArray = objectArray;
                objectArray[2] = "invokeIntention";
                break;
            }
            case 234: 
            case 235: {
                objectArray = objectArray;
                objectArray[2] = "checkPsiTextConsistency";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 13, 17, 22, 23, 25, 28, 29, 35, 36, 55, 58, 60, 62, 63, 64, 66, 68, 107, 121, 123, 125, 127, 129, 132, 134, 136, 138, 140, 146, 149, 150, 159, 162, 174, 196, 198, 200, 201, 210, 211, 215, 217, 227, 229, 230, 237, 238 -> new IllegalStateException(string);
        };
    }

    public static enum SelectionAndCaretMarkupApplyPolicy {
        UPDATE_DOCUMENT_AND_LEAVE_IT_DIRTY,
        UPDATE_FILE_AND_KEEP_DOCUMENT_CLEAN;

    }

    private static final class SelectionAndCaretMarkupLoader {
        private final String filePath;
        private final String newFileText;
        private final String newDocumentText;
        private final EditorTestUtil.CaretAndSelectionState caretState;

        private SelectionAndCaretMarkupLoader(@NotNull String fileText, @NotNull String documentText, String filePath) {
            if (fileText == null) {
                SelectionAndCaretMarkupLoader.$$$reportNull$$$0(0);
            }
            if (documentText == null) {
                SelectionAndCaretMarkupLoader.$$$reportNull$$$0(1);
            }
            this.filePath = filePath;
            Document document = EditorFactory.getInstance().createDocument((CharSequence)documentText);
            this.caretState = EditorTestUtil.extractCaretAndSelectionMarkers(document);
            this.newDocumentText = document.getText();
            Document fileDocument = EditorFactory.getInstance().createDocument((CharSequence)fileText);
            EditorTestUtil.extractCaretAndSelectionMarkers(fileDocument);
            this.newFileText = fileDocument.getText();
        }

        @NotNull
        private static SelectionAndCaretMarkupLoader fromFile(@NotNull String path, String charset) {
            if (path == null) {
                SelectionAndCaretMarkupLoader.$$$reportNull$$$0(2);
            }
            VirtualFile virtualFile = VirtualFileUtil.refreshAndFindVirtualFile((Path)Paths.get(path, new String[0]));
            assert (virtualFile != null);
            return SelectionAndCaretMarkupLoader.fromFile(virtualFile);
        }

        @NotNull
        private static SelectionAndCaretMarkupLoader fromFile(@NotNull VirtualFile file) {
            if (file == null) {
                SelectionAndCaretMarkupLoader.$$$reportNull$$$0(3);
            }
            return SelectionAndCaretMarkupLoader.fromIoSource((ThrowableComputable<Pair<String, String>, IOException>)((ThrowableComputable)() -> {
                String originText = VfsUtilCore.loadText((VirtualFile)file);
                String documentText = TextPresentationTransformers.fromPersistent((CharSequence)originText, (VirtualFile)file).toString();
                return new Pair((Object)originText, (Object)documentText);
            }), file.getPath());
        }

        @NotNull
        private static SelectionAndCaretMarkupLoader fromIoSource(@NotNull ThrowableComputable<Pair<String, String>, IOException> source, String path) {
            if (source == null) {
                SelectionAndCaretMarkupLoader.$$$reportNull$$$0(4);
            }
            try {
                Pair fileDocumentTextPair = (Pair)source.compute();
                String fileText = StringUtil.convertLineSeparators((String)((String)fileDocumentTextPair.first));
                String documentText = StringUtil.convertLineSeparators((String)((String)fileDocumentTextPair.second));
                return new SelectionAndCaretMarkupLoader(fileText, documentText, path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @NotNull
        private static SelectionAndCaretMarkupLoader fromText(@NotNull String text) {
            if (text == null) {
                SelectionAndCaretMarkupLoader.$$$reportNull$$$0(5);
            }
            return new SelectionAndCaretMarkupLoader(text, text, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "documentText";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$SelectionAndCaretMarkupLoader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fromFile";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fromIoSource";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fromText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private record Border(boolean isLeftBorder, int offset, @Nullable String text) implements Comparable<Border>
    {
        @Override
        public int compareTo(@NotNull Border o) {
            if (o == null) {
                Border.$$$reportNull$$$0(0);
            }
            return this.offset < o.offset ? 1 : -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$Border", "compareTo"));
        }
    }
}

