/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public abstract class TestClassesFilter {
    public static final TestClassesFilter ALL_CLASSES = new TestClassesFilter(){

        @Override
        public boolean matches(String className, String moduleName) {
            return true;
        }

        public String toString() {
            return "ALL_CLASSES";
        }
    };
    private static final boolean PATTERNS_ARE_ESCAPED = Boolean.getBoolean("intellij.build.test.patterns.escaped");

    public abstract boolean matches(String var1, @Nullable String var2);

    public boolean matches(String className) {
        return this.matches(className, null);
    }

    protected static Pattern compilePattern(String filter) {
        if (!PATTERNS_ARE_ESCAPED) {
            filter = filter.replace("$", "\\$").replace(".", "\\.").replace("*", ".*");
        }
        return Pattern.compile(filter);
    }

    protected static boolean matchesAnyPattern(Collection<Pattern> patterns, String className) {
        return ContainerUtil.exists(patterns, pattern -> pattern.matcher(className).matches());
    }

    public static class And
    extends TestClassesFilter {
        private final TestClassesFilter first;
        private final TestClassesFilter second;

        public And(TestClassesFilter first, TestClassesFilter second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public boolean matches(String className, @Nullable String moduleName) {
            return this.first.matches(className, moduleName) && this.second.matches(className, moduleName);
        }

        public String toString() {
            return "TestClassesFilter.And{" + this.first + ", " + this.second + "}";
        }
    }
}

