/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.bridge.theme;

import androidx.compose.foundation.layout.PaddingKt;
import androidx.compose.foundation.layout.PaddingValues;
import androidx.compose.foundation.shape.CornerSize;
import androidx.compose.ui.unit.Dp;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.util.ui.NamedColorUtil;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jewel.bridge.BridgeUtilsKt;
import org.jetbrains.jewel.ui.component.styling.TextAreaColors;
import org.jetbrains.jewel.ui.component.styling.TextAreaMetrics;
import org.jetbrains.jewel.ui.component.styling.TextAreaStyle;
import org.jetbrains.jewel.ui.component.styling.TextFieldMetrics;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0004"}, d2={"readTextAreaStyle", "Lorg/jetbrains/jewel/ui/component/styling/TextAreaStyle;", "metrics", "Lorg/jetbrains/jewel/ui/component/styling/TextFieldMetrics;", "intellij.platform.jewel.ideLafBridge"})
@SourceDebugExtension(value={"SMAP\nIntUiBridgeTextArea.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntUiBridgeTextArea.kt\norg/jetbrains/jewel/bridge/theme/IntUiBridgeTextAreaKt\n+ 2 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,58:1\n113#2:59\n*S KotlinDebug\n*F\n+ 1 IntUiBridgeTextArea.kt\norg/jetbrains/jewel/bridge/theme/IntUiBridgeTextAreaKt\n*L\n52#1:59\n*E\n"})
public final class IntUiBridgeTextAreaKt {
    @NotNull
    public static final TextAreaStyle readTextAreaStyle(@NotNull TextFieldMetrics metrics) {
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        long normalBackground = BridgeUtilsKt.retrieveColorOrUnspecified("TextArea.background");
        long normalContent = BridgeUtilsKt.retrieveColorOrUnspecified("TextArea.foreground");
        Color color = DarculaUIUtil.getOutlineColor((boolean)true, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getOutlineColor(...)");
        long normalBorder = BridgeUtilsKt.toComposeColor(color);
        Color color2 = DarculaUIUtil.getOutlineColor((boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getOutlineColor(...)");
        long focusedBorder = BridgeUtilsKt.toComposeColor(color2);
        long normalCaret = BridgeUtilsKt.retrieveColorOrUnspecified("TextArea.caretForeground");
        long l = androidx.compose.ui.graphics.Color.Companion.getUnspecified-0d7_KjU();
        long l2 = BridgeUtilsKt.retrieveColorOrUnspecified("TextArea.inactiveForeground");
        Color color3 = DarculaUIUtil.getOutlineColor((boolean)false, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"getOutlineColor(...)");
        long l3 = BridgeUtilsKt.toComposeColor(color3);
        Color color4 = NamedColorUtil.getInactiveTextColor();
        Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"getInactiveTextColor(...)");
        TextAreaColors colors = new TextAreaColors(normalBackground, l, normalBackground, normalBackground, normalBackground, normalContent, l2, normalContent, normalContent, normalContent, normalBorder, l3, focusedBorder, focusedBorder, normalBorder, normalCaret, normalCaret, normalCaret, normalCaret, normalCaret, BridgeUtilsKt.toComposeColor(color4), null);
        CornerSize cornerSize = metrics.getCornerSize();
        int $this$dp$iv = 5;
        boolean $i$f$getDp = false;
        float f = Dp.constructor-impl((float)$this$dp$iv);
        $this$dp$iv = 4;
        $i$f$getDp = false;
        PaddingValues paddingValues = PaddingKt.PaddingValues-YgX7TsA((float)f, (float)Dp.constructor-impl((float)$this$dp$iv));
        long l4 = metrics.getMinSize-MYxV2XQ();
        float f2 = metrics.getBorderWidth-D9Ej5fM();
        return new TextAreaStyle(colors, new TextAreaMetrics(f2, paddingValues, cornerSize, l4, null));
    }
}

