/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.SingleTaskController;
import com.intellij.vcs.log.data.SmallDataPack;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.visible.CommitCountStage;
import com.intellij.vcs.log.visible.CompoundVisiblePack;
import com.intellij.vcs.log.visible.SnapshotVisiblePackBuilder;
import com.intellij.vcs.log.visible.VcsLogFilterer;
import com.intellij.vcs.log.visible.VcsLogFiltererImplKt;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.VisiblePackChangeListener;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import kotlin.Pair;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VisiblePackRefresherImpl
implements VisiblePackRefresher,
Disposable {
    private static final Logger LOG = Logger.getInstance(VisiblePackRefresherImpl.class);
    @NotNull
    private final String myLogId;
    @NotNull
    private final SingleTaskController<Request, State> myTaskController;
    @NotNull
    private final VcsLogFilterer myVcsLogFilterer;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogIndex.IndexingFinishedListener myIndexingFinishedListener;
    @NotNull
    private final List<VisiblePackChangeListener> myVisiblePackChangeListeners;
    @NotNull
    private volatile State myState;
    @NotNull
    private volatile DataPack myDataPack;

    public VisiblePackRefresherImpl(final @NotNull Project project, @NotNull VcsLogData logData, @NotNull VcsLogFilterCollection filters, @NotNull PermanentGraph.Options options, @NotNull VcsLogFilterer filterer, @NotNull String logId) {
        if (project == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(0);
        }
        if (logData == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(1);
        }
        if (filters == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(2);
        }
        if (options == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(3);
        }
        if (filterer == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(4);
        }
        if (logId == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(5);
        }
        this.myVisiblePackChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myLogData = logData;
        this.myDataPack = logData.getDataPack();
        this.myVcsLogFilterer = filterer;
        this.myLogId = logId;
        this.myState = new State(filters, options, this.myVcsLogFilterer.getInitialCommitCount());
        this.myTaskController = new SingleTaskController<Request, State>("visible " + StringUtil.trimMiddle((String)logId, (int)40), (Disposable)this, state -> {
            boolean hasChanges = this.myState.getVisiblePack() != state.getVisiblePack();
            this.myState = state;
            if (hasChanges) {
                for (VisiblePackChangeListener listener2 : this.myVisiblePackChangeListeners) {
                    listener2.onVisiblePackChange(state.getVisiblePack());
                }
            }
        }){

            @Override
            @NotNull
            protected SingleTaskController.SingleTask startNewBackgroundTask() {
                ProgressIndicator indicator = VisiblePackRefresherImpl.this.myLogData.getProgress().createProgressIndicator(new VisiblePackProgressKey(VisiblePackRefresherImpl.this.myLogId, false));
                MyTask task2 = new MyTask(project, VcsLogBundle.message("vcs.log.applying.filters.process", new Object[0]));
                Future future = ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously((Task.Backgroundable)task2, indicator, null);
                return new SingleTaskController.SingleTaskImpl(future, indicator);
            }

            @Override
            protected boolean cancelRunningTasks(@NotNull List<Request> requests) {
                if (requests == null) {
                    1.$$$reportNull$$$0(0);
                }
                return ContainerUtil.findInstance(requests, IndexingFinishedRequest.class) != null || ContainerUtil.findInstance(requests, FilterRequest.class) != null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requests", "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$1", "cancelRunningTasks"));
            }
        };
        this.myIndexingFinishedListener = root -> this.myTaskController.request((Request[])new Request[]{new IndexingFinishedRequest(root)});
        this.myLogData.getIndex().addListener(this.myIndexingFinishedListener);
    }

    @Override
    public void addVisiblePackChangeListener(@NotNull VisiblePackChangeListener listener2) {
        if (listener2 == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(6);
        }
        this.myVisiblePackChangeListeners.add(listener2);
    }

    @Override
    public void removeVisiblePackChangeListener(@NotNull VisiblePackChangeListener listener2) {
        if (listener2 == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(7);
        }
        this.myVisiblePackChangeListeners.remove(listener2);
    }

    @Override
    public void onRefresh() {
        this.myTaskController.request((Request[])new Request[]{new RefreshRequest()});
    }

    @Override
    public void setValid(boolean validate, boolean refresh) {
        if (refresh) {
            this.myTaskController.request((Request[])new Request[]{new RefreshRequest(), new ValidateRequest(validate)});
        } else {
            this.myTaskController.request((Request[])new Request[]{new ValidateRequest(validate)});
        }
    }

    @Override
    public void setDataPack(boolean validate, @NotNull DataPack dataPack) {
        if (dataPack == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(8);
        }
        this.myDataPack = dataPack;
        this.setValid(validate, true);
    }

    @Override
    public void onFiltersChange(@NotNull VcsLogFilterCollection newFilters) {
        if (newFilters == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(9);
        }
        this.myTaskController.request((Request[])new Request[]{new FilterRequest(newFilters)});
    }

    @Override
    public void onGraphOptionsChange(@NotNull PermanentGraph.Options graphOptions) {
        if (graphOptions == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(10);
        }
        this.myTaskController.request((Request[])new Request[]{new GraphOptionsRequest(graphOptions)});
    }

    @Override
    public void moreCommitsNeeded(@NotNull Runnable onLoaded) {
        if (onLoaded == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(11);
        }
        this.myTaskController.request((Request[])new Request[]{new MoreCommitsRequest(onLoaded)});
    }

    @Override
    public boolean isValid() {
        return this.myState.isValid();
    }

    public String toString() {
        return "VisiblePackRefresher '" + this.myLogId + "' state = " + this.myState;
    }

    public void dispose() {
        this.myLogData.getIndex().removeListener(this.myIndexingFinishedListener);
        VcsLogFilterer vcsLogFilterer = this.myVcsLogFilterer;
        if (vcsLogFilterer instanceof Disposable) {
            Disposable disposableFilterer = (Disposable)vcsLogFilterer;
            Disposer.dispose((Disposable)disposableFilterer);
        }
    }

    @NotNull
    private CommitCountUpdate getCommitCountUpdate(boolean filterRequest, boolean moreCommitsRequest) {
        if (filterRequest) {
            CommitCountUpdate commitCountUpdate = CommitCountUpdate.RESET;
            if (commitCountUpdate == null) {
                VisiblePackRefresherImpl.$$$reportNull$$$0(12);
            }
            return commitCountUpdate;
        }
        if (moreCommitsRequest) {
            int visibleCommitCount = this.myState.myVisiblePack.getVisibleGraph().getVisibleCommitCount();
            int requestCount = this.myState.myCommitCount.getCount();
            if (requestCount > visibleCommitCount) {
                LOG.debug(String.format("Requested to load more commits than can be displayed. Displaying %d commits, request count - %d", visibleCommitCount, requestCount));
                CommitCountUpdate commitCountUpdate = CommitCountUpdate.KEEP;
                if (commitCountUpdate == null) {
                    VisiblePackRefresherImpl.$$$reportNull$$$0(13);
                }
                return commitCountUpdate;
            }
            CommitCountUpdate commitCountUpdate = CommitCountUpdate.INCREASE;
            if (commitCountUpdate == null) {
                VisiblePackRefresherImpl.$$$reportNull$$$0(14);
            }
            return commitCountUpdate;
        }
        CommitCountUpdate commitCountUpdate = CommitCountUpdate.KEEP;
        if (commitCountUpdate == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(15);
        }
        return commitCountUpdate;
    }

    public static boolean isVisibleKeyFor(@NotNull VcsLogProgress.ProgressKey key, @NotNull String logId) {
        if (key == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(16);
        }
        if (logId == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(17);
        }
        if (key instanceof VisiblePackProgressKey) {
            VisiblePackProgressKey visiblePackProgressKey = (VisiblePackProgressKey)key;
            return visiblePackProgressKey.getLogId().equals(logId) && visiblePackProgressKey.isVisible();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterer";
                break;
            }
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logId";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFilters";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphOptions";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onLoaded";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitCountUpdate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addVisiblePackChangeListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeVisiblePackChangeListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setDataPack";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "onFiltersChange";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onGraphOptionsChange";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "moreCommitsNeeded";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isVisibleKeyFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 13, 14, 15 -> new IllegalStateException(string);
        };
    }

    private static class State {
        @NotNull
        private final VcsLogFilterCollection myFilters;
        @NotNull
        private final PermanentGraph.Options myGraphOptions;
        @NotNull
        private final CommitCountStage myCommitCount;
        @NotNull
        private final List<MoreCommitsRequest> myRequestsToRun;
        @NotNull
        private final VisiblePack myVisiblePack;
        private final boolean myIsValid;

        State(@NotNull VcsLogFilterCollection filters, @NotNull PermanentGraph.Options graphOptions, @NotNull CommitCountStage initialCount) {
            if (filters == null) {
                State.$$$reportNull$$$0(0);
            }
            if (graphOptions == null) {
                State.$$$reportNull$$$0(1);
            }
            if (initialCount == null) {
                State.$$$reportNull$$$0(2);
            }
            this(filters, graphOptions, initialCount, new ArrayList<MoreCommitsRequest>(), VisiblePack.EMPTY, true);
        }

        State(@NotNull VcsLogFilterCollection filters, @NotNull PermanentGraph.Options graphOptions, @NotNull CommitCountStage commitCountStage, @NotNull List<MoreCommitsRequest> requests, @NotNull VisiblePack visiblePack, boolean isValid) {
            if (filters == null) {
                State.$$$reportNull$$$0(3);
            }
            if (graphOptions == null) {
                State.$$$reportNull$$$0(4);
            }
            if (commitCountStage == null) {
                State.$$$reportNull$$$0(5);
            }
            if (requests == null) {
                State.$$$reportNull$$$0(6);
            }
            if (visiblePack == null) {
                State.$$$reportNull$$$0(7);
            }
            this.myFilters = filters;
            this.myGraphOptions = graphOptions;
            this.myCommitCount = commitCountStage;
            this.myRequestsToRun = Collections.unmodifiableList(requests);
            this.myVisiblePack = visiblePack;
            this.myIsValid = isValid;
        }

        public boolean isValid() {
            return this.myIsValid;
        }

        @NotNull
        public VisiblePack getVisiblePack() {
            VisiblePack visiblePack = this.myVisiblePack;
            if (visiblePack == null) {
                State.$$$reportNull$$$0(8);
            }
            return visiblePack;
        }

        @NotNull
        public List<MoreCommitsRequest> getRequestsToRun() {
            List<MoreCommitsRequest> list = this.myRequestsToRun;
            if (list == null) {
                State.$$$reportNull$$$0(9);
            }
            return list;
        }

        @NotNull
        public VcsLogFilterCollection getFilters() {
            VcsLogFilterCollection vcsLogFilterCollection = this.myFilters;
            if (vcsLogFilterCollection == null) {
                State.$$$reportNull$$$0(10);
            }
            return vcsLogFilterCollection;
        }

        @NotNull
        public PermanentGraph.Options getGraphOptions() {
            PermanentGraph.Options options = this.myGraphOptions;
            if (options == null) {
                State.$$$reportNull$$$0(11);
            }
            return options;
        }

        @NotNull
        public CommitCountStage getCommitCount() {
            CommitCountStage commitCountStage = this.myCommitCount;
            if (commitCountStage == null) {
                State.$$$reportNull$$$0(12);
            }
            return commitCountStage;
        }

        @NotNull
        public State withValid(boolean valid) {
            return new State(this.myFilters, this.myGraphOptions, this.myCommitCount, this.myRequestsToRun, this.myVisiblePack, valid);
        }

        @NotNull
        public State withVisiblePack(@NotNull VisiblePack visiblePack) {
            if (visiblePack == null) {
                State.$$$reportNull$$$0(13);
            }
            return new State(this.myFilters, this.myGraphOptions, this.myCommitCount, this.myRequestsToRun, visiblePack, this.myIsValid);
        }

        @NotNull
        public State withCommitCount(@NotNull CommitCountStage commitCount) {
            if (commitCount == null) {
                State.$$$reportNull$$$0(14);
            }
            return new State(this.myFilters, this.myGraphOptions, commitCount, this.myRequestsToRun, this.myVisiblePack, this.myIsValid);
        }

        @NotNull
        public State withRequests(@NotNull List<MoreCommitsRequest> requests) {
            if (requests == null) {
                State.$$$reportNull$$$0(15);
            }
            return new State(this.myFilters, this.myGraphOptions, this.myCommitCount, requests, this.myVisiblePack, this.myIsValid);
        }

        @NotNull
        public State withFilters(@NotNull VcsLogFilterCollection filters) {
            if (filters == null) {
                State.$$$reportNull$$$0(16);
            }
            return new State(filters, this.myGraphOptions, this.myCommitCount, this.myRequestsToRun, this.myVisiblePack, this.myIsValid);
        }

        @NotNull
        public State withGraphOptions(@NotNull PermanentGraph.Options graphOptions) {
            if (graphOptions == null) {
                State.$$$reportNull$$$0(17);
            }
            return new State(this.myFilters, graphOptions, this.myCommitCount, this.myRequestsToRun, this.myVisiblePack, this.myIsValid);
        }

        @NonNls
        public String toString() {
            return "State{myFilters=" + this.myFilters + ", myGraphOptions=" + this.myGraphOptions + ", myCommitCount=" + this.myCommitCount + ", myRequestsToRun=" + this.myRequestsToRun + ", myVisiblePack=" + this.myVisiblePack + ", myIsValid=" + this.myIsValid + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8, 9, 10, 11, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filters";
                    break;
                }
                case 1: 
                case 4: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "graphOptions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialCount";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitCountStage";
                    break;
                }
                case 6: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requests";
                    break;
                }
                case 7: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visiblePack";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$State";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitCount";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$State";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVisiblePack";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRequestsToRun";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilters";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGraphOptions";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommitCount";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "withVisiblePack";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "withCommitCount";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "withRequests";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "withFilters";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "withGraphOptions";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8, 9, 10, 11, 12 -> new IllegalStateException(string);
            };
        }
    }

    private static interface Request {
    }

    private static final class RefreshRequest
    implements Request {
        private RefreshRequest() {
        }

        public String toString() {
            return "RefreshRequest";
        }
    }

    private static final class ValidateRequest
    implements Request {
        private final boolean validate;

        private ValidateRequest(boolean validate) {
            this.validate = validate;
        }

        public String toString() {
            return "ValidateRequest " + this.validate;
        }
    }

    private static final class FilterRequest
    implements Request {
        private final VcsLogFilterCollection filters;

        FilterRequest(VcsLogFilterCollection filters) {
            this.filters = filters;
        }

        public String toString() {
            return "FilterRequest by " + this.filters;
        }
    }

    private static final class GraphOptionsRequest
    implements Request {
        private final PermanentGraph.Options graphOptions;

        GraphOptionsRequest(PermanentGraph.Options graphOptions) {
            this.graphOptions = graphOptions;
        }

        public String toString() {
            return "GraphOptionsRequest " + this.graphOptions;
        }
    }

    private static final class MoreCommitsRequest
    implements Request {
        @NotNull
        private final Runnable onLoaded;

        MoreCommitsRequest(@NotNull Runnable onLoaded) {
            if (onLoaded == null) {
                MoreCommitsRequest.$$$reportNull$$$0(0);
            }
            this.onLoaded = onLoaded;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onLoaded", "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$MoreCommitsRequest", "<init>"));
        }
    }

    private static enum CommitCountUpdate {
        KEEP,
        RESET,
        INCREASE;

    }

    public static class VisiblePackProgressKey
    extends VcsLogProgress.ProgressKey {
        @NotNull
        private final String myLogId;
        private final boolean myVisible;

        public VisiblePackProgressKey(@NotNull String logId, boolean visible) {
            if (logId == null) {
                VisiblePackProgressKey.$$$reportNull$$$0(0);
            }
            super("visible pack for " + logId);
            this.myLogId = logId;
            this.myVisible = visible;
        }

        public boolean isVisible() {
            return this.myVisible;
        }

        @NotNull
        public String getLogId() {
            String string = this.myLogId;
            if (string == null) {
                VisiblePackProgressKey.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VisiblePackProgressKey key = (VisiblePackProgressKey)o;
            return this.myVisible == key.myVisible && Objects.equals(this.myLogId, key.myLogId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.myLogId, this.myVisible);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$VisiblePackProgressKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$VisiblePackProgressKey";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLogId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class IndexingFinishedRequest
    implements Request {
        @NotNull
        private final VirtualFile root;

        IndexingFinishedRequest(@NotNull VirtualFile root) {
            if (root == null) {
                IndexingFinishedRequest.$$$reportNull$$$0(0);
            }
            this.root = root;
        }

        @NotNull
        public VirtualFile getRoot() {
            VirtualFile virtualFile = this.root;
            if (virtualFile == null) {
                IndexingFinishedRequest.$$$reportNull$$$0(1);
            }
            return virtualFile;
        }

        public String toString() {
            return "IndexingFinishedRequest for " + this.root;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$IndexingFinishedRequest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$IndexingFinishedRequest";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private class MyTask
    extends Task.Backgroundable {
        MyTask(@Nls(capitalization=Nls.Capitalization.Title) @NotNull Project project, String title) {
            if (title == null) {
                MyTask.$$$reportNull$$$0(0);
            }
            super(project, title, false);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyTask.$$$reportNull$$$0(1);
            }
            State state = VisiblePackRefresherImpl.this.myState;
            List<Request> requests = VisiblePackRefresherImpl.this.myTaskController.peekRequests();
            if (!requests.isEmpty()) {
                try {
                    state = this.computeState(state, requests);
                    VisiblePackRefresherImpl.this.myTaskController.removeRequests(requests);
                }
                catch (ProcessCanceledException reThrown) {
                    LOG.debug("Filtering cancelled");
                    VisiblePackRefresherImpl.this.myTaskController.taskCompleted(null);
                    throw reThrown;
                }
                catch (Throwable t) {
                    LOG.error("Error while processing requests " + requests, t);
                    VisiblePackRefresherImpl.this.myTaskController.removeRequests(requests);
                }
            }
            ArrayList<MoreCommitsRequest> requestsToRun = new ArrayList<MoreCommitsRequest>();
            if (state.getVisiblePack() != VisiblePackRefresherImpl.this.myState.getVisiblePack() && state.isValid() && !(state.getVisiblePack() instanceof VisiblePack.ErrorVisiblePack)) {
                requestsToRun.addAll(state.getRequestsToRun());
                state = state.withRequests(new ArrayList<MoreCommitsRequest>());
            }
            VisiblePackRefresherImpl.this.myTaskController.taskCompleted(state);
            if (!requestsToRun.isEmpty()) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    for (MoreCommitsRequest request : requestsToRun) {
                        request.onLoaded.run();
                    }
                });
            }
        }

        @NotNull
        private State computeState(@NotNull State state, @NotNull List<? extends Request> requests) {
            List<MoreCommitsRequest> moreCommitsRequests;
            if (state == null) {
                MyTask.$$$reportNull$$$0(2);
            }
            if (requests == null) {
                MyTask.$$$reportNull$$$0(3);
            }
            boolean requestMoreCommits = !(moreCommitsRequests = this.filterMoreCommitsRequests(requests)).isEmpty();
            ValidateRequest validateRequest = (ValidateRequest)ContainerUtil.findLastInstance(requests, ValidateRequest.class);
            FilterRequest filterRequest = (FilterRequest)ContainerUtil.findLastInstance(requests, FilterRequest.class);
            GraphOptionsRequest graphOptionsRequest = (GraphOptionsRequest)ContainerUtil.findLastInstance(requests, GraphOptionsRequest.class);
            List indexingRequests = ContainerUtil.findAll(requests, IndexingFinishedRequest.class);
            state = state.withRequests(ContainerUtil.concat(state.getRequestsToRun(), moreCommitsRequests));
            if (filterRequest != null) {
                state = state.withFilters(filterRequest.filters);
            }
            if (graphOptionsRequest != null) {
                state = state.withGraphOptions(graphOptionsRequest.graphOptions);
            }
            if (!state.isValid()) {
                if (validateRequest != null && validateRequest.validate) {
                    state = state.withValid(true);
                    return this.refresh(state, VisiblePackRefresherImpl.this.getCommitCountUpdate(filterRequest != null, requestMoreCommits));
                }
                State state2 = state;
                if (state2 == null) {
                    MyTask.$$$reportNull$$$0(4);
                }
                return state2;
            }
            if (validateRequest != null && !validateRequest.validate) {
                state = state.withValid(false);
                if (filterRequest != null) {
                    state = this.refresh(state, CommitCountUpdate.RESET);
                }
                State state3 = state.withVisiblePack(new SnapshotVisiblePackBuilder(VisiblePackRefresherImpl.this.myLogData.getStorage()).build(state.getVisiblePack()));
                if (state3 == null) {
                    MyTask.$$$reportNull$$$0(5);
                }
                return state3;
            }
            boolean indexingFinished = !indexingRequests.isEmpty() && VcsLogFiltererImplKt.areFiltersAffectedByIndexing(state.getFilters(), ContainerUtil.map((Collection)indexingRequests, IndexingFinishedRequest::getRoot));
            boolean hasUnprocessedRequest = ContainerUtil.exists(requests, request -> (!(request instanceof MoreCommitsRequest) || requestMoreCommits) && !(request instanceof ValidateRequest) && !(request instanceof IndexingFinishedRequest));
            if (hasUnprocessedRequest || indexingFinished) {
                return this.refresh(state, VisiblePackRefresherImpl.this.getCommitCountUpdate(filterRequest != null, requestMoreCommits));
            }
            State state4 = state;
            if (state4 == null) {
                MyTask.$$$reportNull$$$0(6);
            }
            return state4;
        }

        @NotNull
        private List<MoreCommitsRequest> filterMoreCommitsRequests(@NotNull List<? extends Request> requests) {
            List moreCommitsRequests;
            if (requests == null) {
                MyTask.$$$reportNull$$$0(7);
            }
            if (!(moreCommitsRequests = ContainerUtil.findAll(requests, MoreCommitsRequest.class)).isEmpty() && !VisiblePackRefresherImpl.this.myState.myVisiblePack.canRequestMore()) {
                int visibleCommitCount = VisiblePackRefresherImpl.this.myState.myVisiblePack.getVisibleGraph().getVisibleCommitCount();
                int requestCount = VisiblePackRefresherImpl.this.myState.myCommitCount.getCount();
                LOG.debug(String.format("Requested to load more commits, however visible pack indicates that more commits can't be loaded Displaying %d commits, request count - %d", visibleCommitCount, requestCount));
                moreCommitsRequests = Collections.emptyList();
            }
            List list = moreCommitsRequests;
            if (list == null) {
                MyTask.$$$reportNull$$$0(8);
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        private State refresh(@NotNull State state, @NotNull CommitCountUpdate commitCountUpdate) {
            State state2;
            if (state == null) {
                MyTask.$$$reportNull$$$0(9);
            }
            if (commitCountUpdate == null) {
                MyTask.$$$reportNull$$$0(10);
            }
            DataPack dataPack = VisiblePackRefresherImpl.this.myDataPack;
            VcsLogFilterCollection filters = state.getFilters();
            if (dataPack == DataPack.EMPTY && !VisiblePackRefresherImpl.this.myVcsLogFilterer.canFilterEmptyPack(filters)) {
                State state3 = state;
                if (state3 == null) {
                    MyTask.$$$reportNull$$$0(11);
                }
                return state3;
            }
            state = state.withCommitCount(switch (commitCountUpdate) {
                default -> throw new IncompatibleClassChangeError();
                case CommitCountUpdate.KEEP -> state.getCommitCount();
                case CommitCountUpdate.RESET -> VisiblePackRefresherImpl.this.myVcsLogFilterer.getInitialCommitCount();
                case CommitCountUpdate.INCREASE -> state.getCommitCount().next();
            });
            VcsLogProgress.updateCurrentKey(new VisiblePackProgressKey(VisiblePackRefresherImpl.this.myLogId, commitCountUpdate == CommitCountUpdate.KEEP || commitCountUpdate == CommitCountUpdate.RESET || state.getVisiblePack().getDataPack() != dataPack));
            try {
                Pair<VisiblePack, CommitCountStage> pair = VisiblePackRefresherImpl.this.myVcsLogFilterer.filter(dataPack, state.getVisiblePack(), state.getGraphOptions(), filters, state.getCommitCount());
                VisiblePack visiblePack = (VisiblePack)pair.getFirst();
                CommitCountStage commitCount = (CommitCountStage)pair.getSecond();
                if (dataPack instanceof SmallDataPack) {
                    visiblePack = CompoundVisiblePack.build(visiblePack, state.getVisiblePack());
                }
                State state4 = state.withVisiblePack(visiblePack).withCommitCount(commitCount);
                state2 = state4;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable t) {
                State state5 = state.withVisiblePack(new VisiblePack.ErrorVisiblePack(dataPack, filters, t));
                State state6 = state5;
                if (state6 == null) {
                    MyTask.$$$reportNull$$$0(13);
                }
                return state6;
            }
            finally {
                VcsLogProgress.updateCurrentKey(new VisiblePackProgressKey(VisiblePackRefresherImpl.this.myLogId, false));
            }
            if (state2 == null) {
                MyTask.$$$reportNull$$$0(12);
            }
            return state2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6, 8, 11, 12, 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requests";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$MyTask";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitCountUpdate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$MyTask";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeState";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterMoreCommitsRequests";
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "refresh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "computeState";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 11: 
                case 12: 
                case 13: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "filterMoreCommitsRequests";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "refresh";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6, 8, 11, 12, 13 -> new IllegalStateException(string);
            };
        }
    }
}

