/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.google.common.primitives.Ints;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.issueLinks.TableLinkMouseListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.hover.TableHoverListener;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.graph.RowType;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.render.GraphCommitCellRenderer;
import com.intellij.vcs.log.ui.render.SimpleColoredComponentLinkMouseListener;
import com.intellij.vcs.log.ui.table.GraphCommitCellController;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.RootCellRenderer;
import com.intellij.vcs.log.ui.table.SelectionSnapshot;
import com.intellij.vcs.log.ui.table.TableWithProgress;
import com.intellij.vcs.log.ui.table.VcsLogCellController;
import com.intellij.vcs.log.ui.table.VcsLogCellRenderer;
import com.intellij.vcs.log.ui.table.VcsLogCommitList;
import com.intellij.vcs.log.ui.table.VcsLogNewUiTableCellRenderer;
import com.intellij.vcs.log.ui.table.column.Commit;
import com.intellij.vcs.log.ui.table.column.Root;
import com.intellij.vcs.log.ui.table.column.VcsLogColumn;
import com.intellij.vcs.log.ui.table.column.VcsLogColumnManager;
import com.intellij.vcs.log.ui.table.column.VcsLogColumnUtilKt;
import com.intellij.vcs.log.ui.table.column.VcsLogCustomColumn;
import com.intellij.vcs.log.ui.table.column.VcsLogCustomColumnListener;
import com.intellij.vcs.log.ui.table.links.CommitLinksProvider;
import com.intellij.vcs.log.ui.table.links.NavigateToCommit;
import com.intellij.vcs.log.ui.table.links.VcsLinksRenderer;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogGraphTable
extends TableWithProgress
implements VcsLogCommitList,
UiCompatibleDataProvider,
CopyProvider,
Disposable {
    private static final Logger LOG = Logger.getInstance(VcsLogGraphTable.class);
    private static final int MAX_DEFAULT_DYNAMIC_COLUMN_WIDTH = 300;
    private static final int MAX_ROWS_TO_CALC_WIDTH = 1000;
    private static final Color DEFAULT_HOVERED_BACKGROUND = new JBColor(ColorUtil.withAlpha((Color)new Color(12833507), (double)0.4), new Color(4606541));
    private static final Color HOVERED_BACKGROUND = JBColor.namedColor((String)"VersionControl.Log.Commit.hoveredBackground", (Color)DEFAULT_HOVERED_BACKGROUND);
    private static final Color SELECTION_BACKGROUND = JBColor.namedColor((String)"VersionControl.Log.Commit.selectionBackground", (Color)UIUtil.getListSelectionBackground((boolean)true));
    private static final Color SELECTION_BACKGROUND_INACTIVE = JBColor.namedColor((String)"VersionControl.Log.Commit.selectionInactiveBackground", (Color)UIUtil.getListSelectionBackground((boolean)false));
    private static final Color SELECTION_FOREGROUND = JBColor.namedColor((String)"VersionControl.Log.Commit.selectionForeground", (Color)NamedColorUtil.getListSelectionForeground((boolean)true));
    private static final Color SELECTION_FOREGROUND_INACTIVE = JBColor.namedColor((String)"VersionControl.Log.Commit.selectionInactiveForeground", (Color)NamedColorUtil.getListSelectionForeground((boolean)false));
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final String myLogId;
    @NotNull
    private final VcsLogUiProperties myProperties;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private final BaseStyleProvider myBaseStyleProvider;
    @Nullable
    private final GraphCommitCellRenderer myGraphCommitCellRenderer;
    @NotNull
    private final MyMouseAdapter myMouseAdapter;
    @NotNull
    private final Map<VcsLogColumn<?>, TableColumn> myTableColumns;
    @NotNull
    private final Set<VcsLogColumn<?>> myInitializedColumns;
    @NotNull
    private final Collection<VcsLogHighlighter> myHighlighters;
    @Nullable
    private SelectionSnapshot mySelectionSnapshot;
    private boolean myDisposed;

    @ApiStatus.Internal
    public VcsLogGraphTable(@NotNull String logId, @NotNull GraphTableModel tableModel, @NotNull VcsLogUiProperties uiProperties, @NotNull VcsLogColorManager colorManager, @NotNull @NotNull Consumer<@NotNull String> commitByHashNavigator, @NotNull Disposable disposable) {
        if (logId == null) {
            VcsLogGraphTable.$$$reportNull$$$0(0);
        }
        if (tableModel == null) {
            VcsLogGraphTable.$$$reportNull$$$0(1);
        }
        if (uiProperties == null) {
            VcsLogGraphTable.$$$reportNull$$$0(2);
        }
        if (colorManager == null) {
            VcsLogGraphTable.$$$reportNull$$$0(3);
        }
        if (commitByHashNavigator == null) {
            VcsLogGraphTable.$$$reportNull$$$0(4);
        }
        if (disposable == null) {
            VcsLogGraphTable.$$$reportNull$$$0(5);
        }
        super(tableModel);
        this.myTableColumns = new HashMap();
        this.myInitializedColumns = new HashSet();
        this.myHighlighters = new LinkedHashSet<VcsLogHighlighter>();
        this.mySelectionSnapshot = null;
        this.myDisposed = false;
        Disposer.register((Disposable)disposable, (Disposable)this);
        this.myLogId = logId;
        this.myLogData = tableModel.getLogData();
        this.myProperties = uiProperties;
        this.myColorManager = colorManager;
        this.myBaseStyleProvider = new BaseStyleProvider((JTable)((Object)this));
        this.getEmptyText().setText(VcsLogBundle.message("vcs.log.default.status", new Object[0]));
        this.myLogData.getProgress().addProgressIndicatorListener(new MyProgressListener(), this);
        this.setColumnModel(new MyTableColumnModel(this.myProperties));
        this.onColumnOrderSettingChanged();
        this.setRootColumnSize();
        this.subscribeOnNewUiSwitching();
        this.myGraphCommitCellRenderer = this.getGraphCommitCellRenderer();
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(VcsLogCustomColumnListener.TOPIC, (Object)new MyColumnsAvailabilityListener());
        VcsLogColumnManager.getInstance().addCurrentColumnsListener(this, new MyCurrentColumnsListener());
        VcsLogColumnManager.getInstance().addColumnModelListener(this, (column, index) -> this.getModel().fireTableStructureChanged());
        this.setShowVerticalLines(false);
        this.setShowHorizontalLines(false);
        this.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.setTableHeader((JTableHeader)new JBTable.InvisibleResizableHeader(){

            protected boolean canMoveOrResizeColumn(int modelIndex) {
                return modelIndex != VcsLogColumnManager.getInstance().getModelIndex(Root.INSTANCE);
            }
        });
        this.myMouseAdapter = new MyMouseAdapter(commitByHashNavigator);
        this.addMouseMotionListener(this.myMouseAdapter);
        this.addMouseListener(this.myMouseAdapter);
        this.getSelectionModel().addListSelectionListener(e -> {
            this.mySelectionSnapshot = null;
        });
        this.getColumnModel().setColumnSelectionAllowed(false);
        this.putClientProperty(BookmarksManager.ALLOWED, true);
        ScrollingUtil.installActions((JTable)((Object)this), (boolean)false);
        this.registerResolveLinks();
    }

    private void registerResolveLinks() {
        GraphTableModel model = this.getModel();
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                VcsLogGraphTable.this.resolveLinks();
            }
        });
    }

    private void resolveLinks() {
        if (!VcsLinksRenderer.isEnabled()) {
            return;
        }
        VisiblePack visiblePack = this.getModel().getVisiblePack();
        VisibleGraph<Integer> visibleGraph = visiblePack.getVisibleGraph();
        if (visibleGraph.getVisibleCommitCount() == 0) {
            return;
        }
        CommitLinksProvider linksProvider = CommitLinksProvider.getServiceOrNull(this.getLogData().getProject());
        if (linksProvider != null) {
            Couple visibleRows = ScrollingUtil.getVisibleRows((JTable)((Object)this));
            linksProvider.resolveLinks(this.getId(), this.myLogData, this.getModel(), (Integer)visibleRows.first, (Integer)visibleRows.second);
        }
    }

    public boolean getAutoCreateColumnsFromModel() {
        return false;
    }

    @NotNull
    @NonNls
    public String getId() {
        String string = this.myLogId;
        if (string == null) {
            VcsLogGraphTable.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void dispose() {
        this.myDisposed = true;
    }

    @Override
    @NotNull
    public VcsLogCommitSelection getSelection() {
        VcsLogCommitSelection vcsLogCommitSelection = this.getModel().createSelection(this.getSelectedRows());
        if (vcsLogCommitSelection == null) {
            VcsLogGraphTable.$$$reportNull$$$0(7);
        }
        return vcsLogCommitSelection;
    }

    protected void updateEmptyText() {
        this.getEmptyText().setText(VcsLogBundle.message("vcs.log.default.status", new Object[0]));
    }

    protected void setErrorEmptyText(@NotNull Throwable error, @NlsContexts.StatusText @NotNull String defaultText) {
        if (error == null) {
            VcsLogGraphTable.$$$reportNull$$$0(8);
        }
        if (defaultText == null) {
            VcsLogGraphTable.$$$reportNull$$$0(9);
        }
        String message = (String)ObjectUtils.chooseNotNull((Object)error.getLocalizedMessage(), (Object)defaultText);
        String shortenedMessage = StringUtil.shortenTextWithEllipsis((String)message, (int)150, (int)0, (boolean)true);
        this.getEmptyText().setText(shortenedMessage.replace('\n', ' '));
    }

    protected void appendActionToEmptyText(@Nls @NotNull String text, @NotNull Runnable action) {
        if (text == null) {
            VcsLogGraphTable.$$$reportNull$$$0(10);
        }
        if (action == null) {
            VcsLogGraphTable.$$$reportNull$$$0(11);
        }
        this.getEmptyText().appendSecondaryText(text, SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> action.run());
    }

    public void updateDataPack(@NotNull VisiblePack visiblePack, boolean permGraphChanged) {
        if (visiblePack == null) {
            VcsLogGraphTable.$$$reportNull$$$0(12);
        }
        boolean filtersChanged = !this.getModel().getVisiblePack().getFilters().equals(visiblePack.getFilters());
        SelectionSnapshot previousSelection = this.getSelectionSnapshot();
        this.getModel().setVisiblePack(visiblePack);
        previousSelection.restore(visiblePack.getVisibleGraph(), true, permGraphChanged);
        for (VcsLogHighlighter highlighter : this.myHighlighters) {
            highlighter.update((VcsLogDataPack)visiblePack, permGraphChanged);
        }
        if (!this.getEmptyText().getText().equals(VcsLogBundle.message("vcs.log.loading.status", new Object[0]))) {
            this.updateEmptyText();
        }
        this.setPaintBusy(false);
        if (filtersChanged) {
            this.myInitializedColumns.clear();
        }
        this.reLayout();
    }

    public void onColumnOrderSettingChanged() {
        List<VcsLogColumn<?>> columnOrder = this.getColumnOrderFromProperties();
        if (columnOrder != null) {
            TableColumnModel columnModel = this.getColumnModel();
            int columnCount = this.getVisibleColumnCount();
            for (int i = columnCount - 1; i >= 0; --i) {
                columnModel.removeColumn(columnModel.getColumn(i));
            }
            for (VcsLogColumn<?> column : columnOrder) {
                VcsLogCustomColumn customColumn;
                boolean isAvailable = !(column instanceof VcsLogCustomColumn) || VcsLogCustomColumn.isAvailable(customColumn = (VcsLogCustomColumn)column, this.myLogData);
                if (!isAvailable) continue;
                this.myTableColumns.computeIfAbsent(column, k -> this.createTableColumn(column));
                columnModel.addColumn(this.myTableColumns.get(column));
            }
        }
        this.reLayout();
    }

    @Nullable
    private List<VcsLogColumn<?>> getColumnOrderFromProperties() {
        List<VcsLogColumn<?>> columnOrder = VcsLogColumnUtilKt.getColumnsOrder(this.myProperties);
        if (VcsLogColumnUtilKt.isValidColumnOrder(columnOrder)) {
            return columnOrder;
        }
        LOG.debug("Incorrect column order was saved in properties " + columnOrder + ", replacing it with default order.");
        List<VcsLogColumn<?>> visibleColumns = this.getVisibleColumns();
        if (!visibleColumns.isEmpty()) {
            VcsLogColumnUtilKt.updateOrder(this.myProperties, visibleColumns);
            return null;
        }
        List<VcsLogColumn<?>> validColumnOrder = VcsLogColumnUtilKt.makeValidColumnOrder(columnOrder);
        VcsLogColumnUtilKt.updateOrder(this.myProperties, validColumnOrder);
        return validColumnOrder;
    }

    @NotNull
    private List<Integer> getVisibleColumnIndices() {
        ArrayList<Integer> columnOrder = new ArrayList<Integer>();
        for (int i = 0; i < this.getVisibleColumnCount(); ++i) {
            columnOrder.add(this.getColumnModel().getColumn(i).getModelIndex());
        }
        ArrayList<Integer> arrayList = columnOrder;
        if (arrayList == null) {
            VcsLogGraphTable.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    public List<VcsLogColumn<?>> getVisibleColumns() {
        List list = ContainerUtil.map(this.getVisibleColumnIndices(), columnModelIndex -> VcsLogColumnManager.getInstance().getColumn((int)columnModelIndex));
        if (list == null) {
            VcsLogGraphTable.$$$reportNull$$$0(14);
        }
        return list;
    }

    public boolean isColumnVisible(@NotNull VcsLogColumn<?> column) {
        if (column == null) {
            VcsLogGraphTable.$$$reportNull$$$0(15);
        }
        for (int i = 0; i < this.getVisibleColumnCount(); ++i) {
            if (VcsLogColumnManager.getInstance().getColumn(this.getColumnModel().getColumn(i).getModelIndex()) != column) continue;
            return true;
        }
        return false;
    }

    private int getVisibleColumnCount() {
        return this.getColumnModel().getColumnCount();
    }

    public void onColumnDataChanged(@NotNull VcsLogColumn<?> column) {
        if (column == null) {
            VcsLogGraphTable.$$$reportNull$$$0(16);
        }
        if (this.getRowCount() == 0) {
            return;
        }
        TableColumn tableColumn = this.getTableColumn(column);
        if (tableColumn != null) {
            this.reLayout();
            this.getModel().fireTableChanged(new TableModelEvent(this.getModel(), 0, this.getRowCount() - 1, tableColumn.getModelIndex()));
        }
    }

    private void reLayout() {
        if (this.getTableHeader().getResizingColumn() == null) {
            this.updateDynamicColumnsWidth();
            super.doLayout();
            this.repaint();
        }
    }

    public void forceReLayout(@NotNull VcsLogColumn<?> column) {
        if (column == null) {
            VcsLogGraphTable.$$$reportNull$$$0(17);
        }
        this.myInitializedColumns.remove(column);
        this.reLayout();
    }

    public void doLayout() {
        if (this.getTableHeader().getResizingColumn() == null) {
            this.updateDynamicColumnsWidth();
        }
        super.doLayout();
    }

    private void resetColumnWidth(@NotNull VcsLogColumn<?> column) {
        if (column == null) {
            VcsLogGraphTable.$$$reportNull$$$0(18);
        }
        VcsLogUsageTriggerCollector.triggerColumnReset(this.myLogData.getProject());
        if (VcsLogColumnUtilKt.getWidth(column, this.myProperties) != -1) {
            VcsLogColumnUtilKt.setWidth(column, this.myProperties, -1);
        } else {
            this.forceReLayout(column);
        }
    }

    @NotNull
    private TableColumn createTableColumn(VcsLogColumn<?> column) {
        TableColumn tableColumn = new TableColumn(VcsLogColumnManager.getInstance().getModelIndex(column));
        tableColumn.setResizable(column.isResizable());
        tableColumn.setCellRenderer(this.createColumnRenderer(column));
        TableColumn tableColumn2 = tableColumn;
        if (tableColumn2 == null) {
            VcsLogGraphTable.$$$reportNull$$$0(19);
        }
        return tableColumn2;
    }

    private void subscribeOnNewUiSwitching() {
        Registry.get((String)"ide.experimental.ui").addListener(new RegistryValueListener(){

            public void afterValueChanged(@NotNull RegistryValue value) {
                if (value == null) {
                    3.$$$reportNull$$$0(0);
                }
                VcsLogGraphTable.this.updateColumnRenderers();
                VcsLogGraphTable.this.setRootColumnSize();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$3", "afterValueChanged"));
            }
        }, (Disposable)this);
    }

    private void updateColumnRenderers() {
        this.myTableColumns.forEach((logColumn, tableColumn) -> tableColumn.setCellRenderer(this.createColumnRenderer((VcsLogColumn<?>)logColumn)));
    }

    @NotNull
    private TableCellRenderer createColumnRenderer(@NotNull VcsLogColumn<?> column) {
        if (column == null) {
            VcsLogGraphTable.$$$reportNull$$$0(20);
        }
        TableCellRenderer renderer = column.createTableCellRenderer(this);
        if (ExperimentalUI.isNewUI() && column != Root.INSTANCE) {
            renderer = new VcsLogNewUiTableCellRenderer(column, renderer, (Function0<Boolean>)((Function0)this.myColorManager::hasMultiplePaths));
        }
        TableCellRenderer tableCellRenderer = renderer;
        if (tableCellRenderer == null) {
            VcsLogGraphTable.$$$reportNull$$$0(21);
        }
        return tableCellRenderer;
    }

    @NotNull
    private GraphCommitCellRenderer getGraphCommitCellRenderer() {
        TableCellRenderer cellRenderer = this.getCommitColumn().getCellRenderer();
        if (cellRenderer instanceof VcsLogNewUiTableCellRenderer) {
            cellRenderer = ((VcsLogNewUiTableCellRenderer)cellRenderer).getBaseRenderer();
        }
        GraphCommitCellRenderer graphCommitCellRenderer = (GraphCommitCellRenderer)Objects.requireNonNull(cellRenderer);
        if (graphCommitCellRenderer == null) {
            VcsLogGraphTable.$$$reportNull$$$0(22);
        }
        return graphCommitCellRenderer;
    }

    @Nullable
    private static VcsLogCellRenderer getVcsLogCellRenderer(@NotNull TableColumn column) {
        TableCellRenderer renderer;
        if (column == null) {
            VcsLogGraphTable.$$$reportNull$$$0(23);
        }
        return (renderer = column.getCellRenderer()) instanceof VcsLogCellRenderer ? (VcsLogCellRenderer)((Object)renderer) : null;
    }

    @NotNull
    public VcsLogUiProperties getProperties() {
        VcsLogUiProperties vcsLogUiProperties = this.myProperties;
        if (vcsLogUiProperties == null) {
            VcsLogGraphTable.$$$reportNull$$$0(24);
        }
        return vcsLogUiProperties;
    }

    @NotNull
    public VcsLogColorManager getColorManager() {
        VcsLogColorManager vcsLogColorManager = this.myColorManager;
        if (vcsLogColorManager == null) {
            VcsLogGraphTable.$$$reportNull$$$0(25);
        }
        return vcsLogColorManager;
    }

    @NotNull
    public VcsLogData getLogData() {
        VcsLogData vcsLogData = this.myLogData;
        if (vcsLogData == null) {
            VcsLogGraphTable.$$$reportNull$$$0(26);
        }
        return vcsLogData;
    }

    private void updateDynamicColumnsWidth() {
        for (VcsLogColumn<?> logColumn : VcsLogColumnManager.getInstance().getCurrentDynamicColumns()) {
            TableColumn column = this.getTableColumn(logColumn);
            if (column == null) continue;
            int width = VcsLogColumnUtilKt.getWidth(logColumn, this.myProperties);
            if (width <= 0 || width > this.getWidth()) {
                width = this.getColumnWidthFromData(column);
            }
            if (width <= 0 || width == column.getPreferredWidth()) continue;
            column.setPreferredWidth(width);
        }
        int size = this.getWidth();
        for (VcsLogColumn<?> logColumn : VcsLogColumnManager.getInstance().getCurrentColumns()) {
            TableColumn column;
            if (logColumn == Commit.INSTANCE || (column = this.getTableColumn(logColumn)) == null) continue;
            size -= column.getPreferredWidth();
        }
        this.getCommitColumn().setPreferredWidth(size);
    }

    private int getColumnWidthFromData(@NotNull TableColumn column) {
        if (column == null) {
            VcsLogGraphTable.$$$reportNull$$$0(27);
        }
        int index = column.getModelIndex();
        VcsLogColumn<?> logColumn = VcsLogColumnManager.getInstance().getColumn(index);
        VcsLogCellRenderer cellRenderer = VcsLogGraphTable.getVcsLogCellRenderer(column);
        if (cellRenderer == null) {
            return column.getPreferredWidth();
        }
        VcsLogCellRenderer.PreferredWidth preferredWidth = cellRenderer.getPreferredWidth();
        if (preferredWidth instanceof VcsLogCellRenderer.PreferredWidth.Fixed) {
            VcsLogCellRenderer.PreferredWidth.Fixed fixedWidth = (VcsLogCellRenderer.PreferredWidth.Fixed)preferredWidth;
            int width = (Integer)fixedWidth.getFunction().invoke((Object)this);
            if (width >= 0) {
                return width;
            }
            return column.getPreferredWidth();
        }
        if (this.getModel().getRowCount() <= 0 || this.myInitializedColumns.contains(logColumn) || preferredWidth == null) {
            return column.getPreferredWidth();
        }
        VcsLogCellRenderer.PreferredWidth.FromData widthFromData = (VcsLogCellRenderer.PreferredWidth.FromData)preferredWidth;
        int maxRowsToCheck = Math.min(1000, this.getRowCount());
        int maxValueWidth = 0;
        int unloaded = 0;
        for (int row = 0; row < maxRowsToCheck; ++row) {
            Object value = this.getModel().getValueAt(row, logColumn);
            Integer width = (Integer)widthFromData.getFunction().invoke((Object)this, value, (Object)row, (Object)this.getColumnViewIndex(logColumn));
            if (width == null) {
                ++unloaded;
                continue;
            }
            maxValueWidth = Math.max(width, maxValueWidth);
        }
        int width = Math.min(maxValueWidth, JBUIScale.scale((int)300));
        if (unloaded * 2 <= maxRowsToCheck) {
            this.myInitializedColumns.add(logColumn);
        }
        return width;
    }

    @Nullable
    public VcsLogColumn<?> getVcsLogColumn(int viewIndex) {
        int modelIndex = this.convertColumnIndexToModel(viewIndex);
        return modelIndex < 0 ? null : VcsLogColumnManager.getInstance().getColumn(modelIndex);
    }

    public final int getColumnViewIndex(@NotNull VcsLogColumn<?> column) {
        if (column == null) {
            VcsLogGraphTable.$$$reportNull$$$0(28);
        }
        return this.convertColumnIndexToView(VcsLogColumnManager.getInstance().getModelIndex(column));
    }

    @Nullable
    public TableColumn getTableColumn(@NotNull VcsLogColumn<?> column) {
        int viewIndex;
        if (column == null) {
            VcsLogGraphTable.$$$reportNull$$$0(29);
        }
        return (viewIndex = this.getColumnViewIndex(column)) != -1 ? this.getColumnModel().getColumn(viewIndex) : null;
    }

    @NotNull
    public TableColumn getRootColumn() {
        TableColumn tableColumn = Objects.requireNonNull(this.getTableColumn(Root.INSTANCE));
        if (tableColumn == null) {
            VcsLogGraphTable.$$$reportNull$$$0(30);
        }
        return tableColumn;
    }

    @NotNull
    public TableColumn getCommitColumn() {
        TableColumn tableColumn = Objects.requireNonNull(this.getTableColumn(Commit.INSTANCE));
        if (tableColumn == null) {
            VcsLogGraphTable.$$$reportNull$$$0(31);
        }
        return tableColumn;
    }

    @Nullable
    private VcsLogCellController getController(@NotNull VcsLogColumn<?> column) {
        TableColumn tableColumn;
        if (column == null) {
            VcsLogGraphTable.$$$reportNull$$$0(32);
        }
        if ((tableColumn = this.getTableColumn(column)) == null) {
            return null;
        }
        VcsLogCellRenderer cellRenderer = VcsLogGraphTable.getVcsLogCellRenderer(tableColumn);
        return cellRenderer == null ? null : cellRenderer.getCellController();
    }

    @NotNull
    Point getPointInCell(@NotNull Point clickPoint, @NotNull VcsLogColumn<?> vcsLogColumn) {
        if (clickPoint == null) {
            VcsLogGraphTable.$$$reportNull$$$0(33);
        }
        if (vcsLogColumn == null) {
            VcsLogGraphTable.$$$reportNull$$$0(34);
        }
        int columnIndex = this.getColumnViewIndex(vcsLogColumn);
        int left = this.getColumnDataRectLeft(columnIndex);
        int top = this.getCellRectTop(clickPoint.y);
        return new Point(clickPoint.x - left, clickPoint.y - top);
    }

    private int getCellRectTop(int y) {
        int rowHeight = this.getRowHeight();
        int rowIndex = y / rowHeight;
        return rowIndex * rowHeight;
    }

    int getColumnDataRectLeft(int viewColumnIndex) {
        int x = this.getCellRect((int)0, (int)viewColumnIndex, (boolean)false).x;
        if (!ExperimentalUI.isNewUI()) {
            return x;
        }
        return x + VcsLogNewUiTableCellRenderer.getAdditionalOffset(viewColumnIndex);
    }

    private void setRootColumnSize() {
        TableColumn column = this.getRootColumn();
        RootCellRenderer rootCellRenderer = (RootCellRenderer)column.getCellRenderer();
        rootCellRenderer.updateInsets();
        int rootWidth = rootCellRenderer.getColumnWidth();
        column.setMinWidth(rootWidth);
        column.setMaxWidth(rootWidth);
        column.setPreferredWidth(rootWidth);
    }

    public void rootColumnUpdated() {
        this.setRootColumnSize();
        this.reLayout();
        this.repaint();
    }

    private boolean isShowRootNames() {
        return this.myProperties.exists(CommonUiProperties.SHOW_ROOT_NAMES) && this.myProperties.get(CommonUiProperties.SHOW_ROOT_NAMES) != false;
    }

    public void jumpToGraphRow(int graphRow, boolean focus) {
        int rowIndex = this.getModel().fromGraphToTableRow(graphRow);
        if (rowIndex >= 0 && rowIndex <= this.getRowCount() - 1) {
            this.scrollRectToVisible(this.getCellRect(rowIndex, 0, false));
            this.setRowSelectionInterval(rowIndex, rowIndex);
            if (focus && !this.hasFocus()) {
                IdeFocusManager.getInstance((Project)this.myLogData.getProject()).requestFocus((Component)((Object)this), true);
            }
        }
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        int[] selectedRows;
        if (sink == null) {
            VcsLogGraphTable.$$$reportNull$$$0(35);
        }
        Set roots = (selectedRows = this.getSelectedRows()).length == 0 || selectedRows.length > 1000 ? Collections.emptySet() : ContainerUtil.map2SetNotNull((Collection)Ints.asList((int[])selectedRows), row -> this.getModel().getRootAtRow((int)row));
        sink.set(PlatformDataKeys.COPY_PROVIDER, (Object)this);
        sink.set(VcsLogInternalDataKeys.VCS_LOG_GRAPH_TABLE, (Object)this);
        if (roots.size() == 1) {
            sink.set(VcsDataKeys.VCS, (Object)this.myLogData.getLogProvider(Objects.requireNonNull((VirtualFile)ContainerUtil.getFirstItem((Collection)roots))).getSupportedVcs());
        }
        if (selectedRows.length == 1) {
            List<VcsRef> refsAtRow = this.getModel().getRefsAtRow(selectedRows[0]);
            List branchesAtRow = ContainerUtil.filter(refsAtRow, ref -> ref.getType().isBranch());
            sink.set(VcsLogDataKeys.VCS_LOG_BRANCHES, (Object)branchesAtRow);
            sink.set(VcsLogDataKeys.VCS_LOG_REFS, refsAtRow);
        }
        if (selectedRows.length != 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < Math.min(1000, selectedRows.length); ++i) {
                sb.append(this.getModel().getValueAt(selectedRows[i], Commit.INSTANCE));
                if (i == selectedRows.length - 1) continue;
                sb.append("\n");
            }
            sink.set(VcsDataKeys.PRESET_COMMIT_MESSAGE, (Object)sb.toString());
        }
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            VcsLogGraphTable.$$$reportNull$$$0(36);
        }
        StringBuilder sb = new StringBuilder();
        List<Integer> visibleColumns = this.getVisibleColumnIndices();
        int[] selectedRows = this.getSelectedRows();
        for (int i = 0; i < Math.min(1000, selectedRows.length); ++i) {
            int row = selectedRows[i];
            sb.append(StringUtil.join(visibleColumns, j -> {
                if (j.intValue() == VcsLogColumnManager.getInstance().getModelIndex(Root.INSTANCE)) {
                    return "";
                }
                return this.getModel().getValueAt(row, (int)j).toString();
            }, (String)" "));
            if (i == selectedRows.length - 1) continue;
            sb.append("\n");
        }
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(sb.toString()));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            VcsLogGraphTable.$$$reportNull$$$0(37);
        }
        return actionUpdateThread;
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            VcsLogGraphTable.$$$reportNull$$$0(38);
        }
        return this.getSelectedRowCount() > 0;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            VcsLogGraphTable.$$$reportNull$$$0(39);
        }
        return true;
    }

    public void addHighlighter(@NotNull VcsLogHighlighter highlighter) {
        if (highlighter == null) {
            VcsLogGraphTable.$$$reportNull$$$0(40);
        }
        this.myHighlighters.add(highlighter);
        highlighter.update((VcsLogDataPack)this.getModel().getVisiblePack(), true);
    }

    public void removeHighlighter(@NotNull VcsLogHighlighter highlighter) {
        if (highlighter == null) {
            VcsLogGraphTable.$$$reportNull$$$0(41);
        }
        this.myHighlighters.remove(highlighter);
    }

    public void removeAllHighlighters() {
        this.myHighlighters.clear();
    }

    @NotNull
    public SimpleTextAttributes applyHighlighters(@NotNull Component rendererComponent, int row, int column, boolean hasFocus, boolean selected) {
        if (rendererComponent == null) {
            VcsLogGraphTable.$$$reportNull$$$0(42);
        }
        VcsLogHighlighter.VcsCommitStyle style = this.getStyle(row, column, hasFocus, selected, row == TableHoverListener.getHoveredRow((JTable)((Object)this)));
        assert (style.getBackground() != null && style.getForeground() != null && style.getTextStyle() != null);
        rendererComponent.setBackground(style.getBackground());
        rendererComponent.setForeground(style.getForeground());
        SimpleTextAttributes simpleTextAttributes = switch (style.getTextStyle()) {
            case VcsLogHighlighter.TextStyle.BOLD -> SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            case VcsLogHighlighter.TextStyle.ITALIC -> SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES;
            default -> SimpleTextAttributes.REGULAR_ATTRIBUTES;
        };
        if (simpleTextAttributes == null) {
            VcsLogGraphTable.$$$reportNull$$$0(43);
        }
        return simpleTextAttributes;
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getBaseStyle(int row, int column, boolean hasFocus, boolean selected) {
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = this.myBaseStyleProvider.getBaseStyle(row, column, hasFocus, selected);
        if (vcsCommitStyle == null) {
            VcsLogGraphTable.$$$reportNull$$$0(44);
        }
        return vcsCommitStyle;
    }

    @NotNull
    VcsLogHighlighter.VcsCommitStyle getStyle(int row, int column, boolean hasFocus, boolean selected, boolean hovered) {
        VcsShortCommitDetails details;
        VcsLogHighlighter.VcsCommitStyle baseStyle = this.getBaseStyle(row, column, hasFocus, selected);
        GraphTableModel model = this.getModel();
        if (row < 0 || row >= model.getRowCount()) {
            LOG.error("Visible graph has " + model.getRowCount() + " commits, yet we want row " + row);
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = baseStyle;
            if (vcsCommitStyle == null) {
                VcsLogGraphTable.$$$reportNull$$$0(45);
            }
            return vcsCommitStyle;
        }
        RowType rowType = model.getRowType(row);
        VcsLogHighlighter.VcsCommitStyle style = VcsCommitStyleFactory.createStyle((Color)(rowType == RowType.UNMATCHED ? JBColor.GRAY : baseStyle.getForeground()), (Color)baseStyle.getBackground(), (VcsLogHighlighter.TextStyle)VcsLogHighlighter.TextStyle.NORMAL);
        Integer commitId = model.getId(row);
        if (commitId != null && (details = this.myLogData.getCommitMetadataCache().getCachedData(commitId.intValue())) != null) {
            int columnModelIndex = this.convertColumnIndexToModel(column);
            List styles = ContainerUtil.map(this.myHighlighters, highlighter -> {
                try {
                    return highlighter.getStyle(commitId.intValue(), details, columnModelIndex, selected);
                }
                catch (ProcessCanceledException e) {
                    return VcsLogHighlighter.VcsCommitStyle.DEFAULT;
                }
                catch (Throwable t) {
                    LOG.error("Exception while getting style from highlighter " + highlighter, t);
                    return VcsLogHighlighter.VcsCommitStyle.DEFAULT;
                }
            });
            style = VcsCommitStyleFactory.combine((Collection)ContainerUtil.append((List)styles, (Object[])new VcsLogHighlighter.VcsCommitStyle[]{style}));
        }
        if (!selected && hovered) {
            Color background = Objects.requireNonNull(style.getBackground());
            VcsLogHighlighter.VcsCommitStyle lightSelectionBgStyle = VcsCommitStyleFactory.background((Color)VcsLogGraphTable.getHoveredBackgroundColor(background));
            style = VcsCommitStyleFactory.combine(Arrays.asList(lightSelectionBgStyle, style));
        }
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = style;
        if (vcsCommitStyle == null) {
            VcsLogGraphTable.$$$reportNull$$$0(46);
        }
        return vcsCommitStyle;
    }

    @Nullable
    protected Color getHoveredRowBackground() {
        return null;
    }

    public void viewportSet(JViewport viewport) {
        viewport.addChangeListener(e -> {
            if (this.isShowRootNames()) {
                GraphTableModel model = this.getModel();
                Couple visibleRows = ScrollingUtil.getVisibleRows((JTable)((Object)this));
                if ((Integer)visibleRows.first >= 0) {
                    TableModelEvent evt = new TableModelEvent(model, (Integer)visibleRows.first, (Integer)visibleRows.second, VcsLogColumnManager.getInstance().getModelIndex(Root.INSTANCE));
                    model.fireTableChanged(evt);
                }
            }
            this.resolveLinks();
            this.mySelectionSnapshot = null;
        });
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        Component layeredPane = ComponentUtil.findParentByCondition((Component)((Object)this), component -> component instanceof LoadingDecorator.CursorAware);
        if (layeredPane != null) {
            layeredPane.setCursor(cursor);
        }
    }

    @NotNull
    public GraphTableModel getModel() {
        GraphTableModel graphTableModel = (GraphTableModel)super.getModel();
        if (graphTableModel == null) {
            VcsLogGraphTable.$$$reportNull$$$0(47);
        }
        return graphTableModel;
    }

    @Override
    @NotNull
    public GraphTableModel getListModel() {
        GraphTableModel graphTableModel = this.getModel();
        if (graphTableModel == null) {
            VcsLogGraphTable.$$$reportNull$$$0(48);
        }
        return graphTableModel;
    }

    @NotNull
    SelectionSnapshot getSelectionSnapshot() {
        if (this.mySelectionSnapshot == null) {
            this.mySelectionSnapshot = new SelectionSnapshot(this);
        }
        SelectionSnapshot selectionSnapshot = this.mySelectionSnapshot;
        if (selectionSnapshot == null) {
            VcsLogGraphTable.$$$reportNull$$$0(49);
        }
        return selectionSnapshot;
    }

    public void handleAnswer(@NotNull GraphAnswer<Integer> answer) {
        if (answer == null) {
            VcsLogGraphTable.$$$reportNull$$$0(50);
        }
        GraphCommitCellController controller = (GraphCommitCellController)Objects.requireNonNull(this.getController(Commit.INSTANCE));
        Cursor cursor = controller.handleGraphAnswer(answer, true, null, null);
        this.myMouseAdapter.handleCursor(cursor);
    }

    public void showTooltip(int row, @NotNull VcsLogColumn<?> column) {
        if (column == null) {
            VcsLogGraphTable.$$$reportNull$$$0(51);
        }
        if (column != Commit.INSTANCE) {
            return;
        }
        GraphCommitCellController controller = (GraphCommitCellController)Objects.requireNonNull(this.getController(column));
        controller.showTooltip(row);
    }

    @NotNull
    public VisibleGraph<Integer> getVisibleGraph() {
        VisibleGraph<Integer> visibleGraph = this.getModel().getVisiblePack().getVisibleGraph();
        if (visibleGraph == null) {
            VcsLogGraphTable.$$$reportNull$$$0(52);
        }
        return visibleGraph;
    }

    public int getRowHeight() {
        if (this.myGraphCommitCellRenderer == null) {
            return super.getRowHeight();
        }
        return this.myGraphCommitCellRenderer.getPreferredHeight();
    }

    @Override
    protected void paintFooter(@NotNull Graphics g, int x, int y, int width, int height) {
        if (g == null) {
            VcsLogGraphTable.$$$reportNull$$$0(53);
        }
        this.paintTopBottomBorder(g, x, y, width, height);
    }

    private void paintTopBottomBorder(@NotNull Graphics g, int x, int y, int width, int height) {
        int targetRow;
        if (g == null) {
            VcsLogGraphTable.$$$reportNull$$$0(54);
        }
        if ((targetRow = this.getRowCount() - 1) >= 0 && targetRow < this.getRowCount()) {
            g.setColor(this.getStyle(targetRow, this.getColumnViewIndex(Commit.INSTANCE), this.hasFocus(), false, false).getBackground());
        } else {
            g.setColor(this.getBaseStyle(targetRow, this.getColumnViewIndex(Commit.INSTANCE), this.hasFocus(), false).getBackground());
        }
        g.fillRect(x, y, width, height);
    }

    public boolean isResizingColumns() {
        return this.getCursor() == Cursor.getPredefinedCursor(11);
    }

    @NotNull
    private static Color getHoveredBackgroundColor(@NotNull Color background) {
        int alpha;
        if (background == null) {
            VcsLogGraphTable.$$$reportNull$$$0(55);
        }
        if ((alpha = HOVERED_BACKGROUND.getAlpha()) == 255) {
            Color color = HOVERED_BACKGROUND;
            if (color == null) {
                VcsLogGraphTable.$$$reportNull$$$0(56);
            }
            return color;
        }
        if (alpha == 0) {
            Color color = background;
            if (color == null) {
                VcsLogGraphTable.$$$reportNull$$$0(57);
            }
            return color;
        }
        Color color = ColorUtil.mix((Color)new Color(HOVERED_BACKGROUND.getRGB()), (Color)background, (double)((double)alpha / 255.0));
        if (color == null) {
            VcsLogGraphTable.$$$reportNull$$$0(58);
        }
        return color;
    }

    static Font getTableFont() {
        return UIManager.getFont("Table.font");
    }

    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        if (this.shouldChangeSelect(EventQueue.getCurrentEvent(), rowIndex, columnIndex)) {
            super.changeSelection(rowIndex, columnIndex, toggle, extend);
        }
    }

    private boolean shouldChangeSelect(@Nullable AWTEvent event, int rowIndex, int columnIndex) {
        if (!(event instanceof MouseEvent)) {
            return true;
        }
        VcsLogColumn<?> column = this.getVcsLogColumn(columnIndex);
        if (column == null) {
            return false;
        }
        VcsLogCellController controller = this.getController(column);
        if (controller == null) {
            return true;
        }
        return controller.shouldSelectCell(rowIndex, (MouseEvent)event);
    }

    @NotNull
    public static Color getTableBackground() {
        Color color = ExperimentalUI.isNewUI() ? JBUI.CurrentTheme.ToolWindow.background() : UIUtil.getListBackground();
        if (color == null) {
            VcsLogGraphTable.$$$reportNull$$$0(59);
        }
        return color;
    }

    @NotNull
    public static Color getSelectionBackground(boolean hasFocus) {
        Color color = hasFocus ? SELECTION_BACKGROUND : SELECTION_BACKGROUND_INACTIVE;
        if (color == null) {
            VcsLogGraphTable.$$$reportNull$$$0(60);
        }
        return color;
    }

    @NotNull
    public static Color getSelectionForeground(boolean hasFocus) {
        Color color = hasFocus ? SELECTION_FOREGROUND : SELECTION_FOREGROUND_INACTIVE;
        if (color == null) {
            VcsLogGraphTable.$$$reportNull$$$0(61);
        }
        return color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 13, 14, 19, 21, 22, 24, 25, 26, 30, 31, 37, 43, 44, 45, 46, 47, 48, 49, 52, 56, 57, 58, 59, 60, 61 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitByHashNavigator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/table/VcsLogGraphTable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultText";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visiblePack";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clickPoint";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsLogColumn";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 36: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rendererComponent";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "background";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/table/VcsLogGraphTable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleColumnIndices";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleColumns";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableColumn";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createColumnRenderer";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphCommitCellRenderer";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorManager";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogData";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootColumn";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitColumn";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "applyHighlighters";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseStyle";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getListModel";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionSnapshot";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleGraph";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getHoveredBackgroundColor";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableBackground";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionBackground";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionForeground";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setErrorEmptyText";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "appendActionToEmptyText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateDataPack";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isColumnVisible";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "onColumnDataChanged";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "forceReLayout";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resetColumnWidth";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createColumnRenderer";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getVcsLogCellRenderer";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getColumnWidthFromData";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getColumnViewIndex";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getTableColumn";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getController";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getPointInCell";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "performCopy";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isCopyEnabled";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isCopyVisible";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addHighlighter";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "removeHighlighter";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "applyHighlighters";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "handleAnswer";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "showTooltip";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "paintFooter";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "paintTopBottomBorder";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getHoveredBackgroundColor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 13, 14, 19, 21, 22, 24, 25, 26, 30, 31, 37, 43, 44, 45, 46, 47, 48, 49, 52, 56, 57, 58, 59, 60, 61 -> new IllegalStateException(string);
        };
    }

    private static class BaseStyleProvider {
        @NotNull
        private final JTable myTable;
        @NotNull
        private final TableCellRenderer myDummyRenderer;

        BaseStyleProvider(@NotNull JTable table) {
            if (table == null) {
                BaseStyleProvider.$$$reportNull$$$0(0);
            }
            this.myDummyRenderer = new DefaultTableCellRenderer();
            this.myTable = table;
        }

        @NotNull
        public VcsLogHighlighter.VcsCommitStyle getBaseStyle(int row, int column, boolean hasFocus, boolean selected) {
            Component dummyRendererComponent = this.myDummyRenderer.getTableCellRendererComponent(this.myTable, "", selected, hasFocus, row, column);
            Color background = selected ? VcsLogGraphTable.getSelectionBackground(this.myTable.hasFocus()) : VcsLogGraphTable.getTableBackground();
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.createStyle((Color)dummyRendererComponent.getForeground(), (Color)background, (VcsLogHighlighter.TextStyle)VcsLogHighlighter.TextStyle.NORMAL);
            if (vcsCommitStyle == null) {
                BaseStyleProvider.$$$reportNull$$$0(1);
            }
            return vcsCommitStyle;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/table/VcsLogGraphTable$BaseStyleProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/table/VcsLogGraphTable$BaseStyleProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBaseStyle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private class MyProgressListener
    implements VcsLogProgress.ProgressListener {
        private MyProgressListener() {
        }

        @Override
        public void progressStarted(@NotNull Collection<? extends VcsLogProgress.ProgressKey> keys) {
            if (keys == null) {
                MyProgressListener.$$$reportNull$$$0(0);
            }
            this.progressChanged(keys);
        }

        @Override
        public void progressChanged(@NotNull Collection<? extends VcsLogProgress.ProgressKey> keys) {
            if (keys == null) {
                MyProgressListener.$$$reportNull$$$0(1);
            }
            if (VcsLogUiUtil.isProgressVisible(keys, VcsLogGraphTable.this.getId())) {
                VcsLogGraphTable.this.getEmptyText().setText(VcsLogBundle.message("vcs.log.loading.status", new Object[0]));
            } else {
                VcsLogGraphTable.this.updateEmptyText();
            }
        }

        @Override
        public void progressStopped() {
            VcsLogGraphTable.this.updateEmptyText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "keys";
            objectArray2[1] = "com/intellij/vcs/log/ui/table/VcsLogGraphTable$MyProgressListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "progressStarted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "progressChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyTableColumnModel
    extends DefaultTableColumnModel {
        @NotNull
        private final VcsLogUiProperties myProperties;

        MyTableColumnModel(VcsLogUiProperties properties) {
            if (properties == null) {
                MyTableColumnModel.$$$reportNull$$$0(0);
            }
            this.myProperties = properties;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (VcsLogGraphTable.this.getTableHeader().getResizingColumn() == null) {
                return;
            }
            if ("width".equals(evt.getPropertyName())) {
                for (VcsLogColumn<?> logColumn : VcsLogColumnManager.getInstance().getCurrentDynamicColumns()) {
                    TableColumn column = VcsLogGraphTable.this.getTableColumn(logColumn);
                    if (!evt.getSource().equals(column)) continue;
                    VcsLogColumnUtilKt.setWidth(logColumn, this.myProperties, column.getWidth());
                }
            }
            super.propertyChange(evt);
        }

        @Override
        public void moveColumn(int columnIndex, int newIndex) {
            if (columnIndex == newIndex) {
                super.moveColumn(columnIndex, newIndex);
                return;
            }
            VcsLogColumn<?> column = VcsLogGraphTable.this.getVcsLogColumn(columnIndex);
            if (column == null || column == Root.INSTANCE || VcsLogGraphTable.this.getVcsLogColumn(newIndex) == Root.INSTANCE || !VcsLogColumnUtilKt.supportsColumnsReordering(this.myProperties)) {
                return;
            }
            super.moveColumn(columnIndex, newIndex);
            VcsLogColumnUtilKt.moveColumn(this.myProperties, column, newIndex);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$MyTableColumnModel", "<init>"));
        }
    }

    private class MyColumnsAvailabilityListener
    implements VcsLogCustomColumnListener {
        private MyColumnsAvailabilityListener() {
        }

        @Override
        public void columnAvailabilityChanged() {
            ApplicationManager.getApplication().invokeLater(() -> VcsLogGraphTable.this.onColumnOrderSettingChanged(), o -> VcsLogGraphTable.this.myDisposed);
        }
    }

    private class MyCurrentColumnsListener
    implements VcsLogColumnManager.CurrentColumnsListener {
        private MyCurrentColumnsListener() {
        }

        @Override
        public void columnAdded(@NotNull VcsLogColumn<?> column) {
            if (column == null) {
                MyCurrentColumnsListener.$$$reportNull$$$0(0);
            }
            VcsLogGraphTable.this.onColumnOrderSettingChanged();
        }

        @Override
        public void columnRemoved(@NotNull VcsLogColumn<?> column) {
            if (column == null) {
                MyCurrentColumnsListener.$$$reportNull$$$0(1);
            }
            VcsLogGraphTable.this.myTableColumns.remove(column);
            VcsLogGraphTable.this.myInitializedColumns.remove(column);
            VcsLogGraphTable.this.onColumnOrderSettingChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "column";
            objectArray2[1] = "com/intellij/vcs/log/ui/table/VcsLogGraphTable$MyCurrentColumnsListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "columnAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "columnRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private static final int BORDER_THICKNESS = 3;
        @NotNull
        private final TableLinkMouseListener myLinkListener;
        @Nullable
        private Cursor myLastCursor;

        private MyMouseAdapter(Consumer<String> commitByHashNavigator) {
            if (commitByHashNavigator == null) {
                MyMouseAdapter.$$$reportNull$$$0(0);
            }
            this.myLastCursor = null;
            this.myLinkListener = new MyLinkMouseListener(commitByHashNavigator);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            VcsLogCellController controller;
            int row;
            if (VcsLogGraphTable.this.getExpandableItemsHandler().isEnabled() && this.myLinkListener.onClick(e, e.getClickCount())) {
                return;
            }
            int c = VcsLogGraphTable.this.columnAtPoint(e.getPoint());
            VcsLogColumn<?> column = VcsLogGraphTable.this.getVcsLogColumn(c);
            if (column == null) {
                return;
            }
            if (e.getClickCount() == 2) {
                boolean useLeftBorder;
                int commitColumnIndex = VcsLogGraphTable.this.getColumnViewIndex(Commit.INSTANCE);
                boolean bl = useLeftBorder = c > commitColumnIndex;
                if ((useLeftBorder ? this.isOnLeftBorder(e, c) : this.isOnRightBorder(e, c)) && column.isDynamic()) {
                    VcsLogGraphTable.this.resetColumnWidth(column);
                } else {
                    int c2 = VcsLogGraphTable.this.columnAtPoint(new Point(e.getPoint().x + (useLeftBorder ? 1 : -1) * JBUIScale.scale((int)3), e.getPoint().y));
                    VcsLogColumn<?> column2 = VcsLogGraphTable.this.getVcsLogColumn(c2);
                    if (column2 != null && (useLeftBorder ? this.isOnLeftBorder(e, c2) : this.isOnRightBorder(e, c2)) && column2.isDynamic()) {
                        VcsLogGraphTable.this.resetColumnWidth(column2);
                    }
                }
            }
            if ((row = VcsLogGraphTable.this.rowAtPoint(e.getPoint())) >= 0 && row < VcsLogGraphTable.this.getRowCount() && e.getClickCount() == 1 && (controller = VcsLogGraphTable.this.getController(column)) != null) {
                Cursor cursor = SwingUtilities.isLeftMouseButton(e) ? controller.performMouseClick(row, e) : null;
                this.handleCursor(cursor);
            }
        }

        public boolean isOnLeftBorder(@NotNull MouseEvent e, int column) {
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(1);
            }
            return Math.abs(VcsLogGraphTable.this.getCellRect((int)0, (int)column, (boolean)false).x - e.getPoint().x) <= JBUIScale.scale((int)3);
        }

        public boolean isOnRightBorder(@NotNull MouseEvent e, int column) {
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(2);
            }
            return Math.abs(VcsLogGraphTable.this.getCellRect((int)0, (int)column, (boolean)false).x + VcsLogGraphTable.this.getColumnModel().getColumn(column).getWidth() - e.getPoint().x) <= JBUIScale.scale((int)3);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (VcsLogGraphTable.this.getRowCount() == 0) {
                return;
            }
            if (VcsLogGraphTable.this.isResizingColumns()) {
                return;
            }
            VcsLogGraphTable.this.getExpandableItemsHandler().setEnabled(true);
            int row = VcsLogGraphTable.this.rowAtPoint(e.getPoint());
            if (row >= 0 && row < VcsLogGraphTable.this.getRowCount()) {
                VcsLogColumn<?> column = VcsLogGraphTable.this.getVcsLogColumn(VcsLogGraphTable.this.columnAtPoint(e.getPoint()));
                if (column == null) {
                    return;
                }
                VcsLogCellController controller = VcsLogGraphTable.this.getController(column);
                if (controller != null) {
                    VcsLogCellController.MouseMoveResult mouseMoveResult = controller.performMouseMove(row, e);
                    this.handleCursor(mouseMoveResult.getCursor());
                    if (!mouseMoveResult.getContinueProcessing()) {
                        return;
                    }
                }
            }
            if (this.myLinkListener.getTagAt(e) != null) {
                this.swapCursor();
                return;
            }
            this.restoreCursor();
        }

        private void handleCursor(@Nullable Cursor cursor) {
            if (cursor != null) {
                if (cursor.getType() == 0) {
                    this.restoreCursor();
                } else if (cursor.getType() == 12) {
                    this.swapCursor();
                }
            }
        }

        private void swapCursor() {
            if (VcsLogGraphTable.this.getCursor().getType() != 12 && this.myLastCursor == null) {
                Cursor newCursor = Cursor.getPredefinedCursor(12);
                this.myLastCursor = VcsLogGraphTable.this.getCursor();
                VcsLogGraphTable.this.setCursor(newCursor);
            }
        }

        private void restoreCursor() {
            if (VcsLogGraphTable.this.getCursor().getType() != 0) {
                VcsLogGraphTable.this.setCursor(UIUtil.cursorIfNotDefault((Cursor)this.myLastCursor));
            }
            this.myLastCursor = null;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            VcsLogGraphTable.this.getExpandableItemsHandler().setEnabled(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitByHashNavigator";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/table/VcsLogGraphTable$MyMouseAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isOnLeftBorder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isOnRightBorder";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class MyLinkMouseListener
        extends SimpleColoredComponentLinkMouseListener {
            @NotNull
            private final Consumer<String> myCommitByHashNavigator;

            private MyLinkMouseListener(@NotNull Consumer<String> commitByHashNavigator) {
                if (commitByHashNavigator == null) {
                    MyLinkMouseListener.$$$reportNull$$$0(0);
                }
                this.myCommitByHashNavigator = commitByHashNavigator;
            }

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                Object tag;
                if (e == null) {
                    MyLinkMouseListener.$$$reportNull$$$0(1);
                }
                if ((tag = this.getTagAt(e)) instanceof Runnable) {
                    return super.onClick(e, clickCount);
                }
                if (tag instanceof NavigateToCommit) {
                    NavigateToCommit navigateToCommitTag = (NavigateToCommit)tag;
                    this.myCommitByHashNavigator.accept(navigateToCommitTag.getTarget());
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "commitByHashNavigator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/vcs/log/ui/table/VcsLogGraphTable$MyMouseAdapter$MyLinkMouseListener";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onClick";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

