/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.move;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassToInnerHandler;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassToInnerProcessor;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleSettings;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyUnusedImportUtil;
import org.jetbrains.plugins.groovy.util.GroovyChangeContextUtil;

public final class GroovyMoveClassToInnerHandler
implements MoveClassToInnerHandler {
    private static final Logger LOG = Logger.getInstance(GroovyMoveClassToInnerHandler.class);

    public PsiClass moveClass(@NotNull PsiClass aClass, @NotNull PsiClass targetClass) {
        if (aClass == null) {
            GroovyMoveClassToInnerHandler.$$$reportNull$$$0(0);
        }
        if (targetClass == null) {
            GroovyMoveClassToInnerHandler.$$$reportNull$$$0(1);
        }
        if (!(aClass instanceof GrTypeDefinition)) {
            return null;
        }
        GroovyChangeContextUtil.encodeContextInfo((PsiElement)aClass);
        PsiDocComment doc = aClass.getDocComment();
        PsiElement brace = targetClass.getRBrace();
        PsiClass newClass = (PsiClass)targetClass.addBefore((PsiElement)aClass, brace);
        PsiElement sibling = newClass.getPrevSibling();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(targetClass.getProject());
        if (!PsiUtil.isNewLine(sibling)) {
            targetClass.addBefore(factory.createLineTerminator("\n "), (PsiElement)newClass);
        } else if (doc != null) {
            LOG.assertTrue(sibling != null);
            sibling.replace(factory.createLineTerminator(sibling.getText() + " "));
        }
        if (doc != null) {
            targetClass.addBefore((PsiElement)doc, (PsiElement)newClass);
            targetClass.addBefore(factory.createLineTerminator("\n"), (PsiElement)newClass);
        }
        if (targetClass.isInterface()) {
            com.intellij.psi.util.PsiUtil.setModifierProperty((PsiModifierListOwner)newClass, (String)"public", (boolean)true);
        } else {
            com.intellij.psi.util.PsiUtil.setModifierProperty((PsiModifierListOwner)newClass, (String)"static", (boolean)true);
        }
        GroovyChangeContextUtil.decodeContextInfo((PsiElement)newClass, null, null);
        return newClass;
    }

    public List<PsiElement> filterImports(@NotNull List<UsageInfo> usageInfos, @NotNull Project project) {
        if (usageInfos == null) {
            GroovyMoveClassToInnerHandler.$$$reportNull$$$0(2);
        }
        if (project == null) {
            GroovyMoveClassToInnerHandler.$$$reportNull$$$0(3);
        }
        ArrayList<PsiElement> importStatements = new ArrayList<PsiElement>();
        if (!((GroovyCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(GroovyCodeStyleSettings.class)).INSERT_INNER_CLASS_IMPORTS) {
            GroovyMoveClassToInnerHandler.filterUsagesInImportStatements(usageInfos, importStatements);
        } else {
            usageInfos.sort((o1, o2) -> com.intellij.psi.util.PsiUtil.BY_POSITION.compare(o1.getElement(), o2.getElement()));
        }
        return importStatements;
    }

    private static void filterUsagesInImportStatements(List<UsageInfo> usages, List<PsiElement> importStatements) {
        Iterator<UsageInfo> iterator2 = usages.iterator();
        while (iterator2.hasNext()) {
            GrImportStatement stmt;
            UsageInfo usage = iterator2.next();
            PsiElement element = usage.getElement();
            if (element == null || (stmt = (GrImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element, GrImportStatement.class)) == null) continue;
            importStatements.add(stmt);
            iterator2.remove();
        }
    }

    public void retargetClassRefsInMoved(final @NotNull Map<PsiElement, PsiElement> oldToNewElementsMapping) {
        if (oldToNewElementsMapping == null) {
            GroovyMoveClassToInnerHandler.$$$reportNull$$$0(4);
        }
        for (PsiElement newClass : oldToNewElementsMapping.values()) {
            if (!(newClass instanceof GrTypeDefinition)) continue;
            ((GrTypeDefinition)newClass).accept(new GroovyRecursiveElementVisitor(){

                @Override
                public void visitReferenceExpression(@NotNull GrReferenceExpression reference) {
                    if (reference == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (this.visitRef(reference)) {
                        return;
                    }
                    super.visitReferenceExpression(reference);
                }

                @Override
                public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement refElement) {
                    if (refElement == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.visitRef(refElement);
                    super.visitCodeReferenceElement(refElement);
                }

                private boolean visitRef(GrReferenceElement reference) {
                    PsiElement element = reference.resolve();
                    if (element instanceof PsiClass) {
                        for (PsiElement oldClass : oldToNewElementsMapping.keySet()) {
                            if (!PsiTreeUtil.isAncestor((PsiElement)oldClass, (PsiElement)element, (boolean)false)) continue;
                            PsiClass newInnerClass = GroovyMoveClassToInnerHandler.findMatchingClass((PsiClass)oldClass, (PsiClass)oldToNewElementsMapping.get(oldClass), (PsiClass)element);
                            try {
                                reference.bindToElement((PsiElement)newInnerClass);
                                return true;
                            }
                            catch (IncorrectOperationException ex) {
                                LOG.error((Throwable)ex);
                            }
                        }
                    }
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "reference";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "refElement";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/move/GroovyMoveClassToInnerHandler$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitReferenceExpression";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitCodeReferenceElement";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private static PsiClass findMatchingClass(PsiClass classToMove, PsiClass newClass, PsiClass innerClass) {
        if (classToMove == innerClass) {
            return newClass;
        }
        PsiClass parentClass = GroovyMoveClassToInnerHandler.findMatchingClass(classToMove, newClass, innerClass.getContainingClass());
        PsiClass newInnerClass = parentClass.findInnerClassByName(innerClass.getName(), false);
        assert (newInnerClass != null);
        return newInnerClass;
    }

    public void retargetNonCodeUsages(@NotNull Map<PsiElement, PsiElement> oldToNewElementMap, final NonCodeUsageInfo @NotNull [] nonCodeUsages) {
        if (oldToNewElementMap == null) {
            GroovyMoveClassToInnerHandler.$$$reportNull$$$0(5);
        }
        if (nonCodeUsages == null) {
            GroovyMoveClassToInnerHandler.$$$reportNull$$$0(6);
        }
        for (PsiElement newClass : oldToNewElementMap.values()) {
            if (!(newClass instanceof GrTypeDefinition)) continue;
            newClass.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    super.visitElement(element);
                    List list = (List)element.getCopyableUserData(MoveClassToInnerProcessor.ourNonCodeUsageKey);
                    if (list != null) {
                        block0: for (NonCodeUsageInfo info : list) {
                            for (int i2 = 0; i2 < nonCodeUsages.length; ++i2) {
                                if (nonCodeUsages[i2] != info) continue;
                                nonCodeUsages[i2] = info.replaceElement(element);
                                continue block0;
                            }
                        }
                        element.putCopyableUserData(MoveClassToInnerProcessor.ourNonCodeUsageKey, null);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/refactoring/move/GroovyMoveClassToInnerHandler$2", "visitElement"));
                }
            });
        }
    }

    public void removeRedundantImports(PsiFile targetClassFile) {
        if (!(targetClassFile instanceof GroovyFile)) {
            return;
        }
        GroovyFile file = (GroovyFile)targetClassFile;
        for (GrImportStatement unusedImport : GroovyUnusedImportUtil.unusedImports(file)) {
            file.removeImport(unusedImport);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldToNewElementsMapping";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldToNewElementMap";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonCodeUsages";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/move/GroovyMoveClassToInnerHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "moveClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "filterImports";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "retargetClassRefsInMoved";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "retargetNonCodeUsages";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

