/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyReference;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTuple;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTupleAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ControlFlowBuilder;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.FunctionalExpressionFlowUtil;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GroovyControlFlow;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.VariableDescriptorFactory;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAType;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.DefinitionMap;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.ReachingDefinitionsSemilattice;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.InferenceCache;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.NestedContextKt;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypesReachingDefinitionsInstance;
import org.jetbrains.plugins.groovy.lang.psi.impl.InferenceContext;
import org.jetbrains.plugins.groovy.lang.psi.impl.PartialContext;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.typing.TuplesKt;

public final class TypeInferenceHelper {
    private static final Logger LOG = Logger.getInstance(TypeInferenceHelper.class);
    private static final ThreadLocal<InferenceContext> ourInferenceContext = new ThreadLocal();

    static <T> T doInference(@NotNull Map<VariableDescriptor, DFAType> bindings, @NotNull Supplier<? extends T> computation) {
        if (bindings == null) {
            TypeInferenceHelper.$$$reportNull$$$0(0);
        }
        if (computation == null) {
            TypeInferenceHelper.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            NestedContextKt.checkNestedContext();
        }
        return TypeInferenceHelper.withContext(new PartialContext(bindings), computation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T withContext(@NotNull InferenceContext context, @NotNull Supplier<? extends T> computation) {
        if (context == null) {
            TypeInferenceHelper.$$$reportNull$$$0(2);
        }
        if (computation == null) {
            TypeInferenceHelper.$$$reportNull$$$0(3);
        }
        InferenceContext previous = ourInferenceContext.get();
        ourInferenceContext.set(context);
        try {
            T t = computation.get();
            return t;
        }
        finally {
            ourInferenceContext.set(previous);
        }
    }

    @Contract(pure=true)
    @NotNull
    public static InferenceContext getCurrentContext() {
        InferenceContext context = ourInferenceContext.get();
        return context != null ? context : TypeInferenceHelper.getTopContext();
    }

    public static <T> T inTopContext(@NotNull Supplier<? extends T> computation) {
        if (computation == null) {
            TypeInferenceHelper.$$$reportNull$$$0(4);
        }
        return TypeInferenceHelper.withContext(TypeInferenceHelper.getTopContext(), computation);
    }

    @Contract(pure=true)
    @NotNull
    public static InferenceContext getTopContext() {
        InferenceContext inferenceContext = InferenceContext.TOP_CONTEXT;
        if (inferenceContext == null) {
            TypeInferenceHelper.$$$reportNull$$$0(5);
        }
        return inferenceContext;
    }

    @Nullable
    public static PsiType getInferredType(@NotNull GrReferenceExpression refExpr) {
        GrControlFlowOwner scope;
        if (refExpr == null) {
            TypeInferenceHelper.$$$reportNull$$$0(6);
        }
        GrControlFlowOwner grControlFlowOwner = scope = FunctionalExpressionFlowUtil.isFlatDFAAllowed() ? ControlFlowUtils.getTopmostOwner(refExpr) : ControlFlowUtils.findControlFlowOwner(refExpr);
        if (scope == null) {
            return null;
        }
        GroovyReference rValueReference = refExpr.getRValueReference();
        PsiElement resolve2 = rValueReference == null ? null : rValueReference.resolve();
        boolean mixinOnly = resolve2 instanceof GrField && CompileStaticUtil.isCompileStatic(refExpr);
        VariableDescriptor descriptor = VariableDescriptorFactory.createDescriptor(refExpr);
        if (descriptor == null) {
            return null;
        }
        ReadWriteVariableInstruction rwInstruction = ControlFlowUtils.findRWInstruction(refExpr, TypeInferenceHelper.getFlatControlFlow(scope).getFlow());
        if (rwInstruction == null) {
            return null;
        }
        InferenceCache cache2 = TypeInferenceHelper.getInferenceCache(scope);
        int descriptorIndex = cache2.getGroovyFlow().getIndex(descriptor);
        if (descriptorIndex == 0) {
            return null;
        }
        return cache2.getInferredType(descriptorIndex, rwInstruction, mixinOnly);
    }

    @Nullable
    public static PsiType getInferredType(int descriptor, Instruction instruction, GrControlFlowOwner scope) {
        InferenceCache cache2 = TypeInferenceHelper.getInferenceCache(scope);
        return cache2.getInferredType(descriptor, instruction, false);
    }

    @Nullable
    public static PsiType getVariableTypeInContext(@Nullable PsiElement context, @NotNull GrVariable variable) {
        GrControlFlowOwner scope;
        if (variable == null) {
            TypeInferenceHelper.$$$reportNull$$$0(7);
        }
        if (context == null) {
            return variable.getType();
        }
        GrControlFlowOwner grControlFlowOwner = scope = FunctionalExpressionFlowUtil.isFlatDFAAllowed() ? ControlFlowUtils.getTopmostOwner(ControlFlowUtils.findControlFlowOwner(context)) : ControlFlowUtils.findControlFlowOwner(context);
        if (scope == null) {
            return null;
        }
        Instruction nearest = ControlFlowUtils.findNearestInstruction(context, scope.getControlFlow());
        if (nearest == null) {
            return null;
        }
        boolean mixinOnly = variable instanceof GrField && CompileStaticUtil.isCompileStatic(scope);
        InferenceCache cache2 = TypeInferenceHelper.getInferenceCache(scope);
        VariableDescriptor descriptor = VariableDescriptorFactory.createDescriptor(variable);
        int descriptorIndex = cache2.getGroovyFlow().getIndex(descriptor);
        if (descriptorIndex == 0) {
            if (variable instanceof GrField) {
                return variable.getDeclaredType();
            }
            return null;
        }
        PsiType inferredType = cache2.getInferredType(descriptorIndex, nearest, mixinOnly);
        return inferredType != null ? inferredType : variable.getType();
    }

    public static boolean isTooComplexTooAnalyze(@NotNull GrControlFlowOwner scope) {
        if (scope == null) {
            TypeInferenceHelper.$$$reportNull$$$0(8);
        }
        return TypeInferenceHelper.getInferenceCache(scope).isTooComplexToAnalyze();
    }

    @NotNull
    static InferenceCache getInferenceCache(@NotNull GrControlFlowOwner scope) {
        if (scope == null) {
            TypeInferenceHelper.$$$reportNull$$$0(9);
        }
        if (FunctionalExpressionFlowUtil.isFlatDFAAllowed() && ControlFlowUtils.getTopmostOwner(scope) != scope) {
            LOG.error("Flat DFA inconsistency: scope is " + scope + ", but topmost owner is " + ControlFlowUtils.getTopmostOwner(scope));
        }
        InferenceCache inferenceCache = (InferenceCache)CachedValuesManager.getCachedValue((PsiElement)scope, () -> CachedValueProvider.Result.create((Object)new InferenceCache(scope), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (inferenceCache == null) {
            TypeInferenceHelper.$$$reportNull$$$0(10);
        }
        return inferenceCache;
    }

    public static GroovyControlFlow getFlatControlFlow(@NotNull GrControlFlowOwner scope) {
        if (scope == null) {
            TypeInferenceHelper.$$$reportNull$$$0(11);
        }
        if (FunctionalExpressionFlowUtil.isFlatDFAAllowed()) {
            return (GroovyControlFlow)CachedValuesManager.getCachedValue((PsiElement)scope, () -> CachedValueProvider.Result.create((Object)ControlFlowBuilder.buildFlatControlFlow(scope), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        }
        return ControlFlowUtils.getGroovyControlFlow(scope);
    }

    @Nullable
    static List<DefinitionMap> getDefUseMaps(@NotNull GroovyControlFlow flow) {
        if (flow == null) {
            TypeInferenceHelper.$$$reportNull$$$0(12);
        }
        TypesReachingDefinitionsInstance dfaInstance = new TypesReachingDefinitionsInstance();
        ReachingDefinitionsSemilattice lattice = new ReachingDefinitionsSemilattice();
        DFAEngine<DefinitionMap> engine = new DFAEngine<DefinitionMap>(flow.getFlow(), dfaInstance, lattice);
        List<@Nullable DefinitionMap> maps = engine.performDFAWithTimeout();
        if (maps == null) {
            return null;
        }
        return ContainerUtil.map(maps, it -> it == null ? DefinitionMap.NEUTRAL : it);
    }

    @Nullable
    public static PsiType getInitializerType(PsiElement element) {
        if (element instanceof GrReferenceExpression && ((GrReferenceExpression)element).getQualifierExpression() == null) {
            return TypeInferenceHelper.getInitializerTypeFor(element);
        }
        if (element instanceof GrVariable) {
            return ((GrVariable)element).getTypeGroovy();
        }
        return null;
    }

    @Nullable
    public static PsiType getInitializerTypeFor(PsiElement element) {
        GrUnaryExpression unary;
        int idx;
        GrExpression rValue;
        GrTuple list;
        GrTupleAssignmentExpression assignment;
        PsiElement parent = PsiUtil.skipParentheses(element.getParent(), true);
        if (parent instanceof GrAssignmentExpression) {
            if (element instanceof GrIndexProperty) {
                GrExpression rvalue = ((GrAssignmentExpression)parent).getRValue();
                return rvalue != null ? rvalue.getType() : null;
            }
            return ((GrAssignmentExpression)parent).getType();
        }
        if (parent instanceof GrTuple && (assignment = (list = (GrTuple)parent).getParent()) != null && (rValue = assignment.getRValue()) != null && (idx = list.indexOf(element)) >= 0) {
            return TuplesKt.getMultiAssignmentType(rValue, idx);
        }
        if (parent instanceof GrUnaryExpression && TokenSets.POSTFIX_UNARY_OP_SET.contains((unary = (GrUnaryExpression)parent).getOperationTokenType())) {
            return unary.getOperationType();
        }
        return null;
    }

    @Nullable
    public static GrExpression getInitializerFor(GrExpression lValue) {
        PsiElement parent = lValue.getParent();
        if (parent instanceof GrAssignmentExpression) {
            return ((GrAssignmentExpression)parent).getRValue();
        }
        if (parent instanceof GrTuple) {
            GrExpression[] initializers;
            int i2 = ((GrTuple)parent).indexOf(lValue);
            GrTupleAssignmentExpression grandParent = ((GrTuple)parent).getParent();
            LOG.assertTrue(grandParent != null);
            GrExpression rValue = grandParent.getRValue();
            if (rValue instanceof GrListOrMap && !((GrListOrMap)rValue).isMap() && i2 < (initializers = ((GrListOrMap)rValue).getInitializers()).length) {
                return initializers[i2];
            }
        }
        return null;
    }

    public static boolean isSimpleEnoughForAugmenting(Instruction @NotNull [] flow) {
        if (flow == null) {
            TypeInferenceHelper.$$$reportNull$$$0(13);
        }
        return flow.length < 20;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindings";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/TypeInferenceHelper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/TypeInferenceHelper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopContext";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInferenceCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doInference";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withContext";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "inTopContext";
                break;
            }
            case 5: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInferredType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVariableTypeInContext";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isTooComplexTooAnalyze";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInferenceCache";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFlatControlFlow";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDefUseMaps";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isSimpleEnoughForAugmenting";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 10 -> new IllegalStateException(string);
        };
    }
}

