/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.intentions.base.GrPsiUpdateIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.IfEndInstruction;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;

public final class GrRedundantElseIntention
extends GrPsiUpdateIntention {
    public static final String HINT = "Remove redundant 'else' keyword";

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull ActionContext context, @NotNull ModPsiUpdater updater) {
        PsiElement parent;
        if (element == null) {
            GrRedundantElseIntention.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GrRedundantElseIntention.$$$reportNull$$$0(1);
        }
        if (updater == null) {
            GrRedundantElseIntention.$$$reportNull$$$0(2);
        }
        if (!((parent = element.getParent()) instanceof GrIfStatement)) {
            return;
        }
        GrIfStatement ifStatement = GroovyRefactoringUtil.addBlockIntoParent((GrIfStatement)parent);
        assert (ifStatement.getParent() instanceof GrStatementOwner);
        PsiElement statementOwner = ifStatement.getParent();
        GrStatement branch = ifStatement.getElseBranch();
        if (branch == null) {
            return;
        }
        if (branch instanceof GrBlockStatement) {
            GrOpenBlock block = ((GrBlockStatement)branch).getBlock();
            PsiElement first = GrRedundantElseIntention.inferFirst(block.getLBrace());
            PsiElement last = GrRedundantElseIntention.inferLast(block.getRBrace());
            if (!Objects.equals(first, block.getRBrace()) && !Objects.equals(last, block.getLBrace())) {
                statementOwner.addRangeAfter(first, last, (PsiElement)ifStatement);
            }
        } else {
            statementOwner.addAfter((PsiElement)branch, (PsiElement)ifStatement);
        }
        branch.delete();
        updater.moveCaretTo(ifStatement.getTextRange().getEndOffset());
    }

    private static PsiElement inferFirst(PsiElement lbrace) {
        return PsiUtil.skipWhitespaces(lbrace.getNextSibling(), true);
    }

    private static PsiElement inferLast(PsiElement rbrace) {
        return PsiUtil.skipWhitespaces(rbrace.getPrevSibling(), false);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                Instruction[] flow;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element.getNode().getElementType() != GroovyTokenTypes.kELSE) {
                    return false;
                }
                PsiElement parent = element.getParent();
                if (!(parent instanceof GrIfStatement)) {
                    return false;
                }
                GrIfStatement ifStatement = (GrIfStatement)parent;
                GrStatement branch = ifStatement.getThenBranch();
                GrControlFlowOwner flowOwner = ControlFlowUtils.findControlFlowOwner(ifStatement);
                if (flowOwner == null) {
                    return false;
                }
                for (Instruction instruction : flow = flowOwner.getControlFlow()) {
                    if (!(instruction instanceof IfEndInstruction) || instruction.getElement() != ifStatement) continue;
                    for (Instruction pred : instruction.allPredecessors()) {
                        PsiElement predElement = pred.getElement();
                        if (predElement == null || !PsiTreeUtil.isAncestor((PsiElement)branch, (PsiElement)predElement, (boolean)false)) continue;
                        return false;
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/control/GrRedundantElseIntention$1", "satisfiedBy"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "updater";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/intentions/control/GrRedundantElseIntention";
        objectArray[2] = "processIntention";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

