/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrInlineUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.FakeInliningLocalVariables;
import org.jetbrains.kotlin.backend.jvm.lower.FakeLocalVariablesForIrInlinerLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.FunctionParametersProcessor;
import org.jetbrains.kotlin.backend.jvm.lower.LocalVariablesProcessor;
import org.jetbrains.kotlin.backend.jvm.lower.ScopeNumberVariableProcessor;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@PhaseDescription(name="FakeLocalVariablesForIrInlinerLowering")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0001\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0014\u0010\u001c\u001a\u00020\u0010*\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FakeLocalVariablesForIrInlinerLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "Lorg/jetbrains/kotlin/backend/jvm/lower/FakeInliningLocalVariables;", "Lorg/jetbrains/kotlin/ir/expressions/IrInlinedFunctionBlock;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "inlinedStack", "", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "insertInStackAndProcess", "", "lower", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitInlinedFunctionBlock", "inlinedBlock", "handleInlineFunction", "expression", "handleInlineLambda", "addFakeLocalVariable", "name", "", "backend.jvm.lower"})
public final class FakeLocalVariablesForIrInlinerLowering
extends IrVisitorVoid
implements FakeInliningLocalVariables<IrInlinedFunctionBlock>,
FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final List<IrInlinedFunctionBlock> inlinedStack;
    @Nullable
    private IrDeclaration container;

    public FakeLocalVariablesForIrInlinerLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.inlinedStack = new ArrayList();
    }

    @Override
    @NotNull
    public JvmBackendContext getContext() {
        return this.context;
    }

    private final void insertInStackAndProcess(IrInlinedFunctionBlock $this$insertInStackAndProcess) {
        ((Collection)this.inlinedStack).add($this$insertInStackAndProcess);
        $this$insertInStackAndProcess.acceptChildren((IrElementVisitor)this, null);
        CollectionsKt.removeLast(this.inlinedStack);
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (!this.getContext().getConfig().getEnableIrInliner()) {
            return;
        }
        irFile.accept((IrElementVisitor)this, null);
        if (this.getContext().getConfiguration().getBoolean(JVMConfigurationKeys.USE_INLINE_SCOPES_NUMBERS)) {
            IrVisitorsKt.acceptVoid((IrElement)((IrElement)irFile), (IrVisitorVoid)new ScopeNumberVariableProcessor());
        } else {
            irFile.accept((IrElementVisitor)new LocalVariablesProcessor(), (Object)new LocalVariablesProcessor.Data(false));
            IrVisitorsKt.acceptVoid((IrElement)((IrElement)irFile), (IrVisitorVoid)new FunctionParametersProcessor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IrDeclaration oldContainer = this.container;
        try {
            this.container = element instanceof IrDeclaration && !(element instanceof IrVariable) ? (IrDeclaration)element : this.container;
            element.acceptChildren((IrElementVisitor)this, null);
        }
        finally {
            this.container = oldContainer;
        }
    }

    public void visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock) {
        Intrinsics.checkNotNullParameter((Object)inlinedBlock, (String)"inlinedBlock");
        if (org.jetbrains.kotlin.ir.util.IrInlineUtilsKt.isFunctionInlining((IrInlinedFunctionBlock)inlinedBlock)) {
            this.handleInlineFunction(inlinedBlock);
        } else if (org.jetbrains.kotlin.ir.util.IrInlineUtilsKt.isLambdaInlining((IrInlinedFunctionBlock)inlinedBlock)) {
            this.handleInlineLambda(inlinedBlock);
        } else {
            super.visitInlinedFunctionBlock(inlinedBlock);
        }
    }

    private final void handleInlineFunction(IrInlinedFunctionBlock expression2) {
        this.insertInStackAndProcess(expression2);
        IrDeclaration declaration = JvmIrInlineUtilsKt.getInlineDeclaration(expression2);
        this.addFakeLocalVariableForFun((IrElement)expression2, declaration);
    }

    private final void handleInlineLambda(IrInlinedFunctionBlock expression2) {
        this.insertInStackAndProcess(expression2);
        IrElement irElement = org.jetbrains.kotlin.ir.util.IrInlineUtilsKt.getInlinedElement((IrInlinedFunctionBlock)expression2);
        Intrinsics.checkNotNull((Object)irElement);
        IrElement argument = irElement;
        IrDeclaration irDeclaration = FakeLocalVariablesForIrInlinerLoweringKt.access$extractDeclarationWhereGivenElementWasInlined(this.inlinedStack, argument);
        IrFunction irFunction = irDeclaration instanceof IrFunction ? (IrFunction)irDeclaration : null;
        if (irFunction == null) {
            return;
        }
        IrFunction callee = irFunction;
        this.addFakeLocalVariableForLambda((IrElement)expression2, argument, callee);
    }

    @Override
    public void addFakeLocalVariable(@NotNull IrInlinedFunctionBlock $this$addFakeLocalVariable, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$addFakeLocalVariable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        LoweringContext loweringContext = (LoweringContext)this.getContext();
        IrDeclaration irDeclaration = this.container;
        Intrinsics.checkNotNull((Object)irDeclaration);
        DeclarationIrBuilder $this$addFakeLocalVariable_u24lambda_u240 = LowerUtilsKt.createIrBuilder$default((LoweringContext)loweringContext, (IrSymbol)irDeclaration.getSymbol(), (int)0, (int)0, (int)6, null);
        boolean bl = false;
        IrVariable tmpVar = IrBuilderKt.createTmpVariable$default((Scope)$this$addFakeLocalVariable_u24lambda_u240.getScope(), (IrExpression)((IrExpression)ExpressionHelpersKt.irInt$default((IrBuilderWithScope)((IrBuilderWithScope)$this$addFakeLocalVariable_u24lambda_u240), (int)0, null, (int)2, null)), (String)StringsKt.removeSuffix((String)name, (CharSequence)"$$forInline"), (boolean)false, (IrDeclarationOrigin)((IrDeclarationOrigin)IrDeclarationOrigin.Companion.getDEFINED()), null, (int)20, null);
        int position = IrInlineUtilsKt.getTmpVariablesForArguments((IrInlinedFunctionBlock)$this$addFakeLocalVariable).size();
        $this$addFakeLocalVariable.getStatements().add(position, tmpVar);
    }
}

