/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridRow;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdentityDataProducer
implements DataProducer {
    private final DataConsumer myConsumer;
    private final List<? extends GridColumn> myColumns;
    private final List<? extends GridRow> myRows;
    private final int mySubQueryIndex;
    private final int myResultSetIndex;

    public IdentityDataProducer(DataConsumer consumer, List<? extends GridColumn> columns, List<? extends GridRow> rows, int subQueryIndex, int resultSetIndex) {
        this.myConsumer = consumer;
        this.myColumns = columns;
        this.myRows = rows;
        this.mySubQueryIndex = subQueryIndex;
        this.myResultSetIndex = resultSetIndex;
    }

    public void processRequest(@NotNull GridDataRequest r) {
        if (r == null) {
            IdentityDataProducer.$$$reportNull$$$0(0);
        }
        DataConsumer.Composite consumer = r instanceof DataConsumer ? new DataConsumer.Composite(Arrays.asList(this.myConsumer, (DataConsumer)r)) : this.myConsumer;
        GridDataRequest.Context context = this.createContext(r);
        if (context == null) {
            r.getPromise().setError("Cannot create request context. GridDataRequest: " + r);
            return;
        }
        int rowNum = this.myRows.isEmpty() ? 0 : this.myRows.get(0).getRowNum();
        try {
            consumer.setColumns(context, this.mySubQueryIndex, this.myResultSetIndex, this.myColumns.toArray(new GridColumn[0]), rowNum);
            this.doAddRows(context, (DataConsumer)consumer, this.myRows);
            consumer.afterLastRowAdded(context, this.myRows.size());
            r.getPromise().setResult(null);
        }
        catch (Exception e) {
            r.getPromise().setError((Throwable)e);
        }
    }

    @Nullable
    protected abstract GridDataRequest.Context createContext(@NotNull GridDataRequest var1);

    protected void doAddRows(GridDataRequest.Context context, DataConsumer handler, List<? extends GridRow> rows) {
        handler.addRows(context, rows);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/datagrid/IdentityDataProducer", "processRequest"));
    }
}

