/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.util.io.FileUtil;
import java.nio.file.Path;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0001H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u0004\u0018\u00010\u00058VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/idea/maven/server/LocalMavenDistribution;", "Lorg/jetbrains/idea/maven/server/MavenDistribution;", "mavenHome", "Ljava/nio/file/Path;", "name", "", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "getMavenHome", "()Ljava/nio/file/Path;", "getName", "()Ljava/lang/String;", "version", "getVersion", "version$delegate", "Lkotlin/Lazy;", "compatibleWith", "", "mavenDistribution", "isValid", "toString", "intellij.maven"})
public final class LocalMavenDistribution
implements MavenDistribution {
    @NotNull
    private final Path mavenHome;
    @NotNull
    private final String name;
    @NotNull
    private final Lazy version$delegate;

    public LocalMavenDistribution(@NotNull Path mavenHome, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)mavenHome, (String)"mavenHome");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.mavenHome = mavenHome;
        this.name = name;
        this.version$delegate = LazyKt.lazy(() -> LocalMavenDistribution.version_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public Path getMavenHome() {
        return this.mavenHome;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getVersion() {
        Lazy lazy = this.version$delegate;
        return (String)lazy.getValue();
    }

    @Override
    public boolean compatibleWith(@NotNull MavenDistribution mavenDistribution) {
        Intrinsics.checkNotNullParameter((Object)mavenDistribution, (String)"mavenDistribution");
        return Intrinsics.areEqual((Object)mavenDistribution, (Object)this) || FileUtil.pathsEqual((String)((Object)mavenDistribution.getMavenHome()).toString(), (String)((Object)this.getMavenHome()).toString());
    }

    @Override
    public boolean isValid() {
        return this.getVersion() != null;
    }

    @NotNull
    public String toString() {
        return this.getName() + "(" + this.getMavenHome() + ") v " + this.getVersion();
    }

    private static final String version_delegate$lambda$0(LocalMavenDistribution this$0) {
        return MavenUtil.getMavenVersion(this$0.getMavenHome());
    }
}

