/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.util.progress.RawProgressReporter;
import com.intellij.util.containers.ArrayListSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.DisposableWrapperList;
import com.intellij.util.containers.FileCollectionFactory;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import io.opentelemetry.extension.kotlin.ContextExtensionsKt;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.dom.references.MavenFilteredPropertyPsiReferenceProvider;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenCoordinate;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenProfileKind;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.project.MavenEmbedderWrappers;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectReader;
import org.jetbrains.idea.maven.project.MavenProjectReaderProjectLocator;
import org.jetbrains.idea.maven.project.MavenProjectTimestamp;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenProjectsTreeUpdateContext;
import org.jetbrains.idea.maven.project.MavenProjectsTreeUpdateResult;
import org.jetbrains.idea.maven.project.MavenProjectsTreeUpdater;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.telemetry.TelemetryKt;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.Strings;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00dc\u00012\u00020\u0001:\b\u00d9\u0001\u00da\u0001\u00db\u0001\u00dc\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010-\u001a\u0004\u0018\u00010\u001e2\u0006\u0010.\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\b/J\u001a\u00100\u001a\u0002012\u0006\u0010.\u001a\u00020\u001a2\b\u00102\u001a\u0004\u0018\u00010\"H\u0007J\u001d\u00103\u001a\u0002012\u0006\u0010.\u001a\u00020\u001a2\u0006\u00104\u001a\u00020\u001eH\u0001\u00a2\u0006\u0002\b5J\u000e\u00106\u001a\u0002012\u0006\u00107\u001a\u000208J\u001e\u00109\u001a\u0002012\u0006\u0010:\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0013H\u0002J\u001c\u0010@\u001a\u0002012\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010B\u001a\u00020\u0017J\u001e\u0010C\u001a\u0002012\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00132\u0006\u0010B\u001a\u00020\u0017H\u0007J\u001c\u0010E\u001a\u0002012\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00132\u0006\u0010B\u001a\u00020\u0017J\u0014\u0010F\u001a\u0002012\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0013J\u0016\u0010M\u001a\u0002012\u000e\u0010A\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010NJ\u000e\u0010O\u001a\u00020P2\u0006\u0010\u0002\u001a\u00020\u001aJ\u001c\u0010Q\u001a\u0002012\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00132\u0006\u0010S\u001a\u00020PJ$\u0010Q\u001a\u0002012\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00132\u0006\u0010S\u001a\u00020P2\u0006\u0010T\u001a\u00020PJ\u001e\u0010U\u001a\u0002012\f\u0010V\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010S\u001a\u00020PH\u0007J&\u0010U\u001a\u0002012\f\u0010V\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010S\u001a\u00020P2\u0006\u0010T\u001a\u00020PH\u0007J&\u0010W\u001a\u0002012\f\u0010V\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010S\u001a\u00020P2\u0006\u0010T\u001a\u00020PH\u0002J\u001a\u0010\\\u001a\u0002012\u0006\u0010]\u001a\u00020^2\b\b\u0002\u0010T\u001a\u00020PH\u0002J\u000e\u0010a\u001a\u00020P2\u0006\u0010\u0002\u001a\u00020\u001aJ\u0010\u0010a\u001a\u00020P2\u0006\u0010b\u001a\u00020\u000fH\u0007J\u0010\u0010c\u001a\u00020P2\u0006\u0010d\u001a\u00020\u000fH\u0002J\b\u0010j\u001a\u000201H\u0002J(\u0010t\u001a\u0002012\u0006\u0010u\u001a\u00020P2\u0006\u0010v\u001a\u00020w2\u0006\u0010x\u001a\u00020y2\u0006\u0010z\u001a\u00020{H\u0007J.\u0010t\u001a\u00020|2\u0006\u0010u\u001a\u00020P2\u0006\u0010v\u001a\u00020w2\u0006\u0010x\u001a\u00020y2\u0006\u0010z\u001a\u00020}H\u0087@\u00a2\u0006\u0002\u0010~J0\u0010t\u001a\u00020|2\u0006\u0010u\u001a\u00020P2\u0006\u0010v\u001a\u00020w2\u0006\u0010x\u001a\u00020y2\u0007\u0010\u007f\u001a\u00030\u0080\u0001H\u0087@\u00a2\u0006\u0003\u0010\u0081\u0001J?\u0010\u0082\u0001\u001a\u00020|2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u001d0N2\u0006\u0010u\u001a\u00020P2\u0006\u0010v\u001a\u00020w2\u0006\u0010x\u001a\u00020y2\u0007\u0010\u007f\u001a\u00030\u0080\u0001H\u0087@\u00a2\u0006\u0003\u0010\u0083\u0001JC\u0010\u0082\u0001\u001a\u00020|2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u001d0N2\u0007\u0010\u0084\u0001\u001a\u00020P2\u0007\u0010\u0085\u0001\u001a\u00020P2\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\u0007\u0010\u007f\u001a\u00030\u0080\u0001H\u0082@\u00a2\u0006\u0003\u0010\u0088\u0001J\u0013\u0010\u0089\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u008a\u0001\u001a\u00020}H\u0002J\t\u0010\u008b\u0001\u001a\u00020\u000fH\u0016J\u0010\u0010\u008c\u0001\u001a\u00020P2\u0007\u0010\u008d\u0001\u001a\u00020\u001dJ\u0011\u0010\u008c\u0001\u001a\u00020P2\u0006\u0010d\u001a\u00020\u000fH\u0002J7\u0010\u008e\u0001\u001a\u00020|2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00132\u0006\u0010v\u001a\u00020w2\u0006\u0010x\u001a\u00020y2\u0007\u0010\u007f\u001a\u00030\u0080\u0001H\u0087@\u00a2\u0006\u0003\u0010\u008f\u0001J1\u0010\u008e\u0001\u001a\u00020|2\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u001d0N2\u0007\u0010\u007f\u001a\u00030\u0080\u0001H\u0082@\u00a2\u0006\u0003\u0010\u0090\u0001J,\u0010\u0091\u0001\u001a\u0002012\t\u0010\u0092\u0001\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0002\u001a\u00020\u001a2\b\u0010\u0093\u0001\u001a\u00030\u0094\u0001H\u0001\u00a2\u0006\u0003\b\u0095\u0001J\u0011\u0010\u0096\u0001\u001a\u0002012\u0006\u0010.\u001a\u00020\u001aH\u0002J\u0014\u0010\u0097\u0001\u001a\u0002012\t\u0010\u0098\u0001\u001a\u0004\u0018\u00010\"H\u0002J\u0011\u0010\u0099\u0001\u001a\u0002012\u0006\u0010\u0002\u001a\u00020\u001aH\u0002J\u001a\u0010\u009a\u0001\u001a\u00020P2\u0007\u0010\u009b\u0001\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u001aH\u0007J\u0011\u0010\u009c\u0001\u001a\u00020P2\u0006\u0010\u0002\u001a\u00020\u001aH\u0007J\u000f\u0010\u009d\u0001\u001a\u000201H\u0000\u00a2\u0006\u0003\b\u009e\u0001J\u0007\u0010\u009f\u0001\u001a\u00020PJ\u0012\u0010\u00a2\u0001\u001a\u00030\u00a3\u00012\b\u0010\u00a4\u0001\u001a\u00030\u00a5\u0001J\u0012\u0010\u00ad\u0001\u001a\u0004\u0018\u00010\u001a2\u0007\u0010\u00ae\u0001\u001a\u00020\u001dJ\u0014\u0010\u00ad\u0001\u001a\u0004\u0018\u00010\u001a2\t\u0010\u00af\u0001\u001a\u0004\u0018\u00010\"J\u0013\u0010\u00ad\u0001\u001a\u0004\u0018\u00010\u001a2\b\u0010\u00b0\u0001\u001a\u00030\u00b1\u0001J\u0012\u0010\u00b2\u0001\u001a\u0004\u0018\u00010\u001a2\u0007\u0010\u00af\u0001\u001a\u00020\"J\u0011\u0010\u00b6\u0001\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0002\u001a\u00020\u001aJ\u001b\u0010\u00b7\u0001\u001a\b\u0012\u0004\u0012\u00020\u001a0N2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001a0NJ\u000f\u0010\u00b8\u0001\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u001aJ\u0011\u0010\u00b9\u0001\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u001aH\u0002J\u0016\u0010\u00ba\u0001\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00132\u0007\u0010\u0092\u0001\u001a\u00020\u001aJ\u001b\u0010\u00bb\u0001\u001a\u0002012\u0007\u0010\u0092\u0001\u001a\u00020\u001a2\u0007\u0010\u00bc\u0001\u001a\u00020\u001aH\u0002J\u001b\u0010\u00bd\u0001\u001a\u0002012\u0007\u0010\u0092\u0001\u001a\u00020\u001a2\u0007\u0010\u00bc\u0001\u001a\u00020\u001aH\u0007J\u0013\u0010\u00be\u0001\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0002\u001a\u00020\u001aH\u0007J\u0015\u0010\u00bf\u0001\u001a\b\u0012\u0004\u0012\u00020\u001a0N2\u0006\u0010\u0002\u001a\u00020\u001aJ\u001b\u0010\u00c0\u0001\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00132\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u001a0NJ\u001a\u0010\u00c1\u0001\u001a\u0002012\u0007\u0010\u00c2\u0001\u001a\u00020(2\b\u0010\u00c3\u0001\u001a\u00030\u00c4\u0001J\t\u0010\u00c5\u0001\u001a\u000201H\u0002J.\u0010\u00c6\u0001\u001a\u0002012\f\u0010S\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00132\r\u0010\u00c7\u0001\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00132\u0006\u0010T\u001a\u00020PH\u0002J4\u0010\u00c8\u0001\u001a\u0002012\u001a\u0010\u00c9\u0001\u001a\u0015\u0012\u0011\u0012\u000f\u0012\u0004\u0012\u00020\u001a\u0012\u0005\u0012\u00030\u00ca\u00010p0\u00132\r\u0010\u00cb\u0001\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0013H\u0007J\u001d\u0010\u00cc\u0001\u001a\u0002012\u0014\u0010\u00cd\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u001a\u0012\u0005\u0012\u00030\u00ca\u00010pJ\u000f\u0010\u00ce\u0001\u001a\u0002012\u0006\u0010\u0002\u001a\u00020\u001aJ\u001d\u0010\u00cf\u0001\u001a\u0002012\u0014\u0010\u00cd\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u001a\u0012\u0005\u0012\u00030\u00ca\u00010pJ\u000f\u0010\u00d0\u0001\u001a\u0002012\u0006\u0010\u0002\u001a\u00020\u001aJ(\u0010\u00d1\u0001\u001a\u0003H\u00d2\u0001\"\u0005\b\u0000\u0010\u00d2\u00012\u000f\u0010\u00d3\u0001\u001a\n\u0012\u0005\u0012\u0003H\u00d2\u00010\u00d4\u0001H\u0002\u00a2\u0006\u0003\u0010\u00d5\u0001J(\u0010\u00d6\u0001\u001a\u0003H\u00d2\u0001\"\u0005\b\u0000\u0010\u00d2\u00012\u000f\u0010\u00d3\u0001\u001a\n\u0012\u0005\u0012\u0003H\u00d2\u00010\u00d4\u0001H\u0002\u00a2\u0006\u0003\u0010\u00d5\u0001J\f\u0010\u00d7\u0001\u001a\u00070\u00d8\u0001R\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001a0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001a0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010$\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00110\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0017\u0010=\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00138F\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0017\u0010G\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00138F\u00a2\u0006\u0006\u001a\u0004\bH\u0010?R0\u0010I\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00138F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bJ\u0010?\"\u0004\bK\u0010LR0\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\f\u0010X\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00138F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bZ\u0010?\"\u0004\b[\u0010LR\u001a\u0010_\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b`\u0010?R$\u0010e\u001a\u00020\u00172\u0006\u0010e\u001a\u00020\u00178F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bf\u0010g\"\u0004\bh\u0010iR\u0017\u0010k\u001a\b\u0012\u0004\u0012\u00020\u000f0l8F\u00a2\u0006\u0006\u001a\u0004\bm\u0010nR#\u0010o\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020q0p0N8F\u00a2\u0006\u0006\u001a\u0004\br\u0010sR\u0019\u0010\u00a0\u0001\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00138F\u00a2\u0006\u0007\u001a\u0005\b\u00a1\u0001\u0010?R\u0019\u0010\u00a6\u0001\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00138F\u00a2\u0006\u0007\u001a\u0005\b\u00a7\u0001\u0010?R\u0018\u0010R\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00138F\u00a2\u0006\u0007\u001a\u0005\b\u00a8\u0001\u0010?R\u0019\u0010\u00a9\u0001\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00138F\u00a2\u0006\u0007\u001a\u0005\b\u00aa\u0001\u0010?R\u0019\u0010\u00ab\u0001\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00138F\u00a2\u0006\u0007\u001a\u0005\b\u00ac\u0001\u0010?R\u0014\u0010\u00b3\u0001\u001a\u00020 8F\u00a2\u0006\b\u001a\u0006\b\u00b4\u0001\u0010\u00b5\u0001\u00a8\u0006\u00dd\u0001"}, d2={"Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "myStructureLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "myStructureReadLock", "Ljava/util/concurrent/locks/Lock;", "myStructureWriteLock", "myManagedFilesPaths", "", "", "myIgnoredFilesPaths", "", "myIgnoredFilesPatterns", "", "myIgnoredFilesPatternsCache", "Ljava/util/regex/Pattern;", "myExplicitProfiles", "Lorg/jetbrains/idea/maven/model/MavenExplicitProfiles;", "myTemporarilyRemovedExplicitProfiles", "myRootProjects", "Lorg/jetbrains/idea/maven/project/MavenProject;", "myTimestamps", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/idea/maven/project/MavenProjectTimestamp;", "myWorkspaceMap", "Lorg/jetbrains/idea/maven/model/MavenWorkspaceMap;", "myMavenIdToProjectMapping", "Lorg/jetbrains/idea/maven/model/MavenId;", "myVirtualFileToProjectMapping", "myAggregatorToModuleMapping", "myModuleToAggregatorMapping", "myListeners", "Lcom/intellij/util/containers/DisposableWrapperList;", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree$Listener;", "projectLocator", "Lorg/jetbrains/idea/maven/project/MavenProjectReaderProjectLocator;", "getProjectLocator", "()Lorg/jetbrains/idea/maven/project/MavenProjectReaderProjectLocator;", "getTimeStamp", "mavenProject", "getTimeStamp$intellij_maven", "putVirtualFileToProjectMapping", "", "oldProjectId", "putTimestamp", "timestamp", "putTimestamp$intellij_maven", "save", "file", "Ljava/nio/file/Path;", "writeProjectsRecursively", "out", "Ljava/io/DataOutputStream;", "mavenProjects", "managedFilesPaths", "getManagedFilesPaths", "()Ljava/util/List;", "resetManagedFilesPathsAndProfiles", "paths", "profiles", "resetManagedFilesAndProfiles", "files", "addManagedFilesWithProfiles", "removeManagedFiles", "existingManagedFiles", "getExistingManagedFiles", "ignoredFilesPaths", "getIgnoredFilesPaths", "setIgnoredFilesPaths", "(Ljava/util/List;)V", "removeIgnoredFilesPaths", "", "getIgnoredState", "", "setIgnoredState", "projects", "ignored", "fromImport", "setIgnoredStateForPoms", "pomPaths", "doSetIgnoredState", "patterns", "ignoredFilesPatterns", "getIgnoredFilesPatterns", "setIgnoredFilesPatterns", "doChangeIgnoreStatus", "runnable", "Ljava/lang/Runnable;", "ignoredProjects", "getIgnoredProjects", "isIgnored", "projectPath", "matchesIgnoredFilesPatterns", "path", "explicitProfiles", "getExplicitProfiles", "()Lorg/jetbrains/idea/maven/model/MavenExplicitProfiles;", "setExplicitProfiles", "(Lorg/jetbrains/idea/maven/model/MavenExplicitProfiles;)V", "updateExplicitProfiles", "availableProfiles", "", "getAvailableProfiles", "()Ljava/util/Set;", "profilesWithStates", "Lcom/intellij/openapi/util/Pair;", "Lorg/jetbrains/idea/maven/model/MavenProfileKind;", "getProfilesWithStates", "()Ljava/util/Collection;", "updateAll", "force", "generalSettings", "Lorg/jetbrains/idea/maven/project/MavenGeneralSettings;", "mavenEmbedderWrappers", "Lorg/jetbrains/idea/maven/project/MavenEmbedderWrappers;", "process", "Lorg/jetbrains/idea/maven/utils/MavenProgressIndicator;", "Lorg/jetbrains/idea/maven/project/MavenProjectsTreeUpdateResult;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(ZLorg/jetbrains/idea/maven/project/MavenGeneralSettings;Lorg/jetbrains/idea/maven/project/MavenEmbedderWrappers;Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "progressReporter", "Lcom/intellij/platform/util/progress/RawProgressReporter;", "(ZLorg/jetbrains/idea/maven/project/MavenGeneralSettings;Lorg/jetbrains/idea/maven/project/MavenEmbedderWrappers;Lcom/intellij/platform/util/progress/RawProgressReporter;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "update", "(Ljava/util/Collection;ZLorg/jetbrains/idea/maven/project/MavenGeneralSettings;Lorg/jetbrains/idea/maven/project/MavenEmbedderWrappers;Lcom/intellij/platform/util/progress/RawProgressReporter;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateModules", "forceRead", "projectReader", "Lorg/jetbrains/idea/maven/project/MavenProjectReader;", "(Ljava/util/Collection;ZZLorg/jetbrains/idea/maven/project/MavenProjectReader;Lcom/intellij/platform/util/progress/RawProgressReporter;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toRawProgressReporter", "progressIndicator", "toString", "isManagedFile", "moduleFile", "delete", "(Ljava/util/List;Lorg/jetbrains/idea/maven/project/MavenGeneralSettings;Lorg/jetbrains/idea/maven/project/MavenEmbedderWrappers;Lcom/intellij/platform/util/progress/RawProgressReporter;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Lorg/jetbrains/idea/maven/project/MavenProjectReader;Ljava/util/Collection;Lcom/intellij/platform/util/progress/RawProgressReporter;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doDelete", "aggregator", "updateContext", "Lorg/jetbrains/idea/maven/project/MavenProjectsTreeUpdateContext;", "doDelete$intellij_maven", "fillIDMaps", "clearIDMaps", "mavenId", "addRootModule", "reconnect", "newAggregator", "reconnectRoot", "recalculateMavenIdToProjectMap", "recalculateMavenIdToProjectMap$intellij_maven", "hasProjects", "rootProjects", "getRootProjects", "getFilterConfigCrc", "", "fileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "rootProjectsFiles", "getRootProjectsFiles", "getProjects", "nonIgnoredProjects", "getNonIgnoredProjects", "projectsFiles", "getProjectsFiles", "findProject", "f", "id", "artifact", "Lorg/jetbrains/idea/maven/model/MavenArtifact;", "findSingleProjectInReactor", "workspaceMap", "getWorkspaceMap", "()Lorg/jetbrains/idea/maven/model/MavenWorkspaceMap;", "findAggregator", "collectAggregators", "findRootProject", "doFindRootProject", "getModules", "addModule", "module", "removeModule", "findParent", "findInheritors", "getDependentProjects", "addListener", "l", "disposable", "Lcom/intellij/openapi/Disposable;", "fireProfilesChanged", "fireProjectsIgnoredStateChanged", "unignored", "fireProjectsUpdated", "updated", "Lorg/jetbrains/idea/maven/project/MavenProjectChanges;", "deleted", "fireProjectResolved", "projectWithChanges", "firePluginsResolved", "fireFoldersResolved", "fireArtifactsDownloaded", "withReadLock", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withWriteLock", "updater", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree$Updater;", "Listener", "MavenCoordinateHashCodeStrategy", "Updater", "Companion", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenProjectsTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenProjectsTree.kt\norg/jetbrains/idea/maven/project/MavenProjectsTree\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1238:1\n1557#2:1239\n1628#2,3:1240\n1557#2:1243\n1628#2,3:1244\n774#2:1328\n865#2,2:1329\n1863#2,2:1331\n1863#2,2:1333\n295#2,2:1335\n48#3,6:1247\n86#3,2:1253\n55#3,3:1255\n97#3:1258\n89#3,6:1259\n48#3,6:1265\n86#3,2:1271\n55#3,3:1273\n97#3:1276\n89#3,6:1277\n48#3,6:1283\n86#3,2:1289\n55#3,3:1291\n97#3:1294\n89#3,6:1295\n26#3:1301\n86#3,2:1302\n27#3,3:1304\n97#3:1307\n89#3,6:1308\n26#3:1314\n86#3,2:1315\n27#3,3:1317\n97#3:1320\n89#3,6:1321\n1#4:1327\n*S KotlinDebug\n*F\n+ 1 MavenProjectsTree.kt\norg/jetbrains/idea/maven/project/MavenProjectsTree\n*L\n162#1:1239\n162#1:1240,3\n199#1:1243\n199#1:1244,3\n773#1:1328\n773#1:1329,2\n616#1:1331,2\n619#1:1333,2\n748#1:1335,2\n376#1:1247,6\n376#1:1253,2\n376#1:1255,3\n376#1:1258\n376#1:1259,6\n381#1:1265,6\n381#1:1271,2\n381#1:1273,3\n381#1:1276\n381#1:1277,6\n421#1:1283,6\n421#1:1289,2\n421#1:1291,3\n421#1:1294\n421#1:1295,6\n430#1:1301\n430#1:1302,2\n430#1:1304,3\n430#1:1307\n430#1:1308,6\n447#1:1314\n447#1:1315,2\n447#1:1317,3\n447#1:1320\n447#1:1321,6\n*E\n"})
public final class MavenProjectsTree {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ReentrantReadWriteLock myStructureLock;
    @NotNull
    private final Lock myStructureReadLock;
    @NotNull
    private final Lock myStructureWriteLock;
    @NotNull
    private volatile Set<String> myManagedFilesPaths;
    @NotNull
    private volatile List<String> myIgnoredFilesPaths;
    @NotNull
    private volatile List<String> myIgnoredFilesPatterns;
    @Nullable
    private volatile Pattern myIgnoredFilesPatternsCache;
    @NotNull
    private MavenExplicitProfiles myExplicitProfiles;
    @NotNull
    private final MavenExplicitProfiles myTemporarilyRemovedExplicitProfiles;
    @NotNull
    private final List<MavenProject> myRootProjects;
    @NotNull
    private final Map<VirtualFile, MavenProjectTimestamp> myTimestamps;
    @NotNull
    private final MavenWorkspaceMap myWorkspaceMap;
    @NotNull
    private final Map<MavenId, MavenProject> myMavenIdToProjectMapping;
    @NotNull
    private final Map<VirtualFile, MavenProject> myVirtualFileToProjectMapping;
    @NotNull
    private final Map<MavenProject, List<MavenProject>> myAggregatorToModuleMapping;
    @NotNull
    private final Map<MavenProject, MavenProject> myModuleToAggregatorMapping;
    @NotNull
    private final DisposableWrapperList<Listener> myListeners;
    @NotNull
    private final MavenProjectReaderProjectLocator projectLocator;
    @NotNull
    private static final Logger LOG;
    private static final int STORAGE_VERSION_NUMBER = 12;
    @NotNull
    private static final String STORAGE_VERSION;

    public MavenProjectsTree(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myStructureLock = new ReentrantReadWriteLock();
        ReentrantReadWriteLock.ReadLock readLock = this.myStructureLock.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"readLock(...)");
        this.myStructureReadLock = readLock;
        ReentrantReadWriteLock.WriteLock writeLock = this.myStructureLock.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
        this.myStructureWriteLock = writeLock;
        this.myManagedFilesPaths = new LinkedHashSet();
        this.myIgnoredFilesPaths = new ArrayList();
        this.myIgnoredFilesPatterns = new ArrayList();
        MavenExplicitProfiles mavenExplicitProfiles = MavenExplicitProfiles.NONE;
        Intrinsics.checkNotNullExpressionValue((Object)mavenExplicitProfiles, (String)"NONE");
        this.myExplicitProfiles = mavenExplicitProfiles;
        this.myTemporarilyRemovedExplicitProfiles = new MavenExplicitProfiles((Collection)new HashSet(), (Collection)new HashSet());
        this.myRootProjects = new ArrayList();
        this.myTimestamps = new HashMap();
        this.myWorkspaceMap = new MavenWorkspaceMap();
        this.myMavenIdToProjectMapping = new HashMap();
        this.myVirtualFileToProjectMapping = new HashMap();
        this.myAggregatorToModuleMapping = new HashMap();
        this.myModuleToAggregatorMapping = new HashMap();
        this.myListeners = new DisposableWrapperList();
        this.projectLocator = arg_0 -> MavenProjectsTree.projectLocator$lambda$0(this, arg_0);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final MavenProjectReaderProjectLocator getProjectLocator() {
        return this.projectLocator;
    }

    @ApiStatus.Internal
    @Nullable
    public final MavenProjectTimestamp getTimeStamp$intellij_maven(@NotNull MavenProject mavenProject) {
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        return this.myTimestamps.get(mavenProject.getFile());
    }

    @ApiStatus.Internal
    public final void putVirtualFileToProjectMapping(@NotNull MavenProject mavenProject, @Nullable MavenId oldProjectId) {
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        this.withWriteLock(() -> MavenProjectsTree.putVirtualFileToProjectMapping$lambda$1(this, oldProjectId, mavenProject));
    }

    @ApiStatus.Internal
    public final void putTimestamp$intellij_maven(@NotNull MavenProject mavenProject, @NotNull MavenProjectTimestamp timestamp) {
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        this.myTimestamps.put(mavenProject.getFile(), timestamp);
    }

    public final void save(@NotNull Path file2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.withReadLock(() -> MavenProjectsTree.save$lambda$3(file2, this));
    }

    private final void writeProjectsRecursively(DataOutputStream out, List<MavenProject> mavenProjects) throws IOException {
        out.writeInt(mavenProjects.size());
        for (MavenProject mavenProject : mavenProjects) {
            mavenProject.write(out);
            VirtualFile virtualFile = mavenProject.getFile();
            MavenProjectTimestamp mavenProjectTimestamp = MavenProjectTimestamp.NULL;
            Intrinsics.checkNotNullExpressionValue((Object)mavenProjectTimestamp, (String)"NULL");
            MavenProjectTimestamp timestamp = this.myTimestamps.getOrDefault(virtualFile, mavenProjectTimestamp);
            timestamp.write(out);
            this.writeProjectsRecursively(out, this.getModules(mavenProject));
        }
    }

    @NotNull
    public final List<String> getManagedFilesPaths() {
        return (List)this.withReadLock(() -> MavenProjectsTree._get_managedFilesPaths_$lambda$4(this));
    }

    public final void resetManagedFilesPathsAndProfiles(@NotNull List<String> paths, @NotNull MavenExplicitProfiles profiles2) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Intrinsics.checkNotNullParameter((Object)profiles2, (String)"profiles");
        this.withWriteLock(() -> MavenProjectsTree.resetManagedFilesPathsAndProfiles$lambda$5(this, paths, profiles2));
    }

    @TestOnly
    public final void resetManagedFilesAndProfiles(@NotNull List<? extends VirtualFile> files2, @NotNull MavenExplicitProfiles profiles2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)profiles2, (String)"profiles");
        this.resetManagedFilesPathsAndProfiles(MavenUtil.collectPaths(files2), profiles2);
    }

    public final void addManagedFilesWithProfiles(@NotNull List<? extends VirtualFile> files2, @NotNull MavenExplicitProfiles profiles2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)profiles2, (String)"profiles");
        kotlin.Pair pair = (kotlin.Pair)this.withReadLock(() -> MavenProjectsTree.addManagedFilesWithProfiles$lambda$6(this, files2, profiles2));
        ArrayList newFiles = (ArrayList)pair.component1();
        MavenExplicitProfiles newProfiles = (MavenExplicitProfiles)pair.component2();
        List list = newFiles;
        Intrinsics.checkNotNull((Object)newProfiles);
        this.resetManagedFilesPathsAndProfiles(list, newProfiles);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeManagedFiles(@NotNull List<? extends VirtualFile> files2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Iterable $this$map$iv = files2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        Set filePaths = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        this.withWriteLock(() -> MavenProjectsTree.removeManagedFiles$lambda$8(this, filePaths));
    }

    @NotNull
    public final List<VirtualFile> getExistingManagedFiles() {
        List result2 = new ArrayList();
        for (String path : this.getManagedFilesPaths()) {
            VirtualFile f = LocalFileSystem.getInstance().findFileByPath(path);
            if (f == null || !f.exists()) continue;
            result2.add(f);
        }
        return result2;
    }

    @NotNull
    public final List<String> getIgnoredFilesPaths() {
        return (List)this.withReadLock(() -> MavenProjectsTree._get_ignoredFilesPaths_$lambda$9(this));
    }

    public final void setIgnoredFilesPaths(@NotNull List<String> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        MavenProjectsTree.doChangeIgnoreStatus$default(this, () -> MavenProjectsTree._set_ignoredFilesPaths_$lambda$10(this, paths), false, 2, null);
    }

    public final void removeIgnoredFilesPaths(@Nullable Collection<String> paths) {
        MavenProjectsTree.doChangeIgnoreStatus$default(this, () -> MavenProjectsTree.removeIgnoredFilesPaths$lambda$11(this, paths), false, 2, null);
    }

    public final boolean getIgnoredState(@NotNull MavenProject project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (Boolean)this.withReadLock(() -> MavenProjectsTree.getIgnoredState$lambda$12(this, project));
    }

    public final void setIgnoredState(@NotNull List<MavenProject> projects, boolean ignored) {
        Intrinsics.checkNotNullParameter(projects, (String)"projects");
        this.setIgnoredState(projects, ignored, false);
    }

    /*
     * WARNING - void declaration
     */
    public final void setIgnoredState(@NotNull List<MavenProject> projects, boolean ignored, boolean fromImport) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(projects, (String)"projects");
        Iterable $this$map$iv = projects;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MavenProject mavenProject = (MavenProject)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        List pomPaths = (List)destination$iv$iv;
        this.setIgnoredStateForPoms(pomPaths, ignored, fromImport);
    }

    @ApiStatus.Internal
    public final void setIgnoredStateForPoms(@NotNull List<String> pomPaths, boolean ignored) {
        Intrinsics.checkNotNullParameter(pomPaths, (String)"pomPaths");
        this.doSetIgnoredState(pomPaths, ignored, false);
    }

    @ApiStatus.Internal
    public final void setIgnoredStateForPoms(@NotNull List<String> pomPaths, boolean ignored, boolean fromImport) {
        Intrinsics.checkNotNullParameter(pomPaths, (String)"pomPaths");
        this.doSetIgnoredState(pomPaths, ignored, fromImport);
    }

    private final void doSetIgnoredState(List<String> pomPaths, boolean ignored, boolean fromImport) {
        this.doChangeIgnoreStatus(() -> MavenProjectsTree.doSetIgnoredState$lambda$14(ignored, this, pomPaths), fromImport);
    }

    @NotNull
    public final List<String> getIgnoredFilesPatterns() {
        return (List)this.withReadLock(() -> MavenProjectsTree._get_ignoredFilesPatterns_$lambda$15(this));
    }

    public final void setIgnoredFilesPatterns(@NotNull List<String> patterns) {
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        MavenProjectsTree.doChangeIgnoreStatus$default(this, () -> MavenProjectsTree._set_ignoredFilesPatterns_$lambda$16(this, patterns), false, 2, null);
    }

    private final void doChangeIgnoreStatus(Runnable runnable, boolean fromImport) {
        kotlin.Pair pair = (kotlin.Pair)this.withWriteLock(() -> MavenProjectsTree.doChangeIgnoreStatus$lambda$17(this, runnable));
        List ignoredBefore = (List)pair.component1();
        List ignoredAfter = (List)pair.component2();
        List ignored = new ArrayList(ignoredAfter);
        ignored.removeAll(ignoredBefore);
        List unignored = new ArrayList(ignoredBefore);
        unignored.removeAll(ignoredAfter);
        if (ignored.isEmpty() && unignored.isEmpty()) {
            return;
        }
        this.fireProjectsIgnoredStateChanged(ignored, unignored, fromImport);
    }

    static /* synthetic */ void doChangeIgnoreStatus$default(MavenProjectsTree mavenProjectsTree, Runnable runnable, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        mavenProjectsTree.doChangeIgnoreStatus(runnable, bl);
    }

    private final List<MavenProject> getIgnoredProjects() {
        List result2 = new ArrayList();
        for (MavenProject each : this.getProjects()) {
            if (!this.isIgnored(each)) continue;
            result2.add(each);
        }
        return result2;
    }

    public final boolean isIgnored(@NotNull MavenProject project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String path = project.getPath();
        return this.isIgnored(path);
    }

    @ApiStatus.Internal
    public final boolean isIgnored(@NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        return (Boolean)this.withReadLock(() -> MavenProjectsTree.isIgnored$lambda$18(this, projectPath));
    }

    private final boolean matchesIgnoredFilesPatterns(String path) {
        return (Boolean)this.withReadLock(() -> MavenProjectsTree.matchesIgnoredFilesPatterns$lambda$19(this, path));
    }

    @NotNull
    public final MavenExplicitProfiles getExplicitProfiles() {
        Object t = this.withReadLock(() -> MavenProjectsTree._get_explicitProfiles_$lambda$20(this));
        Intrinsics.checkNotNullExpressionValue(t, (String)"withReadLock(...)");
        return (MavenExplicitProfiles)t;
    }

    public final void setExplicitProfiles(@NotNull MavenExplicitProfiles explicitProfiles) {
        Intrinsics.checkNotNullParameter((Object)explicitProfiles, (String)"explicitProfiles");
        this.withWriteLock(() -> MavenProjectsTree._set_explicitProfiles_$lambda$21(this, explicitProfiles));
        this.fireProfilesChanged();
    }

    private final void updateExplicitProfiles() {
        Set<String> available = this.getAvailableProfiles();
        this.withWriteLock(() -> MavenProjectsTree.updateExplicitProfiles$lambda$22(this, available));
    }

    @NotNull
    public final Set<String> getAvailableProfiles() {
        HashSet<String> res = new HashSet<String>();
        for (MavenProject each : this.getProjects()) {
            res.addAll(each.getProfilesIds());
        }
        return res;
    }

    @NotNull
    public final Collection<Pair<String, MavenProfileKind>> getProfilesWithStates() {
        Collection result2 = (Collection)new ArrayListSet();
        Collection available = new HashSet();
        Collection active = new HashSet();
        for (MavenProject each : this.getProjects()) {
            available.addAll(each.getProfilesIds());
            Collection collection = each.getActivatedProfilesIds().getEnabledProfiles();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getEnabledProfiles(...)");
            active.addAll(collection);
        }
        Collection collection = this.getExplicitProfiles().getEnabledProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getEnabledProfiles(...)");
        Collection enabledProfiles = collection;
        Collection collection2 = this.getExplicitProfiles().getDisabledProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getDisabledProfiles(...)");
        Collection disabledProfiles = collection2;
        for (Object e : available) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            String each = (String)e;
            MavenProfileKind state = disabledProfiles.contains(each) ? MavenProfileKind.NONE : (enabledProfiles.contains(each) ? MavenProfileKind.EXPLICIT : (active.contains(each) ? MavenProfileKind.IMPLICIT : MavenProfileKind.NONE));
            Pair pair = Pair.create((Object)each, (Object)state);
            Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
            result2.add(pair);
        }
        return result2;
    }

    @Deprecated(message="use {@link MavenProjectsManager#updateAllMavenProjects(MavenImportSpec)} instead")
    public final void updateAll(boolean force, @NotNull MavenGeneralSettings generalSettings, @NotNull MavenEmbedderWrappers mavenEmbedderWrappers, @NotNull MavenProgressIndicator process2) {
        Intrinsics.checkNotNullParameter((Object)generalSettings, (String)"generalSettings");
        Intrinsics.checkNotNullParameter((Object)mavenEmbedderWrappers, (String)"mavenEmbedderWrappers");
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super MavenProjectsTreeUpdateResult>, Object>(this, force, generalSettings, mavenEmbedderWrappers, process2, null){
            int label;
            final /* synthetic */ MavenProjectsTree this$0;
            final /* synthetic */ boolean $force;
            final /* synthetic */ MavenGeneralSettings $generalSettings;
            final /* synthetic */ MavenEmbedderWrappers $mavenEmbedderWrappers;
            final /* synthetic */ MavenProgressIndicator $process;
            {
                this.this$0 = $receiver;
                this.$force = $force;
                this.$generalSettings = $generalSettings;
                this.$mavenEmbedderWrappers = $mavenEmbedderWrappers;
                this.$process = $process;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ProgressIndicator progressIndicator = this.$process.getIndicator();
                        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"getIndicator(...)");
                        this.label = 1;
                        Object object3 = this.this$0.updateAll(this.$force, this.$generalSettings, this.$mavenEmbedderWrappers, progressIndicator, (Continuation<? super MavenProjectsTreeUpdateResult>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super MavenProjectsTreeUpdateResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @ApiStatus.Internal
    @Nullable
    public final Object updateAll(boolean force, @NotNull MavenGeneralSettings generalSettings, @NotNull MavenEmbedderWrappers mavenEmbedderWrappers, @NotNull ProgressIndicator process2, @NotNull Continuation<? super MavenProjectsTreeUpdateResult> $completion) {
        return this.updateAll(force, generalSettings, mavenEmbedderWrappers, this.toRawProgressReporter(process2), $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @ApiStatus.Internal
    @Nullable
    public final Object updateAll(boolean var1_1, @NotNull MavenGeneralSettings var2_2, @NotNull MavenEmbedderWrappers var3_3, @NotNull RawProgressReporter var4_4, @NotNull Continuation<? super MavenProjectsTreeUpdateResult> $completion) {
        if (!($completion instanceof updateAll.3)) ** GOTO lbl-1000
        var22_6 = $completion;
        if ((var22_6.label & -2147483648) != 0) {
            var22_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ MavenProjectsTree this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.updateAll(false, (MavenGeneralSettings)null, (MavenEmbedderWrappers)null, (RawProgressReporter)null, (Continuation<? super MavenProjectsTreeUpdateResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var23_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                managedFiles = this.getExistingManagedFiles();
                projectReader = new MavenProjectReader(this.project, (MavenEmbedderWrappers)mavenEmbedderWrappers, (MavenGeneralSettings)generalSettings, this.getExplicitProfiles(), this.projectLocator);
                v0 = TelemetryKt.getTracer().spanBuilder("updateProjectTree");
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"spanBuilder(...)");
                $this$useWithScope_u24default$iv = v0;
                context$iv /* !! */  = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
                $i$f$useWithScope = false;
                v1 = $this$useWithScope_u24default$iv.startSpan();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"startSpan(...)");
                $this$useWithoutActiveScope$iv$iv = v1;
                $i$f$useWithoutActiveScope = false;
                span$iv = $this$useWithoutActiveScope$iv$iv;
                $i$a$-useWithoutActiveScope-TraceKt$useWithScope$2$iv = false;
                v2 = Context.current().with((ImplicitContextKeyed)span$iv);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"with(...)");
                $continuation.L$0 = this;
                $continuation.L$1 = progressReporter;
                $continuation.L$2 = managedFiles;
                $continuation.L$3 = projectReader;
                $continuation.L$4 = $this$useWithoutActiveScope$iv$iv;
                $continuation.label = 1;
                v3 = BuildersKt.withContext((CoroutineContext)context$iv /* !! */ .plus(ContextExtensionsKt.asContextElement((Context)v2)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super MavenProjectsTreeUpdateResult>, Object>(span$iv, null, this, managedFiles, force != false, projectReader, progressReporter){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ Span $span;
                    final /* synthetic */ MavenProjectsTree this$0;
                    final /* synthetic */ List $managedFiles$inlined;
                    final /* synthetic */ boolean $force$inlined;
                    final /* synthetic */ MavenProjectReader $projectReader$inlined;
                    final /* synthetic */ RawProgressReporter $progressReporter$inlined;
                    {
                        this.$span = $span;
                        this.this$0 = mavenProjectsTree;
                        this.$managedFiles$inlined = list;
                        this.$force$inlined = bl;
                        this.$projectReader$inlined = mavenProjectReader;
                        this.$progressReporter$inlined = rawProgressReporter;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $completion) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$completion);
                                CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                Continuation cfr_ignored_0 = (Continuation)this;
                                boolean bl = false;
                                this.label = 1;
                                Object object2 = MavenProjectsTree.access$update(this.this$0, this.$managedFiles$inlined, true, this.$force$inlined, this.$projectReader$inlined, this.$progressReporter$inlined, (Continuation)this);
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                void $result;
                                boolean bl = false;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super MavenProjectsTreeUpdateResult> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v3 != var23_8) goto lbl38
lbl37:
                // 1 sources

                return var23_8;
lbl38:
                // 1 sources

                ** GOTO lbl53
            }
            case 1: {
                $i$f$useWithScope = false;
                $i$f$useWithoutActiveScope = false;
                $i$a$-useWithoutActiveScope-TraceKt$useWithScope$2$iv = false;
                $this$useWithoutActiveScope$iv$iv = (Span)$continuation.L$4;
                projectReader = (MavenProjectReader)$continuation.L$3;
                managedFiles = (List)$continuation.L$2;
                progressReporter = (RawProgressReporter)$continuation.L$1;
                this = (MavenProjectsTree)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl53:
                    // 2 sources

                    var17_21 = v3;
                    ** GOTO lbl66
                }
                catch (CancellationException e$iv$iv) {
                    throw e$iv$iv;
                }
                catch (Throwable e$iv$iv) {
                    $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
                    throw e$iv$iv;
                }
            }
            catch (Throwable var18_26) {
                throw var18_26;
            }
            {
                finally {
                    $this$useWithoutActiveScope$iv$iv.end();
                }
lbl66:
                // 1 sources

                updated = (MavenProjectsTreeUpdateResult)var17_21;
                context$iv /* !! */  = ContainerUtil.subtract((Collection)this.getRootProjectsFiles(), (Collection)managedFiles);
                Intrinsics.checkNotNullExpressionValue((Object)context$iv /* !! */ , (String)"subtract(...)");
                obsoleteFiles /* !! */  = context$iv /* !! */ ;
                v4 = TelemetryKt.getTracer().spanBuilder("cleanupProjectTree");
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"spanBuilder(...)");
                $this$useWithScope_u24default$iv = v4;
                context$iv = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
                $i$f$useWithScope = false;
                v5 = $this$useWithScope_u24default$iv.startSpan();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"startSpan(...)");
                $this$useWithoutActiveScope$iv$iv = v5;
                $i$f$useWithoutActiveScope = false;
                span$iv = $this$useWithoutActiveScope$iv$iv;
                $i$a$-useWithoutActiveScope-TraceKt$useWithScope$2$iv = false;
                v6 = Context.current().with((ImplicitContextKeyed)span$iv);
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"with(...)");
                $continuation.L$0 = updated;
                $continuation.L$1 = $this$useWithoutActiveScope$iv$iv;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.label = 2;
                v7 = BuildersKt.withContext((CoroutineContext)context$iv.plus(ContextExtensionsKt.asContextElement((Context)v6)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super MavenProjectsTreeUpdateResult>, Object>(span$iv, null, this, projectReader, (Collection)obsoleteFiles /* !! */ , progressReporter){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ Span $span;
                    final /* synthetic */ MavenProjectsTree this$0;
                    final /* synthetic */ MavenProjectReader $projectReader$inlined;
                    final /* synthetic */ Collection $obsoleteFiles$inlined;
                    final /* synthetic */ RawProgressReporter $progressReporter$inlined;
                    {
                        this.$span = $span;
                        this.this$0 = mavenProjectsTree;
                        this.$projectReader$inlined = mavenProjectReader;
                        this.$obsoleteFiles$inlined = collection;
                        this.$progressReporter$inlined = rawProgressReporter;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $completion) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$completion);
                                CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                Continuation cfr_ignored_0 = (Continuation)this;
                                boolean bl = false;
                                this.label = 1;
                                Object object2 = MavenProjectsTree.access$delete(this.this$0, this.$projectReader$inlined, this.$obsoleteFiles$inlined, this.$progressReporter$inlined, (Continuation)this);
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                void $result;
                                boolean bl = false;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super MavenProjectsTreeUpdateResult> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v7 != var23_8) goto lbl94
lbl93:
                // 1 sources

                return var23_8;
lbl94:
                // 1 sources

                ** GOTO lbl106
            }
            case 2: {
                $i$f$useWithScope = false;
                $i$f$useWithoutActiveScope = false;
                $i$a$-useWithoutActiveScope-TraceKt$useWithScope$2$iv = false;
                $this$useWithoutActiveScope$iv$iv = (Span)$continuation.L$1;
                updated = (MavenProjectsTreeUpdateResult)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v7 = $result;
lbl106:
                    // 2 sources

                    var19_29 = v7;
                    ** GOTO lbl119
                }
                catch (CancellationException e$iv$iv) {
                    throw e$iv$iv;
                }
                catch (Throwable e$iv$iv) {
                    $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
                    throw e$iv$iv;
                }
            }
            catch (Throwable var20_32) {
                throw var20_32;
            }
            {
                finally {
                    $this$useWithoutActiveScope$iv$iv.end();
                }
lbl119:
                // 1 sources

                deleted = (MavenProjectsTreeUpdateResult)var19_29;
                updateResult = updated.plus(deleted);
                MavenLog.LOG.debug("Maven tree update result: updated " + updateResult.getUpdated() + ", deleted " + updateResult.getDeleted());
                return updateResult;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @ApiStatus.Internal
    @Nullable
    public final Object update(@NotNull Collection<? extends VirtualFile> files2, boolean force, @NotNull MavenGeneralSettings generalSettings, @NotNull MavenEmbedderWrappers mavenEmbedderWrappers, @NotNull RawProgressReporter progressReporter2, @NotNull Continuation<? super MavenProjectsTreeUpdateResult> $completion) {
        MavenProjectReader projectReader = new MavenProjectReader(this.project, mavenEmbedderWrappers, generalSettings, this.getExplicitProfiles(), this.projectLocator);
        return this.update(files2, false, force, projectReader, progressReporter2, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final Object update(Collection<? extends VirtualFile> var1_1, boolean var2_2, boolean var3_3, MavenProjectReader var4_4, RawProgressReporter var5_5, Continuation<? super MavenProjectsTreeUpdateResult> $completion) {
        if (!($completion instanceof update.2)) ** GOTO lbl-1000
        var28_7 = $completion;
        if ((var28_7.label & -2147483648) != 0) {
            var28_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ MavenProjectsTree this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MavenProjectsTree.access$update(this.this$0, null, false, false, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var29_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                updateContext = new MavenProjectsTreeUpdateContext(this);
                updater = new MavenProjectsTreeUpdater(this, updateContext, (MavenProjectReader)projectReader, (RawProgressReporter)progressReporter, updateModules != false);
                filesToAddModules = new HashSet<VirtualFile>();
                var10_13 = files.iterator();
lbl16:
                // 3 sources

                while (var10_13.hasNext()) {
                    file = (VirtualFile)var10_13.next();
                    if (this.findProject(file) == null) {
                        filesToAddModules.add(file);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)TelemetryKt.getTracer().spanBuilder("updateProjectFile"), (String)"spanBuilder(...)");
                    context$iv = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
                    $i$f$useWithScope = false;
                    Intrinsics.checkNotNullExpressionValue((Object)$this$useWithScope_u24default$iv.startSpan(), (String)"startSpan(...)");
                    $i$f$useWithoutActiveScope = false;
                    span$iv = $this$useWithoutActiveScope$iv$iv;
                    $i$a$-useWithoutActiveScope-TraceKt$useWithScope$2$iv = false;
                    v0 = Context.current().with((ImplicitContextKeyed)span$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"with(...)");
                    $continuation.L$0 = this;
                    $continuation.L$1 = updateContext;
                    $continuation.L$2 = updater;
                    $continuation.L$3 = filesToAddModules;
                    $continuation.L$4 = var10_13;
                    $continuation.L$5 = $this$useWithoutActiveScope$iv$iv;
                    $continuation.Z$0 = forceRead;
                    $continuation.label = 1;
                    v1 = BuildersKt.withContext((CoroutineContext)context$iv.plus(ContextExtensionsKt.asContextElement((Context)v0)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(span$iv, null, updater, file, forceRead != false){
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ Span $span;
                        final /* synthetic */ MavenProjectsTreeUpdater $updater$inlined;
                        final /* synthetic */ VirtualFile $file$inlined;
                        final /* synthetic */ boolean $forceRead$inlined;
                        {
                            this.$span = $span;
                            this.$updater$inlined = mavenProjectsTreeUpdater;
                            this.$file$inlined = virtualFile;
                            this.$forceRead$inlined = bl;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $completion) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$completion);
                                    CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                    Continuation cfr_ignored_0 = (Continuation)this;
                                    boolean bl = false;
                                    this.label = 1;
                                    Object object2 = this.$updater$inlined.updateProjects(CollectionsKt.listOf((Object)new MavenProjectsTreeUpdater.UpdateSpec(this.$file$inlined, this.$forceRead$inlined)), (Continuation<? super Unit>)this);
                                    if (object2 != object) return Unit.INSTANCE;
                                    return object;
                                }
                                case 1: {
                                    void $result;
                                    boolean bl = false;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    ** if (v1 != var29_9) goto lbl43
lbl42:
                    // 1 sources

                    return var29_9;
lbl43:
                    // 1 sources

                    ** GOTO lbl61
                }
                break;
            }
            case 1: {
                $i$f$useWithScope = false;
                $i$f$useWithoutActiveScope = false;
                $i$a$-useWithoutActiveScope-TraceKt$useWithScope$2$iv = false;
                forceRead = $continuation.Z$0;
                $this$useWithoutActiveScope$iv$iv = (Span)$continuation.L$5;
                var10_13 = (Iterator<E>)$continuation.L$4;
                filesToAddModules = (HashSet<VirtualFile>)$continuation.L$3;
                updater = (MavenProjectsTreeUpdater)$continuation.L$2;
                updateContext = (MavenProjectsTreeUpdateContext)$continuation.L$1;
                this = (MavenProjectsTree)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl61:
                    // 2 sources

                    var20_33 = v1;
                    ** GOTO lbl16
                }
                catch (CancellationException e$iv$iv) {
                    throw e$iv$iv;
                }
                catch (Throwable e$iv$iv) {
                    $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
                    throw e$iv$iv;
                }
            }
            catch (Throwable e$iv$iv) {
                throw e$iv$iv;
            }
            {
                finally {
                    $this$useWithoutActiveScope$iv$iv.end();
                    ** GOTO lbl16
                }
            }
        }
        for (Object aggregator : this.getProjects()) {
            for (VirtualFile moduleFile : aggregator.getExistingModuleFiles()) {
                if (!filesToAddModules.contains(moduleFile)) continue;
                filesToAddModules.remove(moduleFile);
                mavenProject = this.findProject(moduleFile);
                if (mavenProject == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)TelemetryKt.getTracer().spanBuilder("reconnect"), (String)"spanBuilder(...)");
                $i$f$use = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$use$iv.startSpan(), (String)"startSpan(...)");
                $i$f$useWithoutActiveScope = false;
                try {
                    span$iv = $this$useWithoutActiveScope$iv$iv;
                    $i$a$-useWithoutActiveScope-TraceKt$use$1$iv = false;
                    e$iv$iv = (AutoCloseable)span$iv.makeCurrent();
                    var22_47 /* !! */  = null;
                    try {
                        (Scope)e$iv$iv;
                        $i$a$-use-TraceKt$use$1$1$iv = false;
                        $i$a$-use-MavenProjectsTree$update$4 = false;
                        if (this.reconnect((MavenProject)aggregator, mavenProject)) {
                            updateContext.updated(mavenProject, MavenProjectChanges.NONE);
                        }
                        var23_48 = Unit.INSTANCE;
                    }
                    catch (Throwable var24_50) {
                        var22_47 /* !! */  = var24_50;
                        throw var24_50;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)e$iv$iv, (Throwable)var22_47 /* !! */ );
                    }
                    var26_53 = var23_48;
                }
                catch (CancellationException e$iv$iv) {
                    throw e$iv$iv;
                }
                catch (Throwable e$iv$iv) {
                    $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
                    throw e$iv$iv;
                }
                finally {
                    $this$useWithoutActiveScope$iv$iv.end();
                }
            }
        }
        aggregator = filesToAddModules.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)aggregator, (String)"iterator(...)");
        var10_13 = aggregator;
        while (var10_13.hasNext()) {
            v2 = var10_13.next();
            Intrinsics.checkNotNullExpressionValue(v2, (String)"next(...)");
            file = (VirtualFile)v2;
            mavenProject = this.findProject(file);
            if (mavenProject == null) continue;
            this.addRootModule(mavenProject);
        }
        v3 = TelemetryKt.getTracer().spanBuilder("updateProfiles");
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"spanBuilder(...)");
        $this$use$iv = v3;
        $i$f$use = false;
        v4 = $this$use$iv.startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"startSpan(...)");
        $this$useWithoutActiveScope$iv$iv = v4;
        $i$f$useWithoutActiveScope = false;
        try {
            span$iv = $this$useWithoutActiveScope$iv$iv;
            $i$a$-useWithoutActiveScope-TraceKt$use$1$iv = false;
            var16_29 = (AutoCloseable)span$iv.makeCurrent();
            var17_30 = null;
            try {
                (Scope)var16_29;
                $i$a$-use-TraceKt$use$1$1$iv = false;
                $i$a$-use-MavenProjectsTree$update$5 = false;
                this.updateExplicitProfiles();
                var18_32 = Unit.INSTANCE;
            }
            catch (Throwable var19_45) {
                var17_30 = var19_45;
                throw var19_45;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)var16_29, (Throwable)var17_30);
            }
            var22_47 /* !! */  = var18_32;
        }
        catch (CancellationException e$iv$iv) {
            throw e$iv$iv;
        }
        catch (Throwable e$iv$iv) {
            $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
            throw e$iv$iv;
        }
        finally {
            $this$useWithoutActiveScope$iv$iv.end();
        }
        updateContext.fireUpdatedIfNecessary();
        v5 = updateContext.toUpdateResult();
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"toUpdateResult(...)");
        return v5;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final RawProgressReporter toRawProgressReporter(ProgressIndicator progressIndicator) {
        return new RawProgressReporter(progressIndicator){
            final /* synthetic */ ProgressIndicator $progressIndicator;
            {
                this.$progressIndicator = $progressIndicator;
            }

            public void text(String text) {
                this.$progressIndicator.setText(text);
            }
        };
    }

    @NotNull
    public String toString() {
        return "MavenProjectsTree{myRootProjects=" + this.myRootProjects + ", myProject=" + this.project + "}";
    }

    public final boolean isManagedFile(@NotNull VirtualFile moduleFile) {
        Intrinsics.checkNotNullParameter((Object)moduleFile, (String)"moduleFile");
        String string = moduleFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return this.isManagedFile(string);
    }

    private final boolean isManagedFile(String path) {
        return (Boolean)this.withReadLock(() -> MavenProjectsTree.isManagedFile$lambda$28(this, path));
    }

    @ApiStatus.Internal
    @Nullable
    public final Object delete(@NotNull List<? extends VirtualFile> files2, @NotNull MavenGeneralSettings generalSettings, @NotNull MavenEmbedderWrappers mavenEmbedderWrappers, @NotNull RawProgressReporter progressReporter2, @NotNull Continuation<? super MavenProjectsTreeUpdateResult> $completion) {
        MavenProjectReader projectReader = new MavenProjectReader(this.project, mavenEmbedderWrappers, generalSettings, this.getExplicitProfiles(), this.projectLocator);
        return this.delete(projectReader, (Collection<? extends VirtualFile>)files2, progressReporter2, $completion);
    }

    /*
     * Unable to fully structure code
     */
    private final Object delete(MavenProjectReader var1_1, Collection<? extends VirtualFile> var2_2, RawProgressReporter var3_3, Continuation<? super MavenProjectsTreeUpdateResult> $completion) {
        if (!($completion instanceof delete.2)) ** GOTO lbl-1000
        var12_5 = $completion;
        if ((var12_5.label & -2147483648) != 0) {
            var12_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ MavenProjectsTree this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MavenProjectsTree.access$delete(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                updateContext = new MavenProjectsTreeUpdateContext(this);
                inheritorsToUpdate = new HashSet<E>();
                for (VirtualFile each : files) {
                    mavenProject = this.findProject(each);
                    if (mavenProject == null) continue;
                    inheritorsToUpdate.addAll(this.findInheritors(mavenProject));
                    this.doDelete$intellij_maven(this.findAggregator(mavenProject), mavenProject, updateContext);
                }
                v0 = updateContext.getDeletedProjects();
                Intrinsics.checkNotNullExpressionValue(v0, (String)"getDeletedProjects(...)");
                inheritorsToUpdate.removeAll(CollectionsKt.toSet((Iterable)v0));
                updater = new MavenProjectsTreeUpdater(this, updateContext, var1_1, var3_3, false);
                updateSpecs = new ArrayList<MavenProjectsTreeUpdater.UpdateSpec>();
                for (MavenProject mavenProject : inheritorsToUpdate) {
                    updateSpecs.add(new MavenProjectsTreeUpdater.UpdateSpec(mavenProject.getFile(), false));
                }
                $continuation.L$0 = this;
                $continuation.L$1 = updateContext;
                $continuation.L$2 = inheritorsToUpdate;
                $continuation.label = 1;
                v1 = updater.updateProjects((List<MavenProjectsTreeUpdater.UpdateSpec>)updateSpecs, (Continuation<? super Unit>)$continuation);
                if (v1 == var13_7) {
                    return var13_7;
                }
                ** GOTO lbl45
            }
            case 1: {
                inheritorsToUpdate = (Set)$continuation.L$2;
                updateContext = (MavenProjectsTreeUpdateContext)$continuation.L$1;
                this = (MavenProjectsTree)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl45:
                // 4 sources

                for (MavenProject mavenProject : inheritorsToUpdate) {
                    if (!this.reconnectRoot(mavenProject)) continue;
                    updateContext.updated(mavenProject, MavenProjectChanges.NONE);
                }
                this.updateExplicitProfiles();
                updateContext.fireUpdatedIfNecessary();
                v2 = updateContext.toUpdateResult();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toUpdateResult(...)");
                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @ApiStatus.Internal
    public final void doDelete$intellij_maven(@Nullable MavenProject aggregator, @NotNull MavenProject project, @NotNull MavenProjectsTreeUpdateContext updateContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)updateContext, (String)"updateContext");
        for (MavenProject each : this.getModules(project)) {
            if (this.isManagedFile(each.getPath())) {
                if (!this.reconnectRoot(each)) continue;
                updateContext.updated(each, MavenProjectChanges.NONE);
                continue;
            }
            this.doDelete$intellij_maven(project, each, updateContext);
        }
        this.withWriteLock(() -> MavenProjectsTree.doDelete$lambda$29(aggregator, this, project));
        updateContext.deleted(project);
    }

    private final void fillIDMaps(MavenProject mavenProject) {
        MavenId id = mavenProject.getMavenId();
        this.myWorkspaceMap.register(id, new File(mavenProject.getFile().getPath()));
        this.myMavenIdToProjectMapping.put(id, mavenProject);
    }

    private final void clearIDMaps(MavenId mavenId) {
        if (mavenId == null) {
            return;
        }
        this.myWorkspaceMap.unregister(mavenId);
        this.myMavenIdToProjectMapping.remove(mavenId);
    }

    private final void addRootModule(MavenProject project) {
        this.withWriteLock(() -> MavenProjectsTree.addRootModule$lambda$32(this, project));
    }

    @ApiStatus.Internal
    public final boolean reconnect(@NotNull MavenProject newAggregator, @NotNull MavenProject project) {
        Intrinsics.checkNotNullParameter((Object)newAggregator, (String)"newAggregator");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        MavenProject prevAggregator = this.findAggregator(project);
        if (prevAggregator == newAggregator) {
            return false;
        }
        this.withWriteLock(() -> MavenProjectsTree.reconnect$lambda$33(prevAggregator, this, project, newAggregator));
        return true;
    }

    @ApiStatus.Internal
    public final boolean reconnectRoot(@NotNull MavenProject project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        MavenProject prevAggregator = this.findAggregator(project);
        if (prevAggregator == null) {
            return false;
        }
        this.withWriteLock(() -> MavenProjectsTree.reconnectRoot$lambda$34(this, prevAggregator, project));
        return true;
    }

    public final void recalculateMavenIdToProjectMap$intellij_maven() {
        this.withWriteLock(() -> MavenProjectsTree.recalculateMavenIdToProjectMap$lambda$37(this));
    }

    public final boolean hasProjects() {
        return (Boolean)this.withReadLock(() -> MavenProjectsTree.hasProjects$lambda$38(this));
    }

    @NotNull
    public final List<MavenProject> getRootProjects() {
        return (List)this.withReadLock(() -> MavenProjectsTree._get_rootProjects_$lambda$39(this));
    }

    public final int getFilterConfigCrc(@NotNull ProjectFileIndex fileIndex) {
        Intrinsics.checkNotNullParameter((Object)fileIndex, (String)"fileIndex");
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return ((Number)this.withReadLock(() -> MavenProjectsTree.getFilterConfigCrc$lambda$40(this, fileIndex))).intValue();
    }

    @NotNull
    public final List<VirtualFile> getRootProjectsFiles() {
        return MavenUtil.collectFiles((Collection<MavenProject>)this.getRootProjects());
    }

    @NotNull
    public final List<MavenProject> getProjects() {
        return (List)this.withReadLock(() -> MavenProjectsTree._get_projects_$lambda$41(this));
    }

    @NotNull
    public final List<MavenProject> getNonIgnoredProjects() {
        return (List)this.withReadLock(() -> MavenProjectsTree._get_nonIgnoredProjects_$lambda$42(this));
    }

    @NotNull
    public final List<VirtualFile> getProjectsFiles() {
        return (List)this.withReadLock(() -> MavenProjectsTree._get_projectsFiles_$lambda$43(this));
    }

    @Nullable
    public final MavenProject findProject(@NotNull VirtualFile f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        return (MavenProject)this.withReadLock(() -> MavenProjectsTree.findProject$lambda$44(this, f));
    }

    @Nullable
    public final MavenProject findProject(@Nullable MavenId id) {
        return (MavenProject)this.withReadLock(() -> MavenProjectsTree.findProject$lambda$45(this, id));
    }

    @Nullable
    public final MavenProject findProject(@NotNull MavenArtifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        return this.findProject(artifact.getMavenId());
    }

    @Nullable
    public final MavenProject findSingleProjectInReactor(@NotNull MavenId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return (MavenProject)this.withReadLock(() -> MavenProjectsTree.findSingleProjectInReactor$lambda$47(this, id));
    }

    @NotNull
    public final MavenWorkspaceMap getWorkspaceMap() {
        Object t = this.withReadLock(() -> MavenProjectsTree._get_workspaceMap_$lambda$48(this));
        Intrinsics.checkNotNullExpressionValue(t, (String)"withReadLock(...)");
        return (MavenWorkspaceMap)t;
    }

    @Nullable
    public final MavenProject findAggregator(@NotNull MavenProject project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (MavenProject)this.withReadLock(() -> MavenProjectsTree.findAggregator$lambda$49(this, project));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<MavenProject> collectAggregators(@NotNull Collection<MavenProject> mavenProjects) {
        void $this$filterTo$iv$iv;
        Object aggregator;
        Intrinsics.checkNotNullParameter(mavenProjects, (String)"mavenProjects");
        HashSet<MavenProject> mavenProjectsToSkip = new HashSet<MavenProject>();
        block0: for (MavenProject mavenProject : mavenProjects) {
            aggregator = null;
            aggregator = mavenProject;
            do {
                MavenProject mavenProject2;
                Object object = aggregator;
                Intrinsics.checkNotNull((Object)object);
                MavenProject it = mavenProject2 = this.findAggregator((MavenProject)object);
                boolean bl = false;
                aggregator = it;
                if (mavenProject2 == null) continue block0;
            } while (!CollectionsKt.contains((Iterable)mavenProjects, (Object)aggregator));
            mavenProjectsToSkip.add(mavenProject);
        }
        Iterable $this$filter$iv = mavenProjects;
        boolean $i$f$filter = false;
        aggregator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MavenProject it = (MavenProject)element$iv$iv;
            boolean bl = false;
            if (!(!mavenProjectsToSkip.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final MavenProject findRootProject(@NotNull MavenProject project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (MavenProject)this.withReadLock(() -> MavenProjectsTree.findRootProject$lambda$52(this, project));
    }

    private final MavenProject doFindRootProject(MavenProject project) {
        MavenProject rootProject = project;
        MavenProject aggregator;
        while ((aggregator = this.myModuleToAggregatorMapping.get(rootProject)) != null) {
            rootProject = aggregator;
        }
        return rootProject;
    }

    @NotNull
    public final List<MavenProject> getModules(@NotNull MavenProject aggregator) {
        Intrinsics.checkNotNullParameter((Object)aggregator, (String)"aggregator");
        return (List)this.withReadLock(() -> MavenProjectsTree.getModules$lambda$53(this, aggregator));
    }

    private final void addModule(MavenProject aggregator, MavenProject module) {
        this.withWriteLock(() -> MavenProjectsTree.addModule$lambda$54(this, aggregator, module));
    }

    @ApiStatus.Internal
    public final void removeModule(@NotNull MavenProject aggregator, @NotNull MavenProject module) {
        Intrinsics.checkNotNullParameter((Object)aggregator, (String)"aggregator");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.withWriteLock(() -> MavenProjectsTree.removeModule$lambda$55(this, aggregator, module));
    }

    @ApiStatus.Internal
    @Nullable
    public final MavenProject findParent(@NotNull MavenProject project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.findProject(project.getParentId());
    }

    @NotNull
    public final Collection<MavenProject> findInheritors(@NotNull MavenProject project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (project.isNew()) {
            return CollectionsKt.emptyList();
        }
        return (Collection)this.withReadLock(() -> MavenProjectsTree.findInheritors$lambda$56(project, this));
    }

    @NotNull
    public final List<MavenProject> getDependentProjects(@NotNull Collection<MavenProject> projects) {
        Intrinsics.checkNotNullParameter(projects, (String)"projects");
        return (List)this.withReadLock(() -> MavenProjectsTree.getDependentProjects$lambda$57(projects, this));
    }

    public final void addListener(@NotNull Listener l, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        if (!this.myListeners.contains((Object)l)) {
            Disposable disposable2 = this.myListeners.add((Object)l, disposable);
            Intrinsics.checkNotNull((Object)disposable2);
        } else {
            MavenLog.LOG.warn("Trying to add the same listener twice");
        }
    }

    private final void fireProfilesChanged() {
        Iterator iterator = this.myListeners.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Listener each = (Listener)iterator2.next();
            each.profilesChanged();
        }
    }

    private final void fireProjectsIgnoredStateChanged(List<MavenProject> ignored, List<MavenProject> unignored, boolean fromImport) {
        Iterator iterator = this.myListeners.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Listener each = (Listener)iterator2.next();
            each.projectsIgnoredStateChanged(ignored, unignored, fromImport);
        }
    }

    @ApiStatus.Internal
    public final void fireProjectsUpdated(@NotNull List<? extends Pair<MavenProject, MavenProjectChanges>> updated, @NotNull List<MavenProject> deleted) {
        Intrinsics.checkNotNullParameter(updated, (String)"updated");
        Intrinsics.checkNotNullParameter(deleted, (String)"deleted");
        Iterator iterator = this.myListeners.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Listener each = (Listener)iterator2.next();
            each.projectsUpdated(updated, deleted);
        }
    }

    public final void fireProjectResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
        Intrinsics.checkNotNullParameter(projectWithChanges, (String)"projectWithChanges");
        Iterator iterator = this.myListeners.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Listener each = (Listener)iterator2.next();
            each.projectResolved(projectWithChanges);
        }
    }

    public final void firePluginsResolved(@NotNull MavenProject project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterator iterator = this.myListeners.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Listener each = (Listener)iterator2.next();
            each.pluginsResolved(project);
        }
    }

    public final void fireFoldersResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
        Intrinsics.checkNotNullParameter(projectWithChanges, (String)"projectWithChanges");
        Iterator iterator = this.myListeners.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Listener each = (Listener)iterator2.next();
            each.foldersResolved(projectWithChanges);
        }
    }

    public final void fireArtifactsDownloaded(@NotNull MavenProject project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterator iterator = this.myListeners.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Listener each = (Listener)iterator2.next();
            each.artifactsDownloaded(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withReadLock(Function0<? extends T> action) {
        this.myStructureReadLock.lock();
        try {
            Object object = action.invoke();
            return (T)object;
        }
        finally {
            this.myStructureReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withWriteLock(Function0<? extends T> action) {
        this.myStructureWriteLock.lock();
        try {
            Object object = action.invoke();
            return (T)object;
        }
        finally {
            this.myStructureWriteLock.unlock();
        }
    }

    @NotNull
    public final Updater updater() {
        return new Updater();
    }

    private static final VirtualFile projectLocator$lambda$0(MavenProjectsTree this$0, MavenId coordinates) {
        MavenProject project;
        MavenProject mavenProject = project = this$0.findProject(coordinates);
        return mavenProject != null ? mavenProject.getFile() : null;
    }

    private static final Unit putVirtualFileToProjectMapping$lambda$1(MavenProjectsTree this$0, MavenId $oldProjectId, MavenProject $mavenProject) {
        this$0.clearIDMaps($oldProjectId);
        this$0.myVirtualFileToProjectMapping.put($mavenProject.getFile(), $mavenProject);
        this$0.fillIDMaps($mavenProject);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit save$lambda$3(Path $file, MavenProjectsTree this$0) {
        Closeable closeable = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(NioFiles.createParentDirectories((Path)$file), new OpenOption[0])));
        Throwable throwable = null;
        try {
            DataOutputStream out = (DataOutputStream)closeable;
            boolean bl = false;
            out.writeUTF(STORAGE_VERSION);
            MavenProjectsTree.Companion.writeCollection(out, this$0.myManagedFilesPaths);
            MavenProjectsTree.Companion.writeCollection(out, this$0.myIgnoredFilesPaths);
            MavenProjectsTree.Companion.writeCollection(out, this$0.myIgnoredFilesPatterns);
            Collection collection = this$0.myExplicitProfiles.getEnabledProfiles();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getEnabledProfiles(...)");
            MavenProjectsTree.Companion.writeCollection(out, collection);
            Collection collection2 = this$0.myExplicitProfiles.getDisabledProfiles();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getDisabledProfiles(...)");
            MavenProjectsTree.Companion.writeCollection(out, collection2);
            this$0.writeProjectsRecursively(out, this$0.myRootProjects);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }

    private static final ArrayList _get_managedFilesPaths_$lambda$4(MavenProjectsTree this$0) {
        return new ArrayList(this$0.myManagedFilesPaths);
    }

    private static final Unit resetManagedFilesPathsAndProfiles$lambda$5(MavenProjectsTree this$0, List $paths, MavenExplicitProfiles $profiles) {
        this$0.myManagedFilesPaths = new LinkedHashSet($paths);
        this$0.setExplicitProfiles($profiles);
        return Unit.INSTANCE;
    }

    private static final kotlin.Pair addManagedFilesWithProfiles$lambda$6(MavenProjectsTree this$0, List $files, MavenExplicitProfiles $profiles) {
        ArrayList newFiles = new ArrayList(this$0.myManagedFilesPaths);
        newFiles.addAll(MavenUtil.collectPaths($files));
        MavenExplicitProfiles newProfiles = this$0.myExplicitProfiles.clone();
        Collection collection = newProfiles.getEnabledProfiles();
        Collection collection2 = $profiles.getEnabledProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getEnabledProfiles(...)");
        collection.addAll(collection2);
        Collection collection3 = newProfiles.getDisabledProfiles();
        Collection collection4 = $profiles.getDisabledProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)collection4, (String)"getDisabledProfiles(...)");
        collection3.addAll(collection4);
        return TuplesKt.to(newFiles, (Object)newProfiles);
    }

    private static final boolean removeManagedFiles$lambda$8(MavenProjectsTree this$0, Set $filePaths) {
        return this$0.myManagedFilesPaths.removeAll($filePaths);
    }

    private static final ArrayList _get_ignoredFilesPaths_$lambda$9(MavenProjectsTree this$0) {
        return new ArrayList(this$0.myIgnoredFilesPaths);
    }

    private static final void _set_ignoredFilesPaths_$lambda$10(MavenProjectsTree this$0, List $paths) {
        this$0.myIgnoredFilesPaths = new ArrayList($paths);
    }

    private static final void removeIgnoredFilesPaths$lambda$11(MavenProjectsTree this$0, Collection $paths) {
        List<String> list = this$0.myIgnoredFilesPaths;
        Collection collection = $paths;
        Intrinsics.checkNotNull((Object)collection);
        list.removeAll(collection);
    }

    private static final boolean getIgnoredState$lambda$12(MavenProjectsTree this$0, MavenProject $project) {
        return this$0.myIgnoredFilesPaths.contains($project.getPath());
    }

    private static final void doSetIgnoredState$lambda$14(boolean $ignored, MavenProjectsTree this$0, List $pomPaths) {
        boolean bl = $ignored ? this$0.myIgnoredFilesPaths.addAll($pomPaths) : this$0.myIgnoredFilesPaths.removeAll($pomPaths);
    }

    private static final ArrayList _get_ignoredFilesPatterns_$lambda$15(MavenProjectsTree this$0) {
        return new ArrayList(this$0.myIgnoredFilesPatterns);
    }

    private static final void _set_ignoredFilesPatterns_$lambda$16(MavenProjectsTree this$0, List $patterns) {
        this$0.myIgnoredFilesPatternsCache = null;
        this$0.myIgnoredFilesPatterns = new ArrayList($patterns);
    }

    private static final kotlin.Pair doChangeIgnoreStatus$lambda$17(MavenProjectsTree this$0, Runnable $runnable) {
        List<MavenProject> before = this$0.getIgnoredProjects();
        $runnable.run();
        List<MavenProject> after = this$0.getIgnoredProjects();
        return TuplesKt.to(before, after);
    }

    private static final boolean isIgnored$lambda$18(MavenProjectsTree this$0, String $projectPath) {
        return this$0.myIgnoredFilesPaths.contains($projectPath) || this$0.matchesIgnoredFilesPatterns($projectPath);
    }

    private static final boolean matchesIgnoredFilesPatterns$lambda$19(MavenProjectsTree this$0, String $path) {
        if (this$0.myIgnoredFilesPatternsCache == null) {
            this$0.myIgnoredFilesPatternsCache = Pattern.compile(Strings.translateMasks((Collection<String>)this$0.myIgnoredFilesPatterns));
        }
        Pattern pattern = this$0.myIgnoredFilesPatternsCache;
        Intrinsics.checkNotNull((Object)pattern);
        return pattern.matcher($path).matches();
    }

    private static final MavenExplicitProfiles _get_explicitProfiles_$lambda$20(MavenProjectsTree this$0) {
        return this$0.myExplicitProfiles.clone();
    }

    private static final Unit _set_explicitProfiles_$lambda$21(MavenProjectsTree this$0, MavenExplicitProfiles $explicitProfiles) {
        this$0.myExplicitProfiles = $explicitProfiles.clone();
        return Unit.INSTANCE;
    }

    private static final Unit updateExplicitProfiles$lambda$22(MavenProjectsTree this$0, Set $available) {
        Collection collection = this$0.myExplicitProfiles.getEnabledProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getEnabledProfiles(...)");
        Collection collection2 = this$0.myTemporarilyRemovedExplicitProfiles.getEnabledProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getEnabledProfiles(...)");
        MavenProjectsTree.Companion.updateExplicitProfiles(collection, collection2, $available);
        Collection collection3 = this$0.myExplicitProfiles.getDisabledProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"getDisabledProfiles(...)");
        Collection collection4 = this$0.myTemporarilyRemovedExplicitProfiles.getDisabledProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)collection4, (String)"getDisabledProfiles(...)");
        MavenProjectsTree.Companion.updateExplicitProfiles(collection3, collection4, $available);
        return Unit.INSTANCE;
    }

    private static final boolean isManagedFile$lambda$28(MavenProjectsTree this$0, String $path) {
        Iterator<String> iterator = this$0.myManagedFilesPaths.iterator();
        while (iterator.hasNext()) {
            String each;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            if (!FileUtil.pathsEqual((String)each, (String)$path)) continue;
            return true;
        }
        return false;
    }

    private static final MavenProject doDelete$lambda$29(MavenProject $aggregator, MavenProjectsTree this$0, MavenProject $project) {
        if ($aggregator != null) {
            this$0.removeModule($aggregator, $project);
        } else {
            this$0.myRootProjects.remove($project);
        }
        this$0.myTimestamps.remove($project.getFile());
        this$0.myVirtualFileToProjectMapping.remove($project.getFile());
        this$0.clearIDMaps($project.getMavenId());
        this$0.myAggregatorToModuleMapping.remove($project);
        return this$0.myModuleToAggregatorMapping.remove($project);
    }

    private static final Path addRootModule$lambda$32$lambda$30(MavenProject mavenProject) {
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        return MavenProjectsTree.Companion.mavenProjectToNioPath(mavenProject);
    }

    private static final Path addRootModule$lambda$32$lambda$31(Function1 $tmp0, Object p0) {
        return (Path)$tmp0.invoke(p0);
    }

    private static final Unit addRootModule$lambda$32(MavenProjectsTree this$0, MavenProject $project) {
        this$0.myRootProjects.add($project);
        List<MavenProject> list = this$0.myRootProjects;
        Comparator<Object> comparator = Comparator.comparing(arg_0 -> MavenProjectsTree.addRootModule$lambda$32$lambda$31(MavenProjectsTree::addRootModule$lambda$32$lambda$30, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
        CollectionsKt.sortWith(list, comparator);
        return Unit.INSTANCE;
    }

    private static final Unit reconnect$lambda$33(MavenProject $prevAggregator, MavenProjectsTree this$0, MavenProject $project, MavenProject $newAggregator) {
        if ($prevAggregator != null) {
            this$0.removeModule($prevAggregator, $project);
        } else {
            this$0.myRootProjects.remove($project);
        }
        this$0.addModule($newAggregator, $project);
        return Unit.INSTANCE;
    }

    private static final Unit reconnectRoot$lambda$34(MavenProjectsTree this$0, MavenProject $prevAggregator, MavenProject $project) {
        this$0.removeModule($prevAggregator, $project);
        this$0.addRootModule($project);
        return Unit.INSTANCE;
    }

    private static final Unit recalculateMavenIdToProjectMap$lambda$37(MavenProjectsTree this$0) {
        Object it;
        this$0.myMavenIdToProjectMapping.clear();
        Set set = this$0.myWorkspaceMap.getAvailableIds();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAvailableIds(...)");
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)set);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (MavenId)element$iv;
            boolean bl = false;
            this$0.myWorkspaceMap.unregister((MavenId)it);
        }
        $this$forEach$iv = this$0.myVirtualFileToProjectMapping.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (MavenProject)element$iv;
            boolean bl = false;
            this$0.myMavenIdToProjectMapping.put(((MavenProject)it).getMavenId(), (MavenProject)it);
            this$0.myWorkspaceMap.register(((MavenProject)it).getMavenId(), new File(((MavenProject)it).getFile().getPath()));
        }
        return Unit.INSTANCE;
    }

    private static final boolean hasProjects$lambda$38(MavenProjectsTree this$0) {
        return !this$0.myRootProjects.isEmpty();
    }

    private static final ArrayList _get_rootProjects_$lambda$39(MavenProjectsTree this$0) {
        return new ArrayList(this$0.myRootProjects);
    }

    private static final int getFilterConfigCrc$lambda$40(MavenProjectsTree this$0, ProjectFileIndex $fileIndex) {
        CRC32 crc = new CRC32();
        MavenExplicitProfiles profiles2 = this$0.myExplicitProfiles;
        MavenProjectsTree.Companion.updateCrc(crc, profiles2.hashCode());
        Collection<MavenProject> allProjects = this$0.myVirtualFileToProjectMapping.values();
        crc.update(allProjects.size() & 0xFF);
        for (MavenProject mavenProject : allProjects) {
            VirtualFile pomFile = mavenProject.getFile();
            Module module = $fileIndex.getModuleForFile(pomFile);
            if (module == null || !Comparing.equal((Object)$fileIndex.getContentRootForFile(pomFile), (Object)pomFile.getParent())) continue;
            MavenProjectsTree.Companion.updateCrc(crc, module.getName());
            MavenId mavenId = mavenProject.getMavenId();
            MavenProjectsTree.Companion.updateCrc(crc, mavenId.getGroupId());
            MavenProjectsTree.Companion.updateCrc(crc, mavenId.getArtifactId());
            MavenProjectsTree.Companion.updateCrc(crc, mavenId.getVersion());
            MavenId parentId = mavenProject.getParentId();
            if (parentId != null) {
                MavenProjectsTree.Companion.updateCrc(crc, parentId.getGroupId());
                MavenProjectsTree.Companion.updateCrc(crc, parentId.getArtifactId());
                MavenProjectsTree.Companion.updateCrc(crc, parentId.getVersion());
            }
            MavenProjectsTree.Companion.updateCrc(crc, mavenProject.getDirectory());
            MavenProjectsTree.Companion.updateCrc(crc, MavenFilteredPropertyPsiReferenceProvider.getDelimitersPattern(mavenProject).pattern());
            MavenProjectsTree.Companion.updateCrc(crc, ((Object)mavenProject.getModelMap()).hashCode());
            MavenProjectsTree.Companion.updateCrc(crc, ((Object)mavenProject.getResources()).hashCode());
            MavenProjectsTree.Companion.updateCrc(crc, ((Object)mavenProject.getTestResources()).hashCode());
            MavenProjectsTree.Companion.updateCrc(crc, ((Object)MavenProjectsTree.Companion.getFilterExclusions(mavenProject)).hashCode());
            MavenProjectsTree.Companion.updateCrc(crc, mavenProject.getProperties().hashCode());
            for (String each : mavenProject.getFilterPropertiesFiles()) {
                File file2 = new File(each);
                MavenProjectsTree.Companion.updateCrc(crc, file2.lastModified());
            }
            XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
            Writer crcWriter2 = new Writer(crc){
                final /* synthetic */ CRC32 $crc;
                {
                    this.$crc = $crc;
                }

                public void write(char[] cbuf, int off, int len) {
                    Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
                    int end = off + len;
                    for (int i2 = off; i2 < end; ++i2) {
                        this.$crc.update(cbuf[i2]);
                    }
                }

                public void flush() {
                }

                public void close() {
                }
            };
            try {
                Element warPluginCfg;
                Element resourcePluginCfg = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-resources-plugin");
                if (resourcePluginCfg != null) {
                    outputter.output(resourcePluginCfg, crcWriter2);
                }
                if ((warPluginCfg = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-war-plugin")) == null) continue;
                outputter.output(warPluginCfg, crcWriter2);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return (int)crc.getValue();
    }

    private static final ArrayList _get_projects_$lambda$41(MavenProjectsTree this$0) {
        return new ArrayList<MavenProject>(this$0.myVirtualFileToProjectMapping.values());
    }

    private static final List _get_nonIgnoredProjects_$lambda$42(MavenProjectsTree this$0) {
        List result2 = new ArrayList();
        for (MavenProject each : this$0.myVirtualFileToProjectMapping.values()) {
            if (this$0.isIgnored(each)) continue;
            result2.add(each);
        }
        return result2;
    }

    private static final ArrayList _get_projectsFiles_$lambda$43(MavenProjectsTree this$0) {
        return new ArrayList(this$0.myVirtualFileToProjectMapping.keySet());
    }

    private static final MavenProject findProject$lambda$44(MavenProjectsTree this$0, VirtualFile $f) {
        return this$0.myVirtualFileToProjectMapping.get($f);
    }

    private static final MavenProject findProject$lambda$45(MavenProjectsTree this$0, MavenId $id) {
        return this$0.myMavenIdToProjectMapping.get($id);
    }

    private static final MavenProject findSingleProjectInReactor$lambda$47(MavenProjectsTree this$0, MavenId $id) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this$0.myMavenIdToProjectMapping.values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MavenProject it = (MavenProject)element$iv;
                boolean bl = false;
                if (!(StringUtil.equals((CharSequence)it.getMavenId().getArtifactId(), (CharSequence)$id.getArtifactId()) && StringUtil.equals((CharSequence)it.getMavenId().getGroupId(), (CharSequence)$id.getGroupId()))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final MavenWorkspaceMap _get_workspaceMap_$lambda$48(MavenProjectsTree this$0) {
        return this$0.myWorkspaceMap.copy();
    }

    private static final MavenProject findAggregator$lambda$49(MavenProjectsTree this$0, MavenProject $project) {
        return this$0.myModuleToAggregatorMapping.get($project);
    }

    private static final MavenProject findRootProject$lambda$52(MavenProjectsTree this$0, MavenProject $project) {
        return this$0.doFindRootProject($project);
    }

    private static final List getModules$lambda$53(MavenProjectsTree this$0, MavenProject $aggregator) {
        List<MavenProject> modules = this$0.myAggregatorToModuleMapping.get($aggregator);
        return modules == null ? CollectionsKt.emptyList() : (List)new ArrayList(modules);
    }

    private static final Unit addModule$lambda$54(MavenProjectsTree this$0, MavenProject $aggregator, MavenProject $module) {
        List modules = this$0.myAggregatorToModuleMapping.get($aggregator);
        if (modules == null) {
            modules = new ArrayList();
            this$0.myAggregatorToModuleMapping.put($aggregator, modules);
        }
        modules.add((MavenProject)$module);
        this$0.myModuleToAggregatorMapping.put($module, $aggregator);
        return Unit.INSTANCE;
    }

    private static final Unit removeModule$lambda$55(MavenProjectsTree this$0, MavenProject $aggregator, MavenProject $module) {
        List<MavenProject> modules = this$0.myAggregatorToModuleMapping.get($aggregator);
        if (modules == null) {
            return Unit.INSTANCE;
        }
        modules.remove($module);
        if (modules.isEmpty()) {
            this$0.myAggregatorToModuleMapping.remove($aggregator);
        }
        this$0.myModuleToAggregatorMapping.remove($module);
        return Unit.INSTANCE;
    }

    private static final List findInheritors$lambda$56(MavenProject $project, MavenProjectsTree this$0) {
        List result2 = null;
        MavenId id = $project.getMavenId();
        for (MavenProject each : this$0.myVirtualFileToProjectMapping.values()) {
            if (each == $project || !Intrinsics.areEqual((Object)id, (Object)each.getParentId())) continue;
            if (result2 == null) {
                result2 = new ArrayList();
            }
            result2.add(each);
        }
        List list = result2;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final List getDependentProjects$lambda$57(Collection $projects, MavenProjectsTree this$0) {
        List result2 = new ArrayList();
        Set projectIds = (Set)new ObjectOpenCustomHashSet($projects.size(), (Hash.Strategy)new MavenCoordinateHashCodeStrategy());
        for (MavenProject project : $projects) {
            projectIds.add(project.getMavenId());
        }
        Set projectPaths = FileCollectionFactory.createCanonicalFileSet();
        for (MavenProject project : $projects) {
            projectPaths.add(new File(project.getFile().getPath()));
        }
        for (MavenProject project : this$0.myVirtualFileToProjectMapping.values()) {
            boolean isDependent = false;
            Set<String> pathsInStack = project.getModulePaths();
            for (String path : pathsInStack) {
                if (!projectPaths.contains(new File(path))) continue;
                isDependent = true;
                break;
            }
            if (!isDependent) {
                for (MavenArtifact dep : project.getDependencies()) {
                    if (!projectIds.contains(dep)) continue;
                    isDependent = true;
                    break;
                }
            }
            if (!isDependent) continue;
            result2.add(project);
        }
        return result2;
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final MavenProjectsTree read(@NotNull Project project, @NotNull Path path) {
        return Companion.read(project, path);
    }

    @JvmStatic
    @NotNull
    public static final Collection<String> getFilterExclusions(@NotNull MavenProject mavenProject) {
        return Companion.getFilterExclusions(mavenProject);
    }

    public static final /* synthetic */ Object access$update(MavenProjectsTree $this, Collection files2, boolean updateModules, boolean forceRead, MavenProjectReader projectReader, RawProgressReporter progressReporter2, Continuation $completion) {
        return $this.update((Collection<? extends VirtualFile>)files2, updateModules, forceRead, projectReader, progressReporter2, (Continuation<? super MavenProjectsTreeUpdateResult>)$completion);
    }

    public static final /* synthetic */ Object access$delete(MavenProjectsTree $this, MavenProjectReader projectReader, Collection files2, RawProgressReporter progressReporter2, Continuation $completion) {
        return $this.delete(projectReader, files2, progressReporter2, (Continuation<? super MavenProjectsTreeUpdateResult>)$completion);
    }

    static {
        Logger logger = Logger.getInstance(MavenProjectsTree.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        STORAGE_VERSION = MavenProjectsTree.class.getSimpleName() + ".12";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\r\u001a\u00020\b*\u00020\nH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J-\u0010\u0014\u001a\u0002H\u0015\"\u000e\b\u0000\u0010\u0015*\b\u0012\u0004\u0012\u00020\n0\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u0002H\u0015H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0 H\u0002J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u000fH\u0002J2\u0010%\u001a\u00020\u001c2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0\u00162\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0\u00162\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\n0)H\u0002J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020#H\u0002J\u0018\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\bH\u0002J\u0018\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020.2\u0006\u00100\u001a\u000201H\u0002J\u001a\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020.2\b\u00102\u001a\u0004\u0018\u00010\nH\u0002J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\n0 2\u0006\u0010+\u001a\u00020#H\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u00064"}, d2={"Lorg/jetbrains/idea/maven/project/MavenProjectsTree$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "STORAGE_VERSION_NUMBER", "", "STORAGE_VERSION", "", "getSTORAGE_VERSION", "()Ljava/lang/String;", "getStorageVersionNumber", "read", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "project", "Lcom/intellij/openapi/project/Project;", "path", "Ljava/nio/file/Path;", "readCollection", "T", "", "inputStream", "Ljava/io/DataInputStream;", "result", "(Ljava/io/DataInputStream;Ljava/util/Collection;)Ljava/util/Collection;", "writeCollection", "", "out", "Ljava/io/DataOutputStream;", "list", "", "readProjectsRecursively", "", "Lorg/jetbrains/idea/maven/project/MavenProject;", "tree", "updateExplicitProfiles", "explicitProfiles", "temporarilyRemovedExplicitProfiles", "available", "", "mavenProjectToNioPath", "mavenProject", "updateCrc", "crc", "Ljava/util/zip/CRC32;", "xInt", "l", "", "s", "getFilterExclusions", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getSTORAGE_VERSION() {
            return STORAGE_VERSION;
        }

        private final int getStorageVersionNumber(String $this$getStorageVersionNumber) {
            int n;
            String[] stringArray = new String[]{"."};
            List parts = StringsKt.split$default((CharSequence)$this$getStorageVersionNumber, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            try {
                n = Integer.parseInt((String)CollectionsKt.last((List)parts));
            }
            catch (Exception exception) {
                n = 0;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final MavenProjectsTree read(@NotNull Project project, @NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            MavenProjectsTree tree = new MavenProjectsTree(project);
            if (!Files.exists(path, new LinkOption[0])) {
                return tree;
            }
            Closeable closeable = new DataInputStream(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])));
            Throwable throwable = null;
            try {
                DataInputStream inputStream = (DataInputStream)closeable;
                boolean bl = false;
                String storageVersion = "";
                try {
                    storageVersion = inputStream.readUTF();
                    int storageVersionNumber = Companion.getStorageVersionNumber(storageVersion);
                    tree.myManagedFilesPaths = (Set)Companion.readCollection(inputStream, (Collection)new LinkedHashSet());
                    tree.myIgnoredFilesPaths = (List)Companion.readCollection(inputStream, (Collection)new ArrayList());
                    tree.myIgnoredFilesPatterns = (List)Companion.readCollection(inputStream, (Collection)new ArrayList());
                    tree.myExplicitProfiles = new MavenExplicitProfiles(Companion.readCollection(inputStream, (Collection)new HashSet()), Companion.readCollection(inputStream, (Collection)new HashSet()));
                    if (12 == storageVersionNumber) {
                        tree.myRootProjects.addAll((Collection)Companion.readProjectsRecursively(inputStream, tree));
                    }
                }
                catch (IOException e) {
                    MavenLog.LOG.warn("Cannot read project tree from storage, storageVersion " + storageVersion, (Throwable)e);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return tree;
        }

        private final <T extends Collection<String>> T readCollection(DataInputStream inputStream, T result2) throws IOException {
            int count = inputStream.readInt();
            while (count-- > 0) {
                result2.add((String)inputStream.readUTF());
            }
            return result2;
        }

        private final void writeCollection(DataOutputStream out, Collection<String> list) throws IOException {
            out.writeInt(list.size());
            for (String each : list) {
                out.writeUTF(each);
            }
        }

        private final List<MavenProject> readProjectsRecursively(DataInputStream inputStream, MavenProjectsTree tree) throws IOException {
            int count = inputStream.readInt();
            List result2 = new ArrayList(count);
            while (count-- > 0) {
                MavenProject project = MavenProject.Companion.read(inputStream);
                MavenProjectTimestamp timestamp = MavenProjectTimestamp.read(inputStream);
                List<MavenProject> modules = this.readProjectsRecursively(inputStream, tree);
                if (project == null) continue;
                result2.add(project);
                tree.myTimestamps.put(project.getFile(), timestamp);
                tree.myVirtualFileToProjectMapping.put(project.getFile(), project);
                tree.fillIDMaps(project);
                if (modules.isEmpty()) continue;
                tree.myAggregatorToModuleMapping.put(project, modules);
                for (MavenProject eachModule : modules) {
                    tree.myModuleToAggregatorMapping.put(eachModule, project);
                }
            }
            return result2;
        }

        private final void updateExplicitProfiles(Collection<String> explicitProfiles, Collection<String> temporarilyRemovedExplicitProfiles, Set<String> available) {
            HashSet<String> removedProfiles = new HashSet<String>(explicitProfiles);
            removedProfiles.removeAll((Collection)available);
            temporarilyRemovedExplicitProfiles.addAll((Collection<String>)removedProfiles);
            HashSet<String> restoredProfiles = new HashSet<String>(temporarilyRemovedExplicitProfiles);
            restoredProfiles.retainAll((Collection)available);
            temporarilyRemovedExplicitProfiles.removeAll((Collection)restoredProfiles);
            explicitProfiles.removeAll((Collection)removedProfiles);
            explicitProfiles.addAll((Collection<String>)restoredProfiles);
        }

        private final Path mavenProjectToNioPath(MavenProject mavenProject) {
            Path path = Path.of(mavenProject.getFile().getParent().getPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            return path;
        }

        private final void updateCrc(CRC32 crc, int xInt) {
            int x = xInt;
            crc.update(x & 0xFF);
            crc.update((x >>>= 8) & 0xFF);
            crc.update((x >>>= 8) & 0xFF);
            crc.update(x >>>= 8);
        }

        private final void updateCrc(CRC32 crc, long l) {
            this.updateCrc(crc, (int)l);
            this.updateCrc(crc, (int)(l >>> 32));
        }

        private final void updateCrc(CRC32 crc, String s) {
            if (s == null) {
                crc.update(111);
            } else {
                this.updateCrc(crc, s.hashCode());
                crc.update(s.length() & 0xFF);
            }
        }

        @JvmStatic
        @NotNull
        public final Collection<String> getFilterExclusions(@NotNull MavenProject mavenProject) {
            Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
            Element config = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-resources-plugin");
            if (config == null) {
                return SetsKt.emptySet();
            }
            List<String> customNonFilteredExtensions = MavenJDOMUtil.findChildrenValuesByPath(config, "nonFilteredFileExtensions", "nonFilteredFileExtension");
            if (customNonFilteredExtensions.isEmpty()) {
                return SetsKt.emptySet();
            }
            List<String> list = Collections.unmodifiableList(customNonFilteredExtensions);
            Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J,\u0010\u0004\u001a\u00020\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J0\u0010\u000b\u001a\u00020\u00032\u0018\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\r0\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J&\u0010\u0010\u001a\u00020\u00032\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0017J\u001c\u0010\u0010\u001a\u00020\u00032\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J\u001c\u0010\u0016\u001a\u00020\u00032\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0007H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0018\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/idea/maven/project/MavenProjectsTree$Listener;", "Ljava/util/EventListener;", "profilesChanged", "", "projectsIgnoredStateChanged", "ignored", "", "Lorg/jetbrains/idea/maven/project/MavenProject;", "unignored", "fromImport", "", "projectsUpdated", "updated", "Lcom/intellij/openapi/util/Pair;", "Lorg/jetbrains/idea/maven/project/MavenProjectChanges;", "deleted", "projectResolved", "projectWithChanges", "nativeMavenProject", "Lorg/jetbrains/idea/maven/server/NativeMavenProjectHolder;", "pluginsResolved", "project", "foldersResolved", "artifactsDownloaded", "intellij.maven"})
    public static interface Listener
    extends EventListener {
        default public void profilesChanged() {
        }

        default public void projectsIgnoredStateChanged(@NotNull List<MavenProject> ignored, @NotNull List<MavenProject> unignored, boolean fromImport) {
            Intrinsics.checkNotNullParameter(ignored, (String)"ignored");
            Intrinsics.checkNotNullParameter(unignored, (String)"unignored");
        }

        default public void projectsUpdated(@NotNull List<? extends Pair<MavenProject, MavenProjectChanges>> updated, @NotNull List<MavenProject> deleted) {
            Intrinsics.checkNotNullParameter(updated, (String)"updated");
            Intrinsics.checkNotNullParameter(deleted, (String)"deleted");
        }

        @Deprecated(message="use projectResolved(Pair<MavenProject, MavenProjectChanges>)")
        default public void projectResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges, @Nullable NativeMavenProjectHolder nativeMavenProject) {
            Intrinsics.checkNotNullParameter(projectWithChanges, (String)"projectWithChanges");
        }

        default public void projectResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
            Intrinsics.checkNotNullParameter(projectWithChanges, (String)"projectWithChanges");
            this.projectResolved(projectWithChanges, null);
        }

        default public void pluginsResolved(@NotNull MavenProject project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        }

        default public void foldersResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
            Intrinsics.checkNotNullParameter(projectWithChanges, (String)"projectWithChanges");
        }

        default public void artifactsDownloaded(@NotNull MavenProject project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u001d\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0096\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/maven/project/MavenProjectsTree$MavenCoordinateHashCodeStrategy;", "Lit/unimi/dsi/fastutil/Hash$Strategy;", "Lorg/jetbrains/idea/maven/model/MavenCoordinate;", "<init>", "()V", "hashCode", "", "other", "equals", "", "o1", "o2", "intellij.maven"})
    @ApiStatus.Internal
    public static final class MavenCoordinateHashCodeStrategy
    implements Hash.Strategy<MavenCoordinate> {
        public int hashCode(@Nullable MavenCoordinate other) {
            String artifactId;
            MavenCoordinate mavenCoordinate = other;
            String string = artifactId = mavenCoordinate != null ? mavenCoordinate.getArtifactId() : null;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable MavenCoordinate o1, @Nullable MavenCoordinate o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            return Intrinsics.areEqual((Object)o1.getArtifactId(), (Object)o2.getArtifactId()) && Intrinsics.areEqual((Object)o1.getVersion(), (Object)o2.getVersion()) && Intrinsics.areEqual((Object)o1.getGroupId(), (Object)o2.getGroupId());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00060\u0000R\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0018\u0010\t\u001a\u00060\u0000R\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007J$\u0010\f\u001a\u00060\u0000R\u00020\u00052\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00070\u000eJ\u0018\u0010\u000f\u001a\u00060\u0000R\u00020\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007J\u0012\u0010\u0011\u001a\u00060\u0000R\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J0\u0010\u0013\u001a\u00020\u0014\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0012\u001a\u00020\u00052\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00150\u00180\u0017H\u0002J<\u0010\u0019\u001a\u00020\u0014\"\u0004\b\u0000\u0010\u001a\"\u0004\b\u0001\u0010\u001b2\u0006\u0010\u0012\u001a\u00020\u00052\u001e\u0010\u0016\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\u001c0\u0017H\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/idea/maven/project/MavenProjectsTree$Updater;", "", "<init>", "(Lorg/jetbrains/idea/maven/project/MavenProjectsTree;)V", "setManagedFiles", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "paths", "", "", "setRootProjects", "roots", "Lorg/jetbrains/idea/maven/project/MavenProject;", "setAggregatorMappings", "map", "", "setMavenIdMappings", "projects", "copyFrom", "projectTree", "addFrom", "", "T", "getter", "Lkotlin/Function1;", "", "addFromMap", "K", "V", "", "intellij.maven"})
    public final class Updater {
        @NotNull
        public final Updater setManagedFiles(@NotNull List<String> paths) {
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            MavenProjectsTree.this.myManagedFilesPaths.clear();
            MavenProjectsTree.this.myManagedFilesPaths.addAll((Collection)paths);
            return this;
        }

        @NotNull
        public final Updater setRootProjects(@NotNull List<MavenProject> roots) {
            Intrinsics.checkNotNullParameter(roots, (String)"roots");
            MavenProjectsTree.this.myRootProjects.clear();
            MavenProjectsTree.this.myRootProjects.addAll((Collection)roots);
            roots.forEach(arg_0 -> Updater.setRootProjects$lambda$0(MavenProjectsTree.this, arg_0));
            return this;
        }

        @NotNull
        public final Updater setAggregatorMappings(@NotNull Map<MavenProject, ? extends List<MavenProject>> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            MavenProjectsTree.this.myAggregatorToModuleMapping.clear();
            MavenProjectsTree.this.myModuleToAggregatorMapping.clear();
            for (Map.Entry<MavenProject, ? extends List<MavenProject>> entry : map.entrySet()) {
                MavenProject key = entry.getKey();
                List<MavenProject> value = entry.getValue();
                List result2 = new ArrayList(value);
                MavenProjectsTree.this.myAggregatorToModuleMapping.put(key, result2);
                for (MavenProject c : result2) {
                    MavenProjectsTree.this.myModuleToAggregatorMapping.put(c, key);
                    MavenProjectsTree.this.myVirtualFileToProjectMapping.put(c.getFile(), c);
                }
            }
            return this;
        }

        @NotNull
        public final Updater setMavenIdMappings(@NotNull List<MavenProject> projects) {
            Intrinsics.checkNotNullParameter(projects, (String)"projects");
            projects.forEach(arg_0 -> Updater.setMavenIdMappings$lambda$1(MavenProjectsTree.this, arg_0));
            return this;
        }

        @NotNull
        public final Updater copyFrom(@NotNull MavenProjectsTree projectTree) {
            Intrinsics.checkNotNullParameter((Object)projectTree, (String)"projectTree");
            this.addFrom(projectTree, Updater::copyFrom$lambda$2);
            this.addFrom(projectTree, Updater::copyFrom$lambda$3);
            this.addFromMap(projectTree, Updater::copyFrom$lambda$4);
            this.addFromMap(projectTree, Updater::copyFrom$lambda$5);
            this.addFromMap(projectTree, Updater::copyFrom$lambda$6);
            this.addFromMap(projectTree, Updater::copyFrom$lambda$7);
            return this;
        }

        private final <T> void addFrom(MavenProjectsTree projectTree, Function1<? super MavenProjectsTree, ? extends Collection<T>> getter) {
            Collection my = (Collection)getter.invoke((Object)MavenProjectsTree.this);
            Collection theirs = (Collection)getter.invoke((Object)projectTree);
            if (my.isEmpty()) {
                v0 = my.addAll(theirs);
            } else {
                LinkedHashSet set = new LinkedHashSet();
                set.addAll(my);
                set.addAll(theirs);
                my.clear();
                v0 = my.addAll(CollectionsKt.toList((Iterable)set));
            }
        }

        private final <K, V> void addFromMap(MavenProjectsTree projectTree, Function1<? super MavenProjectsTree, ? extends Map<K, V>> getter) {
            Map my = (Map)getter.invoke((Object)MavenProjectsTree.this);
            Map theirs = (Map)getter.invoke((Object)projectTree);
            my.putAll(theirs);
        }

        private static final void setRootProjects$lambda$0(MavenProjectsTree this$0, MavenProject root) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            this$0.myVirtualFileToProjectMapping.put(root.getFile(), root);
        }

        private static final void setMavenIdMappings$lambda$1(MavenProjectsTree this$0, MavenProject it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.myMavenIdToProjectMapping.put(it.getMavenId(), it);
        }

        private static final Collection copyFrom$lambda$2(MavenProjectsTree it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.myManagedFilesPaths;
        }

        private static final Collection copyFrom$lambda$3(MavenProjectsTree it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.myRootProjects;
        }

        private static final Map copyFrom$lambda$4(MavenProjectsTree it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.myMavenIdToProjectMapping;
        }

        private static final Map copyFrom$lambda$5(MavenProjectsTree it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.myVirtualFileToProjectMapping;
        }

        private static final Map copyFrom$lambda$6(MavenProjectsTree it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.myAggregatorToModuleMapping;
        }

        private static final Map copyFrom$lambda$7(MavenProjectsTree it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.myModuleToAggregatorMapping;
        }
    }
}

