/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.parsers;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.FinishEventImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenParsingContext;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenSpyLoggedEventParser;
import org.jetbrains.idea.maven.externalSystemIntegration.output.parsers.MavenEventType;
import org.jetbrains.idea.maven.externalSystemIntegration.output.parsers.MavenTaskFailedResultImpl;
import org.jetbrains.idea.maven.utils.MavenLog;

public class MavenSpyOutputParser {
    public static final String PREFIX = "[IJ]-";
    private static final String SEPARATOR = "-[IJ]-";
    private static final String NEWLINE = "-[N]-";
    private static final String DOWNLOAD_DEPENDENCIES_NAME = "dependencies";
    private final Set<String> downloadingMap;
    private final MavenParsingContext myContext;

    public static boolean isSpyLog(String s) {
        return s != null && s.startsWith(PREFIX);
    }

    public MavenSpyOutputParser(@NotNull MavenParsingContext context2) {
        if (context2 == null) {
            MavenSpyOutputParser.$$$reportNull$$$0(0);
        }
        this.downloadingMap = new HashSet<String>();
        this.myContext = context2;
    }

    public void processLine(@NotNull String spyLine, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        String line;
        if (spyLine == null) {
            MavenSpyOutputParser.$$$reportNull$$$0(1);
        }
        if (messageConsumer == null) {
            MavenSpyOutputParser.$$$reportNull$$$0(2);
        }
        if ((line = MavenSpyOutputParser.extractLine(spyLine)) == null) {
            return;
        }
        try {
            int threadId;
            int threadSeparatorIdx = line.indexOf(45);
            if (threadSeparatorIdx < 0) {
                return;
            }
            try {
                threadId = Integer.parseInt(line.substring(0, threadSeparatorIdx));
            }
            catch (NumberFormatException ignore) {
                return;
            }
            if (threadId < 0) {
                return;
            }
            int typeSeparatorIdx = line.indexOf(SEPARATOR, threadSeparatorIdx + 1);
            if (typeSeparatorIdx < 0) {
                return;
            }
            String type = line.substring(threadSeparatorIdx + 1, typeSeparatorIdx);
            List data = StringUtil.split((String)line.substring(typeSeparatorIdx + SEPARATOR.length()), (String)SEPARATOR);
            Map<String, String> parameters = data.stream().map(d -> d.split("=")).filter(d -> ((String[])d).length == 2).peek(d -> {
                d[1] = d[1].replace(NEWLINE, "\n");
            }).collect(Collectors.toMap(d -> d[0], d -> d[1]));
            MavenEventType eventType = MavenEventType.valueByName(type);
            if (eventType == null) {
                return;
            }
            this.processErrorLogLine(parameters.get("error"), eventType, messageConsumer);
            this.parse(threadId, eventType, parameters, messageConsumer);
        }
        catch (Exception e) {
            MavenLog.LOG.error("Error processing line " + spyLine, (Throwable)e);
        }
    }

    @Nullable
    private static String extractLine(@NotNull String line) {
        if (line == null) {
            MavenSpyOutputParser.$$$reportNull$$$0(3);
        }
        if (line.startsWith(PREFIX)) {
            return line.substring(PREFIX.length());
        }
        return null;
    }

    protected void parse(int threadId, MavenEventType type, Map<String, String> parameters, Consumer<? super BuildEvent> messageConsumer) {
        switch (type) {
            case SESSION_STARTED: {
                List<String> projectsInReactor = MavenSpyOutputParser.getProjectsInReactor(parameters);
                this.myContext.setProjectsInReactor(projectsInReactor);
                break;
            }
            case SESSION_ENDED: {
                MavenSpyOutputParser.doFinishSession(messageConsumer, this.myContext);
                break;
            }
            case PROJECT_STARTED: {
                MavenParsingContext.ProjectExecutionEntry execution = this.myContext.getProject(threadId, parameters, true);
                if (execution == null) {
                    MavenLog.LOG.debug("Not found for " + parameters);
                    break;
                }
                messageConsumer.accept((BuildEvent)new StartEventImpl(execution.getId(), execution.getParentId(), System.currentTimeMillis(), execution.getName()));
                break;
            }
            case MOJO_STARTED: {
                MavenParsingContext.MojoExecutionEntry mojoExecution = this.myContext.getMojo(threadId, parameters, true);
                MavenSpyOutputParser.doStart(messageConsumer, mojoExecution);
                break;
            }
            case MOJO_SUCCEEDED: {
                this.stopFakeDownloadNode(threadId, parameters, messageConsumer);
                MavenParsingContext.MojoExecutionEntry mojoExecution = this.myContext.getMojo(threadId, parameters, false);
                MavenSpyOutputParser.doComplete(messageConsumer, mojoExecution);
                break;
            }
            case MOJO_FAILED: {
                this.stopFakeDownloadNode(threadId, parameters, messageConsumer);
                MavenParsingContext.MojoExecutionEntry mojoExecution = this.myContext.getMojo(threadId, parameters, false);
                if (mojoExecution == null) {
                    MavenLog.LOG.debug("Not found id for " + parameters);
                    break;
                }
                messageConsumer.accept((BuildEvent)new FinishEventImpl(mojoExecution.getId(), mojoExecution.getParentId(), System.currentTimeMillis(), mojoExecution.getName(), (EventResult)new MavenTaskFailedResultImpl(parameters.get("error"))));
                mojoExecution.complete();
                break;
            }
            case MOJO_SKIPPED: {
                this.stopFakeDownloadNode(threadId, parameters, messageConsumer);
                MavenParsingContext.MojoExecutionEntry mojoExecution = this.myContext.getMojo(threadId, parameters, false);
                MavenSpyOutputParser.doSkip(messageConsumer, mojoExecution);
                break;
            }
            case PROJECT_SUCCEEDED: {
                this.stopFakeDownloadNode(threadId, parameters, messageConsumer);
                MavenParsingContext.ProjectExecutionEntry execution = this.myContext.getProject(threadId, parameters, false);
                MavenSpyOutputParser.doComplete(messageConsumer, execution);
                break;
            }
            case PROJECT_SKIPPED: {
                MavenParsingContext.ProjectExecutionEntry execution = this.myContext.getProject(threadId, parameters, false);
                MavenSpyOutputParser.doSkip(messageConsumer, execution);
                break;
            }
            case PROJECT_FAILED: {
                this.stopFakeDownloadNode(threadId, parameters, messageConsumer);
                MavenParsingContext.ProjectExecutionEntry execution = this.myContext.getProject(threadId, parameters, false);
                this.myContext.setProjectFailure(true);
                MavenSpyOutputParser.doError(messageConsumer, execution, parameters.get("error"));
                break;
            }
            case ARTIFACT_RESOLVED: {
                this.artifactResolved(threadId, parameters, messageConsumer);
                break;
            }
            case ARTIFACT_DOWNLOADING: {
                this.artifactDownloading(threadId, parameters, messageConsumer);
            }
        }
    }

    private void processErrorLogLine(String errorLine, MavenEventType eventType, Consumer<? super BuildEvent> messageConsumer) {
        if (errorLine == null) {
            return;
        }
        for (MavenSpyLoggedEventParser eventParser : MavenSpyLoggedEventParser.EP_NAME.getExtensionList()) {
            if (!eventParser.supportsType(eventType) || !eventParser.processLogLine(this.myContext.getLastId(), this.myContext, errorLine, messageConsumer)) continue;
            return;
        }
    }

    private static List<String> getProjectsInReactor(Map<String, String> parameters) {
        String joined = parameters.get("projects");
        if (StringUtil.isEmptyOrSpaces((String)joined)) {
            return Collections.emptyList();
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (String project : joined.split("&&")) {
            if (StringUtil.isEmptyOrSpaces((String)project)) continue;
            result2.add(project);
        }
        return result2;
    }

    private void artifactDownloading(int threadId, Map<String, String> parameters, Consumer<? super BuildEvent> messageConsumer) {
        @NlsSafe String artifactCoord = parameters.get("artifactCoord");
        if (artifactCoord == null || !this.downloadingMap.add(artifactCoord)) {
            return;
        }
        MavenParsingContext.MavenExecutionEntry parent = this.startFakeDownloadNodeIfNotStarted(threadId, parameters, messageConsumer);
        messageConsumer.accept((BuildEvent)new StartEventImpl((Object)MavenSpyOutputParser.getDownloadId(artifactCoord), parent.getId(), System.currentTimeMillis(), artifactCoord));
    }

    private void artifactResolved(int threadId, Map<String, String> parameters, Consumer<? super BuildEvent> messageConsumer) {
        @NlsSafe String artifactCoord = parameters.get("artifactCoord");
        if (artifactCoord == null) {
            return;
        }
        @NlsSafe String error = parameters.get("error");
        if (error != null || this.downloadingMap.contains(artifactCoord)) {
            MavenParsingContext.MavenExecutionEntry parent = this.startFakeDownloadNodeIfNotStarted(threadId, parameters, messageConsumer);
            if (error != null) {
                if (this.downloadingMap.remove(artifactCoord)) {
                    messageConsumer.accept((BuildEvent)new FinishEventImpl((Object)MavenSpyOutputParser.getDownloadId(artifactCoord), parent.getId(), System.currentTimeMillis(), artifactCoord, (EventResult)new FailureResultImpl(error, null)));
                } else {
                    Object eventId = new Object();
                    messageConsumer.accept((BuildEvent)new StartEventImpl(eventId, parent.getId(), System.currentTimeMillis(), error));
                    messageConsumer.accept((BuildEvent)new FinishEventImpl(eventId, parent.getId(), System.currentTimeMillis(), error, (EventResult)new FailureResultImpl()));
                }
            } else {
                messageConsumer.accept((BuildEvent)new FinishEventImpl((Object)MavenSpyOutputParser.getDownloadId(artifactCoord), parent.getId(), System.currentTimeMillis(), artifactCoord, (EventResult)new SuccessResultImpl(false)));
            }
        }
    }

    @NotNull
    private static String getDownloadId(String artifactCoord) {
        String string = "download" + artifactCoord;
        if (string == null) {
            MavenSpyOutputParser.$$$reportNull$$$0(4);
        }
        return string;
    }

    private MavenParsingContext.MavenExecutionEntry startFakeDownloadNodeIfNotStarted(int threadId, Map<String, String> parameters, Consumer<? super BuildEvent> messageConsumer) {
        MavenParsingContext.NodeExecutionEntry parentMojo = this.myContext.getNode(threadId, DOWNLOAD_DEPENDENCIES_NAME, false);
        if (parentMojo != null) {
            return parentMojo;
        }
        parentMojo = this.myContext.getNode(threadId, DOWNLOAD_DEPENDENCIES_NAME, true);
        MavenSpyOutputParser.doStart(messageConsumer, parentMojo);
        return parentMojo;
    }

    private void stopFakeDownloadNode(int threadId, Map<String, String> parameters, Consumer<? super BuildEvent> messageConsumer) {
        MavenParsingContext.NodeExecutionEntry parentMojo = this.myContext.getNode(threadId, DOWNLOAD_DEPENDENCIES_NAME, false);
        if (parentMojo != null) {
            MavenSpyOutputParser.doComplete(messageConsumer, parentMojo);
        }
    }

    private static void doSkip(Consumer<? super BuildEvent> messageConsumer, MavenParsingContext.MavenExecutionEntry execution) {
        if (execution == null) {
            MavenLog.LOG.warn("Error parsing maven log");
            return;
        }
        messageConsumer.accept((BuildEvent)new FinishEventImpl(execution.getId(), execution.getParentId(), System.currentTimeMillis(), execution.getName(), (EventResult)new SkippedResultImpl()));
        execution.complete();
    }

    private static void doStart(Consumer<? super BuildEvent> messageConsumer, MavenParsingContext.MavenExecutionEntry execution) {
        if (execution == null) {
            MavenLog.LOG.warn("Error parsing maven log");
            return;
        }
        messageConsumer.accept((BuildEvent)new StartEventImpl(execution.getId(), execution.getParentId(), System.currentTimeMillis(), execution.getName()));
    }

    private static void doError(Consumer<? super BuildEvent> messageConsumer, MavenParsingContext.MavenExecutionEntry execution, String errorMessage) {
        if (execution == null) {
            MavenLog.LOG.warn("Error parsing maven log");
            return;
        }
        messageConsumer.accept((BuildEvent)new FinishEventImpl(execution.getId(), execution.getParentId(), System.currentTimeMillis(), execution.getName(), (EventResult)new MavenTaskFailedResultImpl(errorMessage)));
        execution.complete();
    }

    private static void doComplete(Consumer<? super BuildEvent> messageConsumer, MavenParsingContext.MavenExecutionEntry execution) {
        if (execution == null) {
            MavenLog.LOG.warn("Error parsing maven log");
            return;
        }
        messageConsumer.accept((BuildEvent)new FinishEventImpl(execution.getId(), execution.getParentId(), System.currentTimeMillis(), execution.getName(), (EventResult)new SuccessResultImpl()));
        execution.complete();
    }

    private static void doFinishSession(Consumer<? super BuildEvent> messageConsumer, MavenParsingContext context2) {
        context2.setSessionEnded(true);
        if (context2.getProjectFailure()) {
            messageConsumer.accept((BuildEvent)new FinishBuildEventImpl((Object)context2.getMyTaskId(), null, System.currentTimeMillis(), "", (EventResult)new FailureResultImpl()));
        } else {
            messageConsumer.accept((BuildEvent)new FinishBuildEventImpl((Object)context2.getMyTaskId(), null, System.currentTimeMillis(), "", (EventResult)new SuccessResultImpl()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spyLine";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageConsumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/externalSystemIntegration/output/parsers/MavenSpyOutputParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/externalSystemIntegration/output/parsers/MavenSpyOutputParser";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDownloadId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processLine";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "extractLine";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

