/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInspection.groovy;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInspection.GradleInspectionBundle;
import org.jetbrains.plugins.groovy.lang.psi.api.GrBlockLambdaBody;
import org.jetbrains.plugins.groovy.lang.psi.api.GrExpressionLambdaBody;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaBody;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a*\u0010\u0006\u001a\u001c\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u001a\u001a\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\tH\u0002\u001a\u001a\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\tH\u0002\u001a\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u001b\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00172\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0018\u001a\u001b\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010\u001b\"\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"checkPluginsStatement", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "pluginsStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;", "decomposeCall", "Lkotlin/Triple;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "", "call", "checkApply", "method", "checkVersion", "checkIdAlias", "", "allowedStrings", "", "getBadStatementHighlightingElement", "suspiciousStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrStatement;", "getStatements", "", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;)[Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrStatement;", "funExpr", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrFunctionalExpression;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/GrFunctionalExpression;)[Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrStatement;", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nGroovyPluginDslStructureInspectionVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroovyPluginDslStructureInspectionVisitor.kt\norg/jetbrains/plugins/gradle/codeInspection/groovy/GroovyPluginDslStructureInspectionVisitorKt\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,128:1\n19#2:129\n19#2:130\n19#2:131\n*S KotlinDebug\n*F\n+ 1 GroovyPluginDslStructureInspectionVisitor.kt\norg/jetbrains/plugins/gradle/codeInspection/groovy/GroovyPluginDslStructureInspectionVisitorKt\n*L\n60#1:129\n61#1:130\n114#1:131\n*E\n"})
public final class GroovyPluginDslStructureInspectionVisitorKt {
    @NotNull
    private static final Set<String> allowedStrings;

    private static final void checkPluginsStatement(ProblemsHolder holder, GrMethodCall pluginsStatement) {
        for (GrStatement statement : GroovyPluginDslStructureInspectionVisitorKt.getStatements(pluginsStatement)) {
            String string;
            PsiElement refElement;
            if (!(statement instanceof GrMethodCall)) {
                holder.registerProblem((PsiElement)statement, GradleInspectionBundle.message("inspection.message.only.method.calls.to.id.alias.are.available.in.plugins.block", new Object[0]), new LocalQuickFix[0]);
                continue;
            }
            Triple<PsiElement, GrExpression, String> triple = GroovyPluginDslStructureInspectionVisitorKt.decomposeCall((GrMethodCall)statement);
            if (triple == null) continue;
            PsiElement psiElement = refElement = (PsiElement)triple.component1();
            String string2 = string = psiElement != null ? psiElement.getText() : null;
            if (Intrinsics.areEqual((Object)string, (Object)"apply")) {
                GroovyPluginDslStructureInspectionVisitorKt.checkApply(holder, (GrExpression)statement);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)"version")) {
                GroovyPluginDslStructureInspectionVisitorKt.checkVersion(holder, (GrExpression)statement);
                continue;
            }
            if (!GroovyPluginDslStructureInspectionVisitorKt.checkIdAlias(holder, (GrExpression)statement)) continue;
            holder.registerProblem((PsiElement)statement, GradleInspectionBundle.message("inspection.message.only.method.calls.to.id.alias.are.available.in.plugins.block", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static final Triple<PsiElement, GrExpression, String> decomposeCall(GrMethodCall call) {
        GrExpression $this$asSafely$iv = call.getInvokedExpression();
        boolean $i$f$asSafely = false;
        GrExpression grExpression = $this$asSafely$iv;
        if (!(grExpression instanceof GrReferenceExpression)) {
            grExpression = null;
        }
        GrReferenceExpression grReferenceExpression = (GrReferenceExpression)grExpression;
        if (grReferenceExpression == null) {
            return null;
        }
        GrReferenceExpression caller = grReferenceExpression;
        GrExpression $this$asSafely$iv2 = caller.getQualifierExpression();
        boolean $i$f$asSafely2 = false;
        GrExpression grExpression2 = $this$asSafely$iv2;
        if (!(grExpression2 instanceof GrMethodCall)) {
            grExpression2 = null;
        }
        GrMethodCall grMethodCall = (GrMethodCall)grExpression2;
        GrExpression $this$asSafely$iv3 = grMethodCall != null ? grMethodCall.getInvokedExpression() : null;
        boolean $i$f$asSafely3 = false;
        GrExpression grExpression3 = $this$asSafely$iv3;
        if (!(grExpression3 instanceof GrReferenceExpression)) {
            grExpression3 = null;
        }
        GrReferenceExpression grReferenceExpression2 = (GrReferenceExpression)grExpression3;
        String qualifierCallName = grReferenceExpression2 != null ? grReferenceExpression2.getReferenceName() : null;
        return new Triple((Object)caller.getReferenceNameElement(), (Object)caller.getQualifierExpression(), (Object)qualifierCallName);
    }

    private static final void checkApply(ProblemsHolder holder, GrExpression method) {
        if (!(method instanceof GrMethodCall)) {
            return;
        }
        Triple<PsiElement, GrExpression, String> triple = GroovyPluginDslStructureInspectionVisitorKt.decomposeCall((GrMethodCall)method);
        if (triple == null) {
            return;
        }
        Triple<PsiElement, GrExpression, String> triple2 = triple;
        PsiElement refElement = (PsiElement)triple2.component1();
        GrExpression qualifier = (GrExpression)triple2.component2();
        String qualifierCallName = (String)triple2.component3();
        if (Intrinsics.areEqual((Object)qualifierCallName, (Object)"version")) {
            GroovyPluginDslStructureInspectionVisitorKt.checkVersion(holder, qualifier);
        } else if (refElement != null && GroovyPluginDslStructureInspectionVisitorKt.checkIdAlias(holder, qualifier)) {
            holder.registerProblem(refElement, GradleInspectionBundle.message("inspection.message.only.method.calls.to.id.alias.are.available.in.plugins.block", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static final void checkVersion(ProblemsHolder holder, GrExpression method) {
        if (!(method instanceof GrMethodCall)) {
            return;
        }
        Triple<PsiElement, GrExpression, String> triple = GroovyPluginDslStructureInspectionVisitorKt.decomposeCall((GrMethodCall)method);
        if (triple == null) {
            return;
        }
        Triple<PsiElement, GrExpression, String> triple2 = triple;
        PsiElement refElement = (PsiElement)triple2.component1();
        GrExpression qualifier = (GrExpression)triple2.component2();
        if (refElement != null && GroovyPluginDslStructureInspectionVisitorKt.checkIdAlias(holder, qualifier)) {
            holder.registerProblem(refElement, GradleInspectionBundle.message("inspection.message.only.method.calls.to.id.alias.are.available.in.plugins.block", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static final boolean checkIdAlias(ProblemsHolder holder, GrExpression method) {
        String methodName;
        PsiElement refElement;
        if (!(method instanceof GrMethodCall)) {
            return true;
        }
        Triple<PsiElement, GrExpression, String> triple = GroovyPluginDslStructureInspectionVisitorKt.decomposeCall((GrMethodCall)method);
        if (triple == null) {
            return true;
        }
        PsiElement psiElement = refElement = (PsiElement)triple.component1();
        String string = methodName = psiElement != null ? psiElement.getText() : null;
        if (!Intrinsics.areEqual((Object)methodName, (Object)"id") && !Intrinsics.areEqual((Object)methodName, (Object)"alias")) {
            PsiElement psiElement2 = refElement;
            if (psiElement2 == null) {
                psiElement2 = (PsiElement)method;
            }
            holder.registerProblem(psiElement2, GradleInspectionBundle.message("inspection.message.only.method.calls.to.id.alias.are.available.in.plugins.block", new Object[0]), new LocalQuickFix[0]);
        }
        return false;
    }

    private static final PsiElement getBadStatementHighlightingElement(GrStatement suspiciousStatement) {
        if (!(suspiciousStatement instanceof GrMethodCall)) {
            return (PsiElement)suspiciousStatement;
        }
        if (!allowedStrings.contains(((GrMethodCall)suspiciousStatement).getInvokedExpression().getText())) {
            return (PsiElement)((GrMethodCall)suspiciousStatement).getInvokedExpression();
        }
        return null;
    }

    private static final GrStatement[] getStatements(GrMethodCall call) {
        GrFunctionalExpression grFunctionalExpression;
        GrClosableBlock[] grClosableBlockArray = call.getClosureArguments();
        Intrinsics.checkNotNullExpressionValue((Object)grClosableBlockArray, (String)"getClosureArguments(...)");
        GrClosableBlock grClosableBlock = (GrClosableBlock)ArraysKt.singleOrNull((Object[])grClosableBlockArray);
        if (grClosableBlock != null) {
            grFunctionalExpression = (GrFunctionalExpression)grClosableBlock;
        } else {
            GrFunctionalExpression grFunctionalExpression2;
            GrExpression[] grExpressionArray = call.getExpressionArguments();
            Intrinsics.checkNotNullExpressionValue((Object)grExpressionArray, (String)"getExpressionArguments(...)");
            GrExpression grExpression = (GrExpression)ArraysKt.firstOrNull((Object[])grExpressionArray);
            if (grExpression != null) {
                GrExpression $this$asSafely$iv = grExpression;
                boolean $i$f$asSafely = false;
                GrExpression grExpression2 = $this$asSafely$iv;
                if (!(grExpression2 instanceof GrFunctionalExpression)) {
                    grExpression2 = null;
                }
                grFunctionalExpression2 = (GrFunctionalExpression)grExpression2;
            } else {
                grFunctionalExpression2 = grFunctionalExpression = null;
            }
            if (grFunctionalExpression2 == null) {
                return new GrStatement[0];
            }
        }
        GrFunctionalExpression closure = grFunctionalExpression;
        return GroovyPluginDslStructureInspectionVisitorKt.getStatements(closure);
    }

    private static final GrStatement[] getStatements(GrFunctionalExpression funExpr) {
        GrStatement[] grStatementArray;
        GrFunctionalExpression grFunctionalExpression = funExpr;
        if (grFunctionalExpression instanceof GrClosableBlock) {
            GrStatement[] grStatementArray2 = ((GrClosableBlock)funExpr).getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)grStatementArray2, (String)"getStatements(...)");
            return grStatementArray2;
        }
        if (grFunctionalExpression instanceof GrLambdaExpression) {
            GrLambdaBody body = ((GrLambdaExpression)funExpr).getBody();
            if (body instanceof GrBlockLambdaBody) {
                GrStatement[] grStatementArray3 = ((GrBlockLambdaBody)body).getStatements();
                grStatementArray = grStatementArray3;
                Intrinsics.checkNotNullExpressionValue((Object)grStatementArray3, (String)"getStatements(...)");
            } else if (body instanceof GrExpressionLambdaBody) {
                GrStatement[] grStatementArray4 = new GrStatement[]{((GrExpressionLambdaBody)body).getExpression()};
                grStatementArray = grStatementArray4;
            } else {
                grStatementArray = new GrStatement[]{};
            }
        } else {
            grStatementArray = new GrStatement[]{};
        }
        return grStatementArray;
    }

    public static final /* synthetic */ void access$checkPluginsStatement(ProblemsHolder holder, GrMethodCall pluginsStatement) {
        GroovyPluginDslStructureInspectionVisitorKt.checkPluginsStatement(holder, pluginsStatement);
    }

    public static final /* synthetic */ PsiElement access$getBadStatementHighlightingElement(GrStatement suspiciousStatement) {
        return GroovyPluginDslStructureInspectionVisitorKt.getBadStatementHighlightingElement(suspiciousStatement);
    }

    static {
        Object[] objectArray = new String[]{"buildscript", "pluginManagement", "plugins"};
        allowedStrings = SetsKt.setOf((Object[])objectArray);
    }
}

