/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.ui;

import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.content.Content;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.TtyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;

public final class TerminalContainer {
    private static final Logger LOG = Logger.getInstance(TerminalContainer.class);
    @ApiStatus.Internal
    @NotNull
    public static final DataKey<TerminalWidget> TERMINAL_WIDGET_DATA_KEY = DataKey.create((String)"terminalWidget");
    private final Content myContent;
    private final TerminalWidget myTerminalWidget;
    private final Project myProject;
    private final TerminalToolWindowManager myTerminalToolWindowManager;
    @Nullable
    private TerminalWrapperPanel myWrapperPanel;
    private boolean myForceHideUiWhenSessionEnds;

    public TerminalContainer(@NotNull Project project, @NotNull Content content, @NotNull TerminalWidget terminalWidget, @NotNull TerminalToolWindowManager terminalToolWindowManager) {
        if (project == null) {
            TerminalContainer.$$$reportNull$$$0(0);
        }
        if (content == null) {
            TerminalContainer.$$$reportNull$$$0(1);
        }
        if (terminalWidget == null) {
            TerminalContainer.$$$reportNull$$$0(2);
        }
        if (terminalToolWindowManager == null) {
            TerminalContainer.$$$reportNull$$$0(3);
        }
        this.myForceHideUiWhenSessionEnds = false;
        this.myProject = project;
        this.myContent = content;
        this.myTerminalWidget = terminalWidget;
        this.myTerminalToolWindowManager = terminalToolWindowManager;
        terminalWidget.addTerminationCallback(() -> ApplicationManager.getApplication().invokeLater(() -> this.processSessionCompleted(), this.myProject.getDisposed()), (Disposable)terminalWidget);
        terminalToolWindowManager.register(this);
        Disposer.register((Disposable)content, () -> this.cleanup());
    }

    @NotNull
    public TerminalWidget getTerminalWidget() {
        TerminalWidget terminalWidget = this.myTerminalWidget;
        if (terminalWidget == null) {
            TerminalContainer.$$$reportNull$$$0(4);
        }
        return terminalWidget;
    }

    @NotNull
    public Content getContent() {
        Content content = this.myContent;
        if (content == null) {
            TerminalContainer.$$$reportNull$$$0(5);
        }
        return content;
    }

    public void closeAndHide() {
        this.myForceHideUiWhenSessionEnds = true;
        TtyConnector connector = this.myTerminalWidget.getTtyConnector();
        if (connector != null && connector.isConnected()) {
            connector.close();
        } else {
            this.processSessionCompleted();
        }
    }

    @NotNull
    public TerminalWrapperPanel getWrapperPanel() {
        if (this.myWrapperPanel == null) {
            this.myWrapperPanel = new TerminalWrapperPanel(this);
        }
        TerminalWrapperPanel terminalWrapperPanel = this.myWrapperPanel;
        if (terminalWrapperPanel == null) {
            TerminalContainer.$$$reportNull$$$0(6);
        }
        return terminalWrapperPanel;
    }

    public void split(boolean vertically, @NotNull TerminalWidget newTerminalWidget) {
        if (newTerminalWidget == null) {
            TerminalContainer.$$$reportNull$$$0(7);
        }
        boolean hasFocus = this.myTerminalWidget.hasFocus();
        TerminalWrapperPanel newParent = this.getWrapperPanel();
        this.myWrapperPanel = new TerminalWrapperPanel(this);
        TerminalContainer newContainer = new TerminalContainer(this.myProject, this.myContent, newTerminalWidget, this.myTerminalToolWindowManager);
        Splitter splitter = TerminalContainer.createSplitter(vertically, this.myWrapperPanel, newContainer.getWrapperPanel());
        newParent.setChildSplitter(splitter);
        if (hasFocus) {
            this.myTerminalWidget.requestFocus();
        }
    }

    @NotNull
    private static Splitter createSplitter(boolean vertically, @NotNull JComponent firstComponent, @NotNull JComponent secondComponent) {
        if (firstComponent == null) {
            TerminalContainer.$$$reportNull$$$0(8);
        }
        if (secondComponent == null) {
            TerminalContainer.$$$reportNull$$$0(9);
        }
        OnePixelSplitter splitter = new OnePixelSplitter(vertically, 0.5f, 0.1f, 0.9f);
        splitter.setDividerWidth(JBUI.scale((int)1));
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        Color color = scheme.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
        if (color != null) {
            splitter.getDivider().setBackground(color);
        }
        splitter.setFirstComponent(firstComponent);
        splitter.setSecondComponent(secondComponent);
        OnePixelSplitter onePixelSplitter = splitter;
        if (onePixelSplitter == null) {
            TerminalContainer.$$$reportNull$$$0(10);
        }
        return onePixelSplitter;
    }

    private void processSessionCompleted() {
        TerminalWrapperPanel thisPanel = this.getWrapperPanel();
        Container container = thisPanel.getParent();
        if (container instanceof Splitter) {
            Splitter splitter = (Splitter)container;
            TerminalWidget nextToFocus = this.myTerminalWidget.hasFocus() ? this.getNextSplitTerminal(true) : null;
            TerminalWrapperPanel parent = TerminalContainer.getSplitterParent(splitter);
            TerminalWrapperPanel otherPanel = splitter.getFirstComponent().equals(thisPanel) ? (TerminalWrapperPanel)splitter.getSecondComponent() : (TerminalWrapperPanel)splitter.getFirstComponent();
            parent.transferChildFrom(otherPanel);
            if (nextToFocus != null) {
                nextToFocus.requestFocus();
            }
            this.cleanup();
            Disposer.dispose((Disposable)this.myTerminalWidget);
        } else {
            this.processSingleTerminalCompleted();
        }
    }

    private void cleanup() {
        this.myTerminalToolWindowManager.unregister(this);
    }

    private void processSingleTerminalCompleted() {
        if (this.myForceHideUiWhenSessionEnds || TerminalOptionsProvider.getInstance().getCloseSessionOnLogout()) {
            this.myTerminalToolWindowManager.closeTab(this.myContent);
        } else {
            String text = TerminalContainer.getSessionCompletedMessage(this.myTerminalWidget);
            this.myTerminalWidget.writePlainMessage("\n" + text + "\n");
            this.myTerminalWidget.setCursorVisible(false);
        }
    }

    @NotNull
    @Nls
    private static String getSessionCompletedMessage(@NotNull TerminalWidget widget) {
        if (widget == null) {
            TerminalContainer.$$$reportNull$$$0(11);
        }
        String text = "[" + TerminalBundle.message("session.terminated.text", new Object[0]) + "]";
        ProcessTtyConnector connector = ShellTerminalWidget.getProcessTtyConnector(widget.getTtyConnector());
        if (connector != null) {
            Integer exitCode = null;
            try {
                exitCode = connector.getProcess().exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
            String string = text + "\n[" + IdeCoreBundle.message((String)"finished.with.exit.code.text.message", (Object[])new Object[]{exitCode != null ? exitCode : "unknown"}) + "]";
            if (string == null) {
                TerminalContainer.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            TerminalContainer.$$$reportNull$$$0(13);
        }
        return string;
    }

    public boolean isSplitTerminal() {
        return TerminalContainer.getParentSplitter(this.myWrapperPanel) != null;
    }

    @Nullable
    public TerminalWidget getNextSplitTerminal(boolean forward) {
        List<TerminalWidget> terminals = this.listTerminals();
        int ind = terminals.indexOf(this.myTerminalWidget);
        if (ind < 0) {
            LOG.error("All split terminal list (" + terminals.size() + ") doesn't contain this terminal");
            return null;
        }
        if (terminals.size() == 1) {
            return null;
        }
        int newInd = (ind + (forward ? 1 : terminals.size() - 1)) % terminals.size();
        return terminals.get(newInd);
    }

    @NotNull
    private List<TerminalWidget> listTerminals() {
        Splitter rootSplitter = this.findRootSplitter();
        if (rootSplitter == null) {
            List<TerminalWidget> list = List.of(this.myTerminalWidget);
            if (list == null) {
                TerminalContainer.$$$reportNull$$$0(14);
            }
            return list;
        }
        ArrayList<TerminalWidget> terminals = new ArrayList<TerminalWidget>();
        this.traverseSplitters(rootSplitter, terminals);
        ArrayList<TerminalWidget> arrayList = terminals;
        if (arrayList == null) {
            TerminalContainer.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private void traverseSplitters(@NotNull Splitter splitter, @NotNull List<TerminalWidget> terminals) {
        if (splitter == null) {
            TerminalContainer.$$$reportNull$$$0(16);
        }
        if (terminals == null) {
            TerminalContainer.$$$reportNull$$$0(17);
        }
        this.traverseWrapperPanel((TerminalWrapperPanel)splitter.getFirstComponent(), terminals);
        this.traverseWrapperPanel((TerminalWrapperPanel)splitter.getSecondComponent(), terminals);
    }

    private void traverseWrapperPanel(@NotNull TerminalWrapperPanel panel, @NotNull List<TerminalWidget> terminals) {
        Object child;
        if (panel == null) {
            TerminalContainer.$$$reportNull$$$0(18);
        }
        if (terminals == null) {
            TerminalContainer.$$$reportNull$$$0(19);
        }
        if ((child = panel.validateAndGetChild()) instanceof Splitter) {
            Splitter splitter = (Splitter)child;
            this.traverseSplitters(splitter, terminals);
        } else {
            terminals.add(((TerminalContainer)child).myTerminalWidget);
        }
    }

    @Nullable
    private Splitter findRootSplitter() {
        Splitter parentSplitter;
        Splitter splitter = TerminalContainer.getParentSplitter(this.myWrapperPanel);
        while (splitter != null && (parentSplitter = TerminalContainer.getParentSplitter(TerminalContainer.getSplitterParent(splitter))) != null) {
            splitter = parentSplitter;
        }
        return splitter;
    }

    @Nullable
    private static Splitter getParentSplitter(@Nullable TerminalWrapperPanel panel) {
        return panel != null ? (Splitter)ObjectUtils.tryCast((Object)panel.getParent(), Splitter.class) : null;
    }

    @NotNull
    private static TerminalWrapperPanel getSplitterParent(@NotNull Splitter splitter) {
        if (splitter == null) {
            TerminalContainer.$$$reportNull$$$0(20);
        }
        TerminalWrapperPanel terminalWrapperPanel = (TerminalWrapperPanel)splitter.getParent();
        if (terminalWrapperPanel == null) {
            TerminalContainer.$$$reportNull$$$0(21);
        }
        return terminalWrapperPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 10, 12, 13, 14, 15, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalWidget";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalToolWindowManager";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/ui/TerminalContainer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTerminalWidget";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstComponent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondComponent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widget";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitter";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminals";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/ui/TerminalContainer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalWidget";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrapperPanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createSplitter";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionCompletedMessage";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "listTerminals";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSplitterParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createSplitter";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSessionCompletedMessage";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "traverseSplitters";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "traverseWrapperPanel";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSplitterParent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 10, 12, 13, 14, 15, 21 -> new IllegalStateException(string);
        };
    }

    private static final class TerminalWrapperPanel
    extends JPanel
    implements UiDataProvider {
        private TerminalContainer myTerminal;

        private TerminalWrapperPanel(@NotNull TerminalContainer terminal) {
            if (terminal == null) {
                TerminalWrapperPanel.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            this.setBorder(null);
            this.setFocusable(false);
            this.setChildTerminal(terminal);
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                TerminalWrapperPanel.$$$reportNull$$$0(1);
            }
            if (this.myTerminal != null) {
                sink.set(TERMINAL_WIDGET_DATA_KEY, (Object)this.myTerminal.getTerminalWidget());
            }
        }

        private void setChildTerminal(@NotNull TerminalContainer terminal) {
            if (terminal == null) {
                TerminalWrapperPanel.$$$reportNull$$$0(2);
            }
            if (this.myTerminal != null) {
                throw new IllegalStateException("Cannot set a new terminal when another terminal is still set");
            }
            this.myTerminal = terminal;
            this.myTerminal.myWrapperPanel = this;
            this.setChildComponent(terminal.myTerminalWidget.getComponent());
        }

        private void setChildSplitter(@NotNull Splitter splitter) {
            if (splitter == null) {
                TerminalWrapperPanel.$$$reportNull$$$0(3);
            }
            this.myTerminal = null;
            this.setChildComponent((Component)splitter);
        }

        private void setChildComponent(@NotNull Component childComponent) {
            Container parent;
            if (childComponent == null) {
                TerminalWrapperPanel.$$$reportNull$$$0(4);
            }
            if ((parent = childComponent.getParent()) != null) {
                parent.remove(childComponent);
            }
            this.removeAll();
            this.add(childComponent, "Center");
            this.revalidate();
        }

        private void transferChildFrom(@NotNull TerminalWrapperPanel other) {
            Object childObj;
            if (other == null) {
                TerminalWrapperPanel.$$$reportNull$$$0(5);
            }
            if ((childObj = other.validateAndGetChild()) instanceof TerminalContainer) {
                TerminalContainer otherTerminal = (TerminalContainer)childObj;
                this.setChildTerminal(otherTerminal);
            } else {
                this.setChildSplitter((Splitter)childObj);
            }
        }

        @NotNull
        private Object validateAndGetChild() {
            Object[] children = this.getComponents();
            if (children.length != 1) {
                throw new IllegalStateException("Expected 1 child, but got " + children.length + ": " + Arrays.toString(children));
            }
            Component child = Objects.requireNonNull(children[0]);
            if (this.myTerminal != null) {
                if (child == this.myTerminal.myTerminalWidget.getComponent()) {
                    TerminalContainer terminalContainer = this.myTerminal;
                    if (terminalContainer == null) {
                        TerminalWrapperPanel.$$$reportNull$$$0(6);
                    }
                    return terminalContainer;
                }
                throw new IllegalStateException("Expected terminal widget (" + this.myTerminal.myTerminalWidget.getComponent() + "), got " + child);
            }
            if (child instanceof Splitter) {
                Splitter splitter;
                Splitter splitter2 = splitter = (Splitter)child;
                if (splitter2 == null) {
                    TerminalWrapperPanel.$$$reportNull$$$0(7);
                }
                return splitter2;
            }
            throw new IllegalStateException("Expected splitter, got " + child);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "terminal";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "splitter";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childComponent";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/terminal/ui/TerminalContainer$TerminalWrapperPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/terminal/ui/TerminalContainer$TerminalWrapperPanel";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "validateAndGetChild";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setChildTerminal";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setChildSplitter";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setChildComponent";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "transferChildFrom";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7 -> new IllegalStateException(string);
            };
        }
    }
}

