/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.importWizard;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.projectImport.SelectImportedProjectsStep;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.EclipseBundle;
import org.jetbrains.idea.eclipse.EclipseProjectFinder;
import org.jetbrains.idea.eclipse.importWizard.EclipseImportBuilder;
import org.jetbrains.idea.eclipse.util.PathUtil;

class SelectEclipseImportedProjectsStep
extends SelectImportedProjectsStep<String> {
    Set<@NlsSafe String> duplicateNames;

    SelectEclipseImportedProjectsStep(WizardContext context) {
        super(context);
        this.fileChooser.addElementsMarkListener((ElementsChooser.ElementsMarkListener)new ElementsChooser.ElementsMarkListener<String>(){

            public void elementMarkChanged(String element, boolean isMarked) {
                SelectEclipseImportedProjectsStep.this.duplicateNames = null;
                SelectEclipseImportedProjectsStep.this.fileChooser.repaint();
            }
        });
    }

    private boolean isInConflict(String item) {
        this.calcDuplicates();
        return this.fileChooser.getMarkedElements().contains(item) && this.duplicateNames.contains(EclipseProjectFinder.findProjectName((String)item));
    }

    private void calcDuplicates() {
        if (this.duplicateNames == null) {
            this.duplicateNames = new HashSet<String>();
            HashSet<String> usedNames = new HashSet<String>();
            for (String model : this.fileChooser.getMarkedElements()) {
                String projectName = EclipseProjectFinder.findProjectName((String)model);
                if (usedNames.add(projectName)) continue;
                this.duplicateNames.add(projectName);
            }
        }
    }

    protected String getElementText(String item) {
        StringBuilder stringBuilder = new StringBuilder();
        String projectName = EclipseProjectFinder.findProjectName((String)item);
        stringBuilder.append(projectName);
        String relPath = PathUtil.getRelative(((EclipseImportBuilder)this.getBuilder()).getParameters().root, item);
        if (!relPath.equals(".") && !relPath.equals(projectName)) {
            stringBuilder.append(" (").append(relPath).append(")");
        }
        return stringBuilder.toString();
    }

    @Nullable
    protected Icon getElementIcon(String item) {
        return this.isInConflict(item) ? AllIcons.Actions.Cancel : null;
    }

    public void updateStep() {
        super.updateStep();
        this.duplicateNames = null;
    }

    public boolean validate() throws ConfigurationException {
        this.calcDuplicates();
        if (!this.duplicateNames.isEmpty()) {
            throw new ConfigurationException(EclipseBundle.message("duplicate.names.found.import.error.message", StringUtil.join(this.duplicateNames, (String)",")), EclipseBundle.message("unable.to.proceed.import.title", new Object[0]));
        }
        return super.validate();
    }

    public String getName() {
        return EclipseBundle.message("eclipse.projects.to.import.selection.step.name", new Object[0]);
    }

    @NonNls
    public String getHelpId() {
        return "reference.dialogs.new.project.import.eclipse.page2";
    }
}

