/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage.dataTypes;

import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.StorageOwner;
import org.jetbrains.jps.javac.Iterators;

@ApiStatus.Internal
public class LibraryRoots
implements StorageOwner {
    private static final Logger LOG = Logger.getInstance(LibraryRoots.class);
    private static final String LIBRARY_ROOTS_FILE_NAME = "libraries.dat";
    private static final String TIMESTAMP_DELIMITER = ": ";
    @NotNull
    private final Path myFile;
    @NotNull
    private final PathRelativizerService myRelativizer;
    private Map<Path, RootData> myRoots;
    private boolean myChanged;

    public LibraryRoots(BuildDataPaths dataPaths, @NotNull PathRelativizerService relativizer) {
        if (relativizer == null) {
            LibraryRoots.$$$reportNull$$$0(0);
        }
        this.myChanged = false;
        this.myFile = dataPaths.getDataStorageDir().resolve(LIBRARY_ROOTS_FILE_NAME);
        this.myRelativizer = relativizer;
    }

    public synchronized Set<Path> getRoots(Set<Path> acc) {
        acc.addAll(this.getLibraryRoots().keySet());
        return acc;
    }

    public synchronized boolean remove(Path root) {
        boolean changed = this.getLibraryRoots().remove(root) != null;
        this.myChanged |= changed;
        return changed;
    }

    public synchronized boolean update(Path root, String namespace, long stamp) {
        RootData update = RootData.create(namespace, stamp);
        boolean changed = !update.equals(this.getLibraryRoots().put(root, update));
        this.myChanged |= changed;
        return changed;
    }

    @Nullable
    public synchronized String getNamespace(Path root) {
        RootData rootData = this.getLibraryRoots().get(root);
        return rootData != null ? rootData.namespace : null;
    }

    @Override
    public synchronized void clean() throws IOException {
        this.cleanState();
        Files.deleteIfExists(this.myFile);
    }

    @Override
    public synchronized void flush(boolean memoryCachesOnly) {
    }

    @Override
    public synchronized void close() throws IOException {
        this.storeLibraryRoots(false);
    }

    private Map<Path, RootData> getLibraryRoots() {
        Map<Path, RootData> roots = this.myRoots;
        if (roots != null) {
            return roots;
        }
        this.myRoots = roots = new HashMap<Path, RootData>();
        try (Stream<String> lines2 = Files.lines(this.myFile);){
            for (String line : lines2.collect(Collectors.toList())) {
                int idx = line.indexOf(TIMESTAMP_DELIMITER);
                if (idx <= 0) continue;
                long stamp = Long.parseLong(line.substring(0, idx));
                int idx2 = line.indexOf(TIMESTAMP_DELIMITER, idx + TIMESTAMP_DELIMITER.length());
                if (idx2 <= 0) continue;
                String libName = line.substring(idx + TIMESTAMP_DELIMITER.length(), idx2);
                String path = line.substring(idx2 + TIMESTAMP_DELIMITER.length());
                roots.put(Path.of(this.myRelativizer.toFull(path), new String[0]), RootData.create(libName, stamp));
            }
        }
        catch (NoSuchFileException lines2) {
        }
        catch (IOException ex) {
            LOG.warn("Error loading library roots data ", (Throwable)ex);
        }
        return roots;
    }

    private void storeLibraryRoots(boolean keepMemoryData) throws IOException {
        Map<Path, RootData> roots = this.myRoots;
        if (roots == null) {
            return;
        }
        try {
            if (this.myChanged) {
                if (roots.isEmpty()) {
                    Files.deleteIfExists(this.myFile);
                } else {
                    Files.createDirectories(this.myFile.getParent(), new FileAttribute[0]);
                    Files.write(this.myFile, (Iterable<? extends CharSequence>)Iterators.map(roots.entrySet(), entry -> String.join((CharSequence)TIMESTAMP_DELIMITER, Long.toString(((RootData)entry.getValue()).stamp), ((RootData)entry.getValue()).namespace, this.myRelativizer.toRelative((Path)entry.getKey()))), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                }
            }
        }
        finally {
            if (keepMemoryData) {
                this.myChanged = false;
            } else {
                this.cleanState();
            }
        }
    }

    private void cleanState() {
        Map<Path, RootData> roots = this.myRoots;
        if (roots != null) {
            this.myRoots = null;
            this.myChanged = false;
            roots.clear();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativizer", "org/jetbrains/jps/incremental/storage/dataTypes/LibraryRoots", "<init>"));
    }

    private static final class RootData {
        @NotNull
        final String namespace;
        final long stamp;

        private RootData(@NotNull String namespace, long stamp) {
            if (namespace == null) {
                RootData.$$$reportNull$$$0(0);
            }
            this.namespace = namespace;
            this.stamp = stamp;
        }

        static RootData create(@NotNull String name, long stamp) {
            if (name == null) {
                RootData.$$$reportNull$$$0(1);
            }
            return new RootData(name, stamp);
        }

        public boolean equals(Object o) {
            if (!(o instanceof RootData)) {
                return false;
            }
            RootData rootData = (RootData)o;
            return this.stamp == rootData.stamp && this.namespace.equals(rootData.namespace);
        }

        public int hashCode() {
            int result = this.namespace.hashCode();
            result = 31 * result + Long.hashCode(this.stamp);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/incremental/storage/dataTypes/LibraryRoots$RootData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

