/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.dynatrace.hash4j.hashing.HashSink;
import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.Hashing;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ArrayUtilRt;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.cache.model.BuildTargetState;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BuildListener;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FileHashUtil;
import org.jetbrains.jps.incremental.IncProjectBuilder;
import org.jetbrains.jps.incremental.messages.FileDeletedEvent;
import org.jetbrains.jps.incremental.messages.FileGeneratedEvent;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.incremental.storage.HashStamp;
import org.jetbrains.jps.incremental.storage.HashStampStorage;
import org.jetbrains.jps.incremental.storage.ProjectStamps;
import org.jetbrains.jps.incremental.storage.StampsStorage;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaProjectExtension;
import org.jetbrains.jps.service.SharedThreadPool;
import org.jetbrains.jps.util.JpsPathUtil;

@ApiStatus.Experimental
@ApiStatus.Internal
public final class BuildTargetSourcesState
implements BuildListener {
    private static final Logger LOG = Logger.getInstance(BuildTargetSourcesState.class);
    public static final String TARGET_SOURCES_STATE_FILE_NAME = "target_sources_state.json";
    private final ExecutorService parallelBuildExecutor;
    private final Map<String, BuildTarget<?>> changedBuildTargets;
    private final Map<String, Long> calculatedHashes;
    private final BuildTargetIndex buildTargetIndex;
    private final BuildRootIndex buildRootIndex;
    private final BuildDataManager dataManager;
    private final CompileContext context;
    private final String outputFolderPath;
    private final Path targetStateStorage;

    public BuildTargetSourcesState(@NotNull CompileContext context) {
        if (context == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(0);
        }
        this.parallelBuildExecutor = SharedThreadPool.getInstance().createBoundedExecutor("TargetSourcesState Executor Pool", IncProjectBuilder.MAX_BUILDER_THREADS);
        this.changedBuildTargets = new ConcurrentHashMap();
        this.calculatedHashes = new ConcurrentHashMap<String, Long>();
        this.context = context;
        ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
        this.dataManager = projectDescriptor.dataManager;
        this.buildRootIndex = projectDescriptor.getBuildRootIndex();
        this.buildTargetIndex = projectDescriptor.getBuildTargetIndex();
        this.outputFolderPath = BuildTargetSourcesState.getOutputFolderPath(projectDescriptor.getProject());
        this.targetStateStorage = this.dataManager.getDataPaths().getDataStorageDir().resolve(TARGET_SOURCES_STATE_FILE_NAME);
        context.addBuildListener(this);
    }

    public void reportSourcesState() {
        List<Future> result;
        List<BuildTarget<?>> buildTargets;
        if (BuildTargetSourcesState.reportStateUnavailable()) {
            return;
        }
        long start = System.nanoTime();
        Map<String, Map<String, BuildTargetState>> targetTypeHashMap = this.loadCurrentTargetState();
        if (targetTypeHashMap.isEmpty()) {
            buildTargets = this.buildTargetIndex.getAllTargets();
        } else {
            ArrayList changedBuildTargets = new ArrayList(this.changedBuildTargets.values());
            LOG.info("List of changed build targets: " + changedBuildTargets);
            buildTargets = changedBuildTargets;
        }
        if (buildTargets.isEmpty()) {
            result = Collections.emptyList();
        } else {
            PathRelativizerService relativizer = this.dataManager.getRelativizer();
            ArrayList<Future> list = new ArrayList<Future>(buildTargets.size());
            for (BuildTarget<?> t : buildTargets) {
                list.add(this.parallelBuildExecutor.submit(() -> {
                    String targetTypeId = t.getTargetType().getTypeId();
                    long buildTargetHash = this.getBuildTargetHash(t, this.context);
                    String relativePath = "";
                    Iterator<File> iterator = t.getOutputRoots(this.context).iterator();
                    if (iterator.hasNext()) {
                        File file = iterator.next();
                        relativePath = relativizer.toRelative(file.getAbsolutePath());
                    }
                    iterator = targetTypeHashMap;
                    synchronized (iterator) {
                        targetTypeHashMap.computeIfAbsent(targetTypeId, key -> new HashMap()).put(t.getId(), new BuildTargetState(buildTargetHash, relativePath));
                    }
                }));
            }
            result = list;
        }
        for (Future future : result) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.warn("Unable to get the result from future", (Throwable)e);
            }
        }
        this.clearRemovedBuildTargets(targetTypeHashMap);
        try {
            Files.createDirectories(this.targetStateStorage.getParent(), new FileAttribute[0]);
            try (JsonWriter writer = new JsonWriter((Writer)Files.newBufferedWriter(this.targetStateStorage, new OpenOption[0]));){
                BuildTargetSourcesState.writeJson(writer, targetTypeHashMap);
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to save sources state", (Throwable)e);
        }
        LOG.info("Build target sources report took: " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + " ms");
    }

    private void clearRemovedBuildTargets(Map<String, Map<String, BuildTargetState>> targetsMap) {
        HashMap<String, List> allTargets = new HashMap<String, List>();
        for (BuildTarget<?> buildTarget : this.buildTargetIndex.getAllTargets()) {
            String id = buildTarget.getId();
            allTargets.computeIfAbsent(buildTarget.getTargetType().getTypeId(), k -> new ArrayList()).add(id);
        }
        targetsMap.keySet().removeIf(targetTypeId -> !allTargets.containsKey(targetTypeId));
        for (Map.Entry entry : targetsMap.entrySet()) {
            String targetTypeId2 = (String)entry.getKey();
            Map targetStates = (Map)entry.getValue();
            targetStates.keySet().removeIf(targetId -> !((List)allTargets.get(targetTypeId2)).contains(targetId));
        }
    }

    public void clearSourcesState() {
        if (BuildTargetSourcesState.reportStateUnavailable()) {
            return;
        }
        if (Files.exists(this.targetStateStorage, new LinkOption[0])) {
            try {
                if (Files.deleteIfExists(this.targetStateStorage)) {
                    LOG.info("Clear build target sources report");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void filesGenerated(@NotNull FileGeneratedEvent event) {
        if (event == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(1);
        }
        if (BuildTargetSourcesState.reportStateUnavailable()) {
            return;
        }
        BuildTarget<?> sourceTarget = event.getSourceTarget();
        String key = sourceTarget.getTargetType().getTypeId() + " " + sourceTarget.getId();
        this.changedBuildTargets.put(key, sourceTarget);
    }

    @Override
    public void filesDeleted(@NotNull FileDeletedEvent event) {
        if (event == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(2);
        }
        if (BuildTargetSourcesState.reportStateUnavailable()) {
            return;
        }
        for (String path : event.getFilePaths()) {
            File file = new File(FileUtilRt.toSystemDependentName((String)path));
            Collection collection = this.buildRootIndex.findAllParentDescriptors(file, this.context);
            for (BuildRootDescriptor buildRootDesc : collection) {
                BuildTarget<?> target = buildRootDesc.getTarget();
                String key = target.getTargetType().getTypeId() + target.getId();
                this.changedBuildTargets.put(key, target);
            }
        }
    }

    private void compilationOutputHash(final @NotNull Path rootFile, @NotNull BuildTarget<?> target, final @NotNull LongArrayList hash, final @NotNull HashStream64 hashToReuse) {
        if (rootFile == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(3);
        }
        if (target == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(4);
        }
        if (hash == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(5);
        }
        if (hashToReuse == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(6);
        }
        try {
            if (Files.notExists(rootFile, new LinkOption[0])) {
                return;
            }
            Files.walkFileTree(rootFile, Set.of(), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String filePathString = file.toString();
                    if (filePathString.endsWith(".class")) {
                        long outputFileHash;
                        Long calculatedHash = BuildTargetSourcesState.this.calculatedHashes.get(filePathString);
                        if (calculatedHash == null) {
                            outputFileHash = BuildTargetSourcesState.getOutputFileHash(file, rootFile, hashToReuse);
                            BuildTargetSourcesState.this.calculatedHashes.put(filePathString, outputFileHash);
                        } else {
                            outputFileHash = calculatedHash;
                        }
                        hash.add(outputFileHash);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LOG.warn("Couldn't calculate build target hash for : " + target.getPresentableName(), (Throwable)e);
        }
    }

    private void sourceRootHash(final @NotNull BuildRootDescriptor rootDescriptor, @NotNull BuildTarget<?> target, final @NotNull LongArrayList hash, final @NotNull HashStream64 hashToReuse) {
        if (rootDescriptor == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(7);
        }
        if (target == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(8);
        }
        if (hash == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(9);
        }
        if (hashToReuse == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(10);
        }
        try {
            final Path rootFile = rootDescriptor.getFile();
            if (Files.notExists(rootFile, new LinkOption[0]) || rootFile.toAbsolutePath().startsWith(this.outputFolderPath)) {
                return;
            }
            StampsStorage<?> stStorage = this.dataManager.getFileStampStorage(target);
            if (stStorage instanceof HashStampStorage) {
                final HashStampStorage stampStorage = (HashStampStorage)stStorage;
                Files.walkFileTree(rootFile, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        return BuildTargetSourcesState.this.buildRootIndex.isDirectoryAccepted(dir, rootDescriptor) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                        if (!BuildTargetSourcesState.this.buildRootIndex.isFileAccepted(path, rootDescriptor)) {
                            return FileVisitResult.CONTINUE;
                        }
                        BuildTargetSourcesState.getFileHash(path, rootFile, hash, hashToReuse, stampStorage);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (IOException e) {
            LOG.warn("Couldn't calculate build target hash for : " + target.getPresentableName(), (Throwable)e);
        }
    }

    private long getBuildTargetHash(@NotNull BuildTarget<?> target, @NotNull CompileContext context) {
        if (target == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(11);
        }
        if (context == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(12);
        }
        LongArrayList hash = new LongArrayList();
        HashStream64 hashToReuse = Hashing.komihash5_0().hashStream();
        for (File file : target.getOutputRoots(context)) {
            this.compilationOutputHash(file.toPath(), target, hash, hashToReuse);
        }
        for (BuildRootDescriptor buildRootDescriptor : this.buildRootIndex.getTargetRoots(target, context)) {
            this.sourceRootHash(buildRootDescriptor, target, hash, hashToReuse);
        }
        hash.sort(null);
        return hashToReuse.reset().putLongs(hash.elements(), 0, hash.size()).putInt(hash.size()).getAsLong();
    }

    private static void getFileHash(@NotNull Path path, @NotNull Path rootFile, @NotNull LongArrayList hash, @NotNull HashStream64 hashToReuse, @NotNull HashStampStorage stampStorage) {
        HashStamp stamp;
        if (path == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(13);
        }
        if (rootFile == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(14);
        }
        if (hash == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(15);
        }
        if (hashToReuse == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(16);
        }
        if (stampStorage == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(17);
        }
        if ((stamp = stampStorage.getStoredFileStamp(path)) == null) {
            return;
        }
        String relativePath = BuildTargetSourcesState.toRelative(path, rootFile);
        if (relativePath.isEmpty()) {
            return;
        }
        hash.add(hashToReuse.reset().putLong(stamp.hash).putString(relativePath).getAsLong());
    }

    private static long getOutputFileHash(@NotNull Path file, @NotNull Path rootPath, @NotNull HashStream64 hashToReuse) throws IOException {
        if (file == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(18);
        }
        if (rootPath == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(19);
        }
        if (hashToReuse == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(20);
        }
        FileHashUtil.getFileHash(file, (HashSink)hashToReuse.reset());
        long fileHash = hashToReuse.getAsLong();
        return hashToReuse.reset().putLong(fileHash).putString(BuildTargetSourcesState.toRelative(file, rootPath)).getAsLong();
    }

    /*
     * Loose catch block
     */
    @NotNull
    private Map<String, Map<String, BuildTargetState>> loadCurrentTargetState() {
        Map<String, Map<String, BuildTargetState>> map;
        BufferedReader reader2222;
        block10: {
            reader2222 = Files.newBufferedReader(this.targetStateStorage);
            map = BuildTargetSourcesState.readJson(new JsonReader((Reader)reader2222));
            if (reader2222 == null) break block10;
            reader2222.close();
        }
        Map<String, Map<String, BuildTargetState>> map2 = map;
        if (map2 == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(21);
        }
        return map2;
        {
            catch (Throwable throwable) {
                try {
                    if (reader2222 != null) {
                        try {
                            reader2222.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException reader2222) {
                }
                catch (Throwable e) {
                    LOG.warn("Couldn't parse current build target state", e);
                }
            }
        }
        return new HashMap<String, Map<String, BuildTargetState>>();
    }

    private static boolean reportStateUnavailable() {
        return !ProjectStamps.PORTABLE_CACHES;
    }

    @NotNull
    private static String toRelative(@NotNull Path target, @NotNull Path rootPath) {
        if (target == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(22);
        }
        if (rootPath == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(23);
        }
        String string = FileUtilRt.toSystemIndependentName((String)rootPath.relativize(target).toString());
        if (string == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private static String getOutputFolderPath(JpsProject project) {
        JpsJavaProjectExtension projectExtension = JpsJavaExtensionService.getInstance().getProjectExtension(project);
        if (projectExtension == null) {
            return "";
        }
        String url = projectExtension.getOutputUrl();
        if (url == null || url.isEmpty()) {
            return "";
        }
        String string = JpsPathUtil.urlToFile((String)url).getAbsolutePath();
        if (string == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    public static Map<String, Map<String, BuildTargetState>> readJson(JsonReader reader) throws IOException {
        reader.beginObject();
        HashMap<String, Map<String, BuildTargetState>> result = new HashMap<String, Map<String, BuildTargetState>>();
        while (reader.hasNext()) {
            String category = reader.nextName();
            reader.beginObject();
            HashMap<String, BuildTargetState> moduleNameToDescriptor = new HashMap<String, BuildTargetState>();
            while (reader.hasNext()) {
                String moduleName = reader.nextName();
                BuildTargetSourcesState.readModule(reader, moduleNameToDescriptor, moduleName);
                result.put(category, moduleNameToDescriptor);
            }
            reader.endObject();
        }
        reader.endObject();
        HashMap<String, Map<String, BuildTargetState>> hashMap = result;
        if (hashMap == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(26);
        }
        return hashMap;
    }

    private static void readModule(JsonReader reader, Map<String, BuildTargetState> moduleNameToDescriptor, String moduleName) throws IOException {
        reader.beginObject();
        long hash = -1L;
        boolean hasHash = false;
        String relativePath = null;
        block10: while (reader.hasNext()) {
            String propertyName;
            switch (propertyName = reader.nextName()) {
                case "relativePath": {
                    relativePath = reader.nextString();
                    continue block10;
                }
                case "h": {
                    hash = reader.nextLong();
                    hasHash = true;
                    continue block10;
                }
                case "hash": {
                    reader.skipValue();
                    continue block10;
                }
            }
            LOG.warn("Unknown property: " + propertyName);
            reader.skipValue();
        }
        reader.endObject();
        if (hasHash && relativePath != null) {
            moduleNameToDescriptor.put(moduleName, new BuildTargetState(hash, relativePath));
        }
    }

    @VisibleForTesting
    public static void writeJson(JsonWriter writer, Map<String, Map<String, BuildTargetState>> map) throws IOException {
        Object[] keys = ArrayUtilRt.toStringArray(map.keySet());
        Arrays.sort(keys);
        writer.beginObject();
        for (Object category : keys) {
            writer.name((String)category);
            Map<String, BuildTargetState> subMap = map.get(category);
            String[] modules = ArrayUtilRt.toStringArray(subMap.keySet());
            writer.beginObject();
            for (String module : modules) {
                writer.name(module);
                BuildTargetState state = subMap.get(module);
                writer.beginObject();
                writer.name("h").value(state.hash);
                writer.name("relativePath").value(state.relativePath);
                writer.endObject();
            }
            writer.endObject();
        }
        writer.endObject();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFile";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 6: 
            case 10: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashToReuse";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stampStorage";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 21: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/storage/BuildTargetSourcesState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/storage/BuildTargetSourcesState";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "loadCurrentTargetState";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "toRelative";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputFolderPath";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "readJson";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "filesGenerated";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "filesDeleted";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compilationOutputHash";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sourceRootHash";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getBuildTargetHash";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getFileHash";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getOutputFileHash";
                break;
            }
            case 21: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "toRelative";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

