/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.concurrency.ContextAwareRunnable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.Formats;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.tracing.Tracer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.FileCollectionFactory;
import com.intellij.util.containers.MultiMap;
import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.JpsBuildBundle;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.impl.BuildOutputConsumerImpl;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.builders.impl.DirtyFilesHolderBase;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.cmdline.BuildRunner;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BuildListener;
import org.jetbrains.jps.incremental.BuildOperations;
import org.jetbrains.jps.incremental.BuildTask;
import org.jetbrains.jps.incremental.Builder;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.BuilderRegistry;
import org.jetbrains.jps.incremental.ChainedTargetsBuildListener;
import org.jetbrains.jps.incremental.ChunkBuildOutputConsumerImpl;
import org.jetbrains.jps.incremental.CleanupTempDirectoryExtension;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompileContextImpl;
import org.jetbrains.jps.incremental.CompileScope;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.GlobalContextKey;
import org.jetbrains.jps.incremental.MessageHandler;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.RebuildRequestedException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.TargetTypeRegistry;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.fs.BuildFSState;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.incremental.fs.FilesDelta;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.BuildProgress;
import org.jetbrains.jps.incremental.messages.BuilderStatisticsMessage;
import org.jetbrains.jps.incremental.messages.BuildingTargetProgressMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.DoneSomethingNotification;
import org.jetbrains.jps.incremental.messages.FileDeletedEvent;
import org.jetbrains.jps.incremental.messages.FileGeneratedEvent;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.incremental.messages.UnprocessedFSChangesNotification;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.incremental.storage.BuildTargetConfiguration;
import org.jetbrains.jps.incremental.storage.BuildTargetSourcesState;
import org.jetbrains.jps.incremental.storage.BuildTargetStateManager;
import org.jetbrains.jps.incremental.storage.OneToManyPathMapping;
import org.jetbrains.jps.incremental.storage.OutputToTargetMapping;
import org.jetbrains.jps.incremental.storage.SourceToOutputMappingCursor;
import org.jetbrains.jps.incremental.storage.SourceToOutputMappingImpl;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.javac.ExternalJavacManager;
import org.jetbrains.jps.javac.ExternalJavacManagerKey;
import org.jetbrains.jps.javac.JavacMain;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.serialization.impl.TimingLog;
import org.jetbrains.jps.service.SharedThreadPool;
import org.jetbrains.jps.util.JpsPathUtil;

@ApiStatus.Internal
public final class IncProjectBuilder {
    private static final Logger LOG = Logger.getInstance(IncProjectBuilder.class);
    private static final MethodHandles.Lookup ourLookup = MethodHandles.lookup();
    private static final String CLASSPATH_INDEX_FILE_NAME = "classpath.index";
    private static final String UNMODIFIED_MARK_FILE_NAME = ".unmodified";
    private static final int FLUSH_INVOCATIONS_TO_SKIP = 10;
    private static final boolean SYNC_DELETE = Boolean.parseBoolean(System.getProperty("jps.sync.delete", "false"));
    private static final GlobalContextKey<Set<BuildTarget<?>>> TARGET_WITH_CLEARED_OUTPUT = GlobalContextKey.create("_targets_with_cleared_output_");
    public static final int MAX_BUILDER_THREADS;
    private final ProjectDescriptor myProjectDescriptor;
    private final BuilderRegistry myBuilderRegistry;
    private final Map<String, String> myBuilderParams;
    private final CanceledStatus myCancelStatus;
    private final List<MessageHandler> messageHandlers;
    private final MessageHandler myMessageDispatcher;
    private final boolean myIsTestMode;
    private final int myTotalModuleLevelBuilderCount;
    private final List<Future<?>> myAsyncTasks;
    private final ConcurrentMap<Builder, AtomicLong> myElapsedTimeNanosByBuilder;
    private final ConcurrentMap<Builder, AtomicInteger> myNumberOfSourcesProcessedByBuilder;

    public IncProjectBuilder(@NotNull ProjectDescriptor projectDescriptor, @NotNull BuilderRegistry builderRegistry, @NotNull Map<String, String> builderParams, @NotNull CanceledStatus canceledStatus, boolean isTestMode) {
        if (projectDescriptor == null) {
            IncProjectBuilder.$$$reportNull$$$0(0);
        }
        if (builderRegistry == null) {
            IncProjectBuilder.$$$reportNull$$$0(1);
        }
        if (builderParams == null) {
            IncProjectBuilder.$$$reportNull$$$0(2);
        }
        if (canceledStatus == null) {
            IncProjectBuilder.$$$reportNull$$$0(3);
        }
        this.messageHandlers = new ArrayList<MessageHandler>();
        this.myMessageDispatcher = message -> {
            for (MessageHandler h : this.messageHandlers) {
                h.processMessage(message);
            }
        };
        this.myAsyncTasks = Collections.synchronizedList(new ArrayList());
        this.myElapsedTimeNanosByBuilder = new ConcurrentHashMap<Builder, AtomicLong>();
        this.myNumberOfSourcesProcessedByBuilder = new ConcurrentHashMap<Builder, AtomicInteger>();
        this.myProjectDescriptor = projectDescriptor;
        this.myBuilderRegistry = builderRegistry;
        this.myBuilderParams = builderParams;
        this.myCancelStatus = canceledStatus;
        this.myTotalModuleLevelBuilderCount = builderRegistry.getModuleLevelBuilderCount();
        this.myIsTestMode = isTestMode;
    }

    public void addMessageHandler(MessageHandler handler) {
        this.messageHandlers.add(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkUpToDate(@NotNull CompileScope scope) {
        if (scope == null) {
            IncProjectBuilder.$$$reportNull$$$0(4);
        }
        CompileContextImpl context = this.createContext(scope);
        try {
            BuildFSState fsState = this.myProjectDescriptor.fsState;
            ExecutorService executor = SharedThreadPool.getInstance().createBoundedExecutor("IncProjectBuilder Check UpToDate Pool", MAX_BUILDER_THREADS);
            ArrayList tasks = new ArrayList();
            var notifier = new Object(){
                private final AtomicBoolean hasWorkToDo = new AtomicBoolean(false);

                boolean hasChanges() {
                    return this.hasWorkToDo.get();
                }

                void signalHasChanges() {
                    if (!this.hasWorkToDo.getAndSet(true)) {
                        IncProjectBuilder.this.myMessageDispatcher.processMessage(DoneSomethingNotification.INSTANCE);
                    }
                }
            };
            for (BuildTarget<?> buildTarget : this.myProjectDescriptor.getBuildTargetIndex().getAllTargets()) {
                if (notifier.hasChanges()) break;
                if (!scope.isAffected(buildTarget)) continue;
                tasks.add(executor.submit(() -> {
                    try {
                        if (notifier.hasChanges()) {
                            return;
                        }
                        if (context.getCancelStatus().isCanceled()) {
                            notifier.signalHasChanges();
                            return;
                        }
                        BuildOperations.ensureFSStateInitialized(context, target, true);
                        FilesDelta delta = fsState.getEffectiveFilesDelta(context, target);
                        delta.lockData();
                        try {
                            for (Set<Path> files : delta.getSourceSetsToRecompile()) {
                                for (Path file : files) {
                                    if (!scope.isAffected(target, file)) continue;
                                    notifier.signalHasChanges();
                                    return;
                                }
                            }
                        }
                        finally {
                            delta.unlockData();
                        }
                    }
                    catch (Throwable e) {
                        LOG.info(e);
                        notifier.signalHasChanges();
                    }
                }));
            }
            for (Future future : tasks) {
                try {
                    future.get();
                }
                catch (Throwable e) {
                    LOG.info(e);
                }
            }
        }
        finally {
            IncProjectBuilder.flushContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build(@NotNull CompileScope scope, boolean forceCleanCaches) throws RebuildRequestedException {
        if (scope == null) {
            IncProjectBuilder.$$$reportNull$$$0(5);
        }
        rebuildRequiredSpan = Tracer.start((String)"IncProjectBuilder.checkRebuildRequired");
        this.checkRebuildRequired(scope);
        rebuildRequiredSpan.complete();
        currentTasks = CleanupTempDirectoryExtension.getRunningCleanupTasks();
        if (!currentTasks.isEmpty()) {
            this.myAsyncTasks.addAll(currentTasks);
        } else {
            cleanupTask = CleanupTempDirectoryExtension.startTempDirectoryCleanupTask(this.myProjectDescriptor);
            if (cleanupTask != null) {
                this.myAsyncTasks.add(cleanupTask);
            }
        }
        dataManager = this.myProjectDescriptor.dataManager;
        memWatcher = LowMemoryWatcher.register((Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$build$2(org.jetbrains.jps.incremental.storage.BuildDataManager ), ()V)((BuildDataManager)dataManager));
        context = null;
        sourcesState = null;
        try {
            context = this.createContext(scope);
            sourcesState = new BuildTargetSourcesState(context);
            if (forceCleanCaches || JavaBuilderUtil.isForcedRecompilationAllJavaModules(context)) {
                sourcesState.clearSourcesState();
            }
            buildSpan = Tracer.start((String)"IncProjectBuilder.runBuild");
            this.runBuild(context, forceCleanCaches);
            buildSpan.complete();
            dataManager.saveVersion();
            dataManager.reportUnhandledRelativizerPaths();
            sourcesState.reportSourcesState();
            IncProjectBuilder.reportRebuiltModules(context);
            IncProjectBuilder.reportUnprocessedChanges(context);
        }
        catch (StopBuildException e) {
            block29: {
                IncProjectBuilder.reportRebuiltModules(context);
                IncProjectBuilder.reportUnprocessedChanges(context);
                sourcesState.reportSourcesState();
                message = e.getMessage();
                if (message == null || message.isBlank()) break block29;
                this.myMessageDispatcher.processMessage(new ProgressMessage(message));
            }
            finishingCompilationSpan = Tracer.start((String)"finishing compilation");
            memWatcher.stop();
            IncProjectBuilder.flushContext(context);
            status = context == null ? CanceledStatus.NULL : context.getCancelStatus();
            var11_21 = this.myAsyncTasks;
            synchronized (var11_21) {
                for (Future<?> task : this.myAsyncTasks) {
                    if (status.isCanceled()) break;
                    IncProjectBuilder.waitForTask(status, task);
                }
            }
            finishingCompilationSpan.complete();
            return;
            catch (BuildDataCorruptedException e) {
                IncProjectBuilder.LOG.info((Throwable)e);
                this.requestRebuild(e, e);
                finishingCompilationSpan = Tracer.start((String)"finishing compilation");
                memWatcher.stop();
                IncProjectBuilder.flushContext(context);
                status = context == null ? CanceledStatus.NULL : context.getCancelStatus();
                var11_22 = this.myAsyncTasks;
                synchronized (var11_22) {
                    for (Future<?> task : this.myAsyncTasks) {
                        if (status.isCanceled()) break;
                        IncProjectBuilder.waitForTask(status, task);
                    }
                }
                finishingCompilationSpan.complete();
                return;
                catch (ProjectBuildException e) {
                    block30: {
                        try {
                            IncProjectBuilder.LOG.info((Throwable)e);
                            cause = e.getCause();
                            if (cause instanceof IOException || cause instanceof BuildDataCorruptedException || cause instanceof RuntimeException && cause.getCause() instanceof IOException) {
                                this.requestRebuild(e, cause);
                                break block30;
                            }
                            this.myMessageDispatcher.processMessage(IncProjectBuilder.getCompilerMessage(e, cause));
                        }
                        catch (Throwable var18_32) {
                            finishingCompilationSpan = Tracer.start((String)"finishing compilation");
                            memWatcher.stop();
                            IncProjectBuilder.flushContext(context);
                            status = context == null ? CanceledStatus.NULL : context.getCancelStatus();
                            var21_35 = this.myAsyncTasks;
                            synchronized (var21_35) {
                                var22_36 = this.myAsyncTasks.iterator();
                                ** break block31
                            }
lbl-1000:
                            // 2 sources

                            {
                                while (var12_24.hasNext()) {
                                    task = var12_24.next();
                                    if (status.isCanceled()) break;
                                    IncProjectBuilder.waitForTask(status, task);
                                }
                                // MONITOREXIT @DISABLED, blocks:[16, 17, 13, 14, 15] lbl112 : MonitorExitStatement: MONITOREXIT : var11_20
                                finishingCompilationSpan.complete();
                                return;
                            }
lbl-1000:
                            // 2 sources

                            {
                                while (var12_27.hasNext()) {
                                    task = var12_27.next();
                                    if (status.isCanceled()) break;
                                    IncProjectBuilder.waitForTask(status, task);
                                }
                                // MONITOREXIT @DISABLED, blocks:[16, 17, 12, 14, 15] lbl120 : MonitorExitStatement: MONITOREXIT : var11_23
                                finishingCompilationSpan.complete();
                                return;
                            }
lbl-1000:
                            // 1 sources

                            {
                                while (var22_36.hasNext()) {
                                    task = var22_36.next();
                                    if (status.isCanceled()) break;
                                    IncProjectBuilder.waitForTask(status, task);
                                }
                            }
                            finishingCompilationSpan.complete();
                            throw var18_32;
                        }
                    }
                    finishingCompilationSpan = Tracer.start((String)"finishing compilation");
                    memWatcher.stop();
                    IncProjectBuilder.flushContext(context);
                    status = context == null ? CanceledStatus.NULL : context.getCancelStatus();
                    var11_23 = this.myAsyncTasks;
                    synchronized (var11_23) {
                        var12_27 = this.myAsyncTasks.iterator();
                        ** GOTO lbl-1000
                    }
                }
            }
        }
        finishingCompilationSpan = Tracer.start((String)"finishing compilation");
        memWatcher.stop();
        IncProjectBuilder.flushContext(context);
        status = context == null ? CanceledStatus.NULL : context.getCancelStatus();
        var11_20 = this.myAsyncTasks;
        synchronized (var11_20) {
            var12_24 = this.myAsyncTasks.iterator();
            ** GOTO lbl-1000
        }
    }

    @NotNull
    private static CompilerMessage getCompilerMessage(@NotNull ProjectBuildException e, @Nullable Throwable cause) {
        String errorMessage;
        if (e == null) {
            IncProjectBuilder.$$$reportNull$$$0(6);
        }
        if ((errorMessage = e.getMessage()) == null || errorMessage.isBlank()) {
            CompilerMessage compilerMessage = CompilerMessage.createInternalCompilationError("", cause == null ? e : cause);
            if (compilerMessage == null) {
                IncProjectBuilder.$$$reportNull$$$0(7);
            }
            return compilerMessage;
        }
        String causeMessage = cause == null ? null : cause.getMessage();
        String text = causeMessage == null || causeMessage.isBlank() || errorMessage.trim().endsWith(causeMessage) ? errorMessage : errorMessage + ": " + causeMessage;
        return new CompilerMessage("", BuildMessage.Kind.ERROR, text);
    }

    private void checkRebuildRequired(final @NotNull CompileScope scope) throws RebuildRequestedException {
        if (scope == null) {
            IncProjectBuilder.$$$reportNull$$$0(8);
        }
        boolean isDebugEnabled = LOG.isDebugEnabled();
        if (this.myIsTestMode || this.isAutoBuild()) {
            if (isDebugEnabled) {
                LOG.debug("Rebuild heuristic: skipping the check; isTestMode = " + this.myIsTestMode + "; isAutoBuild = " + this.isAutoBuild());
            }
            return;
        }
        BuildTargetStateManager targetStateManager = this.myProjectDescriptor.dataManager.getTargetStateManager();
        long timeThreshold = targetStateManager.getLastSuccessfulRebuildDuration() * 95L / 100L;
        if (timeThreshold <= 0L) {
            if (isDebugEnabled) {
                LOG.debug("Rebuild heuristic: no stats available");
            }
            return;
        }
        for (BuildTargetType buildTargetType : JavaModuleBuildTargetType.ALL_TYPES) {
            if (!scope.isBuildIncrementally(buildTargetType)) {
                if (isDebugEnabled) {
                    LOG.debug("Rebuild heuristic: skipping the check because rebuild is forced for targets of type " + buildTargetType.getTypeId());
                }
                return;
            }
            if (scope.isAllTargetsOfTypeAffected(buildTargetType)) continue;
            if (isDebugEnabled) {
                LOG.debug("Rebuild heuristic: skipping the check because some targets are excluded from compilation scope, e.g. targets of type " + buildTargetType.getTypeId());
            }
            return;
        }
        long estimatedWorkTime = IncProjectBuilder.calculateEstimatedBuildTime(this.myProjectDescriptor, new Predicate<BuildTarget<?>>(){
            private final Set<BuildTargetType<?>> allTargetsAffected = new HashSet<JavaModuleBuildTargetType>(JavaModuleBuildTargetType.ALL_TYPES);

            @Override
            public boolean test(BuildTarget<?> target) {
                return this.allTargetsAffected.contains(target.getTargetType()) || scope.isAffected(target);
            }
        });
        if (isDebugEnabled) {
            LOG.debug("Rebuild heuristic: estimated build time / timeThreshold : " + estimatedWorkTime + " / " + timeThreshold);
        }
        if (estimatedWorkTime >= timeThreshold) {
            String message = JpsBuildBundle.message("build.message.too.many.modules.require.recompilation.forcing.full.project.rebuild", new Object[0]);
            LOG.info(message);
            LOG.info("Estimated build duration (linear): " + Formats.formatDuration((long)estimatedWorkTime));
            LOG.info("Last successful rebuild duration (linear): " + Formats.formatDuration((long)targetStateManager.getLastSuccessfulRebuildDuration()));
            LOG.info("Rebuild heuristic time threshold: " + Formats.formatDuration((long)timeThreshold));
            this.myMessageDispatcher.processMessage(new CompilerMessage("", BuildMessage.Kind.INFO, message));
            throw new RebuildRequestedException(null);
        }
    }

    public static long calculateEstimatedBuildTime(@NotNull ProjectDescriptor projectDescriptor, @NotNull Predicate<BuildTarget<?>> isAffected) {
        if (projectDescriptor == null) {
            IncProjectBuilder.$$$reportNull$$$0(9);
        }
        if (isAffected == null) {
            IncProjectBuilder.$$$reportNull$$$0(10);
        }
        BuildTargetStateManager targetStateManager = projectDescriptor.dataManager.getTargetStateManager();
        long estimatedBuildTime = 0L;
        BuildTargetIndex targetIndex = projectDescriptor.getBuildTargetIndex();
        int affectedTargets = 0;
        for (BuildTarget<?> target : targetIndex.getAllTargets()) {
            long avgTimeToBuild;
            if (targetIndex.isDummy(target) || (avgTimeToBuild = targetStateManager.getAverageBuildTime(target.getTargetType())) <= 0L || !targetStateManager.getTargetConfiguration(target).isTargetDirty(projectDescriptor) || !isAffected.test(target)) continue;
            estimatedBuildTime += avgTimeToBuild;
            ++affectedTargets;
        }
        LOG.info("Affected build targets count: " + affectedTargets);
        return estimatedBuildTime;
    }

    private void requestRebuild(Exception e, Throwable cause) throws RebuildRequestedException {
        this.myMessageDispatcher.processMessage(new CompilerMessage("", BuildMessage.Kind.INFO, JpsBuildBundle.message("build.message.internal.caches.are.corrupted", e.getMessage())));
        throw new RebuildRequestedException(cause);
    }

    private static void waitForTask(@NotNull CanceledStatus status, Future<?> task) {
        if (status == null) {
            IncProjectBuilder.$$$reportNull$$$0(11);
        }
        try {
            while (true) {
                try {
                    task.get(500L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException ignored) {
                    if (!status.isCanceled()) continue;
                }
                break;
            }
        }
        catch (Throwable th) {
            LOG.info(th);
        }
    }

    private static void reportRebuiltModules(CompileContextImpl context) {
        Set modules = (Set)BuildTargetConfiguration.MODULES_WITH_TARGET_CONFIG_CHANGED_KEY.get((UserDataHolder)context);
        if (modules == null || modules.isEmpty()) {
            return;
        }
        int shown = modules.size() == 6 ? 6 : Math.min(5, modules.size());
        String modulesText = modules.stream().limit(shown).map(m -> "'" + m.getName() + "'").collect(Collectors.joining(", "));
        String text = JpsBuildBundle.message("build.messages.modules.were.fully.rebuilt", modulesText, modules.size(), modules.size() - shown, ModuleBuildTarget.REBUILD_ON_DEPENDENCY_CHANGE != false ? 1 : 0);
        context.processMessage(new CompilerMessage("", BuildMessage.Kind.INFO, text));
    }

    private static void reportUnprocessedChanges(CompileContextImpl context) {
        ProjectDescriptor pd = context.getProjectDescriptor();
        BuildFSState fsState = pd.fsState;
        for (BuildTarget<?> target : pd.getBuildTargetIndex().getAllTargets()) {
            if (!fsState.hasUnprocessedChanges(context, target)) continue;
            context.processMessage(new UnprocessedFSChangesNotification());
            break;
        }
    }

    private static void flushContext(CompileContext context) {
        ExternalJavacManager server;
        if (context != null) {
            context.getProjectDescriptor().dataManager.flush(false);
        }
        if ((server = (ExternalJavacManager)((Object)ExternalJavacManagerKey.KEY.get(context))) != null) {
            server.stop();
            ExternalJavacManagerKey.KEY.set(context, null);
        }
    }

    private boolean isAutoBuild() {
        return Boolean.parseBoolean(this.myBuilderParams.get("is_automake"));
    }

    private boolean isParallelBuild() {
        return this.isAutoBuild() ? BuildRunner.isParallelBuildAutomakeEnabled() : BuildRunner.isParallelBuildEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBuild(@NotNull CompileContextImpl context, boolean forceCleanCaches) throws ProjectBuildException {
        block12: {
            BuildProgress buildProgress;
            if (context == null) {
                IncProjectBuilder.$$$reportNull$$$0(12);
            }
            context.setDone(0.0f);
            LOG.info("Building project; isRebuild:" + JavaBuilderUtil.isForcedRecompilationAllJavaModules(context) + "; isMake:" + context.isMake() + " parallel compilation:" + this.isParallelBuild() + "; dependency graph enabled:" + JavaBuilderUtil.isDepGraphEnabled() + "; library dependencies tracking enabled:" + JavaBuilderUtil.isTrackLibraryDependenciesEnabled());
            context.addBuildListener(new ChainedTargetsBuildListener(context));
            context.addBuildListener(new BuildListener(){

                @Override
                public void filesGenerated(@NotNull FileGeneratedEvent event) {
                    if (event == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    Collection<Pair<String, String>> paths = event.getPaths();
                    FileSystem fs = FileSystems.getDefault();
                    if (paths.size() == 1) {
                        this.deleteFiles((String)paths.iterator().next().first, fs);
                        return;
                    }
                    HashSet<String> outputs2 = new HashSet<String>();
                    for (Pair<String, String> pair : paths) {
                        String root = (String)pair.getFirst();
                        if (!outputs2.add(root)) continue;
                        this.deleteFiles(root, fs);
                    }
                }

                private void deleteFiles(String rootPath, FileSystem fs) {
                    Path root = fs.getPath(rootPath, new String[0]);
                    try {
                        Files.deleteIfExists(root.resolve(IncProjectBuilder.CLASSPATH_INDEX_FILE_NAME));
                        Files.deleteIfExists(root.resolve(IncProjectBuilder.UNMODIFIED_MARK_FILE_NAME));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/jps/incremental/IncProjectBuilder$3", "filesGenerated"));
                }
            });
            Tracer.Span allTargetBuilderBuildStartedSpan = Tracer.start((String)"All TargetBuilder.buildStarted");
            for (TargetBuilder<?, ?> targetBuilder : this.myBuilderRegistry.getTargetBuilders()) {
                targetBuilder.buildStarted(context);
            }
            allTargetBuilderBuildStartedSpan.complete();
            Tracer.Span allModuleLevelBuildersBuildStartedSpan = Tracer.start((String)"All ModuleLevelBuilder.buildStarted");
            for (ModuleLevelBuilder builder : this.myBuilderRegistry.getModuleLevelBuilders()) {
                builder.buildStarted(context);
            }
            allModuleLevelBuildersBuildStartedSpan.complete();
            BuildProgress buildProgress2 = null;
            try {
                buildProgress = new BuildProgress(this.myProjectDescriptor.dataManager, this.myProjectDescriptor.getBuildTargetIndex(), this.myProjectDescriptor.getBuildTargetIndex().getSortedTargetChunks(context), chunk -> IncProjectBuilder.isAffected(context.getScope(), chunk));
                Tracer.Span cleanOutputSourcesSpan = Tracer.start((String)"Clean output sources");
                this.cleanOutputRoots(context, JavaBuilderUtil.isForcedRecompilationAllJavaModules(context) || forceCleanCaches);
                cleanOutputSourcesSpan.complete();
                Tracer.Span span = Tracer.start((String)"'before' tasks");
                context.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.running.before.tasks", new Object[0])));
                IncProjectBuilder.runTasks(context, this.myBuilderRegistry.getBeforeTasks());
                TimingLog.LOG.debug("'before' tasks finished");
                span.complete();
                Tracer.Span checkingSourcesSpan = Tracer.start((String)"Building targets");
                context.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.checking.sources", new Object[0])));
                this.buildChunks(context, buildProgress);
                TimingLog.LOG.debug("Building targets finished");
                checkingSourcesSpan.complete();
                Tracer.Span afterTasksSpan = Tracer.start((String)"'after' span");
                context.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.running.after.tasks", new Object[0])));
                IncProjectBuilder.runTasks(context, this.myBuilderRegistry.getAfterTasks());
                TimingLog.LOG.debug("'after' tasks finished");
                this.sendElapsedTimeMessages(context);
                afterTasksSpan.complete();
                if (buildProgress == null) break block12;
                buildProgress.updateExpectedAverageTime();
            }
            catch (Throwable throwable) {
                if (buildProgress2 != null) {
                    buildProgress2.updateExpectedAverageTime();
                    if (JavaBuilderUtil.isForcedRecompilationAllJavaModules(context) && !Utils.errorsDetected(context) && !context.getCancelStatus().isCanceled()) {
                        this.myProjectDescriptor.dataManager.getTargetStateManager().setLastSuccessfulRebuildDuration(buildProgress2.getAbsoluteBuildTime());
                    }
                }
                for (Builder builder : this.myBuilderRegistry.getTargetBuilders()) {
                    builder.buildFinished(context);
                }
                for (Builder builder : this.myBuilderRegistry.getModuleLevelBuilders()) {
                    builder.buildFinished(context);
                }
                context.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.finished.saving.caches", new Object[0])));
                throw throwable;
            }
            if (JavaBuilderUtil.isForcedRecompilationAllJavaModules(context) && !Utils.errorsDetected(context) && !context.getCancelStatus().isCanceled()) {
                this.myProjectDescriptor.dataManager.getTargetStateManager().setLastSuccessfulRebuildDuration(buildProgress.getAbsoluteBuildTime());
            }
        }
        for (TargetBuilder<?, ?> targetBuilder : this.myBuilderRegistry.getTargetBuilders()) {
            targetBuilder.buildFinished(context);
        }
        for (ModuleLevelBuilder moduleLevelBuilder : this.myBuilderRegistry.getModuleLevelBuilders()) {
            moduleLevelBuilder.buildFinished(context);
        }
        context.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.finished.saving.caches", new Object[0])));
    }

    private void sendElapsedTimeMessages(CompileContext context) {
        this.myElapsedTimeNanosByBuilder.entrySet().stream().map(entry -> {
            AtomicInteger processedSourcesRef = (AtomicInteger)this.myNumberOfSourcesProcessedByBuilder.get(entry.getKey());
            int processedSources = processedSourcesRef != null ? processedSourcesRef.get() : 0;
            return new BuilderStatisticsMessage(((Builder)entry.getKey()).getPresentableName(), processedSources, ((AtomicLong)entry.getValue()).get() / 1000000L);
        }).sorted(Comparator.comparing(BuilderStatisticsMessage::getBuilderName)).forEach(context::processMessage);
    }

    private boolean runBuildersForChunk(CompileContext context, BuildTargetChunk chunk, BuildProgress buildProgress) throws ProjectBuildException, IOException {
        Set<BuildTarget<?>> targets = chunk.getTargets();
        if (targets.size() > 1) {
            LinkedHashSet<ModuleBuildTarget> moduleTargets = new LinkedHashSet<ModuleBuildTarget>();
            for (BuildTarget<?> target : targets) {
                if (target instanceof ModuleBuildTarget) {
                    moduleTargets.add((ModuleBuildTarget)target);
                    continue;
                }
                String targetsString = Strings.join(targets, target1 -> Introspector.decapitalize(target1.getPresentableName()), (String)", ");
                String message = JpsBuildBundle.message("build.message.cannot.build.0.because.it.is.included.into.a.circular.dependency.1", StringUtil.decapitalize((String)target.getPresentableName()), targetsString);
                context.processMessage(new CompilerMessage("", BuildMessage.Kind.ERROR, message));
                return false;
            }
            return this.runModuleLevelBuilders(IncProjectBuilder.wrapWithModuleInfoAppender(context, moduleTargets), new ModuleChunk(moduleTargets), buildProgress);
        }
        BuildTarget<?> target = targets.iterator().next();
        if (target instanceof ModuleBuildTarget) {
            Set<ModuleBuildTarget> mbt = Set.of((ModuleBuildTarget)target);
            return this.runModuleLevelBuilders(IncProjectBuilder.wrapWithModuleInfoAppender(context, mbt), new ModuleChunk(mbt), buildProgress);
        }
        IncProjectBuilder.completeRecompiledSourcesSet(context, targets);
        IncProjectBuilder.cleanOldOutputs(context, target);
        List<TargetBuilder<?, ?>> builders = BuilderRegistry.getInstance().getTargetBuilders();
        int builderCount = 0;
        for (TargetBuilder<?, ?> builder : builders) {
            this.buildTarget(target, context, builder);
            buildProgress.updateProgress(target, (double)(++builderCount) / (double)builders.size(), context);
        }
        return true;
    }

    @NotNull
    private CompileContextImpl createContext(@NotNull CompileScope scope) {
        if (scope == null) {
            IncProjectBuilder.$$$reportNull$$$0(13);
        }
        return new CompileContextImpl(scope, this.myProjectDescriptor, this.myMessageDispatcher, this.myBuilderParams, this.myCancelStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cleanOutputRoots(final @NotNull CompileContext context, boolean cleanCaches) throws ProjectBuildException {
        if (context == null) {
            IncProjectBuilder.$$$reportNull$$$0(14);
        }
        ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
        ProjectBuildException projectBuildException = null;
        var targetCleanup = new Consumer<BuildTarget<?>>(){
            final ExecutorService executor = SharedThreadPool.getInstance().createBoundedExecutor("IncProjectBuilder Output Cleanup Pool", MAX_BUILDER_THREADS);
            final List<Future<?>> tasks = new ArrayList();

            @Override
            public void accept(BuildTarget<?> target) {
                if (SYNC_DELETE) {
                    IncProjectBuilder.clearOutputFilesUninterruptibly(context, target);
                } else {
                    this.tasks.add(this.executor.submit(() -> IncProjectBuilder.clearOutputFilesUninterruptibly(context, target)));
                }
            }

            void waitForTasks() {
                for (Future<?> task : this.tasks) {
                    try {
                        task.get();
                    }
                    catch (Throwable e) {
                        LOG.info(e);
                    }
                }
            }
        };
        long cleanStart = System.nanoTime();
        try {
            JpsJavaCompilerConfiguration configuration = JpsJavaExtensionService.getInstance().getCompilerConfiguration(projectDescriptor.getProject());
            if (configuration.isClearOutputDirectoryOnRebuild()) {
                this.clearOutputs(context, targetCleanup);
            } else {
                for (BuildTarget buildTarget : projectDescriptor.getBuildTargetIndex().getAllTargets()) {
                    context.checkCanceled();
                    if (!context.getScope().isBuildForced(buildTarget)) continue;
                    targetCleanup.accept(buildTarget);
                }
            }
            for (BuildTargetType buildTargetType : TargetTypeRegistry.getInstance().getTargetTypes()) {
                if (!context.getScope().isAllTargetsOfTypeAffected(buildTargetType)) continue;
                this.cleanOutputOfStaleTargets(buildTargetType, context);
            }
            targetCleanup.waitForTasks();
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof ProjectBuildException)) throw e;
            projectBuildException = (ProjectBuildException)cause;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (ProjectBuildException e2) {
                projectBuildException = e2;
            }
        }
        finally {
            targetCleanup.waitForTasks();
            LOG.info("Cleaned output directories in " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - cleanStart) + " ms");
            if (cleanCaches) {
                try {
                    projectDescriptor.dataManager.clean(this.myAsyncTasks::add);
                }
                catch (IOException e) {
                    if (projectBuildException == null) {
                        projectBuildException = new ProjectBuildException(JpsBuildBundle.message("build.message.error.cleaning.compiler.storages", new Object[0]), e);
                    }
                    LOG.info("Error cleaning compiler storages", (Throwable)e);
                }
                finally {
                    projectDescriptor.fsState.clearAll();
                    if (projectBuildException == null) return;
                    throw projectBuildException;
                }
            }
            BuildTargetStateManager targetStateManager = projectDescriptor.dataManager.getTargetStateManager();
            Iterator<BuildTarget<?>> iterator = IncProjectBuilder.getTargetsWithClearedOutput(context).iterator();
            while (iterator.hasNext()) {
                BuildTarget<?> buildTarget = iterator.next();
                targetStateManager.invalidate(buildTarget);
            }
            return;
        }
        LOG.info("Cleaned output directories in " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - cleanStart) + " ms");
        if (cleanCaches) {
            try {
                projectDescriptor.dataManager.clean(this.myAsyncTasks::add);
                return;
            }
            catch (IOException e) {
                if (projectBuildException == null) {
                    projectBuildException = new ProjectBuildException(JpsBuildBundle.message("build.message.error.cleaning.compiler.storages", new Object[0]), e);
                }
                LOG.info("Error cleaning compiler storages", (Throwable)e);
            }
            finally {
                projectDescriptor.fsState.clearAll();
                if (projectBuildException == null) return;
                throw projectBuildException;
            }
        }
        BuildTargetStateManager targetStateManager = projectDescriptor.dataManager.getTargetStateManager();
        Iterator<Object> iterator = IncProjectBuilder.getTargetsWithClearedOutput(context).iterator();
        while (iterator.hasNext()) {
            BuildTarget buildTarget = (BuildTarget)iterator.next();
            targetStateManager.invalidate(buildTarget);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanOutputOfStaleTargets(BuildTargetType<?> targetType, CompileContext context) {
        BuildDataManager dataManager = this.myProjectDescriptor.dataManager;
        List<Pair<String, Integer>> targetIds = dataManager.getTargetStateManager().getStaleTargetIds(targetType);
        if (targetIds.isEmpty()) {
            return;
        }
        context.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.cleaning.old.output.directories", new Object[0])));
        for (Pair<String, Integer> ids : targetIds) {
            String targetId = (String)ids.first;
            try {
                try (SourceToOutputMappingImpl mapping = null;){
                    mapping = dataManager.createSourceToOutputMapForStaleTarget(targetType, targetId);
                    IncProjectBuilder.clearOutputFiles(context, mapping, targetType, (Integer)ids.second);
                }
                dataManager.cleanStaleTarget(targetType, targetId);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                this.myMessageDispatcher.processMessage(new CompilerMessage("", BuildMessage.Kind.WARNING, JpsBuildBundle.message("build.message.failed.to.delete.output.files.from.obsolete.0.target.1", targetId, e.toString())));
            }
        }
    }

    public static void clearOutputFiles(CompileContext context, BuildTarget<?> target) throws IOException {
        SourceToOutputMapping map = context.getProjectDescriptor().dataManager.getSourceToOutputMap(target);
        BuildTargetType<BuildTarget<?>> targetType = target.getTargetType();
        IncProjectBuilder.clearOutputFiles(context, map, targetType, context.getProjectDescriptor().dataManager.getTargetStateManager().getBuildTargetId(target));
        IncProjectBuilder.registerTargetsWithClearedOutput(context, Collections.singletonList(target));
    }

    private boolean processDeletedPaths(CompileContext context, Set<? extends BuildTarget<?>> targets) throws ProjectBuildException {
        boolean doneSomething = false;
        try {
            HashMap<BuildTarget, Collection> targetToRemovedSources = new HashMap<BuildTarget, Collection>();
            Set dirsToDelete = FileCollectionFactory.createCanonicalPathSet();
            for (BuildTarget<?> target : targets) {
                Collection<String> pathsForIteration;
                Collection<String> deletedPaths = this.myProjectDescriptor.fsState.getAndClearDeletedPaths(target);
                if (deletedPaths.isEmpty()) continue;
                targetToRemovedSources.put(target, deletedPaths.stream().map(x$0 -> Path.of(x$0, new String[0])).collect(Collectors.toList()));
                if (IncProjectBuilder.isTargetOutputCleared(context, target)) continue;
                int buildTargetId = context.getProjectDescriptor().dataManager.getTargetStateManager().getBuildTargetId(target);
                boolean shouldPruneEmptyDirs = target instanceof ModuleBasedTarget;
                BuildDataManager dataManager = context.getProjectDescriptor().dataManager;
                SourceToOutputMapping sourceToOutputStorage = dataManager.getSourceToOutputMap(target);
                ProjectBuilderLogger logger = context.getLoggingManager().getProjectBuilderLogger();
                if (this.myIsTestMode) {
                    pathsForIteration = new ArrayList<String>(deletedPaths);
                    Collections.sort((List)pathsForIteration);
                } else {
                    pathsForIteration = deletedPaths;
                }
                for (String deletedSource : pathsForIteration) {
                    Path deletedSourceFile;
                    OneToManyPathMapping sourceToFormMap;
                    Collection<Path> boundForms;
                    Collection<String> outputs2 = sourceToOutputStorage.getOutputs(deletedSource);
                    if (outputs2 != null && !outputs2.isEmpty()) {
                        ArrayList<String> deletedOutputPaths = new ArrayList<String>();
                        OutputToTargetMapping outputToSourceRegistry = dataManager.getOutputToTargetMapping();
                        for (String output : outputToSourceRegistry.removeTargetAndGetSafeToDeleteOutputs(outputs2, buildTargetId, sourceToOutputStorage)) {
                            boolean deleted = BuildOperations.deleteRecursivelyAndCollectDeleted(Path.of(output, new String[0]), deletedOutputPaths, shouldPruneEmptyDirs ? dirsToDelete : null);
                            if (!deleted) continue;
                            doneSomething = true;
                        }
                        if (!deletedOutputPaths.isEmpty()) {
                            if (logger.isEnabled()) {
                                logger.logDeletedFiles(deletedOutputPaths);
                            }
                            context.processMessage(new FileDeletedEvent(deletedOutputPaths));
                        }
                    }
                    if (!(target instanceof ModuleBuildTarget) || (boundForms = (sourceToFormMap = dataManager.getSourceToFormMap(target)).getOutputs(deletedSourceFile = Path.of(deletedSource, new String[0]))) == null) continue;
                    for (Path formFile : boundForms) {
                        if (!Files.exists(formFile, new LinkOption[0])) continue;
                        FSOperations.markDirty(context, CompilationRound.CURRENT, formFile.toFile());
                    }
                    sourceToFormMap.remove(deletedSourceFile);
                }
            }
            if (!targetToRemovedSources.isEmpty()) {
                Map existing = (Map)Utils.REMOVED_SOURCES_KEY.get((UserDataHolder)context);
                if (existing != null) {
                    for (Map.Entry entry : existing.entrySet()) {
                        Collection paths = (Collection)targetToRemovedSources.get(entry.getKey());
                        if (paths == null) {
                            targetToRemovedSources.put((BuildTarget)entry.getKey(), (Collection)entry.getValue());
                            continue;
                        }
                        paths.addAll((Collection)entry.getValue());
                    }
                }
                Utils.REMOVED_SOURCES_KEY.set((UserDataHolder)context, targetToRemovedSources);
            }
            FSOperations.pruneEmptyDirs(context, dirsToDelete);
        }
        catch (IOException e) {
            throw new ProjectBuildException(e);
        }
        return doneSomething;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerTargetsWithClearedOutput(CompileContext context, Collection<? extends BuildTarget<?>> targets) {
        GlobalContextKey<Set<BuildTarget<?>>> globalContextKey = TARGET_WITH_CLEARED_OUTPUT;
        synchronized (globalContextKey) {
            HashSet data = (HashSet)context.getUserData(TARGET_WITH_CLEARED_OUTPUT);
            if (data == null) {
                data = new HashSet();
                context.putUserData(TARGET_WITH_CLEARED_OUTPUT, data);
            }
            data.addAll(targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isTargetOutputCleared(CompileContext context, BuildTarget<?> target) {
        GlobalContextKey<Set<BuildTarget<?>>> globalContextKey = TARGET_WITH_CLEARED_OUTPUT;
        synchronized (globalContextKey) {
            Set data = (Set)context.getUserData(TARGET_WITH_CLEARED_OUTPUT);
            return data != null && data.contains(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static @Unmodifiable Set<BuildTarget<?>> getTargetsWithClearedOutput(@NotNull CompileContext context) {
        if (context == null) {
            IncProjectBuilder.$$$reportNull$$$0(15);
        }
        GlobalContextKey<Set<BuildTarget<?>>> globalContextKey = TARGET_WITH_CLEARED_OUTPUT;
        synchronized (globalContextKey) {
            Set data = (Set)context.getUserData(TARGET_WITH_CLEARED_OUTPUT);
            return data == null ? Collections.emptySet() : Set.copyOf(data);
        }
    }

    private void clearOutputs(@NotNull CompileContext context, @NotNull Consumer<BuildTarget<?>> targetCleanup) throws ProjectBuildException {
        if (context == null) {
            IncProjectBuilder.$$$reportNull$$$0(16);
        }
        if (targetCleanup == null) {
            IncProjectBuilder.$$$reportNull$$$0(17);
        }
        MultiMap rootsToDelete = MultiMap.createSet();
        Set allSourceRoots = FileCollectionFactory.createCanonicalFileSet();
        ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
        List<BuildTarget<?>> allTargets = projectDescriptor.getBuildTargetIndex().getAllTargets();
        for (BuildTarget<?> target : allTargets) {
            if (target instanceof ModuleBasedTarget) {
                for (File file : target.getOutputRoots(context)) {
                    rootsToDelete.putValue((Object)file, (Object)target);
                }
                continue;
            }
            if (!context.getScope().isBuildForced(target)) continue;
            targetCleanup.accept(target);
        }
        ModuleExcludeIndex moduleIndex = projectDescriptor.getModuleExcludeIndex();
        for (BuildTarget buildTarget : allTargets) {
            for (BuildRootDescriptor descriptor : projectDescriptor.getBuildRootIndex().getTargetRoots(buildTarget, context)) {
                File file;
                if (descriptor.isGenerated() || !moduleIndex.isInContent(file = descriptor.getRootFile())) continue;
                allSourceRoots.add(file);
            }
        }
        CompileScope compileScope = context.getScope();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Predicate<BuildTarget> predicate = compileScope::isBuildForced;
        for (Map.Entry entry : rootsToDelete.entrySet()) {
            boolean okToDelete;
            context.checkCanceled();
            File outputRoot = (File)entry.getKey();
            Collection rootTargets = (Collection)entry.getValue();
            Applicability applicability = Applicability.calculate(predicate, rootTargets);
            if (applicability == Applicability.NONE) continue;
            boolean bl = okToDelete = applicability == Applicability.ALL && !IncProjectBuilder.isEmpty(outputRoot);
            if (okToDelete && !moduleIndex.isExcluded(outputRoot)) {
                if (JpsPathUtil.isUnder((Set)allSourceRoots, (File)outputRoot)) {
                    okToDelete = false;
                } else {
                    Set _outRoot = FileCollectionFactory.createCanonicalFileSet(List.of(outputRoot));
                    for (File srcRoot : allSourceRoots) {
                        if (!JpsPathUtil.isUnder((Set)_outRoot, (File)srcRoot)) continue;
                        okToDelete = false;
                        break;
                    }
                }
                if (!okToDelete) {
                    context.processMessage(new CompilerMessage("", BuildMessage.Kind.WARNING, JpsBuildBundle.message("build.message.output.path.0.intersects.with.a.source.root", outputRoot.getPath())));
                }
            }
            if (okToDelete) {
                File[] children = outputRoot.listFiles();
                if (children != null) {
                    for (File child : children) {
                        if (child.delete()) continue;
                        arrayList.add(child);
                    }
                } else if (!outputRoot.delete()) {
                    arrayList.add(outputRoot);
                }
                IncProjectBuilder.registerTargetsWithClearedOutput(context, rootTargets);
                continue;
            }
            context.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.cleaning.output.directories", new Object[0])));
            for (BuildTarget target : rootTargets) {
                if (!compileScope.isBuildForced(target)) continue;
                targetCleanup.accept(target);
            }
        }
        if (!arrayList.isEmpty()) {
            context.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.cleaning.output.directories", new Object[0])));
            if (SYNC_DELETE) {
                for (File file : arrayList) {
                    context.checkCanceled();
                    FileUtilRt.delete((File)file);
                }
            } else {
                this.myAsyncTasks.add(FileUtil.asyncDelete(arrayList));
            }
        }
    }

    private static boolean isEmpty(@NotNull File outputRoot) {
        String[] files;
        if (outputRoot == null) {
            IncProjectBuilder.$$$reportNull$$$0(18);
        }
        return (files = outputRoot.list()) == null || files.length == 0;
    }

    private static void clearOutputFilesUninterruptibly(CompileContext context, BuildTarget<?> target) {
        try {
            IncProjectBuilder.clearOutputFiles(context, target);
        }
        catch (Throwable e) {
            LOG.info(e);
            String reason = e.getMessage();
            if (reason == null) {
                reason = e.getClass().getName();
            }
            context.processMessage(new CompilerMessage("", BuildMessage.Kind.WARNING, JpsBuildBundle.message("build.message.problems.clearing.output.files.for.target.0.1", target.getPresentableName(), reason)));
        }
    }

    private static void runTasks(@NotNull CompileContext context, @NotNull List<? extends BuildTask> tasks) throws ProjectBuildException {
        if (context == null) {
            IncProjectBuilder.$$$reportNull$$$0(19);
        }
        if (tasks == null) {
            IncProjectBuilder.$$$reportNull$$$0(20);
        }
        for (BuildTask buildTask : tasks) {
            buildTask.build(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildChunks(@NotNull CompileContextImpl context, @NotNull BuildProgress buildProgress) throws ProjectBuildException {
        if (context == null) {
            IncProjectBuilder.$$$reportNull$$$0(21);
        }
        if (buildProgress == null) {
            IncProjectBuilder.$$$reportNull$$$0(22);
        }
        try {
            boolean compileInParallel = this.isParallelBuild();
            if (compileInParallel && MAX_BUILDER_THREADS <= 1) {
                LOG.info("Switched off parallel compilation because maximum number of builder threads is less than 2. Set 'compile.parallel.max.threads' system property to a value greater than 1 to really enable parallel compilation.");
                compileInParallel = false;
            }
            Tracer.Span buildSpan = Tracer.start((String)(compileInParallel ? "Parallel build" : "Non-parallel build"));
            if (compileInParallel) {
                new BuildParallelizer(context, buildProgress).buildInParallel();
            } else {
                ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
                BuildDataManager dataManager = projectDescriptor.dataManager;
                Runnable flushCommand = Utils.asCountedRunnable(10, () -> dataManager.flush(true));
                for (BuildTargetChunk chunk : projectDescriptor.getBuildTargetIndex().getSortedTargetChunks(context)) {
                    try {
                        this.buildChunkIfAffected(context, context.getScope(), chunk, buildProgress);
                    }
                    finally {
                        dataManager.closeSourceToOutputStorages(chunk.getTargets());
                        flushCommand.run();
                    }
                }
            }
            buildSpan.complete();
        }
        catch (IOException e) {
            throw new ProjectBuildException(e);
        }
    }

    private void buildChunkIfAffected(CompileContext context, CompileScope scope, BuildTargetChunk chunk, BuildProgress buildProgress) throws ProjectBuildException {
        Tracer.Span isAffectedSpan = Tracer.start((String)"isAffected");
        boolean affected = IncProjectBuilder.isAffected(scope, chunk);
        isAffectedSpan.complete();
        if (affected) {
            this.buildTargetsChunk(context, chunk, buildProgress);
        }
    }

    private static boolean isAffected(CompileScope scope, BuildTargetChunk chunk) {
        for (BuildTarget<?> target : chunk.getTargets()) {
            if (!scope.isAffected(target)) continue;
            return true;
        }
        return false;
    }

    private <R extends BuildRootDescriptor, T extends BuildTarget<R>> void buildTarget(final T target, final CompileContext context, TargetBuilder<?, ?> builder) throws ProjectBuildException, IOException {
        if (builder.getTargetTypes().contains(target.getTargetType())) {
            DirtyFilesHolderBase holder = new DirtyFilesHolderBase<R, T>(context){

                @Override
                public void processDirtyFiles(@NotNull FileProcessor<R, T> processor) throws IOException {
                    if (processor == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    context.getProjectDescriptor().fsState.processFilesToRecompile(context, target, processor);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/jps/incremental/IncProjectBuilder$5", "processDirtyFiles"));
                }
            };
            BuildOutputConsumerImpl outputConsumer = new BuildOutputConsumerImpl(target, context);
            long start = System.nanoTime();
            builder.build(target, holder, outputConsumer, context);
            this.storeBuilderStatistics(builder, System.nanoTime() - start, outputConsumer.getNumberOfProcessedSources());
            outputConsumer.fireFileGeneratedEvent();
            context.checkCanceled();
        }
    }

    private static CompileContext wrapWithModuleInfoAppender(final CompileContext context, final Collection<ModuleBuildTarget> moduleTargets) {
        final Class<MessageHandler> messageHandlerInterface = MessageHandler.class;
        return (CompileContext)ReflectionUtil.proxy((ClassLoader)context.getClass().getClassLoader(), CompileContext.class, (InvocationHandler)new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (args != null && args.length > 0 && messageHandlerInterface.equals(method.getDeclaringClass())) {
                    for (Object arg : args) {
                        if (!(arg instanceof CompilerMessage)) continue;
                        CompilerMessage compilerMessage = (CompilerMessage)arg;
                        for (ModuleBuildTarget target : moduleTargets) {
                            compilerMessage.addModuleName(target.getModule().getName());
                        }
                        break;
                    }
                }
                MethodHandle mh = ourLookup.unreflect(method);
                return args == null ? mh.invoke(context) : mh.bindTo(context).asSpreader(Object[].class, args.length).invoke(args);
            }
        });
    }

    private static <T extends BuildTarget<R>, R extends BuildRootDescriptor> void completeRecompiledSourcesSet(CompileContext context, Collection<T> targets) throws IOException {
        CompileScope scope = context.getScope();
        for (BuildTarget target : targets) {
            if (!scope.isBuildForced(target)) continue;
            return;
        }
        final ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
        final Set affectedOutputs = CollectionFactory.createFilePathSet();
        final Set affectedSources = CollectionFactory.createFilePathSet();
        final ArrayList mappings = new ArrayList();
        for (BuildTarget target : targets) {
            projectDescriptor.fsState.processFilesToRecompile(context, target, new FileProcessor<R, T>(){
                private SourceToOutputMapping srcToOut;

                @Override
                public boolean apply(@NotNull T target, @NotNull File file, @NotNull R root) throws IOException {
                    Collection<Path> outs;
                    String src;
                    if (target == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    if (file == null) {
                        7.$$$reportNull$$$0(1);
                    }
                    if (root == null) {
                        7.$$$reportNull$$$0(2);
                    }
                    if (!affectedSources.add(src = FileUtilRt.toSystemIndependentName((String)file.getPath()))) {
                        return true;
                    }
                    if (this.srcToOut == null) {
                        this.srcToOut = projectDescriptor.dataManager.getSourceToOutputMap((BuildTarget<?>)target);
                        mappings.add(this.srcToOut);
                    }
                    if ((outs = this.srcToOut.getOutputs(file.toPath())) != null) {
                        ArrayList<String> filteredOuts = new ArrayList<String>(outs.size());
                        for (Path out : outs) {
                            String outPath = FileUtilRt.toSystemIndependentName((String)out.toString());
                            if (outPath.endsWith(".kotlin_module")) continue;
                            filteredOuts.add(outPath);
                        }
                        affectedOutputs.addAll(filteredOuts);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "target";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "file";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "root";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/jps/incremental/IncProjectBuilder$7";
                    objectArray[2] = "apply";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        if (!affectedOutputs.isEmpty()) {
            for (SourceToOutputMapping srcToOut : mappings) {
                SourceToOutputMappingCursor cursor2 = srcToOut.cursor();
                block3: while (cursor2.hasNext()) {
                    String src = (String)cursor2.next();
                    if (affectedSources.contains(src)) continue;
                    for (String out : cursor2.getOutputPaths()) {
                        if (!affectedOutputs.contains(out)) continue;
                        FSOperations.markDirtyIfNotDeleted(context, CompilationRound.CURRENT, Path.of(src, new String[0]));
                        continue block3;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runModuleLevelBuilders(final CompileContext context, final ModuleChunk chunk, BuildProgress buildProgress) throws ProjectBuildException, IOException {
        for (BuilderCategory category : BuilderCategory.values()) {
            for (ModuleLevelBuilder builder : this.myBuilderRegistry.getBuilders(category)) {
                builder.chunkBuildStarted(context, chunk);
            }
        }
        IncProjectBuilder.completeRecompiledSourcesSet(context, chunk.getTargets());
        boolean doneSomething = false;
        boolean rebuildFromScratchRequested = false;
        int roundCount = -1;
        boolean isFullRebuild = JavaBuilderUtil.isForcedRecompilationAllJavaModules(context);
        ChunkBuildOutputConsumerImpl outputConsumer = new ChunkBuildOutputConsumerImpl(context);
        try {
            boolean nextPassRequired;
            block18: do {
                nextPassRequired = false;
                ++roundCount;
                this.myProjectDescriptor.fsState.beforeNextRoundStart(context, chunk);
                DirtyFilesHolderBase<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder = new DirtyFilesHolderBase<JavaSourceRootDescriptor, ModuleBuildTarget>(context){

                    @Override
                    public void processDirtyFiles(@NotNull FileProcessor<JavaSourceRootDescriptor, ModuleBuildTarget> processor) throws IOException {
                        if (processor == null) {
                            8.$$$reportNull$$$0(0);
                        }
                        FSOperations.processFilesToRecompile(context, chunk, processor);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/jps/incremental/IncProjectBuilder$8", "processDirtyFiles"));
                    }
                };
                if (!isFullRebuild) {
                    Map<ModuleBuildTarget, Map<Path, List<Path>>> cleanedSources = BuildOperations.cleanOutputsCorrespondingToChangedFiles(context, dirtyFilesHolder);
                    for (Map.Entry entry : cleanedSources.entrySet()) {
                        ModuleBuildTarget target2 = (ModuleBuildTarget)entry.getKey();
                        Set files = ((Map)entry.getValue()).keySet();
                        if (files.isEmpty()) continue;
                        SourceToOutputMapping mapping = context.getProjectDescriptor().dataManager.getSourceToOutputMap(target2);
                        for (Path sourceFile : files) {
                            List outputs2 = (List)((Map)entry.getValue()).get(sourceFile);
                            mapping.setOutputs(sourceFile, outputs2);
                            if (outputs2.isEmpty()) continue;
                            LOG.info("Some outputs were not removed for " + sourceFile + " source file: " + outputs2);
                        }
                    }
                }
                try {
                    int buildersPassed = 0;
                    for (BuilderCategory category : BuilderCategory.values()) {
                        List<ModuleLevelBuilder> builders = this.myBuilderRegistry.getBuilders(category);
                        if (category == BuilderCategory.CLASS_POST_PROCESSOR) {
                            IncProjectBuilder.saveInstrumentedClasses(outputConsumer);
                        }
                        if (builders.isEmpty()) continue;
                        for (ModuleLevelBuilder builder : builders) {
                            outputConsumer.setCurrentBuilderName(builder.getPresentableName());
                            this.processDeletedPaths(context, chunk.getTargets());
                            long start = System.nanoTime();
                            int processedSourcesBefore = outputConsumer.getNumberOfProcessedSources();
                            ErrorsCapture errCapture = null;
                            ModuleLevelBuilder.ExitCode buildResult = ModuleLevelBuilder.ExitCode.NOTHING_DONE;
                            try {
                                CompileContext compileContext;
                                if (roundCount == 0 && !isFullRebuild) {
                                    errCapture = ErrorsCapture.wrap(context);
                                    compileContext = errCapture;
                                } else {
                                    compileContext = context;
                                }
                                buildResult = builder.build(compileContext, chunk, (DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget>)dirtyFilesHolder, outputConsumer);
                                this.storeBuilderStatistics(builder, System.nanoTime() - start, outputConsumer.getNumberOfProcessedSources() - processedSourcesBefore);
                                doneSomething |= buildResult != ModuleLevelBuilder.ExitCode.NOTHING_DONE;
                            }
                            catch (StopBuildException e) {
                                try {
                                    if (errCapture == null) {
                                        throw e;
                                    }
                                    buildResult = ModuleLevelBuilder.ExitCode.ABORT;
                                    this.storeBuilderStatistics(builder, System.nanoTime() - start, outputConsumer.getNumberOfProcessedSources() - processedSourcesBefore);
                                    doneSomething |= buildResult != ModuleLevelBuilder.ExitCode.NOTHING_DONE;
                                }
                                catch (Throwable throwable) {
                                    this.storeBuilderStatistics(builder, System.nanoTime() - start, outputConsumer.getNumberOfProcessedSources() - processedSourcesBefore);
                                    doneSomething |= buildResult != ModuleLevelBuilder.ExitCode.NOTHING_DONE;
                                    throw throwable;
                                }
                            }
                            context.checkCanceled();
                            if (errCapture != null && (errCapture.hasErrors() || buildResult == ModuleLevelBuilder.ExitCode.ABORT)) {
                                if (JavaBuilderUtil.updateMappingsOnRoundCompletion(errCapture, (DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget>)dirtyFilesHolder, chunk)) {
                                    dirtyFilesHolder.processDirtyFiles((target, file, root) -> {
                                        FSOperations.markDirty(context, CompilationRound.NEXT, file);
                                        return true;
                                    });
                                    nextPassRequired = true;
                                    continue block18;
                                }
                                errCapture.reportErrors();
                            }
                            if (buildResult == ModuleLevelBuilder.ExitCode.ABORT) {
                                throw new StopBuildException(JpsBuildBundle.message("build.message.builder.0.requested.build.stop", builder.getPresentableName()));
                            }
                            if (buildResult == ModuleLevelBuilder.ExitCode.ADDITIONAL_PASS_REQUIRED) {
                                nextPassRequired = true;
                            } else if (buildResult == ModuleLevelBuilder.ExitCode.CHUNK_REBUILD_REQUIRED) {
                                if (!rebuildFromScratchRequested && !isFullRebuild) {
                                    IncProjectBuilder.notifyChunkRebuildRequested(context, chunk, builder);
                                    rebuildFromScratchRequested = true;
                                    try {
                                        context.getProjectDescriptor().fsState.clearContextRoundData(context);
                                        FSOperations.markDirty(context, CompilationRound.NEXT, chunk, null);
                                        nextPassRequired = true;
                                        outputConsumer.clear();
                                        continue block18;
                                    }
                                    catch (Exception e) {
                                        throw new ProjectBuildException(e);
                                    }
                                }
                                LOG.debug("Builder " + builder.getPresentableName() + " requested second chunk rebuild");
                            }
                            ++buildersPassed;
                        }
                        continue;
                        {
                            for (ModuleBuildTarget target3 : chunk.getTargets()) {
                                buildProgress.updateProgress(target3, (double)buildersPassed / (double)this.myTotalModuleLevelBuilderCount, context);
                            }
                            continue;
                            break;
                        }
                        finally {
                            outputConsumer.setCurrentBuilderName(null);
                        }
                    }
                }
                finally {
                    boolean moreToCompile = JavaBuilderUtil.updateMappingsOnRoundCompletion(context, (DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget>)dirtyFilesHolder, chunk);
                    if (moreToCompile) {
                        nextPassRequired = true;
                    }
                    JavaBuilderUtil.clearDataOnRoundCompletion(context);
                }
            } while (nextPassRequired);
        }
        catch (Throwable throwable) {
            IncProjectBuilder.saveInstrumentedClasses(outputConsumer);
            outputConsumer.fireFileGeneratedEvents();
            outputConsumer.clear();
            for (BuilderCategory category : BuilderCategory.values()) {
                for (ModuleLevelBuilder builder : this.myBuilderRegistry.getBuilders(category)) {
                    builder.chunkBuildFinished(context, chunk);
                }
            }
            if (Utils.errorsDetected(context)) {
                context.processMessage(new CompilerMessage("", BuildMessage.Kind.JPS_INFO, JpsBuildBundle.message("build.message.errors.occurred.while.compiling.module.0", chunk.getPresentableShortName())));
            }
            throw throwable;
        }
        IncProjectBuilder.saveInstrumentedClasses(outputConsumer);
        outputConsumer.fireFileGeneratedEvents();
        outputConsumer.clear();
        for (BuilderCategory builderCategory : BuilderCategory.values()) {
            for (ModuleLevelBuilder builder : this.myBuilderRegistry.getBuilders(builderCategory)) {
                builder.chunkBuildFinished(context, chunk);
            }
        }
        if (Utils.errorsDetected(context)) {
            context.processMessage(new CompilerMessage("", BuildMessage.Kind.JPS_INFO, JpsBuildBundle.message("build.message.errors.occurred.while.compiling.module.0", chunk.getPresentableShortName())));
        }
        return doneSomething;
    }

    private static <T extends BuildRootDescriptor> void cleanOldOutputs(final CompileContext context, final BuildTarget<T> target) throws ProjectBuildException {
        if (!context.getScope().isBuildForced(target)) {
            BuildOperations.cleanOutputsCorrespondingToChangedFiles(context, new DirtyFilesHolderBase<T, BuildTarget<T>>(context){

                @Override
                public void processDirtyFiles(@NotNull FileProcessor<T, BuildTarget<T>> processor) throws IOException {
                    if (processor == null) {
                        9.$$$reportNull$$$0(0);
                    }
                    context.getProjectDescriptor().fsState.processFilesToRecompile(context, target, processor);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/jps/incremental/IncProjectBuilder$9", "processDirtyFiles"));
                }
            });
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildTargetsChunk(CompileContext context, BuildTargetChunk chunk, BuildProgress buildProgress) throws ProjectBuildException {
        Tracer.DelayedSpan buildSpan = Tracer.start(() -> "Building " + chunk.getPresentableName());
        BuildFSState fsState = this.myProjectDescriptor.fsState;
        try {
            context.setCompilationStartStamp(chunk.getTargets(), System.currentTimeMillis());
            this.sendBuildingTargetMessages(chunk.getTargets(), BuildingTargetProgressMessage.Event.STARTED);
            Utils.ERRORS_DETECTED_KEY.set((UserDataHolder)context, (Object)Boolean.FALSE);
            for (BuildTarget<?> buildTarget : chunk.getTargets()) {
                BuildOperations.ensureFSStateInitialized(context, buildTarget, false);
            }
            boolean doneSomething = this.processDeletedPaths(context, chunk.getTargets());
            fsState.beforeChunkBuildStart(context, chunk.getTargets());
            Tracer.DelayedSpan runBuildersSpan = Tracer.start(() -> "runBuilders " + chunk.getPresentableName());
            runBuildersSpan.complete();
            fsState.clearContextRoundData(context);
            fsState.clearContextChunk(context);
            if (doneSomething |= this.runBuildersForChunk(context, chunk, buildProgress)) {
                BuildOperations.markTargetsUpToDate(context, chunk.getTargets());
            }
        }
        catch (BuildDataCorruptedException | ProjectBuildException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    @NlsSafe StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(chunk.getPresentableName()).append(": ").append(e2.getClass().getName());
                    String string = e2.getMessage();
                    if (string == null) throw new ProjectBuildException(stringBuilder.toString(), e2);
                    stringBuilder.append(": ").append(string);
                    throw new ProjectBuildException(stringBuilder.toString(), e2);
                }
            }
            catch (Throwable throwable) {
                buildProgress.onTargetChunkFinished(chunk.getTargets(), context);
                for (BuildRootDescriptor buildRootDescriptor : this.myProjectDescriptor.getBuildRootIndex().clearTempRoots(context)) {
                    this.myProjectDescriptor.fsState.clearRecompile(buildRootDescriptor);
                }
                try {
                    Map map = (Map)Utils.REMOVED_SOURCES_KEY.get((UserDataHolder)context);
                    if (map == null) throw throwable;
                    for (Map.Entry entry : map.entrySet()) {
                        BuildTarget target = (BuildTarget)entry.getKey();
                        Collection paths = (Collection)entry.getValue();
                        if (paths == null) continue;
                        for (Path file : paths) {
                            fsState.registerDeleted(context, target, file, null);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e3) {
                    throw new ProjectBuildException(e3);
                }
                finally {
                    Utils.REMOVED_SOURCES_KEY.set((UserDataHolder)context, null);
                    this.sendBuildingTargetMessages(chunk.getTargets(), BuildingTargetProgressMessage.Event.FINISHED);
                    buildSpan.complete();
                }
            }
        }
        buildProgress.onTargetChunkFinished(chunk.getTargets(), context);
        for (BuildRootDescriptor buildRootDescriptor : this.myProjectDescriptor.getBuildRootIndex().clearTempRoots(context)) {
            this.myProjectDescriptor.fsState.clearRecompile(buildRootDescriptor);
        }
        try {
            Map map = (Map)Utils.REMOVED_SOURCES_KEY.get((UserDataHolder)context);
            if (map == null) return;
            for (Map.Entry entry : map.entrySet()) {
                BuildTarget target = (BuildTarget)entry.getKey();
                Collection paths = (Collection)entry.getValue();
                if (paths == null) continue;
                for (Path file : paths) {
                    fsState.registerDeleted(context, target, file, null);
                }
            }
            return;
        }
        catch (IOException e) {
            throw new ProjectBuildException(e);
        }
        finally {
            Utils.REMOVED_SOURCES_KEY.set((UserDataHolder)context, null);
            this.sendBuildingTargetMessages(chunk.getTargets(), BuildingTargetProgressMessage.Event.FINISHED);
            buildSpan.complete();
        }
    }

    private void sendBuildingTargetMessages(@NotNull Set<? extends BuildTarget<?>> targets, @NotNull BuildingTargetProgressMessage.Event event) {
        if (targets == null) {
            IncProjectBuilder.$$$reportNull$$$0(23);
        }
        if (event == null) {
            IncProjectBuilder.$$$reportNull$$$0(24);
        }
        this.myMessageDispatcher.processMessage(new BuildingTargetProgressMessage(targets, event));
    }

    private static void clearOutputFiles(CompileContext context, SourceToOutputMapping mapping, BuildTargetType<?> targetType, int targetId) throws IOException {
        Set dirsToDelete = targetType instanceof ModuleBasedBuildTargetType ? FileCollectionFactory.createCanonicalPathSet() : null;
        OutputToTargetMapping outputToTargetRegistry = context.getProjectDescriptor().dataManager.getOutputToTargetMapping();
        SourceToOutputMappingCursor cursor2 = mapping.cursor();
        while (cursor2.hasNext()) {
            cursor2.next();
            String[] outs = cursor2.getOutputPaths();
            if (outs.length <= 0) continue;
            ArrayList<String> deletedPaths = new ArrayList<String>();
            for (String out : outs) {
                BuildOperations.deleteRecursivelyAndCollectDeleted(Path.of(out, new String[0]), deletedPaths, dirsToDelete);
            }
            outputToTargetRegistry.removeMappings(Arrays.asList(outs), targetId, mapping);
            if (deletedPaths.isEmpty()) continue;
            context.processMessage(new FileDeletedEvent(deletedPaths));
        }
        if (dirsToDelete != null) {
            FSOperations.pruneEmptyDirs(context, dirsToDelete);
        }
    }

    private static void notifyChunkRebuildRequested(CompileContext context, ModuleChunk chunk, ModuleLevelBuilder builder) {
        Object infoMessage = JpsBuildBundle.message("builder.0.requested.rebuild.of.module.chunk.1", builder.getPresentableName(), chunk.getName());
        LOG.info((String)infoMessage);
        BuildMessage.Kind kind = BuildMessage.Kind.JPS_INFO;
        CompileScope scope = context.getScope();
        for (ModuleBuildTarget target : chunk.getTargets()) {
            if (scope.isWholeTargetAffected(target)) continue;
            infoMessage = (String)infoMessage + ".\n";
            infoMessage = (String)infoMessage + JpsBuildBundle.message("build.message.consider.building.whole.project.or.rebuilding.the.module", new Object[0]);
            kind = BuildMessage.Kind.INFO;
            break;
        }
        context.processMessage(new CompilerMessage("", kind, (String)infoMessage));
    }

    private void storeBuilderStatistics(Builder builder, long elapsedTime, int processedFiles) {
        this.myElapsedTimeNanosByBuilder.computeIfAbsent(builder, b -> new AtomicLong()).addAndGet(elapsedTime);
        this.myNumberOfSourcesProcessedByBuilder.computeIfAbsent(builder, b -> new AtomicInteger()).addAndGet(processedFiles);
    }

    private static void saveInstrumentedClasses(@NotNull ChunkBuildOutputConsumerImpl outputConsumer) throws IOException {
        if (outputConsumer == null) {
            IncProjectBuilder.$$$reportNull$$$0(25);
        }
        for (CompiledClass compiledClass : outputConsumer.getCompiledClasses().values()) {
            if (!compiledClass.isDirty()) continue;
            compiledClass.save();
        }
    }

    @NotNull
    private static CompileContext createContextWrapper(@NotNull CompileContext delegate) {
        if (delegate == null) {
            IncProjectBuilder.$$$reportNull$$$0(26);
        }
        UserDataHolderBase localDataHolder = new UserDataHolderBase();
        ConcurrentHashMap.KeySetView deletedKeysSet = ConcurrentHashMap.newKeySet();
        Class<UserDataHolder> dataHolderInterface = UserDataHolder.class;
        Class<MessageHandler> messageHandlerInterface = MessageHandler.class;
        CompileContext compileContext = (CompileContext)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), new Class[]{CompileContext.class}, (proxy, method, args) -> {
            BuildMessage msg;
            if (args == null) {
                return ourLookup.unreflect(method).invoke(delegate);
            }
            Class<?> declaringClass = method.getDeclaringClass();
            if (dataHolderInterface.equals(declaringClass)) {
                Object firstArgument = args[0];
                if (!(firstArgument instanceof GlobalContextKey)) {
                    boolean isWriteOperation;
                    boolean bl = isWriteOperation = args.length == 2;
                    if (isWriteOperation) {
                        if (args[1] == null) {
                            deletedKeysSet.add(firstArgument);
                        } else {
                            deletedKeysSet.remove(firstArgument);
                        }
                    } else if (deletedKeysSet.contains(firstArgument)) {
                        return null;
                    }
                    Object result = method.invoke((Object)localDataHolder, args);
                    if (isWriteOperation || result != null) {
                        return result;
                    }
                }
            } else if (messageHandlerInterface.equals(declaringClass) && (msg = (BuildMessage)args[0]).getKind() == BuildMessage.Kind.ERROR) {
                Utils.ERRORS_DETECTED_KEY.set((UserDataHolder)localDataHolder, (Object)Boolean.TRUE);
            }
            return ourLookup.unreflect(method).bindTo(delegate).asSpreader(Object[].class, args.length).invoke(args);
        });
        if (compileContext == null) {
            IncProjectBuilder.$$$reportNull$$$0(27);
        }
        return compileContext;
    }

    private static /* synthetic */ void lambda$build$2(BuildDataManager dataManager) {
        JavacMain.clearCompilerZipFileCache();
        dataManager.flush(false);
        dataManager.clearCache();
    }

    static {
        int maxThreads = Math.min(10, 75 * Runtime.getRuntime().availableProcessors() / 100);
        try {
            maxThreads = Math.max(1, Integer.parseInt(System.getProperty("compile.parallel.max.threads", Integer.toString(maxThreads))));
        }
        catch (NumberFormatException ignored) {
            maxThreads = Math.max(1, maxThreads);
        }
        MAX_BUILDER_THREADS = maxThreads;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderRegistry";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderParams";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canceledStatus";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/IncProjectBuilder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isAffected";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetCleanup";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputRoot";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildProgress";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputConsumer";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/IncProjectBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerMessage";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createContextWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkUpToDate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerMessage";
                break;
            }
            case 7: 
            case 27: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkRebuildRequired";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calculateEstimatedBuildTime";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "waitForTask";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runBuild";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "cleanOutputRoots";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTargetsWithClearedOutput";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "clearOutputs";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isEmpty";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "runTasks";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "buildChunks";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "sendBuildingTargetMessages";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "saveInstrumentedClasses";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createContextWrapper";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum Applicability {
        NONE,
        PARTIAL,
        ALL;


        static <T> Applicability calculate(Predicate<? super T> p, Collection<? extends T> collection) {
            int count = 0;
            int item = 0;
            for (T elem : collection) {
                ++item;
                if (!(p.test(elem) ? item > ++count : count > 0)) continue;
                return PARTIAL;
            }
            return count == 0 ? NONE : ALL;
        }
    }

    private final class BuildParallelizer {
        private final CompileContext myContext;
        private final BuildProgress myBuildProgress;
        private final AtomicReference<Throwable> myException = new AtomicReference();
        private final CountDownLatch taskCountDown;
        private final List<BuildChunkTask> myTasks;
        private final Runnable myFlushCommand;

        /*
         * WARNING - void declaration
         */
        private BuildParallelizer(CompileContext context, BuildProgress buildProgress) {
            void var13_18;
            Tracer.Span span = Tracer.start((String)"BuildParallelizer constructor");
            this.myContext = context;
            this.myBuildProgress = buildProgress;
            ProjectDescriptor pd = this.myContext.getProjectDescriptor();
            BuildTargetIndex targetIndex = pd.getBuildTargetIndex();
            this.myFlushCommand = Utils.asCountedRunnable(10, () -> pd.dataManager.flush(true));
            List<BuildTargetChunk> chunks = targetIndex.getSortedTargetChunks(this.myContext);
            this.myTasks = new ArrayList<BuildChunkTask>(chunks.size());
            HashMap targetToTask = new HashMap(chunks.size());
            for (BuildTargetChunk chunk : chunks) {
                BuildChunkTask task = new BuildChunkTask(chunk);
                this.myTasks.add(task);
                for (BuildTarget<?> buildTarget : chunk.getTargets()) {
                    targetToTask.put(buildTarget, task);
                }
                task.mySelfScore = chunk.getTargets().size();
            }
            Tracer.Span collectTaskDependantsSpan = Tracer.start((String)"IncProjectBuilder.collectTaskDependants");
            int taskCounter = 0;
            for (BuildChunkTask task : this.myTasks) {
                task.myIndex = taskCounter++;
                for (BuildTarget<?> buildTarget : task.getChunk().getTargets()) {
                    for (BuildTarget<?> dependency : targetIndex.getDependencies(buildTarget, this.myContext)) {
                        BuildChunkTask depTask = (BuildChunkTask)targetToTask.get(dependency);
                        if (depTask == null || depTask == task) continue;
                        task.addDependency(depTask);
                    }
                }
            }
            collectTaskDependantsSpan.complete();
            Tracer.Span prioritisationSpan = Tracer.start((String)"IncProjectBuilder.prioritisation");
            HashMap<BuildChunkTask, BitSet> chunkToTransitive = new HashMap<BuildChunkTask, BitSet>();
            int n = this.myTasks.size() - 1;
            while (var13_18 >= 0) {
                BuildChunkTask buildChunkTask = this.myTasks.get((int)var13_18);
                List<BuildChunkTask> dependantTasks = buildChunkTask.myTasksDependsOnThis;
                HashSet<BuildChunkTask> directDependants = new HashSet<BuildChunkTask>(dependantTasks);
                BitSet transitiveDependants = new BitSet();
                for (BuildChunkTask directDependant : directDependants) {
                    BitSet dependantChunkTransitiveDependants = (BitSet)chunkToTransitive.get(directDependant);
                    if (dependantChunkTransitiveDependants == null) continue;
                    transitiveDependants.or(dependantChunkTransitiveDependants);
                    transitiveDependants.set(directDependant.myIndex);
                }
                chunkToTransitive.put(buildChunkTask, transitiveDependants);
                buildChunkTask.myDepsScore = transitiveDependants.cardinality();
                --var13_18;
            }
            prioritisationSpan.complete();
            this.taskCountDown = new CountDownLatch(this.myTasks.size());
            span.complete();
        }

        public void buildInParallel() throws ProjectBuildException {
            ArrayList<BuildChunkTask> initialTasks = new ArrayList<BuildChunkTask>();
            for (BuildChunkTask task : this.myTasks) {
                if (!task.isReady()) continue;
                initialTasks.add(task);
            }
            Executor parallelBuildExecutor = SharedThreadPool.getInstance().createCustomPriorityQueueBoundedExecutor("IncProjectBuilder Executor Pool", MAX_BUILDER_THREADS, (o1, o2) -> {
                int p1 = o1 instanceof RunnableWithPriority ? ((RunnableWithPriority)o1).priority : 1;
                int p2 = o1 instanceof RunnableWithPriority ? ((RunnableWithPriority)o2).priority : 1;
                return Integer.compare(p2, p1);
            });
            this.queueTasks(initialTasks, LOG.isDebugEnabled(), parallelBuildExecutor);
            try {
                this.taskCountDown.await();
            }
            catch (InterruptedException e) {
                LOG.info((Throwable)e);
            }
            Throwable throwable = this.myException.get();
            if (throwable instanceof ProjectBuildException) {
                throw (ProjectBuildException)throwable;
            }
            if (throwable != null) {
                throw new ProjectBuildException(throwable);
            }
        }

        private void queueTasks(List<BuildChunkTask> tasks, boolean isDebugLogEnabled, @NotNull Executor parallelBuildExecutor) {
            if (parallelBuildExecutor == null) {
                BuildParallelizer.$$$reportNull$$$0(0);
            }
            BuildChunkTask[] sorted = tasks.toArray(new BuildChunkTask[0]);
            Arrays.sort(sorted, Comparator.comparingLong(rec$ -> ((BuildChunkTask)rec$).getScore()).reversed());
            if (isDebugLogEnabled) {
                ArrayList<BuildTargetChunk> chunksToLog = new ArrayList<BuildTargetChunk>(sorted.length);
                for (BuildChunkTask task : sorted) {
                    chunksToLog.add(task.getChunk());
                }
                StringBuilder logBuilder = new StringBuilder().append("Queuing ").append(chunksToLog.size()).append(" chunks in parallel: ");
                chunksToLog.sort(Comparator.comparing(BuildTargetChunk::toString));
                for (BuildTargetChunk chunk : chunksToLog) {
                    logBuilder.append(chunk.toString()).append("; ");
                }
                LOG.debug(logBuilder.toString());
            }
            for (BuildChunkTask task : sorted) {
                this.queueTask(task, isDebugLogEnabled, parallelBuildExecutor);
            }
        }

        private void queueTask(final @NotNull BuildChunkTask task, final boolean isDebugLogEnabled, final @NotNull Executor parallelBuildExecutor) {
            if (task == null) {
                BuildParallelizer.$$$reportNull$$$0(1);
            }
            if (parallelBuildExecutor == null) {
                BuildParallelizer.$$$reportNull$$$0(2);
            }
            final CompileContext chunkLocalContext = IncProjectBuilder.createContextWrapper(this.myContext);
            parallelBuildExecutor.execute(new RunnableWithPriority(task.getScore()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        try {
                            if (BuildParallelizer.this.myException.get() == null) {
                                IncProjectBuilder.this.buildChunkIfAffected(chunkLocalContext, BuildParallelizer.this.myContext.getScope(), task.getChunk(), BuildParallelizer.this.myBuildProgress);
                            }
                        }
                        finally {
                            IncProjectBuilder.this.myProjectDescriptor.dataManager.closeSourceToOutputStorages(task.getChunk().getTargets());
                            BuildParallelizer.this.myFlushCommand.run();
                        }
                    }
                    catch (Throwable e) {
                        BuildParallelizer.this.myException.compareAndSet(null, e);
                        LOG.info(e);
                    }
                    finally {
                        try {
                            List<BuildChunkTask> nextTasks;
                            if (isDebugLogEnabled) {
                                LOG.debug("Finished compilation of " + task.getChunk().toString());
                            }
                            if ((nextTasks = task.getNextReadyTasks()) != null && !nextTasks.isEmpty()) {
                                BuildParallelizer.this.queueTasks(nextTasks, isDebugLogEnabled, parallelBuildExecutor);
                            }
                        }
                        finally {
                            BuildParallelizer.this.taskCountDown.countDown();
                        }
                    }
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parallelBuildExecutor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/incremental/IncProjectBuilder$BuildParallelizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "queueTasks";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "queueTask";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private abstract class RunnableWithPriority
        implements Runnable,
        ContextAwareRunnable {
            public final int priority;

            RunnableWithPriority(int priority) {
                this.priority = priority;
            }
        }
    }

    private static interface ErrorsCapture
    extends CompileContext {
        public boolean hasErrors();

        public boolean reportErrors();

        public static ErrorsCapture wrap(CompileContext delegate) {
            SmartList capturedErrors = new SmartList();
            return (ErrorsCapture)Proxy.newProxyInstance(ErrorsCapture.class.getClassLoader(), new Class[]{ErrorsCapture.class}, (arg_0, arg_1, arg_2) -> ErrorsCapture.lambda$wrap$0((List)capturedErrors, delegate, arg_0, arg_1, arg_2));
        }

        private static /* synthetic */ Object lambda$wrap$0(List capturedErrors, CompileContext delegate, Object proxy, Method method, Object[] args) throws Throwable {
            Class<?> declaringClass = method.getDeclaringClass();
            if (ErrorsCapture.class.equals(declaringClass)) {
                boolean empty = capturedErrors.isEmpty();
                if ("hasErrors".equals(method.getName())) {
                    return !empty;
                }
                if (empty) {
                    return false;
                }
                for (CompilerMessage error : capturedErrors) {
                    delegate.processMessage(error);
                }
                capturedErrors.clear();
                return true;
            }
            if (MessageHandler.class.equals(declaringClass)) {
                for (Object arg : args) {
                    CompilerMessage compilerMessage;
                    if (!(arg instanceof CompilerMessage) || (compilerMessage = (CompilerMessage)arg).getKind() != BuildMessage.Kind.ERROR) continue;
                    capturedErrors.add(compilerMessage);
                    return null;
                }
            }
            if (UserDataHolder.class.equals(declaringClass) && args != null && args.length == 1 && !Void.class.equals(method.getReturnType()) && Utils.ERRORS_DETECTED_KEY.equals(args[0]) && !capturedErrors.isEmpty()) {
                return true;
            }
            MethodHandle mh = ourLookup.unreflect(method).bindTo(delegate);
            return args == null ? mh.invoke() : mh.asSpreader(Object[].class, args.length).invoke(args);
        }
    }

    private static final class BuildChunkTask {
        private final BuildTargetChunk myChunk;
        private final AtomicInteger myNotBuildDependenciesCount = new AtomicInteger(0);
        private final Set<BuildChunkTask> myNotBuiltDependencies = new HashSet<BuildChunkTask>();
        private final List<BuildChunkTask> myTasksDependsOnThis = new ArrayList<BuildChunkTask>();
        private int mySelfScore = 0;
        private int myDepsScore = 0;
        private int myIndex = 0;

        private BuildChunkTask(BuildTargetChunk chunk) {
            this.myChunk = chunk;
        }

        private int getScore() {
            return this.myDepsScore + this.mySelfScore;
        }

        public BuildTargetChunk getChunk() {
            return this.myChunk;
        }

        public boolean isReady() {
            return this.myNotBuildDependenciesCount.get() == 0;
        }

        public void addDependency(BuildChunkTask dependency) {
            if (this.myNotBuiltDependencies.add(dependency)) {
                this.myNotBuildDependenciesCount.incrementAndGet();
                dependency.myTasksDependsOnThis.add(this);
            }
        }

        @Nullable
        List<BuildChunkTask> getNextReadyTasks() {
            List nextTasks = null;
            for (BuildChunkTask task : this.myTasksDependsOnThis) {
                int dependenciesCount = task.myNotBuildDependenciesCount.decrementAndGet();
                if (dependenciesCount != 0) continue;
                if (nextTasks == null) {
                    nextTasks = new SmartList();
                }
                nextTasks.add(task);
            }
            return nextTasks;
        }
    }
}

