/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.dependency.Usage;
import org.jetbrains.jps.dependency.java.ClassUsage;
import org.jetbrains.jps.javac.Iterators;
import org.jetbrains.org.objectweb.asm.Type;

public abstract class TypeRepr {
    @NotNull
    public abstract String getDescriptor();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public Iterable<Usage> getUsages() {
        return Collections.emptyList();
    }

    static Iterable<TypeRepr> getTypes(Type[] types) {
        return types == null || types.length == 0 ? Collections.emptySet() : Iterators.map(Arrays.asList(types), t -> TypeRepr.getType(t));
    }

    public static TypeRepr getType(String descriptor) {
        return TypeRepr.getType(Type.getType((String)descriptor));
    }

    public static TypeRepr getType(Type t) {
        switch (t.getSort()) {
            case 10: {
                return new ClassType(t.getClassName().replace('.', '/'));
            }
            case 9: {
                return new ArrayType(TypeRepr.getType(t.getElementType().getDescriptor()));
            }
        }
        return new PrimitiveType(t.getDescriptor());
    }

    public static final class ClassType
    extends TypeRepr {
        public static final ClassType BOOLEAN = new ClassType("java/lang/Boolean");
        public static final ClassType BYTE = new ClassType("java/lang/Byte");
        public static final ClassType CHARACTER = new ClassType("java/lang/Character");
        public static final ClassType FLOAT = new ClassType("java/lang/Float");
        public static final ClassType INTEGER = new ClassType("java/lang/Integer");
        public static final ClassType LONG = new ClassType("java/lang/Long");
        public static final ClassType SHORT = new ClassType("java/lang/Short");
        public static final ClassType DOUBLE = new ClassType("java/lang/Double");
        private final String myJvmName;

        public ClassType(String jvmName) {
            this.myJvmName = jvmName;
        }

        public String getJvmName() {
            return this.myJvmName;
        }

        @Override
        public Iterable<Usage> getUsages() {
            return Collections.singleton(new ClassUsage(this.myJvmName));
        }

        @Override
        @NotNull
        public String getDescriptor() {
            String string = "L" + this.myJvmName + ";";
            if (string == null) {
                ClassType.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassType classType = (ClassType)o;
            return this.myJvmName.equals(classType.myJvmName);
        }

        @Override
        public int hashCode() {
            return this.myJvmName.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/dependency/java/TypeRepr$ClassType", "getDescriptor"));
        }
    }

    public static final class ArrayType
    extends TypeRepr {
        @NotNull
        private final TypeRepr myElementType;

        public ArrayType(@NotNull TypeRepr elementType) {
            if (elementType == null) {
                ArrayType.$$$reportNull$$$0(0);
            }
            this.myElementType = elementType;
        }

        @Override
        @NotNull
        public String getDescriptor() {
            String string = "[" + this.myElementType.getDescriptor();
            if (string == null) {
                ArrayType.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public TypeRepr getElementType() {
            TypeRepr typeRepr = this.myElementType;
            if (typeRepr == null) {
                ArrayType.$$$reportNull$$$0(2);
            }
            return typeRepr;
        }

        @NotNull
        public TypeRepr getDeepElementType() {
            TypeRepr current = this;
            while (current instanceof ArrayType) {
                current = current.myElementType;
            }
            ArrayType arrayType = current;
            if (arrayType == null) {
                ArrayType.$$$reportNull$$$0(3);
            }
            return arrayType;
        }

        @Override
        public Iterable<Usage> getUsages() {
            return this.getDeepElementType().getUsages();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArrayType arrayType = (ArrayType)o;
            return this.myElementType.equals(arrayType.myElementType);
        }

        @Override
        public int hashCode() {
            return this.myElementType.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementType";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/dependency/java/TypeRepr$ArrayType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/dependency/java/TypeRepr$ArrayType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescriptor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeepElementType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class PrimitiveType
    extends TypeRepr {
        public static final PrimitiveType BOOLEAN = new PrimitiveType("Z");
        public static final PrimitiveType BYTE = new PrimitiveType("B");
        public static final PrimitiveType CHAR = new PrimitiveType("C");
        public static final PrimitiveType FLOAT = new PrimitiveType("F");
        public static final PrimitiveType INT = new PrimitiveType("I");
        public static final PrimitiveType LONG = new PrimitiveType("J");
        public static final PrimitiveType SHORT = new PrimitiveType("S");
        public static final PrimitiveType DOUBLE = new PrimitiveType("D");
        @NotNull
        private final String myDescriptor;

        public PrimitiveType(@NotNull String descriptor) {
            if (descriptor == null) {
                PrimitiveType.$$$reportNull$$$0(0);
            }
            this.myDescriptor = descriptor;
        }

        @Override
        @NotNull
        public String getDescriptor() {
            String string = this.myDescriptor;
            if (string == null) {
                PrimitiveType.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrimitiveType that = (PrimitiveType)o;
            return this.myDescriptor.equals(that.myDescriptor);
        }

        @Override
        public int hashCode() {
            return this.myDescriptor.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/dependency/java/TypeRepr$PrimitiveType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/dependency/java/TypeRepr$PrimitiveType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

