/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import org.jetbrains.jps.dependency.DifferentiateContext;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.diff.Difference;
import org.jetbrains.jps.dependency.java.JVMClassNode;
import org.jetbrains.jps.dependency.java.JvmClass;
import org.jetbrains.jps.dependency.java.JvmField;
import org.jetbrains.jps.dependency.java.JvmMethod;
import org.jetbrains.jps.dependency.java.JvmModule;
import org.jetbrains.jps.dependency.java.Utils;

public interface JvmDifferentiateStrategy {
    default public boolean isIncremental(DifferentiateContext context, Node<?, ?> affectedNode) {
        return true;
    }

    default public boolean processRemovedClasses(DifferentiateContext context, Iterable<JvmClass> removedClasses, Utils future, Utils present) {
        for (JvmClass aClass : removedClasses) {
            if (this.processRemovedClass(context, aClass, future, present)) continue;
            return false;
        }
        return true;
    }

    default public boolean processRemovedClass(DifferentiateContext context, JvmClass removedClass, Utils future, Utils present) {
        return true;
    }

    default public boolean processAddedClasses(DifferentiateContext context, Iterable<JvmClass> addedClasses, Utils future, Utils present) {
        for (JvmClass aClass : addedClasses) {
            if (this.processAddedClass(context, aClass, future, present)) continue;
            return false;
        }
        return true;
    }

    default public boolean processAddedClass(DifferentiateContext context, JvmClass addedClass, Utils future, Utils present) {
        return true;
    }

    default public boolean processChangedClasses(DifferentiateContext context, Iterable<Difference.Change<JvmClass, JvmClass.Diff>> changed, Utils future, Utils present) {
        for (Difference.Change<JvmClass, JvmClass.Diff> change : changed) {
            Difference.Specifier<JvmField, JvmField.Diff> fieldsDiff;
            if (!this.processChangedClass(context, change, future, present)) {
                return false;
            }
            JvmClass changedClass = change.getPast();
            Difference.Specifier<JvmMethod, JvmMethod.Diff> methodsDiff = change.getDiff().methods();
            if (!methodsDiff.unchanged()) {
                if (!this.processRemovedMethods(context, change, methodsDiff.removed(), future, present)) {
                    return false;
                }
                if (!this.processAddedMethods(context, change, methodsDiff.added(), future, present)) {
                    return false;
                }
                if (!this.processChangedMethods(context, change, methodsDiff.changed(), future, present)) {
                    return false;
                }
            }
            if ((fieldsDiff = change.getDiff().fields()).unchanged()) continue;
            if (!this.processRemovedFields(context, change, fieldsDiff.removed(), future, present)) {
                return false;
            }
            if (!this.processAddedFields(context, change, fieldsDiff.added(), future, present)) {
                return false;
            }
            if (this.processChangedFields(context, change, fieldsDiff.changed(), future, present)) continue;
            return false;
        }
        return true;
    }

    default public boolean processChangedClass(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, Utils future, Utils present) {
        return true;
    }

    default public boolean processRemovedMethods(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, Iterable<JvmMethod> removed, Utils future, Utils present) {
        for (JvmMethod method : removed) {
            if (this.processRemovedMethod(context, change, method, future, present)) continue;
            return false;
        }
        return true;
    }

    default public boolean processRemovedMethod(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, JvmMethod removedMethod, Utils future, Utils present) {
        return true;
    }

    default public boolean processAddedMethods(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, Iterable<JvmMethod> added, Utils future, Utils present) {
        for (JvmMethod method : added) {
            if (this.processAddedMethod(context, change, method, future, present)) continue;
            return false;
        }
        return true;
    }

    default public boolean processAddedMethod(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, JvmMethod addedMethod, Utils future, Utils present) {
        return true;
    }

    default public boolean processChangedMethods(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, Iterable<Difference.Change<JvmMethod, JvmMethod.Diff>> methodChanges, Utils future, Utils present) {
        for (Difference.Change<JvmMethod, JvmMethod.Diff> methodChange : methodChanges) {
            if (this.processChangedMethod(context, change, methodChange, future, present)) continue;
            return false;
        }
        return true;
    }

    default public boolean processChangedMethod(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> clsChange, Difference.Change<JvmMethod, JvmMethod.Diff> methodChange, Utils future, Utils present) {
        return true;
    }

    default public boolean processRemovedFields(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, Iterable<JvmField> removed, Utils future, Utils present) {
        for (JvmField field : removed) {
            if (this.processRemovedField(context, change, field, future, present)) continue;
            return false;
        }
        return true;
    }

    default public boolean processRemovedField(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, JvmField removedField, Utils future, Utils present) {
        return true;
    }

    default public boolean processAddedFields(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, Iterable<JvmField> added, Utils future, Utils present) {
        for (JvmField field : added) {
            if (this.processAddedField(context, change, field, future, present)) continue;
            return false;
        }
        return true;
    }

    default public boolean processAddedField(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, JvmField addedField, Utils future, Utils present) {
        return true;
    }

    default public boolean processChangedFields(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> clsChange, Iterable<Difference.Change<JvmField, JvmField.Diff>> fieldChanges, Utils future, Utils present) {
        for (Difference.Change<JvmField, JvmField.Diff> fieldChange : fieldChanges) {
            if (this.processChangedField(context, clsChange, fieldChange, future, present)) continue;
            return false;
        }
        return true;
    }

    default public boolean processChangedField(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> clsChange, Difference.Change<JvmField, JvmField.Diff> fieldChange, Utils future, Utils present) {
        return true;
    }

    default public boolean processRemovedModules(DifferentiateContext context, Iterable<JvmModule> removed, Utils future, Utils present) {
        for (JvmModule module : removed) {
            if (this.processRemovedModule(context, module, future, present)) continue;
            return false;
        }
        return true;
    }

    default public boolean processRemovedModule(DifferentiateContext context, JvmModule removedModule, Utils future, Utils present) {
        return true;
    }

    default public boolean processAddedModules(DifferentiateContext context, Iterable<JvmModule> added, Utils future, Utils present) {
        for (JvmModule module : added) {
            if (this.processAddedModule(context, module, future, present)) continue;
            return false;
        }
        return true;
    }

    default public boolean processAddedModule(DifferentiateContext context, JvmModule addedModule, Utils future, Utils present) {
        return true;
    }

    default public boolean processChangedModules(DifferentiateContext context, Iterable<Difference.Change<JvmModule, JvmModule.Diff>> changed, Utils future, Utils present) {
        for (Difference.Change<JvmModule, JvmModule.Diff> change : changed) {
            if (this.processChangedModule(context, change, future, present)) continue;
            return false;
        }
        return true;
    }

    default public boolean processChangedModule(DifferentiateContext context, Difference.Change<JvmModule, JvmModule.Diff> change, Utils future, Utils present) {
        return true;
    }

    default public boolean processNodesWithErrors(DifferentiateContext context, Iterable<JVMClassNode<?, ?>> nodes, Utils present) {
        return true;
    }
}

