/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.BackDependencyIndex;
import org.jetbrains.jps.dependency.Externalizer;
import org.jetbrains.jps.dependency.Graph;
import org.jetbrains.jps.dependency.MapletFactory;
import org.jetbrains.jps.dependency.MultiMaplet;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.ReferenceID;
import org.jetbrains.jps.dependency.impl.NodeDependenciesIndex;
import org.jetbrains.jps.dependency.impl.PathSource;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;

@ApiStatus.Internal
public abstract class GraphImpl
implements Graph {
    private final BackDependencyIndex myDependencyIndex;
    private final List<BackDependencyIndex> myIndices;
    protected final MultiMaplet<ReferenceID, NodeSource> myNodeToSourcesMap;
    protected final MultiMaplet<NodeSource, Node<?, ?>> mySourceToNodesMap;
    private final MapletFactory myContainerFactory;

    protected GraphImpl(@NotNull MapletFactory cFactory) {
        if (cFactory == null) {
            GraphImpl.$$$reportNull$$$0(0);
        }
        this.myIndices = new ArrayList<BackDependencyIndex>();
        this.myContainerFactory = cFactory;
        try {
            this.myDependencyIndex = new NodeDependenciesIndex(cFactory);
            this.addIndex(this.myDependencyIndex);
            Externalizer<NodeSource> srcExternalizer = Externalizer.forGraphElement(PathSource::new);
            this.myNodeToSourcesMap = cFactory.createSetMultiMaplet("node-sources-map", Externalizer.forGraphElement(JvmNodeReferenceID::new), srcExternalizer);
            this.mySourceToNodesMap = cFactory.createSetMultiMaplet("source-nodes-map", srcExternalizer, Externalizer.forAnyGraphElement());
        }
        catch (RuntimeException e) {
            this.closeIgnoreErrors();
            throw e;
        }
    }

    protected final void addIndex(BackDependencyIndex index) {
        this.myIndices.add(index);
    }

    @Override
    @NotNull
    public Iterable<ReferenceID> getDependingNodes(@NotNull ReferenceID id) {
        if (id == null) {
            GraphImpl.$$$reportNull$$$0(1);
        }
        Iterable<ReferenceID> iterable = this.myDependencyIndex.getDependencies(id);
        if (iterable == null) {
            GraphImpl.$$$reportNull$$$0(2);
        }
        return iterable;
    }

    @Override
    public final Iterable<BackDependencyIndex> getIndices() {
        return this.myIndices;
    }

    @Override
    @Nullable
    public final BackDependencyIndex getIndex(String name) {
        for (BackDependencyIndex index : this.myIndices) {
            if (!index.getName().equals(name)) continue;
            return index;
        }
        return null;
    }

    @Override
    public Iterable<NodeSource> getSources(@NotNull ReferenceID id) {
        if (id == null) {
            GraphImpl.$$$reportNull$$$0(3);
        }
        return this.myNodeToSourcesMap.get(id);
    }

    @Override
    public Iterable<ReferenceID> getRegisteredNodes() {
        return this.myNodeToSourcesMap.getKeys();
    }

    @Override
    public Iterable<NodeSource> getSources() {
        return this.mySourceToNodesMap.getKeys();
    }

    @Override
    public Iterable<Node<?, ?>> getNodes(@NotNull NodeSource source) {
        if (source == null) {
            GraphImpl.$$$reportNull$$$0(4);
        }
        return this.mySourceToNodesMap.get(source);
    }

    protected final void closeIgnoreErrors() {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void close() throws IOException {
        if (this.myContainerFactory instanceof Closeable) {
            ((Closeable)((Object)this.myContainerFactory)).close();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cFactory";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/dependency/impl/GraphImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/dependency/impl/GraphImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependingNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDependingNodes";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSources";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNodes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

