/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cmdline;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.FileCollectionFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.BuildType;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.backwardRefs.JavaBackwardReferenceIndexWriter;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.JpsBuildBundle;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.impl.BuildDataPathsImpl;
import org.jetbrains.jps.builders.impl.BuildRootIndexImpl;
import org.jetbrains.jps.builders.impl.BuildTargetIndexImpl;
import org.jetbrains.jps.builders.impl.BuildTargetRegistryImpl;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.logging.BuildLoggingManager;
import org.jetbrains.jps.cmdline.JpsModelLoader;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BuilderRegistry;
import org.jetbrains.jps.incremental.CompileScope;
import org.jetbrains.jps.incremental.CompileScopeImpl;
import org.jetbrains.jps.incremental.IncProjectBuilder;
import org.jetbrains.jps.incremental.MessageHandler;
import org.jetbrains.jps.incremental.RebuildRequestedException;
import org.jetbrains.jps.incremental.TargetTypeRegistry;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.fs.BuildFSState;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.incremental.storage.BuildTargetStateManagerImpl;
import org.jetbrains.jps.incremental.storage.BuildTargetsState;
import org.jetbrains.jps.incremental.storage.ProjectStamps;
import org.jetbrains.jps.incremental.storage.StampsStorage;
import org.jetbrains.jps.incremental.storage.StorageManager;
import org.jetbrains.jps.indices.impl.IgnoredFileIndexImpl;
import org.jetbrains.jps.indices.impl.ModuleExcludeIndexImpl;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;

public final class BuildRunner {
    private static final boolean USE_EXPERIMENTAL_STORAGE = Boolean.getBoolean("jps.use.experimental.storage");
    private static final Logger LOG = Logger.getInstance(BuildRunner.class);
    private final JpsModelLoader myModelLoader;
    private List<String> myFilePaths;
    private Map<String, String> myBuilderParams;
    private boolean myForceCleanCaches;

    public BuildRunner(@NotNull JpsModelLoader modelLoader) {
        if (modelLoader == null) {
            BuildRunner.$$$reportNull$$$0(0);
        }
        this.myFilePaths = Collections.emptyList();
        this.myBuilderParams = Collections.emptyMap();
        this.myModelLoader = modelLoader;
    }

    public void setFilePaths(@Nullable List<String> filePaths) {
        this.myFilePaths = filePaths == null ? Collections.emptyList() : filePaths;
    }

    public void setBuilderParams(@Nullable Map<String, String> builderParams) {
        this.myBuilderParams = builderParams == null ? Collections.emptyMap() : builderParams;
    }

    @NotNull
    public JpsProject loadModelAndGetJpsProject() throws IOException {
        JpsProject jpsProject = this.myModelLoader.loadModel().getProject();
        if (jpsProject == null) {
            BuildRunner.$$$reportNull$$$0(1);
        }
        return jpsProject;
    }

    @Deprecated(forRemoval=true)
    public ProjectDescriptor load(@NotNull MessageHandler msgHandler, @NotNull File dataStorageRoot, @NotNull BuildFSState fsState) throws IOException {
        if (msgHandler == null) {
            BuildRunner.$$$reportNull$$$0(2);
        }
        if (dataStorageRoot == null) {
            BuildRunner.$$$reportNull$$$0(3);
        }
        if (fsState == null) {
            BuildRunner.$$$reportNull$$$0(4);
        }
        return this.load(msgHandler, dataStorageRoot.toPath(), fsState);
    }

    public ProjectDescriptor load(@NotNull MessageHandler msgHandler, @NotNull Path dataStorageRoot, @NotNull BuildFSState fsState) throws IOException {
        if (msgHandler == null) {
            BuildRunner.$$$reportNull$$$0(5);
        }
        if (dataStorageRoot == null) {
            BuildRunner.$$$reportNull$$$0(6);
        }
        if (fsState == null) {
            BuildRunner.$$$reportNull$$$0(7);
        }
        JpsModel jpsModel = this.myModelLoader.loadModel();
        BuildDataPathsImpl dataPaths = new BuildDataPathsImpl(dataStorageRoot);
        BuildTargetRegistryImpl targetRegistry = new BuildTargetRegistryImpl(jpsModel);
        ModuleExcludeIndexImpl index = new ModuleExcludeIndexImpl(jpsModel);
        IgnoredFileIndexImpl ignoredFileIndex = new IgnoredFileIndexImpl(jpsModel);
        BuildRootIndexImpl buildRootIndex = new BuildRootIndexImpl(targetRegistry, jpsModel, index, dataPaths, ignoredFileIndex);
        BuildTargetIndexImpl targetIndex = new BuildTargetIndexImpl(targetRegistry, buildRootIndex);
        PathRelativizerService relativizer = new PathRelativizerService(jpsModel.getProject(), (Boolean)JavaBackwardReferenceIndexWriter.isCompilerReferenceFSCaseSensitive());
        BuildDataManager dataManager = null;
        StorageManager storageManager = null;
        try {
            storageManager = BuildRunner.createStorageManager(dataStorageRoot);
            dataManager = new BuildDataManager(dataPaths, new BuildTargetsState(new BuildTargetStateManagerImpl(dataPaths, jpsModel)), relativizer, storageManager);
            if (dataManager.versionDiffers()) {
                this.myForceCleanCaches = true;
                msgHandler.processMessage(new CompilerMessage(BuildRunner.getRootCompilerName(), BuildMessage.Kind.INFO, JpsBuildBundle.message("build.message.dependency.data.format.has.changed.project.rebuild.required", new Object[0])));
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            if (storageManager != null) {
                storageManager.forceClose();
            }
            if (dataManager != null) {
                dataManager.close();
            }
            this.myForceCleanCaches = true;
            FileUtilRt.deleteRecursively((Path)dataStorageRoot);
            dataManager = new BuildDataManager(dataPaths, new BuildTargetsState(new BuildTargetStateManagerImpl(dataPaths, jpsModel)), relativizer, BuildRunner.createStorageManager(dataStorageRoot));
            msgHandler.processMessage(new CompilerMessage(BuildRunner.getRootCompilerName(), BuildMessage.Kind.INFO, JpsBuildBundle.message("build.message.project.rebuild.forced.0", e.getMessage())));
        }
        return new ProjectDescriptor(jpsModel, fsState, dataManager, BuildLoggingManager.DEFAULT, index, targetIndex, buildRootIndex, ignoredFileIndex);
    }

    @Nullable
    private static StorageManager createStorageManager(@NotNull Path dataStorageRoot) {
        if (dataStorageRoot == null) {
            BuildRunner.$$$reportNull$$$0(8);
        }
        if (USE_EXPERIMENTAL_STORAGE || ProjectStamps.PORTABLE_CACHES) {
            StorageManager manager = new StorageManager(dataStorageRoot.resolve("jps-portable-cache.db"));
            manager.open();
            return manager;
        }
        return null;
    }

    @NotNull
    @Nls
    public static String getRootCompilerName() {
        String string = JpsBuildBundle.message("builder.name.root", new Object[0]);
        if (string == null) {
            BuildRunner.$$$reportNull$$$0(9);
        }
        return string;
    }

    public void setForceCleanCaches(boolean forceCleanCaches) {
        this.myForceCleanCaches = forceCleanCaches;
    }

    public void runBuild(@NotNull ProjectDescriptor pd, @NotNull CanceledStatus cs, @NotNull MessageHandler msgHandler, @NotNull BuildType buildType, @NotNull List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes, boolean includeDependenciesToScope) throws Exception {
        if (pd == null) {
            BuildRunner.$$$reportNull$$$0(10);
        }
        if (cs == null) {
            BuildRunner.$$$reportNull$$$0(11);
        }
        if (msgHandler == null) {
            BuildRunner.$$$reportNull$$$0(12);
        }
        if (buildType == null) {
            BuildRunner.$$$reportNull$$$0(13);
        }
        if (scopes == null) {
            BuildRunner.$$$reportNull$$$0(14);
        }
        for (int attempt = 0; attempt < 2 && !cs.isCanceled(); ++attempt) {
            boolean forceClean = this.myForceCleanCaches && this.myFilePaths.isEmpty();
            CompileScope compileScope = BuildRunner.createCompilationScope(pd, scopes, this.myFilePaths, forceClean, includeDependenciesToScope);
            IncProjectBuilder builder = new IncProjectBuilder(pd, BuilderRegistry.getInstance(), this.myBuilderParams, cs, Utils.IS_TEST_MODE);
            builder.addMessageHandler(msgHandler);
            try {
                switch (buildType) {
                    case BUILD: {
                        builder.build(compileScope, forceClean);
                        break;
                    }
                    case CLEAN: {
                        break;
                    }
                    case UP_TO_DATE_CHECK: {
                        builder.checkUpToDate(compileScope);
                    }
                }
                break;
            }
            catch (RebuildRequestedException e) {
                if (attempt != 0) {
                    throw e;
                }
                LOG.info((Throwable)e);
                this.myForceCleanCaches = true;
                continue;
            }
        }
    }

    public CompileScope createCompilationScope(ProjectDescriptor pd, List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes) throws Exception {
        boolean forceClean = this.myForceCleanCaches && this.myFilePaths.isEmpty();
        return BuildRunner.createCompilationScope(pd, scopes, this.myFilePaths, forceClean, false);
    }

    private static CompileScope createCompilationScope(@NotNull ProjectDescriptor projectDescriptor, @NotNull List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes, @NotNull Collection<String> paths, boolean forceClean, boolean includeDependenciesToScope) throws Exception {
        Map<BuildTarget<?>, Set<File>> files;
        if (projectDescriptor == null) {
            BuildRunner.$$$reportNull$$$0(15);
        }
        if (scopes == null) {
            BuildRunner.$$$reportNull$$$0(16);
        }
        if (paths == null) {
            BuildRunner.$$$reportNull$$$0(17);
        }
        HashSet targetTypes = new HashSet();
        HashSet targetTypesToForceBuild = new HashSet();
        HashSet targets = new HashSet();
        TargetTypeRegistry typeRegistry = TargetTypeRegistry.getInstance();
        for (CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope scope : scopes) {
            BuildTargetType<?> buildTargetType = typeRegistry.getTargetType(scope.getTypeId());
            if (buildTargetType == null) {
                LOG.info("Unknown target type: " + scope.getTypeId());
                continue;
            }
            if (scope.getForceBuild() || forceClean) {
                targetTypesToForceBuild.add(buildTargetType);
            }
            if (scope.getAllTargets()) {
                targetTypes.add(buildTargetType);
                continue;
            }
            BuildTargetLoader<?> loader = buildTargetType.createLoader(projectDescriptor.getModel());
            for (String targetId : scope.getTargetIdList()) {
                Object target = loader.createTarget(targetId);
                if (target != null) {
                    targets.add((BuildTarget<?>)target);
                    continue;
                }
                LOG.info("Unknown " + buildTargetType + " target id: " + targetId);
            }
        }
        if (includeDependenciesToScope) {
            BuildRunner.includeDependenciesToScope(targetTypes, targets, targetTypesToForceBuild, projectDescriptor);
        }
        if (paths.isEmpty()) {
            files = Collections.emptyMap();
        } else {
            boolean forceBuildAllModuleBasedTargets = false;
            for (BuildTargetType buildTargetType : targetTypesToForceBuild) {
                if (!(buildTargetType instanceof JavaModuleBuildTargetType)) continue;
                forceBuildAllModuleBasedTargets = true;
                break;
            }
            files = new HashMap();
            for (String string : paths) {
                File file = new File(string);
                Collection descriptors = projectDescriptor.getBuildRootIndex().findAllParentDescriptors(file, null);
                for (BuildRootDescriptor descriptor : descriptors) {
                    BuildTargetType<BuildTarget<?>> targetType;
                    boolean added;
                    Set fileSet = files.get(descriptor.getTarget());
                    if (fileSet == null) {
                        fileSet = FileCollectionFactory.createCanonicalFileSet();
                        files.put(descriptor.getTarget(), fileSet);
                    }
                    if (!(added = fileSet.add(file)) || !targetTypesToForceBuild.contains(targetType = descriptor.getTarget().getTargetType()) && (!forceBuildAllModuleBasedTargets || !(targetType instanceof ModuleBasedBuildTargetType))) continue;
                    StampsStorage<?> stampStorage = projectDescriptor.dataManager.getFileStampStorage(descriptor.getTarget());
                    projectDescriptor.fsState.markDirty(null, file, descriptor, stampStorage, false);
                }
            }
        }
        return new CompileScopeImpl(targetTypes, targetTypesToForceBuild, targets, files);
    }

    private static void includeDependenciesToScope(Set<? extends BuildTargetType<?>> targetTypes, Set<BuildTarget<?>> targets, Set<? super BuildTargetType<?>> targetTypesToForceBuild, ProjectDescriptor descriptor) {
        TargetOutputIndex dummyIndex = new TargetOutputIndex(){

            @Override
            public Collection<BuildTarget<?>> getTargetsByOutputFile(@NotNull File file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                return List.of();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/cmdline/BuildRunner$1", "getTargetsByOutputFile"));
            }
        };
        ArrayList<BuildTarget<?>> current = new ArrayList(targets);
        while (!current.isEmpty()) {
            ArrayList next = new ArrayList();
            for (BuildTarget buildTarget : current) {
                for (BuildTarget<?> depTarget : buildTarget.computeDependencies(descriptor.getBuildTargetIndex(), dummyIndex)) {
                    if (targets.contains(depTarget) || targetTypes.contains(depTarget.getTargetType())) continue;
                    next.add(depTarget);
                    if (!targetTypesToForceBuild.contains(buildTarget.getTargetType())) continue;
                    targetTypesToForceBuild.add(depTarget.getTargetType());
                }
            }
            targets.addAll(next);
            current = next;
        }
    }

    public static boolean isParallelBuildEnabled() {
        return Boolean.parseBoolean(System.getProperty("compile.parallel"));
    }

    public static boolean isParallelBuildAutomakeEnabled() {
        if (!BuildRunner.isParallelBuildEnabled()) {
            return false;
        }
        String value = System.getProperty("allow.parallel.automake");
        return value == null || Boolean.parseBoolean(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelLoader";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/cmdline/BuildRunner";
                break;
            }
            case 2: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msgHandler";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStorageRoot";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fsState";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pd";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cs";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildType";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDescriptor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/cmdline/BuildRunner";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModelAndGetJpsProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootCompilerName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 9: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createStorageManager";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runBuild";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createCompilationScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

