/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cache.loader;

import com.dynatrace.hash4j.hashing.Hashing;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.builders.JpsBuildBundle;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.ResourcesTargetType;
import org.jetbrains.jps.cache.JpsCachesLoaderUtil;
import org.jetbrains.jps.cache.client.JpsServerClient;
import org.jetbrains.jps.cache.loader.JpsOutputLoader;
import org.jetbrains.jps.cache.model.AffectedModule;
import org.jetbrains.jps.cache.model.BuildTargetState;
import org.jetbrains.jps.cache.model.JpsLoaderContext;
import org.jetbrains.jps.cache.model.OutputLoadResult;

@ApiStatus.Internal
public final class JpsCompilationOutputLoader
implements JpsOutputLoader<List<OutputLoadResult>> {
    private static final Logger LOG = Logger.getInstance(JpsCompilationOutputLoader.class);
    private static final String RESOURCES_PRODUCTION = ResourcesTargetType.PRODUCTION.getTypeId();
    private static final String JAVA_PRODUCTION = JavaModuleBuildTargetType.PRODUCTION.getTypeId();
    private static final String RESOURCES_TEST = ResourcesTargetType.TEST.getTypeId();
    private static final String JAVA_TEST = JavaModuleBuildTargetType.TEST.getTypeId();
    private static final String PRODUCTION = "production";
    private static final String TEST = "test";
    private final JpsServerClient myClient;
    private final String myBuildDirPath;
    private Map<File, String> myTmpFolderToModuleName;
    private List<File> myOldModulesPaths;
    private JpsLoaderContext myContext;

    JpsCompilationOutputLoader(@NotNull JpsServerClient client, @NotNull String buildDirPath) {
        if (client == null) {
            JpsCompilationOutputLoader.$$$reportNull$$$0(0);
        }
        if (buildDirPath == null) {
            JpsCompilationOutputLoader.$$$reportNull$$$0(1);
        }
        this.myClient = client;
        this.myBuildDirPath = buildDirPath;
    }

    @Override
    public int calculateDownloads(@NotNull Map<String, Map<String, BuildTargetState>> commitSourcesState, @Nullable Map<String, Map<String, BuildTargetState>> currentSourcesState) {
        if (commitSourcesState == null) {
            JpsCompilationOutputLoader.$$$reportNull$$$0(2);
        }
        return this.calculateAffectedModules(currentSourcesState, commitSourcesState, true).size();
    }

    @Override
    public List<OutputLoadResult> load() {
        this.myOldModulesPaths = null;
        this.myTmpFolderToModuleName = null;
        this.myContext.sendDescriptionStatusMessage(JpsBuildBundle.message("progress.text.calculating.affected.modules", new Object[0]));
        List<AffectedModule> affectedModules = this.calculateAffectedModules(this.myContext.getCurrentSourcesState(), this.myContext.getCommitSourcesState(), true);
        this.myContext.checkCanceled();
        if (!affectedModules.isEmpty()) {
            long start = System.currentTimeMillis();
            List<OutputLoadResult> loadResults = this.myClient.downloadCompiledModules(this.myContext, affectedModules);
            LOG.info("Download of compilation outputs took: " + (System.currentTimeMillis() - start));
            return loadResults;
        }
        return Collections.emptyList();
    }

    @Override
    public JpsOutputLoader.LoaderStatus extract(@Nullable Object loadResults) {
        if (!(loadResults instanceof List)) {
            return JpsOutputLoader.LoaderStatus.FAILED;
        }
        LOG.info("Start extraction of compilation outputs");
        List outputLoadResults = (List)loadResults;
        ConcurrentHashMap<File, String> result = new ConcurrentHashMap<File, String>();
        try {
            long start = System.currentTimeMillis();
            this.myContext.sendDescriptionStatusMessage(JpsBuildBundle.message("progress.text.extracting.downloaded.results", new Object[0]));
            List futureList = ContainerUtil.map((Collection)outputLoadResults, loadResult -> JpsCachesLoaderUtil.EXECUTOR_SERVICE.submit(new UnzipOutputTask((Map<File, String>)result, (OutputLoadResult)loadResult, this.myContext)));
            for (Future future : futureList) {
                future.get();
            }
            this.myTmpFolderToModuleName = result;
            LOG.info("Unzip compilation output took: " + (System.currentTimeMillis() - start));
            return JpsOutputLoader.LoaderStatus.COMPLETE;
        }
        catch (ProcessCanceledException | InterruptedException | ExecutionException e) {
            if (!(e.getCause() instanceof ProcessCanceledException)) {
                LOG.warn("Failed unzip downloaded compilation outputs", e);
            }
            outputLoadResults.forEach(loadResult -> FileUtil.delete((File)loadResult.getZipFile()));
            result.forEach((key, value) -> FileUtil.delete((File)key));
            return JpsOutputLoader.LoaderStatus.FAILED;
        }
    }

    @Override
    public void rollback() {
        if (this.myTmpFolderToModuleName == null) {
            return;
        }
        this.myTmpFolderToModuleName.forEach((tmpFolder, __) -> {
            if (tmpFolder.isDirectory() && tmpFolder.exists()) {
                FileUtil.delete((File)tmpFolder);
            }
        });
        LOG.info("JPS cache loader rolled back");
    }

    @Override
    public void apply() {
        long start = System.currentTimeMillis();
        if (this.myOldModulesPaths != null) {
            LOG.info("Removing old compilation outputs " + this.myOldModulesPaths.size() + " counts");
            this.myOldModulesPaths.forEach(file -> {
                if (file.exists()) {
                    FileUtil.delete((File)file);
                }
            });
        }
        if (this.myTmpFolderToModuleName == null) {
            LOG.debug("Nothing to apply, download results are empty");
            return;
        }
        this.myContext.sendDescriptionStatusMessage(JpsBuildBundle.message("progress.text.applying.jps.caches", new Object[0]));
        ContainerUtil.map(this.myTmpFolderToModuleName.entrySet(), entry -> JpsCachesLoaderUtil.EXECUTOR_SERVICE.submit(() -> {
            String moduleName = (String)entry.getValue();
            File tmpModuleFolder = (File)entry.getKey();
            this.myContext.sendDescriptionStatusMessage(JpsBuildBundle.message("progress.details.applying.changes.for.module", moduleName));
            File currentModuleBuildDir = new File(tmpModuleFolder.getParentFile(), moduleName);
            FileUtil.delete((File)currentModuleBuildDir);
            try {
                FileUtil.rename((File)tmpModuleFolder, (File)currentModuleBuildDir);
                LOG.debug("Module: " + moduleName + " was replaced successfully");
            }
            catch (IOException e) {
                LOG.warn("Couldn't replace compilation output for module: " + moduleName, (Throwable)e);
            }
        })).forEach(future -> {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.info("Couldn't apply compilation output", (Throwable)e);
            }
        });
        LOG.info("Applying compilation output took: " + (System.currentTimeMillis() - start));
    }

    @Override
    public void setContext(@NotNull JpsLoaderContext context) {
        if (context == null) {
            JpsCompilationOutputLoader.$$$reportNull$$$0(3);
        }
        this.myContext = context;
    }

    @NotNull
    private List<AffectedModule> calculateAffectedModules(@Nullable Map<String, Map<String, BuildTargetState>> currentModulesState, @NotNull Map<String, Map<String, BuildTargetState>> commitModulesState, boolean checkExistance) {
        if (commitModulesState == null) {
            JpsCompilationOutputLoader.$$$reportNull$$$0(4);
        }
        long start = System.currentTimeMillis();
        ArrayList<AffectedModule> affectedModules = new ArrayList<AffectedModule>();
        HashMap oldModulesMap = new HashMap();
        this.myOldModulesPaths = new ArrayList<File>();
        if (currentModulesState == null) {
            commitModulesState.forEach((type, map) -> map.forEach((name, state) -> affectedModules.add(new AffectedModule((String)type, (String)name, state.hash, this.getBuildDirRelativeFile(state.relativePath)))));
            LOG.warn("Project doesn't contain metadata, force to download " + affectedModules.size() + " modules.");
            List<AffectedModule> result = JpsCompilationOutputLoader.mergeAffectedModules(affectedModules, commitModulesState);
            long total = System.currentTimeMillis() - start;
            LOG.info("Compilation output affected for the " + result.size() + " modules. Computation took " + total + "ms");
            List<AffectedModule> list = result;
            if (list == null) {
                JpsCompilationOutputLoader.$$$reportNull$$$0(5);
            }
            return list;
        }
        HashSet<String> newBuildTypes = new HashSet<String>(commitModulesState.keySet());
        newBuildTypes.removeAll(currentModulesState.keySet());
        newBuildTypes.forEach(type -> ((Map)commitModulesState.get(type)).forEach((name, state) -> affectedModules.add(new AffectedModule((String)type, (String)name, state.hash, this.getBuildDirRelativeFile(state.relativePath)))));
        HashSet<String> oldBuildTypes = new HashSet<String>(currentModulesState.keySet());
        oldBuildTypes.removeAll(commitModulesState.keySet());
        oldBuildTypes.forEach(type -> ((Map)currentModulesState.get(type)).forEach((name, state) -> oldModulesMap.put(name, state.relativePath)));
        commitModulesState.forEach((type, map) -> {
            Map currentTypeState = (Map)currentModulesState.get(type);
            if (currentTypeState == null) {
                return;
            }
            HashSet newBuildModules = new HashSet(map.keySet());
            newBuildModules.removeAll(currentTypeState.keySet());
            newBuildModules.forEach(name -> {
                BuildTargetState state = (BuildTargetState)map.get(name);
                affectedModules.add(new AffectedModule((String)type, (String)name, state.hash, this.getBuildDirRelativeFile(state.relativePath)));
            });
            HashSet oldBuildModules = new HashSet(currentTypeState.keySet());
            oldBuildModules.removeAll(map.keySet());
            oldBuildModules.forEach(name -> {
                BuildTargetState state = (BuildTargetState)currentTypeState.get(name);
                oldModulesMap.put(name, state.relativePath);
            });
            map.forEach((name, state) -> {
                BuildTargetState currentTargetState = (BuildTargetState)currentTypeState.get(name);
                if (currentTargetState == null || !state.equals(currentTargetState)) {
                    affectedModules.add(new AffectedModule((String)type, (String)name, state.hash, this.getBuildDirRelativeFile(state.relativePath)));
                    return;
                }
                File outFile = this.getBuildDirRelativeFile(state.relativePath);
                if (checkExistance && (!outFile.exists() || ArrayUtil.isEmpty((Object[])outFile.listFiles()))) {
                    affectedModules.add(new AffectedModule((String)type, (String)name, state.hash, outFile));
                }
            });
        });
        this.myOldModulesPaths = oldModulesMap.entrySet().stream().filter(entry -> {
            for (Map.Entry commitEntry : commitModulesState.entrySet()) {
                BuildTargetState targetState = (BuildTargetState)((Map)commitEntry.getValue()).get(entry.getKey());
                if (targetState == null || !targetState.relativePath.equals(entry.getValue())) continue;
                return false;
            }
            return true;
        }).map(entry -> this.getBuildDirRelativeFile((String)entry.getValue())).collect(Collectors.toList());
        List<AffectedModule> result = JpsCompilationOutputLoader.mergeAffectedModules(affectedModules, commitModulesState);
        long total = System.currentTimeMillis() - start;
        LOG.info("Compilation output affected for the " + result.size() + " modules. Computation took " + total + "ms");
        List<AffectedModule> list = result;
        if (list == null) {
            JpsCompilationOutputLoader.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private static List<AffectedModule> mergeAffectedModules(List<AffectedModule> affectedModules, @NotNull Map<String, Map<String, BuildTargetState>> commitModulesState) {
        if (commitModulesState == null) {
            JpsCompilationOutputLoader.$$$reportNull$$$0(7);
        }
        HashSet result = new HashSet();
        affectedModules.forEach(affectedModule -> {
            if (affectedModule.getType().equals(JAVA_PRODUCTION)) {
                BuildTargetState targetState = (BuildTargetState)((Map)commitModulesState.get(RESOURCES_PRODUCTION)).get(affectedModule.getName());
                if (targetState == null) {
                    result.add(affectedModule);
                    return;
                }
                long hash = Hashing.komihash5_0().hashLongLongToLong(affectedModule.getHash(), targetState.hash);
                result.add(new AffectedModule(PRODUCTION, affectedModule.getName(), hash, affectedModule.getOutPath()));
            } else if (affectedModule.getType().equals(RESOURCES_PRODUCTION)) {
                BuildTargetState targetState = (BuildTargetState)((Map)commitModulesState.get(JAVA_PRODUCTION)).get(affectedModule.getName());
                if (targetState == null) {
                    result.add(affectedModule);
                    return;
                }
                long hash = Hashing.komihash5_0().hashLongLongToLong(targetState.hash, affectedModule.getHash());
                result.add(new AffectedModule(PRODUCTION, affectedModule.getName(), hash, affectedModule.getOutPath()));
            } else if (affectedModule.getType().equals(JAVA_TEST)) {
                BuildTargetState targetState = (BuildTargetState)((Map)commitModulesState.get(RESOURCES_TEST)).get(affectedModule.getName());
                if (targetState == null) {
                    result.add(affectedModule);
                    return;
                }
                long hash = Hashing.komihash5_0().hashLongLongToLong(affectedModule.getHash(), targetState.hash);
                result.add(new AffectedModule(TEST, affectedModule.getName(), hash, affectedModule.getOutPath()));
            } else if (affectedModule.getType().equals(RESOURCES_TEST)) {
                BuildTargetState targetState = (BuildTargetState)((Map)commitModulesState.get(JAVA_TEST)).get(affectedModule.getName());
                if (targetState == null) {
                    result.add(affectedModule);
                    return;
                }
                long hash = Hashing.komihash5_0().hashLongLongToLong(targetState.hash, affectedModule.getHash());
                result.add(new AffectedModule(TEST, affectedModule.getName(), hash, affectedModule.getOutPath()));
            } else {
                result.add(affectedModule);
            }
        });
        return new ArrayList<AffectedModule>(result);
    }

    private File getBuildDirRelativeFile(String buildDirRelativePath) {
        return new File(buildDirRelativePath.replace("$BUILD_DIR$", this.myBuildDirPath));
    }

    @TestOnly
    List<File> getOldModulesPaths() {
        return this.myOldModulesPaths;
    }

    @TestOnly
    List<AffectedModule> getAffectedModules(@Nullable Map<String, Map<String, BuildTargetState>> currentModulesState, @NotNull Map<String, Map<String, BuildTargetState>> commitModulesState, boolean checkExistence) {
        if (commitModulesState == null) {
            JpsCompilationOutputLoader.$$$reportNull$$$0(8);
        }
        return this.calculateAffectedModules(currentModulesState, commitModulesState, checkExistence);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDirPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitSourcesState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitModulesState";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/cache/loader/JpsCompilationOutputLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/cache/loader/JpsCompilationOutputLoader";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateAffectedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calculateDownloads";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setContext";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calculateAffectedModules";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mergeAffectedModules";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedModules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class UnzipOutputTask
    implements Runnable {
        private final OutputLoadResult loadResult;
        private final Map<File, String> result;
        private final JpsLoaderContext context;

        private UnzipOutputTask(Map<File, String> result, OutputLoadResult loadResult, JpsLoaderContext context) {
            this.result = result;
            this.loadResult = loadResult;
            this.context = context;
        }

        @Override
        public void run() {
            AffectedModule affectedModule = this.loadResult.getModule();
            File outPath = affectedModule.getOutPath();
            try {
                this.context.checkCanceled();
                int expectedDownloads = this.context.getTotalExpectedDownloads();
                this.context.getNettyClient().sendDescriptionStatusMessage(JpsBuildBundle.message("progress.details.extracting.compilation.outputs.for.module", affectedModule.getName()), expectedDownloads);
                LOG.debug("Downloaded JPS compiled module from: " + this.loadResult.getDownloadUrl());
                File tmpFolder = new File(outPath.getParent(), outPath.getName() + "_tmp");
                Path zipFile = this.loadResult.getZipFile().toPath();
                ZipUtil.extract((Path)zipFile, (Path)tmpFolder.toPath(), null);
                NioFiles.deleteRecursively((Path)zipFile);
                this.result.put(tmpFolder, affectedModule.getName());
            }
            catch (IOException e) {
                LOG.warn("Couldn't extract download result for module: " + affectedModule.getName(), (Throwable)e);
            }
        }
    }
}

