
use builtin;
use str;

set edit:completion:arg-completer[hq] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'hq'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'hq'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
            cand server 'Commands for controlling the HyperQueue server'
            cand job 'Commands for controlling HyperQueue jobs'
            cand task 'Commands for displaying task(s)'
            cand submit 'Submit a job to HyperQueue'
            cand worker 'Commands for controlling HyperQueue workers'
            cand output-log 'Operations with log'
            cand alloc 'Automatic allocation management'
            cand journal 'Event and journal management'
            cand dashboard 'Start the HyperQueue CLI dashboard'
            cand doc 'Display a link to or open HyperQueue documentation'
            cand generate-completion 'Generate shell completion script'
        }
        &'hq;server'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand start 'Start the HyperQueue server'
            cand stop 'Stop the HyperQueue server, if it is running'
            cand info 'Show info of running HyperQueue server'
            cand generate-access 'Generate access file without starting server'
        }
        &'hq;server;start'= {
            cand --host 'Hostname/IP of the machine under which is visible to others, default: hostname'
            cand --idle-timeout 'Duration after which will an idle worker automatically stop.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --client-port 'Port for client connections (used e.g. for `hq submit`)'
            cand --worker-port 'Port for worker connections'
            cand --journal 'Path to a journal file where events is stored. If the file already exists, the file is used to restore the server state'
            cand --journal-flush-period 'Configure how often should be the journal written.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --access-file 'Path to access file that is used for configuration of secret keys and ports'
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --disable-client-authentication-and-encryption 'If set, client connection will NOT be AUTHENTICATED and ENCRYPTED. ANYONE CAN CONNECT TO THE SERVER AS CLIENT! USE AT YOUR OWN RISK'
            cand --disable-worker-authentication-and-encryption 'If set, worker connection will NOT be AUTHENTICATED and ENCRYPTED. ANYONE CAN CONNECT TO THE SERVER AS WORKER! USE AT YOUR OWN RISK'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;server;stop'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;server;info'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;server;generate-access'= {
            cand --client-file 'Target filename of the access file for client that will be generated'
            cand --worker-file 'Target filename of the access file for worker that will be generated'
            cand --host 'Override target host name, otherwise local hostname is used'
            cand --client-host 'Override target host name for clients'
            cand --worker-host 'Override target host name for workers'
            cand --client-port 'Port for connecting client'
            cand --worker-port 'Port for connecting workers'
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;job'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand list 'Display information about jobs. By default, only queued or running jobs will be displayed'
            cand summary 'Display a summary with the amount of jobs per each job state'
            cand info 'Display detailed information of the selected job'
            cand cancel 'Cancel a specific job. This will cancel all tasks, stopping them from being computation'
            cand forget 'Forget a specific job. This will remove the job from the server''s memory, forgetting it completely and reducing the server''s memory usage'
            cand cat 'Shows task(s) streams(stdout, stderr) of a specific job'
            cand submit 'Submit a job to HyperQueue'
            cand submit-file 'Submit a job through a job definition file'
            cand wait 'Waits until a job is finished'
            cand progress 'Interactively observe the execution of a job'
            cand task-ids 'Print task Ids for given job'
            cand open 'Open new job (without attaching any tasks yet)'
            cand close 'Close an open job'
        }
        &'hq;job;list'= {
            cand --filter 'Display only jobs with the given states. You can use multiple states separated by a comma'
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --all 'Display all jobs'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;job;summary'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;job;info'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;job;cancel'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;job;forget'= {
            cand --filter 'Forget only jobs with the given states. You can use multiple states separated by a comma. You can only filter by states that mark a completed job'
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;job;cat'= {
            cand --tasks 'Filter task(s) by ID'
            cand --task-status 'Filter task(s) by status. You can use multiple states separated by a comma'
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --print-task-header 'Prepend the output of each task with a header line that identifies the task which produced that output'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;job;submit'= {
            cand --name 'Name of the job'
            cand --max-fails 'Maximum number of permitted task failures. If this limit is reached, the job will fail immediately'
            cand --nodes 'Number of nodes; 0'
            cand --cpus 'Number and placement of CPUs for each job'
            cand --resource 'Generic resource request in the form <NAME>=<AMOUNT>'
            cand --time-request 'Minimal lifetime of the worker needed to start the job  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --pin 'Pin the job to the cores specified in `--cpus`'
            cand --cwd 'Working directory for the submitted job. The path must be accessible from worker nodes [default: %{SUBMIT_DIR}]'
            cand --stdout 'Path where the standard output of the job will be stored. The path must be accessible from worker nodes'
            cand --stderr 'Path where the standard error of the job will be stored. The path must be accessible from worker nodes'
            cand --env 'Specify additional environment variable for the job. You can pass this flag multiple times to pass multiple variables'
            cand --each-line 'Create a task array where a task will be created for each line of the given file. The corresponding line will be passed to the task in environment variable `HQ_ENTRY`'
            cand --from-json 'Create a task array where a task will be created for each item of a JSON array stored in the given file. The corresponding item from the array will be passed as a JSON string to the task in environment variable `HQ_ENTRY`'
            cand --array 'Create a task array where a task will be created for each number in the specified number range. Each task will be passed an environment variable `HQ_TASK_ID`'
            cand --priority 'Priority of each task'
            cand --time-limit 'Time limit per task. E.g. --time-limit=10min  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --stream 'Stream the output of tasks into this log file'
            cand --crash-limit 'Limits how many times may task be in a running state while worker is lost. If the limit is reached, the task is marked as failed. If the limit is zero, the limit is disabled'
            cand --job 'Attach a submission to an open job'
            cand --directives 'Select directives parsing mode'
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --task-dir 'Create a temporary directory for task, path is provided in HQ_TASK_DIR The directory is automatically deleted when task is finished'
            cand --wait 'Wait for the job to finish'
            cand --progress 'Interactively observe the progress of the submitted job'
            cand --stdin 'Capture stdin and start the task with the given stdin; the job will be submitted when the stdin is closed'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;job;submit-file'= {
            cand --job 'Attach a submission to an open job'
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;job;wait'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --without-close 'Wait until all tasks are completed, even if the job is still open'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;job;progress'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;job;task-ids'= {
            cand --filter 'Select only tasks with given state(s) You can use multiple states separated by a comma'
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;job;open'= {
            cand --name 'Name of the job'
            cand --max-fails 'Maximum number of permitted task failures. If this limit is reached, the job will fail immediately'
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;job;close'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;task'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand list 'Displays task(s) associated with selected job(s)'
            cand info 'Displays detailed task info'
        }
        &'hq;task;list'= {
            cand --tasks 'Filter task(s) by ID'
            cand --task-status 'Filter task(s) by status. You can use multiple states separated by a comma'
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand -v 'Use this flag to enable verbose output'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;task;info'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand -v 'Use this flag to enable verbose output'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;submit'= {
            cand --name 'Name of the job'
            cand --max-fails 'Maximum number of permitted task failures. If this limit is reached, the job will fail immediately'
            cand --nodes 'Number of nodes; 0'
            cand --cpus 'Number and placement of CPUs for each job'
            cand --resource 'Generic resource request in the form <NAME>=<AMOUNT>'
            cand --time-request 'Minimal lifetime of the worker needed to start the job  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --pin 'Pin the job to the cores specified in `--cpus`'
            cand --cwd 'Working directory for the submitted job. The path must be accessible from worker nodes [default: %{SUBMIT_DIR}]'
            cand --stdout 'Path where the standard output of the job will be stored. The path must be accessible from worker nodes'
            cand --stderr 'Path where the standard error of the job will be stored. The path must be accessible from worker nodes'
            cand --env 'Specify additional environment variable for the job. You can pass this flag multiple times to pass multiple variables'
            cand --each-line 'Create a task array where a task will be created for each line of the given file. The corresponding line will be passed to the task in environment variable `HQ_ENTRY`'
            cand --from-json 'Create a task array where a task will be created for each item of a JSON array stored in the given file. The corresponding item from the array will be passed as a JSON string to the task in environment variable `HQ_ENTRY`'
            cand --array 'Create a task array where a task will be created for each number in the specified number range. Each task will be passed an environment variable `HQ_TASK_ID`'
            cand --priority 'Priority of each task'
            cand --time-limit 'Time limit per task. E.g. --time-limit=10min  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --stream 'Stream the output of tasks into this log file'
            cand --crash-limit 'Limits how many times may task be in a running state while worker is lost. If the limit is reached, the task is marked as failed. If the limit is zero, the limit is disabled'
            cand --job 'Attach a submission to an open job'
            cand --directives 'Select directives parsing mode'
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --task-dir 'Create a temporary directory for task, path is provided in HQ_TASK_DIR The directory is automatically deleted when task is finished'
            cand --wait 'Wait for the job to finish'
            cand --progress 'Interactively observe the progress of the submitted job'
            cand --stdin 'Capture stdin and start the task with the given stdin; the job will be submitted when the stdin is closed'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;worker'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand start 'Start worker'
            cand stop 'Stop worker'
            cand list 'Display information about workers. By default, only running workers will be displayed'
            cand hwdetect 'Hwdetect'
            cand info 'Display information about a specific worker'
            cand address 'Display worker''s hostname'
            cand wait 'Waits on the connection of worker(s)'
            cand deploy-ssh 'Deploy a set of workers using SSH'
        }
        &'hq;worker;start'= {
            cand --cpus 'How many cores should be allocated for the worker'
            cand --resource 'Resources provided by the worker'
            cand --group 'Manual configuration of worker''s group Workers from the same group are used for multi-node tasks'
            cand --idle-timeout 'Duration after which will an idle worker automatically stop.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --overview-interval 'How often should the worker send its overview status (e.g. HW usage, task status) to the server for monitoring. Set to "0s" to disable overview updates'
            cand --heartbeat 'How often should the worker announce its existence to the server.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --time-limit 'Worker time limit. Worker exits after given time.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --manager 'What HPC job manager should be used by the worker'
            cand --hostname 'Overwrite worker hostname'
            cand --on-server-lost 'Behavior when a connection to a server is lost'
            cand --work-dir 'Working directory of a worker. Temp directory by default. It should *NOT* be placed on a network filesystem'
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --no-detect-resources 'Disable auto-detection of resources'
            cand --no-hyper-threading 'Ignore hyper-threading while detecting CPU cores'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;worker;stop'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;worker;list'= {
            cand --filter 'Select only workers with the given state'
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --all 'Display all workers'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;worker;hwdetect'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --no-hyper-threading 'Detect only physical cores'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;worker;info'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;worker;address'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;worker;wait'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;worker;deploy-ssh'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --show-output 'Show log output of the spawned worker(s)'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;output-log'= {
            cand --server-uid 'Filter files for given server instance'
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand summary 'Prints summary of log file'
            cand jobs 'Prints jobs ids in stream'
            cand show 'Prints content of stream ordered by time'
            cand cat 'Prints a raw content of one channel'
            cand export 'Export stream into JSON'
        }
        &'hq;output-log;summary'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;output-log;jobs'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;output-log;show'= {
            cand --job 'JobId'
            cand --channel 'Filter only specific channel'
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;output-log;cat'= {
            cand --task 'Print only the specified task(s) output. You can use the array syntax to specify multiple tasks'
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --allow-unfinished 'Allow unfinished channel'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;output-log;export'= {
            cand --task 'Export only the specified task(s) output. You can use the array syntax to specify multiple tasks'
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;alloc'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand list 'Displays allocation queues'
            cand info 'Display allocations of the specified allocation queue'
            cand add 'Add new allocation queue'
            cand pause 'Pause an existing allocation queue. Paused queues do not submit new allocations'
            cand resume 'Resume a previously paused allocation queue'
            cand dry-run 'Try to submit an allocation to test allocation parameters'
            cand remove 'Removes an allocation queue with the given ID'
        }
        &'hq;alloc;list'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;alloc;info'= {
            cand --filter 'Display only allocations with the given state'
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;alloc;add'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand pbs 'Create a PBS allocation queue'
            cand slurm 'Create a SLURM allocation queue'
        }
        &'hq;alloc;add;pbs'= {
            cand -b 'How many jobs should be waiting in the queue to be started'
            cand --backlog 'How many jobs should be waiting in the queue to be started'
            cand -t 'Time limit (walltime) of PBS/Slurm allocations.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --time-limit 'Time limit (walltime) of PBS/Slurm allocations.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand -w 'How many workers (nodes) should be spawned in each allocation'
            cand --workers-per-alloc 'How many workers (nodes) should be spawned in each allocation'
            cand --max-worker-count 'Maximum number of workers that can be queued or running at any given time in this queue'
            cand -n 'Name of the allocation queue (for debug purposes only)'
            cand --name 'Name of the allocation queue (for debug purposes only)'
            cand --cpus 'How many cores should be allocated for the worker'
            cand --resource 'Resources provided by the worker'
            cand --group 'Manual configuration of worker''s group Workers from the same group are used for multi-node tasks'
            cand --idle-timeout 'Duration after which will an idle worker automatically stop.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --overview-interval 'How often should the worker send its overview status (e.g. HW usage, task status) to the server for monitoring. Set to "0s" to disable overview updates'
            cand --on-server-lost 'Behavior when a connection to a server is lost'
            cand --worker-start-cmd 'Shell command that will be executed on each allocated node, before a worker is created on that node'
            cand --worker-stop-cmd 'Shell command that will be executed on each allocated node, just before the allocation ends. Note that this execution is best-effort. It is not guaranteed that the script will always be executed'
            cand --worker-time-limit ' Time limit after which workers in the submitted allocations will be stopped. By default, it is set to the time limit of the allocation. However, if you want the workers to be stopped sooner, for example to give `worker_stop_cmd` more time to execute before the allocation is killed, you can lower the worker time limit.  The limit must not be larger than the allocation time limit.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --no-detect-resources 'Disable auto-detection of resources'
            cand --no-hyper-threading 'Ignore hyper-threading while detecting CPU cores'
            cand --no-dry-run 'Disables dry-run, which submits an allocation with the specified parameters to verify whether the parameters are correct'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;alloc;add;slurm'= {
            cand -b 'How many jobs should be waiting in the queue to be started'
            cand --backlog 'How many jobs should be waiting in the queue to be started'
            cand -t 'Time limit (walltime) of PBS/Slurm allocations.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --time-limit 'Time limit (walltime) of PBS/Slurm allocations.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand -w 'How many workers (nodes) should be spawned in each allocation'
            cand --workers-per-alloc 'How many workers (nodes) should be spawned in each allocation'
            cand --max-worker-count 'Maximum number of workers that can be queued or running at any given time in this queue'
            cand -n 'Name of the allocation queue (for debug purposes only)'
            cand --name 'Name of the allocation queue (for debug purposes only)'
            cand --cpus 'How many cores should be allocated for the worker'
            cand --resource 'Resources provided by the worker'
            cand --group 'Manual configuration of worker''s group Workers from the same group are used for multi-node tasks'
            cand --idle-timeout 'Duration after which will an idle worker automatically stop.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --overview-interval 'How often should the worker send its overview status (e.g. HW usage, task status) to the server for monitoring. Set to "0s" to disable overview updates'
            cand --on-server-lost 'Behavior when a connection to a server is lost'
            cand --worker-start-cmd 'Shell command that will be executed on each allocated node, before a worker is created on that node'
            cand --worker-stop-cmd 'Shell command that will be executed on each allocated node, just before the allocation ends. Note that this execution is best-effort. It is not guaranteed that the script will always be executed'
            cand --worker-time-limit ' Time limit after which workers in the submitted allocations will be stopped. By default, it is set to the time limit of the allocation. However, if you want the workers to be stopped sooner, for example to give `worker_stop_cmd` more time to execute before the allocation is killed, you can lower the worker time limit.  The limit must not be larger than the allocation time limit.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --no-detect-resources 'Disable auto-detection of resources'
            cand --no-hyper-threading 'Ignore hyper-threading while detecting CPU cores'
            cand --no-dry-run 'Disables dry-run, which submits an allocation with the specified parameters to verify whether the parameters are correct'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;alloc;pause'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;alloc;resume'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;alloc;dry-run'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand pbs 'Try to create a PBS allocation'
            cand slurm 'Try to create a SLURM allocation'
        }
        &'hq;alloc;dry-run;pbs'= {
            cand -b 'How many jobs should be waiting in the queue to be started'
            cand --backlog 'How many jobs should be waiting in the queue to be started'
            cand -t 'Time limit (walltime) of PBS/Slurm allocations.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --time-limit 'Time limit (walltime) of PBS/Slurm allocations.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand -w 'How many workers (nodes) should be spawned in each allocation'
            cand --workers-per-alloc 'How many workers (nodes) should be spawned in each allocation'
            cand --max-worker-count 'Maximum number of workers that can be queued or running at any given time in this queue'
            cand -n 'Name of the allocation queue (for debug purposes only)'
            cand --name 'Name of the allocation queue (for debug purposes only)'
            cand --cpus 'How many cores should be allocated for the worker'
            cand --resource 'Resources provided by the worker'
            cand --group 'Manual configuration of worker''s group Workers from the same group are used for multi-node tasks'
            cand --idle-timeout 'Duration after which will an idle worker automatically stop.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --overview-interval 'How often should the worker send its overview status (e.g. HW usage, task status) to the server for monitoring. Set to "0s" to disable overview updates'
            cand --on-server-lost 'Behavior when a connection to a server is lost'
            cand --worker-start-cmd 'Shell command that will be executed on each allocated node, before a worker is created on that node'
            cand --worker-stop-cmd 'Shell command that will be executed on each allocated node, just before the allocation ends. Note that this execution is best-effort. It is not guaranteed that the script will always be executed'
            cand --worker-time-limit ' Time limit after which workers in the submitted allocations will be stopped. By default, it is set to the time limit of the allocation. However, if you want the workers to be stopped sooner, for example to give `worker_stop_cmd` more time to execute before the allocation is killed, you can lower the worker time limit.  The limit must not be larger than the allocation time limit.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --no-detect-resources 'Disable auto-detection of resources'
            cand --no-hyper-threading 'Ignore hyper-threading while detecting CPU cores'
            cand --no-dry-run 'Disables dry-run, which submits an allocation with the specified parameters to verify whether the parameters are correct'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;alloc;dry-run;slurm'= {
            cand -b 'How many jobs should be waiting in the queue to be started'
            cand --backlog 'How many jobs should be waiting in the queue to be started'
            cand -t 'Time limit (walltime) of PBS/Slurm allocations.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --time-limit 'Time limit (walltime) of PBS/Slurm allocations.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand -w 'How many workers (nodes) should be spawned in each allocation'
            cand --workers-per-alloc 'How many workers (nodes) should be spawned in each allocation'
            cand --max-worker-count 'Maximum number of workers that can be queued or running at any given time in this queue'
            cand -n 'Name of the allocation queue (for debug purposes only)'
            cand --name 'Name of the allocation queue (for debug purposes only)'
            cand --cpus 'How many cores should be allocated for the worker'
            cand --resource 'Resources provided by the worker'
            cand --group 'Manual configuration of worker''s group Workers from the same group are used for multi-node tasks'
            cand --idle-timeout 'Duration after which will an idle worker automatically stop.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --overview-interval 'How often should the worker send its overview status (e.g. HW usage, task status) to the server for monitoring. Set to "0s" to disable overview updates'
            cand --on-server-lost 'Behavior when a connection to a server is lost'
            cand --worker-start-cmd 'Shell command that will be executed on each allocated node, before a worker is created on that node'
            cand --worker-stop-cmd 'Shell command that will be executed on each allocated node, just before the allocation ends. Note that this execution is best-effort. It is not guaranteed that the script will always be executed'
            cand --worker-time-limit ' Time limit after which workers in the submitted allocations will be stopped. By default, it is set to the time limit of the allocation. However, if you want the workers to be stopped sooner, for example to give `worker_stop_cmd` more time to execute before the allocation is killed, you can lower the worker time limit.  The limit must not be larger than the allocation time limit.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --no-detect-resources 'Disable auto-detection of resources'
            cand --no-hyper-threading 'Ignore hyper-threading while detecting CPU cores'
            cand --no-dry-run 'Disables dry-run, which submits an allocation with the specified parameters to verify whether the parameters are correct'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;alloc;remove'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --force 'Remove the queue even if there are currently running jobs. The running jobs will be canceled'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;journal'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand export 'Export events from a journal to NDJSON (line-delimited JSON). Events will be exported to `stdout`, you can redirect it e.g. to a file'
            cand stream 'Stream events from a running server, it first replays old events then it waits for new live events'
            cand replay 'Stream events from a running server, it replays old events after that it terminates the connection'
            cand prune 'Connect to a server and remove completed tasks and non-active workers from journal'
            cand flush 'Connect to a server and forces to flush a journal'
        }
        &'hq;journal;export'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;journal;stream'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;journal;replay'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;journal;prune'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;journal;flush'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;dashboard'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand stream 'Stream events from a server. Note that this will replay all events from the currently active journal file before new events will be streamed'
            cand replay 'Replay events from a recorded journal file'
        }
        &'hq;dashboard;stream'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;dashboard;replay'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand job 'Submitting and examining tasks and jobs'
            cand jobs 'Submitting and examining tasks and jobs'
            cand tasks 'Submitting and examining tasks and jobs'
            cand taskarray 'Jobs containing large amounts of similar tasks'
            cand resources 'CPU and generic resources of tasks'
            cand worker 'Deployment of workers'
            cand workers 'Deployment of workers'
            cand autoalloc 'Automatic allocator subsystem'
            cand pbs 'Automatic allocator subsystem'
            cand slurm 'Automatic allocator subsystem'
            cand python-api 'Python API'
            cand python 'Python API'
            cand cheatsheet 'Cheatsheet with the most common HyperQueue commands'
            cand changelog 'Changelog'
            cand faq 'Frequently asked questions about HyperQueue'
        }
        &'hq;doc;job'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;jobs'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;tasks'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;taskarray'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;resources'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;worker'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;workers'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;autoalloc'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;pbs'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;slurm'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;python-api'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;python'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;cheatsheet'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;changelog'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;faq'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;generate-completion'= {
            cand --server-dir 'Path to a directory that stores HyperQueue access files'
            cand --colors 'Console color policy'
            cand --output-mode 'How should the output of the command be formatted'
            cand --debug 'Turn on a more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
    ]
    $completions[$command]
}
