#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 uniplate
version:              1.6.13
visibility:           public
id:                   uniplate-1.6.13-8GWqyDLzdG1GIR763aHdX
key:                  uniplate-1.6.13-8GWqyDLzdG1GIR763aHdX
license:              BSD-3-Clause
copyright:            Neil Mitchell 2006-2020
maintainer:           Neil Mitchell <ndmitchell@gmail.com>
author:               Neil Mitchell <ndmitchell@gmail.com>
homepage:             https://github.com/ndmitchell/uniplate#readme
synopsis:             Help writing simple, concise and fast generic operations.
description:
    Uniplate is library for writing simple and concise generic operations.
    Uniplate has similar goals to the original Scrap Your Boilerplate work,
    but is substantially simpler and faster.

    To get started with Uniplate you should import one of the three following
    modules:

    * "Data.Generics.Uniplate.Data" - to quickly start writing generic functions.
    Most users should start by importing this module.

    * "Data.Generics.Uniplate.Direct" - a replacement for "Data.Generics.Uniplate.Data"
    with substantially higher performance (around 5 times), but requires writing
    instance declarations.

    * "Data.Generics.Uniplate.Operations" - definitions of all the operations defined
    by Uniplate. Both the above two modules re-export this module.

    In addition, some users may want to make use of the following modules:

    * "Data.Generics.Uniplate.Zipper" - a zipper built on top of Uniplate instances.

    * "Data.Generics.SYB" - users transitioning from the Scrap Your Boilerplate library.

    * "Data.Generics.Compos" - users transitioning from the Compos library.

    * "Data.Generics.Uniplate.DataOnly" - users making use of both @Data@ and @Direct@
    to avoid getting instance conflicts.

category:             Generics
abi:                  e3910a9e6d15c4cdfb6d3467683c3eea
exposed:              True
exposed-modules:
    Data.Generics.Biplate Data.Generics.Compos Data.Generics.PlateData
    Data.Generics.PlateDirect Data.Generics.PlateTypeable
    Data.Generics.SYB Data.Generics.Str Data.Generics.Uniplate
    Data.Generics.Uniplate.Data Data.Generics.Uniplate.Data.Instances
    Data.Generics.Uniplate.DataOnly Data.Generics.Uniplate.Direct
    Data.Generics.Uniplate.Operations Data.Generics.Uniplate.Typeable
    Data.Generics.Uniplate.Zipper Data.Generics.UniplateOn
    Data.Generics.UniplateStr Data.Generics.UniplateStrOn

hidden-modules:
    Data.Generics.Uniplate.Internal.Data
    Data.Generics.Uniplate.Internal.DataOnlyOperations
    Data.Generics.Uniplate.Internal.Utils

import-dirs:          /usr/lib/ghc-9.4.8/site-local/uniplate-1.6.13
library-dirs:         /usr/lib/ghc-9.4.8/site-local/uniplate-1.6.13
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/uniplate-1.6.13
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-uniplate
hs-libraries:         HSuniplate-1.6.13-8GWqyDLzdG1GIR763aHdX
depends:
    base-4.17.2.1 containers-0.6.7 ghc-prim-0.9.1
    hashable-1.4.4.0-Jc2uKL4S7Fl9QLNJZYpfiY
    syb-0.7.2.4-HJAbU0lurQkHN7nU4EHwhb
    unordered-containers-0.2.20-L3M6eILO3KM5ipeNJik2xY

haddock-interfaces:   /usr/share/doc/haskell-uniplate/html/uniplate.haddock
haddock-html:         /usr/share/doc/haskell-uniplate/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

