#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 statistics
version:              0.16.3.0
visibility:           public
id:                   statistics-0.16.3.0-6LSulQV6I6b4iX8EYA4TYt
key:                  statistics-0.16.3.0-6LSulQV6I6b4iX8EYA4TYt
license:              BSD-2-Clause
copyright:            2009-2014 Bryan O'\''Sullivan
maintainer:           Alexey Khudaykov <alexey.skladnoy@gmail.com>
author:
    Bryan O'\''Sullivan <bos@serpentine.com>, Alexey Khudaykov <alexey.skladnoy@gmail.com>

homepage:             https://github.com/haskell/statistics
synopsis:             A library of statistical types, data, and functions
description:
    This library provides a number of common functions and types useful
    in statistics.  We focus on high performance, numerical robustness,
    and use of good algorithms.  Where possible, we provide
    references to the statistical literature.
    .
    The library'\''s facilities can be divided into four broad categories:
    .
    * Working with widely used discrete and continuous probability
      distributions.  (There are dozens of exotic distributions in use;
      we focus on the most common.)
    .
    * Computing with sample data: quantile estimation, kernel density
      estimation, histograms, bootstrap methods, significance testing,
      and regression and autocorrelation analysis.
    .
    * Random variate generation under several different distributions.
    .
    * Common statistical tests for significant differences between
      samples.

category:             Math, Statistics
abi:                  e23160877f1b17adfe77bfddafc1e0b2
exposed:              True
exposed-modules:
    Statistics.Autocorrelation Statistics.ConfidenceInt
    Statistics.Correlation Statistics.Correlation.Kendall
    Statistics.Distribution Statistics.Distribution.Beta
    Statistics.Distribution.Binomial
    Statistics.Distribution.CauchyLorentz
    Statistics.Distribution.ChiSquared
    Statistics.Distribution.DiscreteUniform
    Statistics.Distribution.Exponential
    Statistics.Distribution.FDistribution Statistics.Distribution.Gamma
    Statistics.Distribution.Geometric
    Statistics.Distribution.Hypergeometric
    Statistics.Distribution.Laplace Statistics.Distribution.Lognormal
    Statistics.Distribution.NegativeBinomial
    Statistics.Distribution.Normal Statistics.Distribution.Poisson
    Statistics.Distribution.StudentT Statistics.Distribution.Transform
    Statistics.Distribution.Uniform Statistics.Distribution.Weibull
    Statistics.Function Statistics.Quantile Statistics.Regression
    Statistics.Resampling Statistics.Resampling.Bootstrap
    Statistics.Sample Statistics.Sample.Histogram
    Statistics.Sample.Internal Statistics.Sample.KernelDensity
    Statistics.Sample.KernelDensity.Simple Statistics.Sample.Normalize
    Statistics.Sample.Powers Statistics.Test.ChiSquared
    Statistics.Test.KolmogorovSmirnov Statistics.Test.KruskalWallis
    Statistics.Test.MannWhitneyU Statistics.Test.StudentT
    Statistics.Test.Types Statistics.Test.WilcoxonT
    Statistics.Transform Statistics.Types

hidden-modules:
    Statistics.Distribution.Poisson.Internal Statistics.Internal
    Statistics.Test.Internal Statistics.Types.Internal

import-dirs:          /usr/lib/ghc-9.4.8/site-local/statistics-0.16.3.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/statistics-0.16.3.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/statistics-0.16.3.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-statistics
hs-libraries:         HSstatistics-0.16.3.0-6LSulQV6I6b4iX8EYA4TYt
depends:
    aeson-2.1.2.1-Gng3eoGBP2Sj2fbUBsnWH
    async-2.2.5-6FnQWPoSLF0101MXuyNKqJ base-4.17.2.1 binary-0.8.9.1
    data-default-class-0.1.2.0-J3yYo85AtrC9KKZSpt62Yc deepseq-1.4.8.0
    dense-linear-algebra-0.1.0.0-GV3ecHOBZKg4AqhlwhGEUG
    math-functions-0.3.4.4-Dkon7u36GIY5AHdC58AYwk
    mwc-random-0.15.2.0-G5sntawqyKg8CqPIsp2uWk
    parallel-3.2.2.0-KJ5o3ImR3G8wdLWLqGjpy
    primitive-0.9.0.0-1uQl5SMm5FQ52SaicTkt1Y
    random-1.2.1.2-FNtVSr9AyR5Fv650rjDfzJ
    vector-0.13.2.0-G0g5gCprguQ6M58H7uQE53
    vector-algorithms-0.9.1.0-6APE2Z3Gksr2bYrUMoQV5q
    vector-binary-instances-0.2.5.2-5S4dmVVdeAc9FOqhvkmxUg
    vector-th-unbox-0.2.2-EztiRkUf5uf63v8aHXPEM6

haddock-interfaces:   /usr/share/doc/haskell-statistics/html/statistics.haddock
haddock-html:         /usr/share/doc/haskell-statistics/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

