#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 math-functions
version:              0.3.4.4
visibility:           public
id:                   math-functions-0.3.4.4-E8iUEx01Qk9DqpLsVR97wn
key:                  math-functions-0.3.4.4-E8iUEx01Qk9DqpLsVR97wn
license:              BSD-2-Clause
maintainer:           Alexey Khudyakov <alexey.skladnoy@gmail.com>
author:
    Bryan O'\''Sullivan <bos@serpentine.com>,
    Alexey Khudyakov <alexey.skladnoy@gmail.com>

homepage:             https://github.com/haskell/math-functions
synopsis:             Collection of tools for numeric computations
description:
    This library contain collection of various utilities for numerical
    computing. So far there'\''re special mathematical functions,
    compensated summation algorithm, summation of series, root finding
    for real functions, polynomial summation and Chebyshev
    polynomials.

category:             Math, Numeric
abi:                  3b47b92dda4624b79621a1ec60ef6840
exposed:              True
exposed-modules:
    Numeric.MathFunctions.Comparison Numeric.MathFunctions.Constants
    Numeric.Polynomial Numeric.Polynomial.Chebyshev Numeric.RootFinding
    Numeric.Series Numeric.SpecFunctions Numeric.SpecFunctions.Extra
    Numeric.SpecFunctions.Internal Numeric.Sum

hidden-modules:       Numeric.SpecFunctions.Compat
import-dirs:          /usr/lib/ghc-9.4.8/site-local/math-functions-0.3.4.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/math-functions-0.3.4.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/math-functions-0.3.4.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-math-functions
hs-libraries:         HSmath-functions-0.3.4.4-E8iUEx01Qk9DqpLsVR97wn
depends:
    base-4.17.2.1 data-default-class-0.1.2.0-J3yYo85AtrC9KKZSpt62Yc
    deepseq-1.4.8.0 primitive-0.8.0.0-1110YmBHzhAERV5HY7EG3e
    vector-0.13.2.0-KDCTRjRQ0urK2B6TNAGAn8

haddock-interfaces:
    /usr/share/doc/haskell-math-functions/html/math-functions.haddock

haddock-html:         /usr/share/doc/haskell-math-functions/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

