/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.TemplateCharacters;

public class TemplateLiteral
extends AstNode {
    private List<AstNode> elements;

    public TemplateLiteral() {
        this.type = 170;
    }

    public TemplateLiteral(int n) {
        super(n);
        this.type = 170;
    }

    public TemplateLiteral(int n, int n2) {
        super(n, n2);
        this.type = 170;
    }

    public List<TemplateCharacters> getTemplateStrings() {
        if (this.elements == null) {
            return Collections.emptyList();
        }
        ArrayList<TemplateCharacters> arrayList = new ArrayList<TemplateCharacters>();
        for (AstNode astNode : this.elements) {
            if (astNode.getType() != 171) continue;
            arrayList.add((TemplateCharacters)astNode);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List<AstNode> getSubstitutions() {
        if (this.elements == null) {
            return Collections.emptyList();
        }
        ArrayList<AstNode> arrayList = new ArrayList<AstNode>();
        for (AstNode astNode : this.elements) {
            if (astNode.getType() == 171) continue;
            arrayList.add(astNode);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List<AstNode> getElements() {
        if (this.elements == null) {
            return Collections.emptyList();
        }
        return this.elements;
    }

    public void setElements(List<AstNode> list) {
        if (list == null) {
            this.elements = null;
        } else {
            if (this.elements != null) {
                this.elements.clear();
            }
            for (AstNode astNode : list) {
                this.addElement(astNode);
            }
        }
    }

    public void addElement(AstNode astNode) {
        this.assertNotNull(astNode);
        if (this.elements == null) {
            this.elements = new ArrayList<AstNode>();
        }
        this.elements.add(astNode);
        astNode.setParent(this);
    }

    public int getSize() {
        return this.elements == null ? 0 : this.elements.size();
    }

    public AstNode getElement(int n) {
        if (this.elements == null) {
            throw new IndexOutOfBoundsException("no elements");
        }
        return this.elements.get(n);
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append("`");
        for (AstNode astNode : this.getElements()) {
            if (astNode.getType() == 171) {
                stringBuilder.append(astNode.toSource(0));
                continue;
            }
            stringBuilder.append("${").append(astNode.toSource(0)).append("}");
        }
        stringBuilder.append("`");
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            for (AstNode astNode : this.getElements()) {
                astNode.visit(nodeVisitor);
            }
        }
    }
}

