/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.Jump;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.SwitchCase;

public class SwitchStatement
extends Jump {
    private static final List<SwitchCase> NO_CASES = Collections.unmodifiableList(new ArrayList());
    private AstNode expression;
    private List<SwitchCase> cases;
    private int lp = -1;
    private int rp = -1;

    public SwitchStatement() {
        this.type = 118;
    }

    public SwitchStatement(int n) {
        this.type = 118;
        this.position = n;
    }

    public SwitchStatement(int n, int n2) {
        this.type = 118;
        this.position = n;
        this.length = n2;
    }

    public AstNode getExpression() {
        return this.expression;
    }

    public void setExpression(AstNode astNode) {
        this.assertNotNull(astNode);
        this.expression = astNode;
        astNode.setParent(this);
    }

    public List<SwitchCase> getCases() {
        return this.cases != null ? this.cases : NO_CASES;
    }

    public void setCases(List<SwitchCase> list) {
        if (list == null) {
            this.cases = null;
        } else {
            if (this.cases != null) {
                this.cases.clear();
            }
            for (SwitchCase switchCase : list) {
                this.addCase(switchCase);
            }
        }
    }

    public void addCase(SwitchCase switchCase) {
        this.assertNotNull(switchCase);
        if (this.cases == null) {
            this.cases = new ArrayList<SwitchCase>();
        }
        this.cases.add(switchCase);
        switchCase.setParent(this);
    }

    public int getLp() {
        return this.lp;
    }

    public void setLp(int n) {
        this.lp = n;
    }

    public int getRp() {
        return this.rp;
    }

    public void setRp(int n) {
        this.rp = n;
    }

    public void setParens(int n, int n2) {
        this.lp = n;
        this.rp = n2;
    }

    @Override
    public String toSource(int n) {
        String string = this.makeIndent(n);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("switch (");
        stringBuilder.append(this.expression.toSource(0));
        stringBuilder.append(") {\n");
        if (this.cases != null) {
            for (SwitchCase switchCase : this.cases) {
                stringBuilder.append(switchCase.toSource(n + 1));
            }
        }
        stringBuilder.append(string);
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            this.expression.visit(nodeVisitor);
            for (SwitchCase switchCase : this.getCases()) {
                switchCase.visit(nodeVisitor);
            }
        }
    }
}

