/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui.layout;

import com.jogamp.opengl.math.FloatUtil;

public class Margin {
    public static final float CENTER = Float.NaN;
    public final float top;
    public final float right;
    public final float bottom;
    public final float left;
    private final int bits;
    private static final int CENTER_HORIZ = 1;
    private static final int CENTER_VERT = 2;

    private static int getBits(float f, float f2, float f3, float f4) {
        int n = 0;
        if (FloatUtil.isEqual(Float.NaN, f4) && FloatUtil.isEqual(Float.NaN, f2)) {
            n |= 1;
        }
        if (FloatUtil.isEqual(Float.NaN, f) && FloatUtil.isEqual(Float.NaN, f3)) {
            n |= 2;
        }
        return n;
    }

    public Margin() {
        this.top = 0.0f;
        this.right = 0.0f;
        this.bottom = 0.0f;
        this.left = 0.0f;
        this.bits = 0;
    }

    public Margin(float f, float f2, float f3, float f4) {
        this.bits = Margin.getBits(f, f2, f3, f4);
        if (this.isCenteredVert()) {
            this.top = 0.0f;
            this.bottom = 0.0f;
        } else {
            this.top = f;
            this.bottom = f3;
        }
        if (this.isCenteredHoriz()) {
            this.right = 0.0f;
            this.left = 0.0f;
        } else {
            this.right = f2;
            this.left = f4;
        }
    }

    public Margin(float f, float f2, float f3) {
        this.bits = Margin.getBits(f, f2, f3, f2);
        if (this.isCenteredVert()) {
            this.top = 0.0f;
            this.bottom = 0.0f;
        } else {
            this.top = f;
            this.bottom = f3;
        }
        if (this.isCenteredHoriz()) {
            this.right = 0.0f;
            this.left = 0.0f;
        } else {
            this.right = f2;
            this.left = f2;
        }
    }

    public Margin(float f, float f2) {
        this.bits = Margin.getBits(f, f2, f, f2);
        if (this.isCenteredVert()) {
            this.top = 0.0f;
            this.bottom = 0.0f;
        } else {
            this.top = f;
            this.bottom = f;
        }
        if (this.isCenteredHoriz()) {
            this.right = 0.0f;
            this.left = 0.0f;
        } else {
            this.right = f2;
            this.left = f2;
        }
    }

    public Margin(float f) {
        this.bits = Margin.getBits(f, f, f, f);
        if (this.isCenteredVert()) {
            this.top = 0.0f;
            this.bottom = 0.0f;
        } else {
            this.top = f;
            this.bottom = f;
        }
        if (this.isCenteredHoriz()) {
            this.right = 0.0f;
            this.left = 0.0f;
        } else {
            this.right = f;
            this.left = f;
        }
    }

    public boolean isCenteredHoriz() {
        return 0 != (1 & this.bits);
    }

    public boolean isCenteredVert() {
        return 0 != (2 & this.bits);
    }

    public boolean isCentered() {
        return 0 != (3 & this.bits);
    }

    public float width() {
        return this.left + this.right;
    }

    public float height() {
        return this.bottom + this.top;
    }

    public boolean zeroSumWidth() {
        return FloatUtil.isZero(this.width());
    }

    public boolean zeroSumHeight() {
        return FloatUtil.isZero(this.height());
    }

    public boolean zeroSumSize() {
        return this.zeroSumWidth() && this.zeroSumHeight();
    }

    public String toString() {
        return "Margin[t " + this.top + ", r " + this.right + ", b " + this.bottom + ", l " + this.left + ", ctr[h " + this.isCenteredHoriz() + ", v " + this.isCenteredVert() + "]]";
    }
}

