/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text.mindmapmode;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class EventBuffer
implements KeyEventDispatcher,
FocusListener,
InputMethodListener {
    ArrayList<AWTEvent> events = new ArrayList(100);
    private Component textComponent;
    boolean isActive = false;
    private AWTEvent firstEvent;
    private AWTEvent dispatchedEvent = null;
    private Component focusOwner;

    public boolean isActive() {
        return this.isActive;
    }

    EventBuffer() {
    }

    public Component getTextComponent() {
        return this.textComponent;
    }

    public void setTextComponent(Component c) {
        if (this.textComponent != null) {
            this.textComponent.removeFocusListener(this);
        }
        this.textComponent = c;
        if (this.textComponent != null) {
            this.textComponent.addFocusListener(this);
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent ke) {
        if (ke.equals(this.dispatchedEvent) || this.events.isEmpty() && ke.getID() != 401) {
            return false;
        }
        this.addAwtEvent(ke);
        if (ke.getKeyCode() == 27 && ke.getID() == 402) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(EventBuffer.this);
                }
            });
        }
        ke.consume();
        return true;
    }

    private void addAwtEvent(AWTEvent ke) {
        this.events.add(ke);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.textComponent.removeFocusListener(this);
        SwingUtilities.invokeLater(() -> {
            try {
                for (int i = 0; i < this.events.size(); ++i) {
                    AWTEvent event = this.events.get(i);
                    if (event.getSource().equals(this.textComponent)) {
                        this.dispatchedEvent = event;
                    } else if (event instanceof KeyEvent) {
                        KeyEvent ke = (KeyEvent)event;
                        this.dispatchedEvent = new KeyEvent(this.textComponent, ke.getID(), ke.getWhen(), ke.getModifiers(), ke.getKeyCode(), ke.getKeyChar(), ke.getKeyLocation());
                    } else if (event instanceof InputMethodEvent) {
                        InputMethodEvent ime = (InputMethodEvent)event;
                        this.dispatchedEvent = new InputMethodEvent(this.textComponent, ime.getID(), ime.getWhen(), ime.getText(), ime.getCommittedCharacterCount(), ime.getCaret(), ime.getVisiblePosition());
                    }
                    e.getComponent().dispatchEvent(this.dispatchedEvent);
                    this.dispatchedEvent = null;
                }
            }
            finally {
                this.deactivate();
            }
        });
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public void deactivate() {
        if (!this.isActive) {
            return;
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        this.isActive = false;
        if (this.textComponent != null) {
            this.textComponent.removeFocusListener(this);
            this.textComponent = null;
        }
        if (this.focusOwner != null) {
            this.focusOwner.removeInputMethodListener(this);
            this.focusOwner = null;
        }
        this.events.clear();
        this.firstEvent = null;
        this.dispatchedEvent = null;
    }

    public void activate(AWTEvent e) {
        if (!this.isActive) {
            KeyboardFocusManager currentKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            if (e != null) {
                this.focusOwner = (Component)e.getSource();
                if (!this.focusOwner.isFocusOwner()) {
                    this.focusOwner.requestFocus();
                }
            } else {
                this.focusOwner = currentKeyboardFocusManager.getFocusOwner();
            }
            currentKeyboardFocusManager.addKeyEventDispatcher(this);
            this.focusOwner.addInputMethodListener(this);
            this.isActive = true;
            if (e instanceof MouseEvent) {
                this.setFirstEvent((MouseEvent)e);
            } else if (e != null) {
                this.addAwtEvent(e);
            }
        }
    }

    public void setFirstEvent(AWTEvent e) {
        this.firstEvent = e;
    }

    public AWTEvent getFirstEvent() {
        if (this.firstEvent != null) {
            return this.firstEvent;
        }
        if (this.events.isEmpty()) {
            return null;
        }
        return this.events.get(0);
    }

    public MouseEvent getMouseEvent() {
        if (this.firstEvent instanceof MouseEvent) {
            return (MouseEvent)this.firstEvent;
        }
        return null;
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent event) {
        this.addAwtEvent(event);
    }

    @Override
    public void caretPositionChanged(InputMethodEvent event) {
        this.addAwtEvent(event);
    }
}

