/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.net.URI;
import java.util.Objects;
import org.junit.platform.commons.support.Resource;
import org.junit.platform.commons.util.Preconditions;

class ClasspathResource
implements Resource {
    private final String name;
    private final URI uri;

    ClasspathResource(String name, URI uri) {
        this.name = Preconditions.notNull(name, "name must not be null");
        this.uri = Preconditions.notNull(uri, "uri must not be null");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClasspathResource that = (ClasspathResource)o;
        return this.name.equals(that.name) && this.uri.equals(that.uri);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.uri);
    }
}

