/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.border.Border;
import net.infonode.gui.GraphicsUtil;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.ColorProviderUtil;
import net.infonode.gui.colorprovider.UIManagerColorProvider;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedUtils;
import net.infonode.util.Direction;

public class TabHighlightBorder
implements Border,
Serializable {
    private static final long serialVersionUID = 1L;
    private ColorProvider color;
    private boolean openBorder;

    public TabHighlightBorder() {
        this((Color)null, false);
    }

    public TabHighlightBorder(Color color, boolean openBorder) {
        this(ColorProviderUtil.getColorProvider(color, UIManagerColorProvider.TABBED_PANE_HIGHLIGHT), openBorder);
    }

    public TabHighlightBorder(ColorProvider colorProvider, boolean openBorder) {
        this.color = colorProvider;
        this.openBorder = openBorder;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        TabbedPanel tabbedPanel = TabbedUtils.getParentTabbedPanel(c);
        if (tabbedPanel != null) {
            Direction d = tabbedPanel.getProperties().getTabAreaOrientation();
            g.setColor(this.color.getColor(c));
            if (d == Direction.UP) {
                GraphicsUtil.drawOptimizedLine(g, x + 1, y, x + width - 2, y);
                GraphicsUtil.drawOptimizedLine(g, x, y, x, y + height - (this.openBorder ? 1 : 2));
            } else if (d == Direction.LEFT) {
                GraphicsUtil.drawOptimizedLine(g, x + 1, y, x + width - (this.openBorder ? 1 : 2), y);
                GraphicsUtil.drawOptimizedLine(g, x, y, x, y + height - 2);
            } else if (d == Direction.DOWN) {
                if (!this.openBorder) {
                    GraphicsUtil.drawOptimizedLine(g, x + 1, y, x + width - 2, y);
                }
                GraphicsUtil.drawOptimizedLine(g, x, y, x, y + height - 2);
            } else if (this.openBorder) {
                GraphicsUtil.drawOptimizedLine(g, x, y, x + width - 2, y);
            } else {
                GraphicsUtil.drawOptimizedLine(g, x + 1, y, x + width - 2, y);
                GraphicsUtil.drawOptimizedLine(g, x, y, x, y + height - 2);
            }
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(1, 1, 0, 0);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

