/**
 * SECTION:avatar-cache
 * @short_description: A singleton persistent cache for avatars in folks.
 * 
 * <para>Avatars may be added to the cache, and referred to by a persistent URI from that point onwards. The avatars will be stored on disk in the user&apos;s XDG cache directory.</para><para>The avatar cache is typically used by backends where retrieving avatars is an expensive operation (for example, they have to be downloaded from the network every time they&apos;re used).</para><para>All avatars from all users of the <link linkend="FolksAvatarCache"><type>FolksAvatarCache</type></link> are stored in the same namespace, so callers must ensure that the IDs they use for avatars are globally unique (e.g. by using the corresponding <link linkend="FolksPersona--uid"><type>"uid"</type></link>).</para><para>Ongoing store operations (<link linkend="folks-avatar-cache-store-avatar"><function>folks_avatar_cache_store_avatar()</function></link>) are rate limited to try and prevent file descriptor exhaustion. Load operations (<link linkend="folks-avatar-cache-load-avatar"><function>folks_avatar_cache_load_avatar()</function></link>) must be rate limited by the client, as the file I/O occurs when calling <link linkend="g-loadable-icon-load"><function>g_loadable_icon_load()</function></link> rather than when retrieving the <link linkend="GLoadableIcon"><type>GLoadableIcon</type></link> from the cache.</para>
 *
 * Since: 0.6.0
 */
/**
 * FOLKS_TYPE_AVATAR_CACHE:
 * 
 * The type for <link linkend="FolksAvatarCache"><type>FolksAvatarCache</type></link>.
 */
/**
 * folks_avatar_cache_load_avatar:
 * @self: the <link linkend="FolksAvatarCache"><type>FolksAvatarCache</type></link> instance
 * @id: (in): &nbsp;.  <para>the globally unique ID for the avatar </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Fetch an avatar from the cache by its globally unique ID.
 * 
 * <para>It is up to the caller to ensure that file I/O is rate-limited when loading many avatars in parallel, by limiting calls to <link linkend="g-loadable-icon-load"><function>g_loadable_icon_load()</function></link>.</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if checking for existence of the cache file failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-avatar-cache-load-avatar-finish"><function>folks_avatar_cache_load_avatar_finish()</function></link>
 *
 * Since: 0.6.0
 */
/**
 * folks_avatar_cache_load_avatar_finish:
 * @self: the <link linkend="FolksAvatarCache"><type>FolksAvatarCache</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: location to store the error occurring, or %NULL to ignore
 * 
 * Fetch an avatar from the cache by its globally unique ID.
 * 
 * <para>It is up to the caller to ensure that file I/O is rate-limited when loading many avatars in parallel, by limiting calls to <link linkend="g-loadable-icon-load"><function>g_loadable_icon_load()</function></link>.</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if checking for existence of the cache file failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-avatar-cache-load-avatar"><function>folks_avatar_cache_load_avatar()</function></link>
 * 
 * Returns: <para>Avatar from the cache, or <code>null</code> if it doesn&apos;t exist in the cache </para>
 *
 * Since: 0.6.0
 */
/**
 * folks_avatar_cache_store_avatar:
 * @self: the <link linkend="FolksAvatarCache"><type>FolksAvatarCache</type></link> instance
 * @id: (in): &nbsp;.  <para>the globally unique ID for the avatar </para>
 * @avatar: (in): &nbsp;.  <para>the avatar data to cache </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Store an avatar in the cache, assigning the given globally unique ID to it, which can later be used to load and remove the avatar from the cache. For example, this ID could be the UID of a persona. The URI of the cached avatar file will be returned.
 * 
 * <para>This method may be called multiple times concurrently for the same avatar ID (e.g. an asynchronous call may be made, and a subsequent asynchronous call may begin before the first has finished).</para><para>Concurrent file I/O may be rate limited within each <link linkend="folks-avatar-cache-new"><function>folks_avatar_cache_new()</function></link> instance to avoid file descriptor exhaustion.</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if the avatar data couldn&apos;t be loaded, or if creating the avatar directory or cache file failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-avatar-cache-store-avatar-finish"><function>folks_avatar_cache_store_avatar_finish()</function></link>
 *
 * Since: 0.6.0
 */
/**
 * folks_avatar_cache_store_avatar_finish:
 * @self: the <link linkend="FolksAvatarCache"><type>FolksAvatarCache</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: location to store the error occurring, or %NULL to ignore
 * 
 * Store an avatar in the cache, assigning the given globally unique ID to it, which can later be used to load and remove the avatar from the cache. For example, this ID could be the UID of a persona. The URI of the cached avatar file will be returned.
 * 
 * <para>This method may be called multiple times concurrently for the same avatar ID (e.g. an asynchronous call may be made, and a subsequent asynchronous call may begin before the first has finished).</para><para>Concurrent file I/O may be rate limited within each <link linkend="folks-avatar-cache-new"><function>folks_avatar_cache_new()</function></link> instance to avoid file descriptor exhaustion.</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if the avatar data couldn&apos;t be loaded, or if creating the avatar directory or cache file failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-avatar-cache-store-avatar"><function>folks_avatar_cache_store_avatar()</function></link>
 * 
 * Returns: <para>a URI for the file storing the cached avatar </para>
 *
 * Since: 0.6.0
 */
/**
 * folks_avatar_cache_remove_avatar:
 * @self: the <link linkend="FolksAvatarCache"><type>FolksAvatarCache</type></link> instance
 * @id: (in): &nbsp;.  <para>the globally unique ID for the avatar </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Remove an avatar from the cache, if it exists in the cache. If the avatar exists in the cache but there is a problem in removing it, a <link linkend="GError"><type>GError</type></link> will be thrown.
 * 
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if deleting the cache file failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-avatar-cache-remove-avatar-finish"><function>folks_avatar_cache_remove_avatar_finish()</function></link>
 *
 * Since: 0.6.0
 */
/**
 * folks_avatar_cache_remove_avatar_finish:
 * @self: the <link linkend="FolksAvatarCache"><type>FolksAvatarCache</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: location to store the error occurring, or %NULL to ignore
 * 
 * Remove an avatar from the cache, if it exists in the cache. If the avatar exists in the cache but there is a problem in removing it, a <link linkend="GError"><type>GError</type></link> will be thrown.
 * 
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if deleting the cache file failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-avatar-cache-remove-avatar"><function>folks_avatar_cache_remove_avatar()</function></link>
 *
 * Since: 0.6.0
 */
/**
 * folks_avatar_cache_build_uri_for_avatar:
 * @self: the <link linkend="FolksAvatarCache"><type>FolksAvatarCache</type></link> instance
 * @id: (in): &nbsp;.  <para>the globally unique ID for the avatar </para>
 * 
 * Build the URI of an avatar file in the cache from a globally unique ID. This will always succeed, even if the avatar doesn&apos;t exist in the cache.
 * 
 * Returns: <para>URI of the avatar file with the given globally unique ID </para>
 *
 * Since: 0.6.0
 */
/**
 * folks_avatar_cache_dup:
 * 
 * Create or return the singleton <link linkend="FolksAvatarCache"><type>FolksAvatarCache</type></link> class instance. If the instance doesn&apos;t exist already, it will be created.
 * 
 * <para>This function is thread-safe.</para>
 * 
 * Returns: <para>Singleton <link linkend="FolksAvatarCache"><type>FolksAvatarCache</type></link> instance </para>
 *
 * Since: 0.6.0
 */
/**
 * FolksAvatarCache:
 * 
 * A singleton persistent cache for avatars in folks.
 * 
 * <para>Avatars may be added to the cache, and referred to by a persistent URI from that point onwards. The avatars will be stored on disk in the user&apos;s XDG cache directory.</para><para>The avatar cache is typically used by backends where retrieving avatars is an expensive operation (for example, they have to be downloaded from the network every time they&apos;re used).</para><para>All avatars from all users of the <link linkend="FolksAvatarCache"><type>FolksAvatarCache</type></link> are stored in the same namespace, so callers must ensure that the IDs they use for avatars are globally unique (e.g. by using the corresponding <link linkend="FolksPersona--uid"><type>"uid"</type></link>).</para><para>Ongoing store operations (<link linkend="folks-avatar-cache-store-avatar"><function>folks_avatar_cache_store_avatar()</function></link>) are rate limited to try and prevent file descriptor exhaustion. Load operations (<link linkend="folks-avatar-cache-load-avatar"><function>folks_avatar_cache_load_avatar()</function></link>) must be rate limited by the client, as the file I/O occurs when calling <link linkend="g-loadable-icon-load"><function>g_loadable_icon_load()</function></link> rather than when retrieving the <link linkend="GLoadableIcon"><type>GLoadableIcon</type></link> from the cache.</para>
 *
 * Since: 0.6.0
 */
/**
 * FolksAvatarCacheClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-AVATAR-CACHE:CAPS"><literal>FOLKS_TYPE_AVATAR_CACHE</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
