/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.ui;

import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.ui.SQLServerUIMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class SQLServerConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private Label hostLabel;
    private Text hostText;
    private Label portLabel;
    private Text portText;
    private Label dbLabel;
    private Text dbText;
    private Text urlText;
    private Button showAllDatabases;
    private Button showAllSchemas;
    private Button encryptPassword;
    private Button trustServerCertificate;
    private boolean needsPort;
    private boolean activated;
    private final Image LOGO_AZURE = this.createImage("icons/azure_logo.png");
    private final Image LOGO_BABELFISH = this.createImage("icons/babelfish_logo.png");
    private final Image LOGO_SQLSERVER = this.createImage("icons/mssql_logo.png");
    private final Image LOGO_SYBASE = this.createImage("icons/sybase_logo.png");

    public void dispose() {
        super.dispose();
        UIUtils.dispose((Resource)this.LOGO_AZURE);
        UIUtils.dispose((Resource)this.LOGO_BABELFISH);
        UIUtils.dispose((Resource)this.LOGO_SQLSERVER);
        UIUtils.dispose((Resource)this.LOGO_SYBASE);
    }

    public void createControl(Composite composite) {
        ModifyListener textListener = e -> {
            if (this.activated) {
                this.updateUrl();
                this.site.updateButtons();
            }
        };
        boolean isSqlServer = this.isSqlServer();
        boolean isDriverAzure = isSqlServer && this.isDriverAzure();
        Composite settingsGroup = new Composite(composite, 0);
        settingsGroup.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        settingsGroup.setLayoutData((Object)gd);
        Group addrGroup = UIUtils.createControlGroup((Composite)settingsGroup, (String)UIConnectionMessages.dialog_connection_server_label, (int)4, (int)768, (int)0);
        SelectionAdapter typeSwitcher = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLServerConnectionPage.this.setupConnectionModeSelection(SQLServerConnectionPage.this.urlText, SQLServerConnectionPage.this.typeURLRadio.getSelection(), GROUP_CONNECTION_ARR);
                SQLServerConnectionPage.this.updateUrl();
            }
        };
        this.createConnectionModeSwitcher((Composite)addrGroup, (SelectionListener)typeSwitcher);
        Label urlLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)UIConnectionMessages.dialog_connection_url_label);
        urlLabel.setLayoutData((Object)new GridData(128));
        this.urlText = new Text((Composite)addrGroup, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 355;
        this.urlText.setLayoutData((Object)gd);
        this.urlText.addModifyListener(e -> this.site.updateButtons());
        this.needsPort = CommonUtils.getBoolean((Object)this.getSite().getDriver().getDriverParameter("needsPort"), (boolean)true);
        this.hostLabel = new Label((Composite)addrGroup, 0);
        this.hostLabel.setText(SQLServerUIMessages.dialog_connection_host_label);
        this.hostLabel.setLayoutData((Object)new GridData(128));
        this.hostText = new Text((Composite)addrGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.hostText.setLayoutData((Object)gd);
        this.hostText.addModifyListener(textListener);
        this.addControlToGroup("connection", new Control[]{this.hostLabel, this.hostText});
        if (isDriverAzure || !this.needsPort) {
            gd.horizontalSpan = 3;
        } else {
            this.portLabel = new Label((Composite)addrGroup, 0);
            this.portLabel.setText(SQLServerUIMessages.dialog_connection_port_label);
            this.portLabel.setLayoutData((Object)new GridData(128));
            this.portText = new Text((Composite)addrGroup, 2048);
            gd = new GridData(2);
            gd.widthHint = UIUtils.getFontHeight((Control)this.portText) * 7;
            this.portText.setLayoutData((Object)gd);
            this.portText.addModifyListener(textListener);
            this.addControlToGroup("connection", new Control[]{this.portLabel, this.portText});
        }
        this.dbLabel = new Label((Composite)addrGroup, 0);
        this.dbLabel.setText(SQLServerUIMessages.dialog_connection_database_schema_label);
        this.dbLabel.setLayoutData((Object)new GridData(128));
        this.dbText = new Text((Composite)addrGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.dbText.setLayoutData((Object)gd);
        this.dbText.addModifyListener(textListener);
        this.addControlToGroup("connection", new Control[]{this.dbLabel, this.dbText});
        this.createAuthPanel(settingsGroup, 1);
        Group secureGroup = new Group(settingsGroup, 0);
        secureGroup.setText(SQLServerUIMessages.dialog_setting_connection_settings);
        secureGroup.setLayoutData((Object)new GridData(768));
        secureGroup.setLayout((Layout)new GridLayout(1, false));
        if (!isSqlServer) {
            this.encryptPassword = UIUtils.createCheckbox((Composite)secureGroup, (String)SQLServerUIMessages.dialog_setting_encrypt_password, (String)SQLServerUIMessages.dialog_setting_encrypt_password_tip, (boolean)false, (int)1);
        }
        if (isDriverAzure || this.isDriverBabelfish()) {
            this.showAllDatabases = UIUtils.createCheckbox((Composite)secureGroup, (String)SQLServerUIMessages.dialog_setting_show_all_databases, (String)SQLServerUIMessages.dialog_setting_show_all_databases_tip, (boolean)false, (int)1);
        }
        this.showAllSchemas = UIUtils.createCheckbox((Composite)secureGroup, (String)SQLServerUIMessages.dialog_setting_show_all_schemas, (String)SQLServerUIMessages.dialog_setting_show_all_schemas_tip, (boolean)true, (int)1);
        if (isSqlServer) {
            this.trustServerCertificate = UIUtils.createCheckbox((Composite)secureGroup, (String)SQLServerUIMessages.dialog_setting_trust_server_certificate, (String)SQLServerUIMessages.dialog_setting_trust_server_certificate_tip, (boolean)false, (int)1);
        }
        this.createDriverPanel(settingsGroup);
        this.setControl((Control)settingsGroup);
    }

    public boolean isComplete() {
        if (this.isCustomURL()) {
            return !CommonUtils.isEmpty((String)this.urlText.getText());
        }
        return this.hostText != null && !CommonUtils.isEmpty((String)this.hostText.getText());
    }

    public Image getImage() {
        DBPImage logoImage = this.site.getDriver().getLogoImage();
        if (logoImage != null) {
            return DBeaverIcons.getImage((DBPImage)logoImage);
        }
        Image logo = this.LOGO_SYBASE;
        if (this.isSqlServer()) {
            logo = this.isDriverAzure() ? this.LOGO_AZURE : (this.isDriverBabelfish() ? this.LOGO_BABELFISH : this.LOGO_SQLSERVER);
        }
        return logo;
    }

    private boolean isDriverAzure() {
        return SQLServerUtils.isDriverAzure((DBPDriver)this.getSite().getDriver());
    }

    private boolean isDriverBabelfish() {
        return SQLServerUtils.isDriverBabelfish((DBPDriver)this.getSite().getDriver());
    }

    private boolean isSqlServer() {
        return SQLServerUtils.isDriverSqlServer((DBPDriver)this.getSite().getDriver());
    }

    public void loadSettings() {
        boolean useURL;
        super.loadSettings();
        boolean isDriverAzure = this.isSqlServer() && this.isDriverAzure();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.hostText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                this.hostText.setText(connectionInfo.getHostName());
            } else {
                this.hostText.setText(CommonUtils.toString((Object)this.site.getDriver().getDefaultHost(), (String)(isDriverAzure ? ".database.windows.net" : "localhost")));
            }
        }
        if (this.portText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                this.portText.setText(String.valueOf(connectionInfo.getHostPort()));
            } else if (this.site.getDriver().getDefaultPort() != null) {
                this.portText.setText(this.site.getDriver().getDefaultPort());
            } else {
                this.portText.setText("");
            }
        }
        if (this.dbText != null) {
            String databaseName = connectionInfo.getDatabaseName();
            if (this.getSite().isNew() && CommonUtils.isEmpty((String)databaseName)) {
                databaseName = CommonUtils.notEmpty((String)this.site.getDriver().getDefaultDatabase());
            }
            this.dbText.setText(CommonUtils.notEmpty((String)databaseName));
        }
        if (this.showAllDatabases != null) {
            this.showAllDatabases.setSelection(CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("show-all-databases-azure")));
        }
        this.showAllSchemas.setSelection(CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("@dbeaver-show-all-schemas@")));
        if (this.trustServerCertificate != null) {
            this.trustServerCertificate.setSelection(CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("sslTrustServerCertificate"), (boolean)false));
        }
        if (!this.isSqlServer() && this.encryptPassword != null) {
            this.encryptPassword.setSelection(CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("@dbeaver-encrypt-password@")));
        }
        boolean bl = useURL = connectionInfo.getConfigurationType() == DBPDriverConfigurationType.URL;
        if (useURL) {
            this.urlText.setText(connectionInfo.getUrl());
        }
        this.setupConnectionModeSelection(this.urlText, useURL, GROUP_CONNECTION_ARR);
        this.updateUrl();
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        connectionInfo.setConfigurationType(this.typeURLRadio != null && this.typeURLRadio.getSelection() ? DBPDriverConfigurationType.URL : DBPDriverConfigurationType.MANUAL);
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
        }
        if (this.portText != null) {
            connectionInfo.setHostPort(this.portText.getText().trim());
        }
        if (this.dbText != null) {
            connectionInfo.setDatabaseName(this.dbText.getText().trim());
        }
        if (this.showAllDatabases != null) {
            connectionInfo.setProviderProperty("show-all-databases-azure", String.valueOf(this.showAllDatabases.getSelection()));
        }
        if (this.showAllSchemas != null) {
            connectionInfo.setProviderProperty("@dbeaver-show-all-schemas@", String.valueOf(this.showAllSchemas.getSelection()));
        }
        if (this.trustServerCertificate != null) {
            connectionInfo.setProviderProperty("sslTrustServerCertificate", String.valueOf(this.trustServerCertificate.getSelection()));
        }
        if (this.encryptPassword != null) {
            connectionInfo.setProviderProperty("@dbeaver-encrypt-password@", String.valueOf(this.encryptPassword.getSelection()));
        }
        if (this.typeURLRadio != null && this.typeURLRadio.getSelection()) {
            connectionInfo.setUrl(this.urlText.getText());
        }
        super.saveSettings(dataSource);
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }

    private void updateUrl() {
        DBPDataSourceContainer dataSourceContainer = this.site.getActiveDataSource();
        this.saveSettings(dataSourceContainer);
        if (this.typeURLRadio != null && this.typeURLRadio.getSelection()) {
            this.urlText.setText(dataSourceContainer.getConnectionConfiguration().getUrl());
        } else {
            this.urlText.setText(dataSourceContainer.getDriver().getConnectionURL(this.site.getActiveDataSource().getConnectionConfiguration()));
        }
    }
}

