/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.manager;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableIndex;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLIndexManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;

public class ExasolTableIndexManager
extends SQLIndexManager<ExasolTableIndex, ExasolTable> {
    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 4L;
    }

    @Nullable
    public DBSObjectCache<ExasolSchema, ExasolTableIndex> getObjectsCache(ExasolTableIndex object) {
        return ((ExasolSchema)object.getTable().getContainer()).getIndexCache();
    }

    public boolean canEditObject(ExasolTableIndex object) {
        return false;
    }

    protected ExasolTableIndex createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object from, @NotNull Map<String, Object> options) throws DBException {
        return new ExasolTableIndex((ExasolTable)container, null, DBSIndexType.OTHER, false);
    }

    protected String getDropIndexPattern(ExasolTableIndex index) {
        return "DROP " + index.getType().getName() + " INDEX ON " + index.getTable().getFullyQualifiedName(DBPEvaluationContext.DDL) + " " + index.getColumnString();
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        ExasolTableIndex index = (ExasolTableIndex)command.getObject();
        String SQL = String.format("ENFORCE %s INDEX ON %s %s", index.getType().getName(), index.getTable().getFullyQualifiedName(DBPEvaluationContext.DDL), index.getColumnString());
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create Index", SQL));
    }
}

