/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hana.model.data;

import java.sql.SQLException;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCollection;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCArrayValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class HANAVectorValueHandler
extends JDBCArrayValueHandler {
    public static final HANAVectorValueHandler INSTANCE = new HANAVectorValueHandler();
    private static DBCLogicalOperator[] SUPPORTED_OPERATORS = new DBCLogicalOperator[]{DBCLogicalOperator.IS_NOT_NULL, DBCLogicalOperator.IS_NULL};

    protected boolean useGetArray(DBCSession session, DBSTypedObject type) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        if (value == null) {
            statement.setNull(paramIndex, 2003);
            return;
        } else {
            if (!(value instanceof DBDCollection)) throw new DBCException("Array parameter type '" + value.getClass().getName() + "' not supported");
            DBDCollection collection = (DBDCollection)value;
            if (collection.isNull()) {
                statement.setNull(paramIndex, 2003);
                return;
            } else {
                if (!(collection instanceof JDBCCollection)) throw new DBCException("Array parameter type '" + value.getClass().getName() + "' not supported");
                JDBCCollection jc = (JDBCCollection)collection;
                if (jc.getComponentType().getTypeID() != 7) {
                    throw new DBCException("Only REAL numbers are allowed in vectors");
                }
                float[] nvals = new float[jc.size()];
                int i = 0;
                while (i < nvals.length) {
                    Float val = (Float)jc.get(i);
                    if (val == null) {
                        throw new DBCException("NULL elements are not allowed in vectors");
                    }
                    nvals[i] = val.floatValue();
                    ++i;
                }
                statement.setObject(paramIndex, (Object)nvals);
            }
        }
    }

    public DBCLogicalOperator[] getSupportedOperators(DBSTypedObject attribute) {
        return SUPPORTED_OPERATORS;
    }
}

