/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.view;

import java.util.List;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ProgressPainter;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardListViewer;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardMessages;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardConfiguration;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardConfigurationList;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardGroupContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardViewer;
import org.jkiss.dbeaver.ui.dashboard.view.DashboardUpdateJob;
import org.jkiss.utils.CommonUtils;

public class DataSourceDashboardView
extends ViewPart
implements DashboardViewer,
DBPDataSourceContainerProvider,
DBPEventListener {
    public static final String VIEW_ID = "org.jkiss.dbeaver.ui.dashboardView";
    protected static final Log log = Log.getLog(DataSourceDashboardView.class);
    private DashboardListViewer dashboardListViewer;
    private DashboardConfigurationList configurationList;
    private DashboardConfiguration configuration;
    private DBPDataSourceContainer dataSourceContainer;
    private DBPProject project;
    private String dashboardId;

    public static DataSourceDashboardView openView(@NotNull IWorkbenchWindow workbenchWindow, @NotNull DBPProject project, @Nullable DBPDataSourceContainer dataSourceContainer, @Nullable String id) {
        try {
            return (DataSourceDashboardView)workbenchWindow.getActivePage().showView(VIEW_ID, DashboardConfiguration.getViewId(project, dataSourceContainer, id), 1);
        }
        catch (PartInitException e) {
            DBWorkbench.getPlatformUI().showError(UIDashboardMessages.error_dashboard_view_cannot_open_title, UIDashboardMessages.error_dashboard_view_cannot_open_msg, (Throwable)e);
            return null;
        }
    }

    @Override
    public DashboardConfigurationList getConfigurationList() {
        return this.configurationList;
    }

    @Override
    public DashboardConfiguration getConfiguration() {
        return this.configuration;
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        return this.configuration == null ? null : this.configuration.getDataSourceContainer();
    }

    public void createPartControl(Composite parent) {
        UIExecutionQueue.queueExec(() -> this.createDashboardControls(parent));
    }

    private void createDashboardControls(Composite parent) {
        ProgressPainter dashboardProgressPainter = new ProgressPainter((Control)parent);
        try {
            String secondaryId = this.getViewSite().getSecondaryId();
            if (CommonUtils.isEmpty((String)secondaryId)) {
                throw new IllegalStateException("Dashboard view requires active database connection");
            }
            String projectName = null;
            String datasourceId = null;
            this.dashboardId = null;
            if (secondaryId.startsWith("ref#")) {
                String[] params;
                String[] stringArray = params = secondaryId.substring("ref#".length()).split(",");
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    String param = stringArray[n2];
                    int divPos = param.indexOf("=");
                    if (divPos < 0) {
                        log.debug((Object)("Invalid dashboard parameter '" + param + "'"));
                    } else {
                        DashboardConfiguration.Parameter dp = (DashboardConfiguration.Parameter)CommonUtils.valueOf(DashboardConfiguration.Parameter.class, (String)param.substring(0, divPos), null);
                        String value = param.substring(divPos + 1);
                        switch (dp) {
                            case project: {
                                projectName = value;
                                break;
                            }
                            case id: {
                                this.dashboardId = value;
                                break;
                            }
                            case datasource: {
                                datasourceId = value;
                            }
                        }
                    }
                    ++n2;
                }
            } else {
                String[] idParts = secondaryId.split("/");
                if (idParts.length == 1) {
                    datasourceId = idParts[0];
                } else {
                    projectName = idParts[0];
                    datasourceId = idParts[1];
                }
            }
            if (CommonUtils.isEmpty((String)this.dashboardId) && CommonUtils.isEmpty((String)projectName)) {
                throw new IllegalStateException("Bad dashboard view ID: " + secondaryId);
            }
            if (CommonUtils.isEmpty((String)projectName)) {
                this.dataSourceContainer = DBUtils.findDataSource(null, (String)datasourceId);
                if (datasourceId == null) {
                    throw new IllegalStateException("Invalid datasource ID: " + datasourceId);
                }
                this.project = this.dataSourceContainer.getProject();
            } else {
                this.project = DBWorkbench.getPlatform().getWorkspace().getProject(projectName);
                if (this.project == null) {
                    throw new IllegalStateException("Invalid project name: " + projectName);
                }
                if (!CommonUtils.isEmpty((String)datasourceId)) {
                    this.dataSourceContainer = this.project.getDataSourceRegistry().getDataSource(datasourceId);
                }
            }
            if (this.dataSourceContainer != null) {
                this.dataSourceContainer.getRegistry().addDataSourceListener((DBPEventListener)this);
                this.configurationList = new DashboardConfigurationList(this.dataSourceContainer);
                this.configurationList.checkDefaultDashboardExistence();
                if (CommonUtils.isEmpty((String)this.dashboardId)) {
                    this.dashboardId = this.configurationList.getDashboards().get(0).getDashboardId();
                }
                this.configuration = this.configurationList.getDashboard(this.dashboardId);
                if (this.configuration == null) {
                    this.dashboardId = "default";
                    this.configuration = this.configurationList.getDashboard(this.dashboardId);
                }
                this.updateStatus();
                this.dashboardListViewer = new DashboardListViewer((IWorkbenchSite)this.getSite(), (IWorkbenchPart)this, this.configurationList, this.configuration);
                this.dashboardListViewer.createControl(parent);
                this.dashboardListViewer.createDashboardsFromConfiguration();
                this.getSite().setSelectionProvider((ISelectionProvider)this.dashboardListViewer);
            } else {
                this.updateStatus();
            }
            parent.layout(true, true);
            dashboardProgressPainter.close();
        }
        catch (Throwable e) {
            log.error((Object)"Error initializing dashboard view", e);
        }
    }

    public void setFocus() {
        List<? extends DashboardItemContainer> items;
        DashboardGroupContainer group;
        if (this.dashboardListViewer != null && (group = this.dashboardListViewer.getDefaultGroup()) != null && !(items = group.getItems()).isEmpty()) {
            group.selectItem(items.get(0));
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void dispose() {
        super.dispose();
        if (this.dashboardListViewer != null) {
            if (this.dataSourceContainer != null) {
                this.dataSourceContainer.getRegistry().removeDataSourceListener((DBPEventListener)this);
            }
            this.dashboardListViewer.dispose();
            this.dashboardListViewer = null;
        }
    }

    public void handleDataSourceEvent(DBPEvent event) {
        if (event.getObject() != this.dataSourceContainer) {
            return;
        }
        switch (event.getAction()) {
            case OBJECT_UPDATE: 
            case OBJECT_REMOVE: {
                UIUtils.asyncExec(this::updateStatus);
            }
        }
    }

    @Override
    public void updateStatus() {
        if (this.configuration == null) {
            return;
        }
        Object partName = "Default".equals(this.configuration.getDashboardName()) ? (this.dataSourceContainer != null ? this.dataSourceContainer.getName() + (this.dataSourceContainer.isConnected() ? "" : UIDashboardMessages.dashboard_view_status_off) : this.project.getName() + ":" + this.dashboardId) : this.configuration.getDashboardName();
        if (this.dataSourceContainer != null && this.dataSourceContainer.isConnected()) {
            DashboardUpdateJob.getDefault().resumeDashboardUpdate();
        }
        if (this.dataSourceContainer != null) {
            this.setTitleToolTip("Connection: " + this.dataSourceContainer.getName() + " (" + this.dataSourceContainer.getDriver().getFullName() + ")");
        }
        UIUtils.syncExec(() -> this.lambda$2((String)partName));
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
    }

    @Override
    public DashboardListViewer getDashboardListViewer() {
        return this.dashboardListViewer;
    }

    private /* synthetic */ void lambda$2(String string) {
        this.setPartName(string);
    }
}

