/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPConnectionInformation;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderRegistry;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.InternalDatabaseConfig;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialectSchemaController;
import org.jkiss.dbeaver.model.sql.db.InternalProxyConnection;
import org.jkiss.dbeaver.model.sql.schema.ClassLoaderScriptSource;
import org.jkiss.dbeaver.model.sql.schema.SQLSchemaConfig;
import org.jkiss.dbeaver.model.sql.schema.SQLSchemaManager;
import org.jkiss.dbeaver.model.sql.schema.UpdateSchemaResult;
import org.jkiss.utils.CommonUtils;

public abstract class InternalDB<T extends InternalDatabaseConfig> {
    private static final Log log = Log.getLog(InternalDB.class);
    protected final T databaseConfig;
    protected final List<SQLSchemaConfig> schemaConfigList;
    private final String name;
    protected SQLDialect dialect;
    protected DataSource dataSource;
    protected DBPConnectionInformation dbConnectionInformation;

    protected InternalDB(@NotNull String name, @NotNull T databaseConfig, @NotNull List<SQLSchemaConfig> configList) {
        this.databaseConfig = databaseConfig;
        this.name = name;
        this.schemaConfigList = configList;
    }

    public synchronized Connection getConnection() {
        block6: {
            try {
                if (this.dataSource != null) break block6;
                return null;
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
        InternalProxyConnection conn = new InternalProxyConnection(this.dataSource.getConnection(), (InternalDatabaseConfig)this.databaseConfig);
        try {
            if (!conn.getAutoCommit()) {
                conn.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            log.error((Object)"Error setting auto-commit state", (Throwable)e);
        }
        return conn;
    }

    public SQLDialect getDialect() {
        return this.dialect;
    }

    @NotNull
    public DBPConnectionInformation getMetaDataInfo() {
        return this.dbConnectionInformation;
    }

    public T getDatabaseConfig() {
        return this.databaseConfig;
    }

    protected void initSchema(@NotNull DBRProgressMonitor monitor, @NotNull Connection connection) throws Exception {
        DatabaseMetaData metaData = connection.getMetaData();
        this.initializeSchema(monitor, connection);
        String dbName = metaData.getDatabaseProductName();
        String dbVersion = metaData.getDatabaseProductVersion();
        log.debug((Object)("\t" + this.name + " DB server started (" + dbName + " " + dbVersion + ")"));
        this.dbConnectionInformation = new DBPConnectionInformation(this.databaseConfig.getUrl(), this.databaseConfig.getDriver(), dbName, dbVersion);
    }

    protected abstract void initializeSchema(@NotNull DBRProgressMonitor var1, @Nullable Connection var2) throws Exception;

    protected void updateSchema(@NotNull DBRProgressMonitor monitor, @NotNull Connection connection) throws DBException {
        List<SQLSchemaConfig> schemaConfigList = this.getSchemaConfigList();
        UpdateSchemaResult updateSchemaResult = null;
        int i = 0;
        while (i < schemaConfigList.size()) {
            SQLSchemaConfig schemaConfig = schemaConfigList.get(i);
            SQLSchemaManager schemaManager = new SQLSchemaManager(schemaConfig.getSchemaId(), new ClassLoaderScriptSource(schemaConfig.getClassLoader(), schemaConfig.getCreateScriptPath(), schemaConfig.getUpdateScriptPrefix()), monitor1 -> connection, schemaConfig.getVersionManager(), this.dialect, schemaConfig.getSchemaVersionActual(), schemaConfig.getSchemaVersionObsolete(), (InternalDatabaseConfig)this.databaseConfig, schemaConfig.getInitialSchemaFiller());
            updateSchemaResult = schemaManager.updateSchema(monitor, updateSchemaResult);
            ++i;
        }
    }

    protected void createSchemaIfNotExists(@NotNull Connection connection) throws SQLException {
        String schemaName = this.databaseConfig.getSchema();
        SQLDialect sQLDialect = this.dialect;
        if (sQLDialect instanceof SQLDialectSchemaController) {
            SQLDialectSchemaController schemaController = (SQLDialectSchemaController)sQLDialect;
            if (CommonUtils.isNotEmpty((String)schemaName)) {
                boolean schemaExist;
                String schemaExistQuery = schemaController.getSchemaExistQuery(schemaName);
                boolean bl = schemaExist = JDBCUtils.executeQuery((Connection)connection, (String)schemaExistQuery, (Object[])new Object[0]) != null;
                if (!schemaExist) {
                    log.info((Object)("Schema " + schemaName + " not exist, create new one"));
                    String createSchemaQuery = schemaController.getCreateSchemaQuery(schemaName);
                    try {
                        JDBCUtils.executeStatement((Connection)connection, (String)createSchemaQuery);
                    }
                    catch (SQLException e) {
                        log.error((Object)("Failed to create schema: " + schemaName), (Throwable)e);
                        this.closeConnection();
                        throw e;
                    }
                }
            }
        }
    }

    protected abstract DataSource initConnectionPool(@NotNull Driver var1, @NotNull String var2);

    @NotNull
    protected DBPDriver getDatabaseDriver(@NotNull DBPDataSourceProviderRegistry dataSourceProviderRegistry) throws DBException {
        if (CommonUtils.isEmpty((String)this.databaseConfig.getDriver())) {
            throw new DBException("No database driver configured for CloudBeaver database");
        }
        DBPDriver driver = dataSourceProviderRegistry.findDriver(this.databaseConfig.getDriver());
        if (driver == null) {
            throw new DBException("Driver '" + this.databaseConfig.getDriver() + "' not found");
        }
        return driver;
    }

    @NotNull
    protected Properties getProperties() {
        Properties conProperties = new Properties();
        if (!CommonUtils.isEmpty((String)this.databaseConfig.getUser())) {
            conProperties.put("user", this.databaseConfig.getUser());
            if (!CommonUtils.isEmpty((String)this.databaseConfig.getPassword())) {
                conProperties.put("password", this.databaseConfig.getPassword());
            }
        }
        return conProperties;
    }

    protected void closeConnection() {
        DataSource dataSource = this.dataSource;
        if (dataSource instanceof AutoCloseable) {
            AutoCloseable closeable = (AutoCloseable)((Object)dataSource);
            try {
                closeable.close();
            }
            catch (Exception e) {
                log.warn((Object)("Error while stopping " + this.name + " database"), (Throwable)e);
            }
            this.dataSource = null;
        }
    }

    protected List<SQLSchemaConfig> getSchemaConfigList() {
        return this.schemaConfigList;
    }
}

