/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.impls.PostgreServerType;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IDataSourceConnectionEditorSite;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.utils.CommonUtils;

public class PostgreConnectionPageAdvanced
extends ConnectionPageAbstract {
    private Button showTemplates;
    private Button showUnavailable;
    private Button showDatabaseStatistics;
    private Button readAllDataTypes;
    private Button readKeysWithColumns;
    private Button replaceLegacyTimezone;
    private Button usePreparedStatements;
    private Combo ddPlainBehaviorCombo;
    private Combo ddTagBehaviorCombo;

    public PostgreConnectionPageAdvanced() {
        this.setTitle("PostgreSQL");
        this.setDescription("PostgreSQL - " + PostgreMessages.dialog_setting_connection_settings);
    }

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite cfgGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        cfgGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        cfgGroup.setLayoutData((Object)gd);
        Group secureGroup = new Group(cfgGroup, 0);
        secureGroup.setText(PostgreMessages.dialog_setting_connection_settings);
        secureGroup.setLayoutData((Object)new GridData(768));
        secureGroup.setLayout((Layout)new GridLayout(2, false));
        this.showTemplates = UIUtils.createCheckbox((Composite)secureGroup, (String)PostgreMessages.dialog_setting_connection_show_templates, (String)PostgreMessages.dialog_setting_connection_show_templates_tip, (boolean)false, (int)2);
        this.showUnavailable = UIUtils.createCheckbox((Composite)secureGroup, (String)PostgreMessages.dialog_setting_connection_show_not_available_for_conn, (String)PostgreMessages.dialog_setting_connection_show_not_available_for_conn_tip, (boolean)false, (int)2);
        this.showDatabaseStatistics = UIUtils.createCheckbox((Composite)secureGroup, (String)PostgreMessages.dialog_setting_connection_database_statistics, (String)PostgreMessages.dialog_setting_connection_database_statistics_tip, (boolean)false, (int)2);
        this.readAllDataTypes = UIUtils.createCheckbox((Composite)secureGroup, (String)PostgreMessages.dialog_setting_connection_read_all_data_types, (String)PostgreMessages.dialog_setting_connection_read_all_data_types_tip, (boolean)false, (int)2);
        this.readKeysWithColumns = UIUtils.createCheckbox((Composite)secureGroup, (String)PostgreMessages.dialog_setting_connection_read_keys_with_columns, (String)PostgreMessages.dialog_setting_connection_read_keys_with_columns_tip, (boolean)false, (int)2);
        this.replaceLegacyTimezone = UIUtils.createCheckbox((Composite)secureGroup, (String)PostgreMessages.dialog_setting_connection_replace_legacy_timezone, (String)PostgreMessages.dialog_setting_connection_replace_legacy_timezone_tip, (boolean)false, (int)2);
        secureGroup = new Group(cfgGroup, 0);
        secureGroup.setText(PostgreMessages.dialog_setting_group_sql);
        secureGroup.setLayoutData((Object)new GridData(32));
        secureGroup.setLayout((Layout)new GridLayout(2, false));
        this.ddPlainBehaviorCombo = UIUtils.createLabelCombo((Composite)secureGroup, (String)PostgreMessages.dialog_setting_sql_dd_plain_label, (String)PostgreMessages.dialog_setting_sql_dd_plain_tip, (int)12);
        this.ddPlainBehaviorCombo.add(PostgreMessages.dialog_setting_sql_dd_string);
        this.ddPlainBehaviorCombo.add(PostgreMessages.dialog_setting_sql_dd_code_block);
        this.ddTagBehaviorCombo = UIUtils.createLabelCombo((Composite)secureGroup, (String)PostgreMessages.dialog_setting_sql_dd_tag_label, (String)PostgreMessages.dialog_setting_sql_dd_tag_tip, (int)12);
        this.ddTagBehaviorCombo.add(PostgreMessages.dialog_setting_sql_dd_string);
        this.ddTagBehaviorCombo.add(PostgreMessages.dialog_setting_sql_dd_code_block);
        DBPDriver driver = this.site.getDriver();
        PostgreServerType serverType = PostgreUtils.getServerType((DBPDriver)driver);
        if (serverType.turnOffPreparedStatements()) {
            Group performanceGroup = new Group(cfgGroup, 0);
            performanceGroup.setText(PostgreMessages.dialog_setting_group_performance);
            performanceGroup.setLayoutData((Object)new GridData(32));
            performanceGroup.setLayout((Layout)new GridLayout(2, false));
            this.usePreparedStatements = UIUtils.createCheckbox((Composite)performanceGroup, (String)PostgreMessages.dialog_setting_connection_use_prepared_statements, (String)PostgreMessages.dialog_setting_connection_use_prepared_statements_tip, (boolean)false, (int)2);
        }
        this.setControl((Control)cfgGroup);
        this.loadSettings();
    }

    public boolean isComplete() {
        return true;
    }

    public void setSite(IDataSourceConnectionEditorSite site) {
        super.setSite(site);
        if (site != null && site.getDriver() != null) {
            this.setTitle(site.getDriver().getName());
        }
    }

    public void loadSettings() {
        DBPPreferenceStore globalPrefs = DBWorkbench.getPlatform().getPreferenceStore();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        this.setTitle(this.site.getActiveDataSource().getDriver().getName());
        this.showTemplates.setSelection(CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("@dbeaver-show-template-db@"), (boolean)globalPrefs.getBoolean("@dbeaver-show-template-db@")));
        this.showUnavailable.setSelection(CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("@dbeaver-show-unavailable-db@"), (boolean)globalPrefs.getBoolean("@dbeaver-show-unavailable-db@")));
        this.showDatabaseStatistics.setSelection(CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("show-database-statistics"), (boolean)globalPrefs.getBoolean("show-database-statistics")));
        this.readAllDataTypes.setSelection(CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("@dbeaver-read-all-data-types-db@"), (boolean)globalPrefs.getBoolean("@dbeaver-read-all-data-types-db@")));
        this.readKeysWithColumns.setSelection(CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("read-keys-with-columns"), (boolean)globalPrefs.getBoolean("read-keys-with-columns")));
        this.replaceLegacyTimezone.setSelection(CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("replace-legacy-timezone"), (boolean)globalPrefs.getBoolean("replace-legacy-timezone")));
        if (this.usePreparedStatements != null) {
            this.usePreparedStatements.setSelection(CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("@dbeaver-use-prepared-statements-db@"), (boolean)false));
        }
        this.ddPlainBehaviorCombo.select(CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("postgresql.dd.plain.string"), (boolean)globalPrefs.getBoolean("postgresql.dd.plain.string")) ? 0 : 1);
        this.ddTagBehaviorCombo.select(CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("postgresql.dd.tag.string"), (boolean)globalPrefs.getBoolean("postgresql.dd.tag.string")) ? 0 : 1);
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionCfg = dataSource.getConnectionConfiguration();
        connectionCfg.setProviderProperty("@dbeaver-show-template-db@", String.valueOf(this.showTemplates.getSelection()));
        connectionCfg.setProviderProperty("@dbeaver-show-unavailable-db@", String.valueOf(this.showUnavailable.getSelection()));
        connectionCfg.setProviderProperty("show-database-statistics", String.valueOf(this.showDatabaseStatistics.getSelection()));
        connectionCfg.setProviderProperty("@dbeaver-read-all-data-types-db@", String.valueOf(this.readAllDataTypes.getSelection()));
        connectionCfg.setProviderProperty("read-keys-with-columns", String.valueOf(this.readKeysWithColumns.getSelection()));
        connectionCfg.setProviderProperty("replace-legacy-timezone", String.valueOf(this.replaceLegacyTimezone.getSelection()));
        if (this.usePreparedStatements != null) {
            connectionCfg.setProviderProperty("@dbeaver-use-prepared-statements-db@", String.valueOf(this.usePreparedStatements.getSelection()));
        }
        connectionCfg.setProviderProperty("postgresql.dd.plain.string", String.valueOf(this.ddPlainBehaviorCombo.getSelectionIndex() == 0));
        connectionCfg.setProviderProperty("postgresql.dd.tag.string", String.valueOf(this.ddTagBehaviorCombo.getSelectionIndex() == 0));
        this.saveConnectionURL(connectionCfg);
    }
}

