/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class PostgreEnumValue
implements PostgreObject {
    private PostgreDataSource dataSource;
    private PostgreDatabase database;
    private long oid;
    private long enumTypId;
    private long enumSortOrder;
    private String enumLabel;

    public PostgreEnumValue(@NotNull PostgreDataSource dataSource, @NotNull PostgreDatabase database, @NotNull JDBCResultSet dbResult) {
        this.dataSource = dataSource;
        this.database = database;
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.enumTypId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"enumtypid");
        this.enumSortOrder = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"enumsortorder");
        this.enumLabel = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"enumlabel");
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.database;
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return this.database;
    }

    @NotNull
    public String getName() {
        return CommonUtils.toString((Object)this.enumTypId);
    }

    public long getOid() {
        return this.oid;
    }

    public long getEnumTypId() {
        return this.enumTypId;
    }

    public long getEnumSortOrder() {
        return this.enumSortOrder;
    }

    public String getEnumLabel() {
        return this.enumLabel;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public long getObjectId() {
        return this.oid;
    }

    public boolean isPersisted() {
        return true;
    }
}

