/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreTableManager;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreIndex;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraint;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeignKey;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablePartition;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class PostgrePartitionManager
extends PostgreTableManager {
    private static final Log log = Log.getLog(PostgrePartitionManager.class);
    private static final Class<? extends DBSObject>[] CHILD_TYPES_PART = (Class[])CommonUtils.array((Object[])new Class[]{PostgreTableConstraint.class, PostgreTableForeignKey.class, PostgreIndex.class});

    @Override
    protected PostgreTablePartition createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) {
        return new PostgreTablePartition((PostgreTable)container);
    }

    private String getParentTable(@NotNull DBRProgressMonitor monitor, @NotNull PostgreTablePartition partition) {
        List<PostgreTableBase> superTables;
        try {
            superTables = partition.getSuperTables(monitor);
        }
        catch (DBException e) {
            log.error((Object)"Unable to get parent", (Throwable)e);
            return "";
        }
        if (superTables == null && partition.getPartitionOf() != null) {
            return partition.getPartitionOf().getFullyQualifiedName(DBPEvaluationContext.DDL);
        }
        if (CommonUtils.isEmpty(superTables) || superTables.size() > 1) {
            log.error((Object)"Unable to get parent");
            return "";
        }
        return superTables.get(0).getFullyQualifiedName(DBPEvaluationContext.DDL);
    }

    @Override
    protected String beginCreateTableStatement(@NotNull DBRProgressMonitor monitor, @NotNull PostgreTableBase table, @NotNull String tableName, @NotNull Map<String, Object> options) {
        return "CREATE " + this.getCreateTableType(table) + " " + tableName + " PARTITION OF " + this.getParentTable(monitor, (PostgreTablePartition)table) + " ";
    }

    @Override
    protected boolean hasAttrDeclarations(PostgreTableBase table) {
        return false;
    }

    protected boolean excludeFromDDL(SQLObjectEditor.NestedObjectCommand command, Collection<SQLObjectEditor.NestedObjectCommand> orderedCommands) {
        return !(command.getObject() instanceof PostgreTableConstraint) && !(command.getObject() instanceof PostgreIndex);
    }

    public boolean canEditObject(PostgreTableBase object) {
        return object instanceof PostgreTablePartition;
    }

    public boolean canCreateObject(@NotNull Object container) {
        return container instanceof PostgreTable;
    }

    public boolean canDeleteObject(@NotNull PostgreTableBase object) {
        return true;
    }

    @Override
    @NotNull
    public Class<? extends DBSObject>[] getChildTypes() {
        return CHILD_TYPES_PART;
    }
}

