/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistActionAtomic;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class PostgreDatabaseManager
extends SQLObjectEditor<PostgreDatabase, PostgreDataSource>
implements DBEObjectRenamer<PostgreDatabase> {
    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 1L;
    }

    @Nullable
    public DBSObjectCache<PostgreDataSource, PostgreDatabase> getObjectsCache(PostgreDatabase object) {
        return object.getDataSource().getDatabaseCache();
    }

    public void deleteObject(@NotNull DBECommandContext commandContext, @NotNull PostgreDatabase object, @NotNull Map<String, Object> options) throws DBException {
        if (object == object.getDataSource().getDefaultInstance()) {
            throw new DBException("Cannot drop the currently open database.\nSwitch to another database and try again\n(Note: enable 'Show all databases' option to see them).");
        }
        super.deleteObject(commandContext, (DBSObject)object, options);
    }

    protected PostgreDatabase createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) throws DBException {
        return ((PostgreDataSource)((Object)container)).createDatabaseImpl(monitor, "NewDatabase", null, null, null, null);
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        PostgreDatabase database = (PostgreDatabase)command.getObject();
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE DATABASE ").append(DBUtils.getQuotedIdentifier((DBSObject)database));
        if (database.getInitialOwner() != null) {
            sql.append("\nOWNER = ").append(DBUtils.getQuotedIdentifier((DBSObject)database.getInitialOwner()));
        }
        if (!CommonUtils.isEmpty((String)database.getTemplateName())) {
            sql.append("\nTEMPLATE = ").append(DBUtils.getQuotedIdentifier((DBPDataSource)database.getDataSource(), (String)database.getTemplateName()));
        }
        if (database.getInitialEncoding() != null) {
            sql.append("\nENCODING = '").append(database.getInitialEncoding().getName()).append("'");
        }
        if (database.getInitialTablespace() != null) {
            sql.append("\nTABLESPACE = ").append(DBUtils.getQuotedIdentifier((DBPDataSource)database.getDataSource(), (String)database.getInitialTablespace().getName()));
        }
        actions.add((DBEPersistAction)new CreateDatabaseAction(database, sql));
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) {
        actions.add((DBEPersistAction)new DeleteDatabaseAction(command));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull PostgreDatabase database, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, database, options, newName);
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename database", "ALTER DATABASE " + DBUtils.getQuotedIdentifier((DBPDataSource)((PostgreDatabase)command.getObject()).getDataSource(), (String)command.getOldName()) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)((PostgreDatabase)command.getObject()).getDataSource(), (String)command.getNewName())));
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        if (command.getProperties().size() > 1 || command.getProperty((Object)"description") == null) {
            try {
                this.generateAlterActions(monitor, actionList, command);
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
    }

    private void generateAlterActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command) throws DBException {
        PostgreDatabase database = (PostgreDatabase)command.getObject();
        String alterPrefix = "ALTER DATABASE " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject())) + " ";
        if (command.hasProperty((Object)"defaultTablespace")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(alterPrefix + "SET TABLESPACE " + DBUtils.getQuotedIdentifier((DBSObject)database.getDefaultTablespace(monitor))));
        }
        if (command.hasProperty((Object)"defaultEncoding")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(alterPrefix + "SET ENCODING " + DBUtils.getQuotedIdentifier((DBSObject)database.getDefaultEncoding(monitor))));
        }
        if (command.hasProperty((Object)"dBA")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(alterPrefix + "OWNER TO " + DBUtils.getQuotedIdentifier((DBSObject)database.getDBA(monitor))));
        }
    }

    protected void validateObjectProperties(DBRProgressMonitor monitor, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        super.validateObjectProperties(monitor, command, options);
        options.put("avoidTransactions", true);
    }

    protected void addObjectExtraActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.NestedObjectCommand<PostgreDatabase, SQLObjectEditor.PropertyHandler> command, @NotNull Map<String, Object> options) throws DBException {
        if (command.hasProperty((Object)"description")) {
            PostgreDatabase database = (PostgreDatabase)command.getObject();
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("COMMENT ON DATABASE " + DBUtils.getQuotedIdentifier((DBSObject)database) + " IS " + SQLUtils.quoteString((DBSObject)database, (String)CommonUtils.notEmpty((String)database.getDescription()))));
        }
    }

    private static class CreateDatabaseAction
    extends SQLDatabasePersistActionAtomic {
        private final PostgreDatabase database;

        public CreateDatabaseAction(PostgreDatabase database, StringBuilder sql) {
            super("Create database", sql.toString());
            this.database = database;
        }

        public void afterExecute(DBCSession session, Throwable error) throws DBCException {
            super.afterExecute(session, error);
            if (error == null) {
                try {
                    this.database.checkInstanceConnection(session.getProgressMonitor());
                }
                catch (DBException dBException) {
                    log.error((Object)"Can't connect to the new database");
                }
            }
        }
    }

    private static class DeleteDatabaseAction
    extends SQLDatabasePersistActionAtomic {
        private final PostgreDatabase database;

        public DeleteDatabaseAction(SQLObjectEditor.ObjectDeleteCommand command) {
            super("Drop database", "DROP DATABASE " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject())));
            this.database = (PostgreDatabase)command.getObject();
        }

        public void beforeExecute(DBCSession session) throws DBCException {
            super.beforeExecute(session);
            this.database.shutdown(session.getProgressMonitor());
        }
    }
}

