/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.select;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryRowsCorrelatedSourceModel
extends SQLQueryRowsSourceModel {
    @NotNull
    private final SQLQueryRowsSourceModel source;
    @NotNull
    private final SQLQuerySymbolEntry alias;
    @NotNull
    private final List<SQLQuerySymbolEntry> correlationColumNames;

    public SQLQueryRowsCorrelatedSourceModel(@NotNull STMTreeNode syntaxNode, @NotNull SQLQueryRowsSourceModel source, @NotNull SQLQuerySymbolEntry alias, @NotNull List<SQLQuerySymbolEntry> correlationColumNames) {
        super(syntaxNode, source);
        this.source = source;
        this.alias = alias;
        this.correlationColumNames = correlationColumNames;
    }

    @NotNull
    public SQLQueryRowsSourceModel getSource() {
        return this.source;
    }

    @NotNull
    public SQLQuerySymbolEntry getAlias() {
        return this.alias;
    }

    @NotNull
    public List<SQLQuerySymbolEntry> getCorrelationColumNames() {
        return this.correlationColumNames;
    }

    @Override
    @NotNull
    protected SQLQueryDataContext propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        context = this.source.propagateContext(context, statistics);
        if (this.alias.isNotClassified()) {
            context = context.extendWithTableAlias(this.alias.getSymbol(), this);
            this.alias.getSymbol().setDefinition(this.alias);
            if (this.alias.isNotClassified()) {
                this.alias.getSymbol().setSymbolClass(SQLQuerySymbolClass.TABLE_ALIAS);
            }
            context = SQLQueryRowsCorrelatedSourceModel.prepareColumnsCorrelation(context, this.correlationColumNames, (SQLQueryRowsSourceModel)this);
        }
        return context;
    }

    @NotNull
    public static SQLQueryDataContext prepareColumnsCorrelation(@NotNull SQLQueryDataContext context, @NotNull List<SQLQuerySymbolEntry> correlationColumNames, @NotNull SQLQueryRowsSourceModel columnsSource) {
        if (correlationColumNames.size() > 0) {
            ArrayList<SQLQueryResultColumn> columns = new ArrayList<SQLQueryResultColumn>(context.getColumnsList());
            int i = 0;
            while (i < columns.size() && i < correlationColumNames.size()) {
                SQLQuerySymbolEntry correlatedNameDef = correlationColumNames.get(i);
                if (correlatedNameDef.isNotClassified()) {
                    SQLQueryResultColumn oldColumn = (SQLQueryResultColumn)columns.get(i);
                    SQLQuerySymbol correlatedName = correlatedNameDef.getSymbol();
                    correlatedName.setDefinition(correlatedNameDef);
                    correlatedName.setSymbolClass(SQLQuerySymbolClass.COLUMN_DERIVED);
                    correlatedNameDef.setDefinition(oldColumn.symbol.getDefinition());
                    columns.set(i, new SQLQueryResultColumn(i, correlatedName, columnsSource, null, null, oldColumn.type));
                }
                ++i;
            }
            context = context.overrideResultTuple(columnsSource, columns, context.getPseudoColumnsList());
        }
        return context;
    }

    @NotNull
    public static SQLQueryRowsDataContext prepareColumnsCorrelation(@NotNull SQLQueryRowsDataContext context, @NotNull List<SQLQuerySymbolEntry> correlationColumNames, @NotNull SQLQueryRowsSourceModel columnsSource) {
        if (!correlationColumNames.isEmpty()) {
            ArrayList<SQLQueryResultColumn> columns = new ArrayList<SQLQueryResultColumn>(context.getColumnsList());
            int i = 0;
            while (i < columns.size() && i < correlationColumNames.size()) {
                SQLQuerySymbolEntry correlatedNameDef = correlationColumNames.get(i);
                if (correlatedNameDef.isNotClassified()) {
                    SQLQueryResultColumn oldColumn = (SQLQueryResultColumn)columns.get(i);
                    SQLQuerySymbol correlatedName = correlatedNameDef.getSymbol();
                    correlatedName.setDefinition(correlatedNameDef);
                    correlatedName.setSymbolClass(SQLQuerySymbolClass.COLUMN_DERIVED);
                    correlatedNameDef.setDefinition(oldColumn.symbol.getDefinition());
                    columns.set(i, new SQLQueryResultColumn(i, correlatedName, columnsSource, null, null, oldColumn.type));
                }
                ++i;
            }
            return columnsSource.getRowsSources().makeTuple(columnsSource, columns, context.getPseudoColumnsList());
        }
        return columnsSource.getRowsSources().makeTuple(columnsSource, context.getColumnsList(), context.getPseudoColumnsList());
    }

    @Override
    protected SQLQueryRowsSourceContext resolveRowSourcesImpl(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics) {
        if (this.alias.isNotClassified()) {
            this.alias.getSymbol().setDefinition(this.alias);
            if (this.alias.isNotClassified()) {
                this.alias.getSymbol().setSymbolClass(SQLQuerySymbolClass.TABLE_ALIAS);
            }
        }
        return this.source.resolveRowSources(context, statistics).appendAlias(this.source, this.alias.getSymbol());
    }

    @Override
    protected SQLQueryRowsDataContext resolveRowDataImpl(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        return SQLQueryRowsCorrelatedSourceModel.prepareColumnsCorrelation(this.source.getRowsDataContext(), this.correlationColumNames, (SQLQueryRowsSourceModel)this);
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T node) {
        return visitor.visitRowsCorrelatedSource(this, node);
    }
}

