/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.fs.nio;

import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOFileStore;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystem;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystemRoot;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystems;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class EFSNIOFileSystem
extends FileSystem {
    public static final String DBVFS_FS_ID = "dbvfs";
    private static final Log log = Log.getLog(EFSNIOFileSystem.class);

    public IFileStore getStore(URI uri) {
        try {
            return (IFileStore)DBWorkbench.getPlatformUI().runWithMonitor(monitor -> EFSNIOFileSystem.getFileStoreFromUri(monitor, uri));
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)e;
                throw re;
            }
            throw new IllegalArgumentException("Error while getting file store", e);
        }
    }

    @NotNull
    private static EFSNIOFileStore getFileStoreFromUri(@NotNull DBRProgressMonitor monitor, @NotNull URI uri) {
        Path path;
        block9: {
            DBPProject project;
            path = null;
            String projectName = CommonUtils.toString((Object)uri.getHost(), (String)uri.getAuthority());
            String[] vfsPath = CommonUtils.removeTrailingSlash((String)CommonUtils.removeLeadingSlash((String)uri.getPath())).split("/");
            String relPath = uri.getQuery();
            if (!CommonUtils.isEmpty((String)projectName) && vfsPath.length == 3 && !CommonUtils.isEmpty((String)relPath) && (project = DBWorkbench.getPlatform().getWorkspace().getProject(projectName)) != null) {
                DBNFileSystems fileSystemsNode;
                String fsType = vfsPath[0];
                String fsId = vfsPath[1];
                String fsRootPath = vfsPath[2];
                DBNProject projectNode = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode(project);
                if (projectNode != null && (fileSystemsNode = (DBNFileSystems)projectNode.getExtraNode(DBNFileSystems.class)) != null) {
                    try {
                        fileSystemsNode.getChildren(monitor);
                        DBNFileSystem fsNode = fileSystemsNode.getFileSystem(fsType, fsId);
                        if (fsNode != null) {
                            fsNode.getChildren(monitor);
                            DBNFileSystemRoot fsNodeRoot = fsNode.getRoot(fsRootPath);
                            if (fsNodeRoot == null) break block9;
                            try {
                                relPath = CommonUtils.removeLeadingSlash((String)relPath);
                                relPath = URLDecoder.decode(relPath, StandardCharsets.UTF_8);
                                path = fsNodeRoot.getPath().resolve(relPath);
                                break block9;
                            }
                            catch (Exception e) {
                                throw new IllegalArgumentException("Error resolving path '" + relPath + "'", e);
                            }
                        }
                        log.debug((Object)("File system '" + fsType + ":" + fsId + "' not found"));
                    }
                    catch (Exception e) {
                        if (e instanceof RuntimeException) {
                            RuntimeException re = (RuntimeException)e;
                            throw re;
                        }
                        throw new IllegalArgumentException("Error reading file systems", e);
                    }
                }
            }
        }
        if (path == null) {
            throw new IllegalArgumentException("Invalid dbvfs URI: " + String.valueOf(uri));
        }
        return new EFSNIOFileStore(uri, path);
    }

    public int attributes() {
        return 2143289344;
    }

    public boolean canDelete() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }
}

