/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandAggregator;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.DBERegistry;
import org.jkiss.dbeaver.model.edit.DBEStructEditor;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.edit.AbstractCommandContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectExt2;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectExt3;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyDescriptor;
import org.jkiss.dbeaver.runtime.properties.PropertySourceEditable;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingAttribute;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingType;
import org.jkiss.dbeaver.tools.transfer.database.MappingNameCase;
import org.jkiss.dbeaver.tools.transfer.database.MappingReplaceMechanism;
import org.jkiss.dbeaver.tools.transfer.internal.DTActivator;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class DatabaseTransferUtils {
    private static final Log log = Log.getLog(DatabaseTransferUtils.class);
    private static final boolean USE_STRUCT_DDL = true;
    private static final Pair<DBPDataKind, String> DATA_TYPE_UNKNOWN = new Pair((Object)DBPDataKind.UNKNOWN, null);
    private static final Pair<DBPDataKind, String> DATA_TYPE_INTEGER = new Pair((Object)DBPDataKind.NUMERIC, (Object)"INTEGER");
    private static final Pair<DBPDataKind, String> DATA_TYPE_REAL = new Pair((Object)DBPDataKind.NUMERIC, (Object)"REAL");
    private static final Pair<DBPDataKind, String> DATA_TYPE_BOOLEAN = new Pair((Object)DBPDataKind.BOOLEAN, (Object)"BOOLEAN");
    private static final Pair<DBPDataKind, String> DATA_TYPE_STRING = new Pair((Object)DBPDataKind.STRING, (Object)"VARCHAR");

    public static void refreshDatabaseModel(DBRProgressMonitor monitor, DatabaseConsumerSettings consumerSettings, DatabaseMappingContainer containerMapping) throws DBException {
        monitor.subTask("Refresh database model");
        DBSObjectContainer container = consumerSettings.getContainer();
        DBNModel navigatorModel = DBNUtils.getNavigatorModel((DBSObject)container);
        if (navigatorModel != null) {
            DBNDatabaseNode containerNode = navigatorModel.getNodeByObject(monitor, (DBSObject)container, false);
            if (containerNode != null) {
                containerNode.refreshNode(monitor, (Object)containerMapping);
            }
        } else if (container instanceof DBPRefreshableObject) {
            ((DBPRefreshableObject)container).refreshObject(monitor);
        }
        DatabaseTransferUtils.refreshDatabaseMappings(monitor, consumerSettings, containerMapping, false);
    }

    public static void refreshDatabaseMappings(@NotNull DBRProgressMonitor monitor, @NotNull DatabaseConsumerSettings consumerSettings, @Nullable DatabaseMappingContainer containerMapping, boolean force) throws DBException {
        DBSObjectContainer container = consumerSettings.getContainer();
        if (container == null) {
            log.debug((Object)"Null target container");
            return;
        }
        if (containerMapping == null) {
            log.debug((Object)"Null container mapping");
            return;
        }
        boolean updateMappingTarget = false;
        boolean updateMappingAttributes = false;
        switch (containerMapping.getMappingType()) {
            case create: 
            case recreate: {
                updateMappingTarget = true;
                updateMappingAttributes = true;
                break;
            }
            case existing: {
                updateMappingTarget = false;
                updateMappingAttributes = true;
                break;
            }
        }
        if (updateMappingTarget || force) {
            monitor.subTask("Refresh database mappings");
            DBSObject newTarget = container.getChild(monitor, DBUtils.getUnQuotedIdentifier((DBPDataSource)container.getDataSource(), (String)containerMapping.getTargetName()));
            if (newTarget == null) {
                throw new DBCException("New table " + containerMapping.getTargetName() + " not found in container " + DBUtils.getObjectFullName((DBPNamedObject)container, (DBPEvaluationContext)DBPEvaluationContext.UI));
            }
            if (!(newTarget instanceof DBSDataManipulator)) {
                throw new DBCException("New table " + DBUtils.getObjectFullName((DBPNamedObject)newTarget, (DBPEvaluationContext)DBPEvaluationContext.UI) + " doesn't support data manipulation");
            }
            containerMapping.setTarget((DBSDataManipulator)newTarget);
            if (containerMapping.getMappingType() == DatabaseMappingType.create) {
                containerMapping.setMappingType(DatabaseMappingType.existing);
            }
        }
        if (updateMappingAttributes || force) {
            for (DatabaseMappingAttribute attr : containerMapping.getAttributeMappings(monitor)) {
                if (attr.getMappingType() != DatabaseMappingType.create && (!attr.getMappingType().isValid() || !force)) continue;
                attr.updateMappingType(monitor, false, false);
                if (attr.getTarget() != null) continue;
                log.debug((Object)("Can't find target attribute '" + attr.getTargetName() + "' in '" + containerMapping.getTargetName() + "'"));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static DBEPersistAction[] generateTargetTableDDL(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull DBSObjectContainer schema, @NotNull DatabaseMappingContainer containerMapping, @Nullable Map<DBPPropertyDescriptor, Object> changedProperties) throws DBException {
        block18: {
            block17: {
                if (containerMapping.getMappingType() == DatabaseMappingType.skip) {
                    return new DBEPersistAction[0];
                }
                if (containerMapping.getMappingType() == DatabaseMappingType.existing) {
                    hasChanges = false;
                    for (DatabaseMappingAttribute attr : containerMapping.getAttributeMappings(monitor)) {
                        if (attr.getMappingType() == DatabaseMappingType.existing || attr.getMappingType() == DatabaseMappingType.skip) continue;
                        hasChanges = true;
                        break;
                    }
                    if (!hasChanges) {
                        return new DBEPersistAction[0];
                    }
                }
                monitor.subTask("Validate table structure table '" + containerMapping.getTargetName() + "'");
                try {
                    actions = new ArrayList<DBEPersistAction>();
                    DatabaseTransferUtils.generateStructTableDDL(monitor, executionContext, schema, containerMapping, actions, changedProperties);
                    return (DBEPersistAction[])actions.toArray((IntFunction<DBEPersistAction[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$0(int ), (I)[Lorg/jkiss/dbeaver/model/edit/DBEPersistAction;)());
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Can't create or update target table", null, (Throwable)e);
                    if (!DBWorkbench.getPlatformUI().confirmAction("Generate DDL automatically", "Do you want to create or update target object with auto-generated SQL script?")) {
                        throw new DBException("Target table create or update was canceled");
                    }
                    dataSource = executionContext.getDataSource();
                    sql = new StringBuilder(500);
                    tableName = containerMapping.getMappingType() == DatabaseMappingType.create ? DatabaseTransferUtils.getTransformedName(dataSource, containerMapping.getTargetName(), false) : DBObjectNameCaseTransformer.transformName((DBPDataSource)dataSource, (String)containerMapping.getTargetName());
                    containerMapping.setTargetName(tableName);
                    if (CommonUtils.isEmpty((String)tableName)) {
                        return new DBEPersistAction[0];
                    }
                    actions = new ArrayList<Object>();
                    if (containerMapping.getMappingType() == DatabaseMappingType.recreate && containerMapping.getTarget() != null) {
                        sql.append("DROP TABLE ");
                        DatabaseTransferUtils.getTableFullName(schema, dataSource, sql, tableName);
                        sql.append(dataSource.getSQLDialect().getScriptDelimiters()[0]);
                    }
                    if (!containerMapping.hasNewTargetObject()) break block17;
                    sql.append("CREATE TABLE ");
                    DatabaseTransferUtils.getTableFullName(schema, dataSource, sql, tableName);
                    sql.append("(\n");
                    mappedAttrs = new HashMap<DBSAttributeBase, DatabaseMappingAttribute>();
                    ** for (attr : containerMapping.getAttributeMappings((DBRProgressMonitor)monitor))
                }
lbl-1000:
                // 1 sources

                {
                    if (attr.getMappingType() != DatabaseMappingType.create) continue;
                    if (!mappedAttrs.isEmpty()) {
                        sql.append(",\n");
                    }
                    sql.append("\t");
                    DatabaseTransferUtils.appendAttributeClause(dataSource, sql, attr);
                    mappedAttrs.put(attr.getSource(), attr);
                    continue;
                }
lbl53:
                // 1 sources

                if (containerMapping.getSource() instanceof DBSEntity && !CommonUtils.isEmpty((Collection)(identifier = DBUtils.getBestTableIdentifier((DBRProgressMonitor)monitor, (DBSEntity)((DBSEntity)containerMapping.getSource()))))) {
                    idMapped = true;
                    for (DBSEntityAttribute idAttr : identifier) {
                        if (mappedAttrs.containsKey(idAttr)) continue;
                        idMapped = false;
                        break;
                    }
                    if (idMapped) {
                        sql.append(",\n\tPRIMARY KEY (");
                        hasAttr = false;
                        for (DBSEntityAttribute idAttr : identifier) {
                            mappedAttr = (DatabaseMappingAttribute)mappedAttrs.get(idAttr);
                            if (hasAttr) {
                                sql.append(",");
                            }
                            sql.append(DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)mappedAttr.getTargetName()));
                            hasAttr = true;
                        }
                        sql.append(")\n");
                    }
                }
                sql.append(")");
                actions.add(new SQLDatabasePersistAction("Table DDL", sql.toString()));
                break block18;
            }
            for (DatabaseMappingAttribute attr : containerMapping.getAttributeMappings(monitor)) {
                if (attr.getMappingType() != DatabaseMappingType.create) continue;
                actions.add(DatabaseTransferUtils.generateTargetAttributeDDL(dataSource, attr));
            }
        }
        return actions.toArray(new DBEPersistAction[0]);
    }

    @NotNull
    public static String getTransformedName(@NotNull DBPDataSource dataSource, @NotNull String targetName, boolean skipCaseChanging) {
        String finalName = targetName;
        DBPPreferenceStore dbpPreferenceStore = dataSource.getContainer().getPreferenceStore();
        DBPPreferenceStore store = DTActivator.getDefault().getPreferences();
        MappingNameCase nameCase = MappingNameCase.getCaseFromPreferences(dbpPreferenceStore, store);
        MappingReplaceMechanism mechanism = MappingReplaceMechanism.getCaseFromPreferences(dbpPreferenceStore, store);
        if (nameCase != MappingNameCase.DEFAULT) {
            finalName = nameCase.getIdentifierCase().transform(targetName);
        } else if (!skipCaseChanging && mechanism != MappingReplaceMechanism.CAMELCASE) {
            finalName = DBObjectNameCaseTransformer.transformName((DBPDataSource)dataSource, (String)targetName);
        }
        if (mechanism != MappingReplaceMechanism.ABSENT && CommonUtils.isNotEmpty((String)finalName) && finalName.contains(" ")) {
            String camelCaseName;
            if (MappingReplaceMechanism.UNDERSCORES == mechanism) {
                finalName = finalName.replaceAll(" ", "_");
            } else if (MappingReplaceMechanism.CAMELCASE == mechanism && (nameCase != MappingNameCase.DEFAULT || dataSource.getSQLDialect().storesUnquotedCase() != DBPIdentifierCase.UPPER) && nameCase != MappingNameCase.UPPER && CommonUtils.isNotEmpty((String)(camelCaseName = CommonUtils.toCamelCase((String)finalName)))) {
                finalName = camelCaseName.replaceAll(" ", "");
            }
        }
        if (CommonUtils.isNotEmpty((String)finalName)) {
            return DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)finalName);
        }
        log.debug((Object)"Can't transform target attribute name");
        return targetName;
    }

    private static void getTableFullName(@Nullable DBSObjectContainer schema, @NotNull DBPDataSource dataSource, @NotNull StringBuilder sql, @NotNull String tableName) {
        if (schema instanceof DBSSchema || schema instanceof DBSCatalog) {
            sql.append(DBUtils.getFullyQualifiedName((DBPDataSource)dataSource, (String[])new String[]{schema.getName(), tableName}));
        } else {
            sql.append(DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)tableName));
        }
    }

    @NotNull
    private static SQLObjectEditor<DBSEntity, ?> getTableManager(DBERegistry editorsRegistry, Class<? extends DBSObject> tableClass) throws DBException {
        SQLObjectEditor tableManager = (SQLObjectEditor)editorsRegistry.getObjectManager(tableClass, SQLObjectEditor.class);
        if (tableManager == null) {
            throw new DBException("Table manager not found for '" + tableClass.getName() + "'");
        }
        return tableManager;
    }

    @NotNull
    private static Class<? extends DBSObject> getTableClass(DBRProgressMonitor monitor, DBSObjectContainer schema) throws DBException {
        Class tableClass = schema.getPrimaryChildType(monitor);
        if (!DBSEntity.class.isAssignableFrom(tableClass)) {
            throw new DBException("Wrong table container child type: " + tableClass.getName());
        }
        return tableClass;
    }

    @NotNull
    public static DBSEntity generateStructTableDDL(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull DBSObjectContainer schema, @NotNull DatabaseMappingContainer containerMapping, @NotNull List<DBEPersistAction> actions, @Nullable Map<DBPPropertyDescriptor, Object> changedProperties) throws DBException {
        DBERegistry editorsRegistry = DBWorkbench.getPlatform().getEditorsRegistry();
        try {
            String tableFinalName;
            DBSEntity table;
            SQLObjectEditor attributeManager;
            Class attrClass;
            Class<? extends DBSObject> tableClass = DatabaseTransferUtils.getTableClass(monitor, schema);
            SQLObjectEditor<DBSEntity, ?> tableManager = DatabaseTransferUtils.getTableManager(editorsRegistry, tableClass);
            if (!tableManager.canCreateObject((Object)schema)) {
                throw new DBException("Table create is not supported by driver " + schema.getDataSource().getContainer().getDriver().getName());
            }
            if (executionContext.getDataSource().getInfo().isDynamicMetadata()) {
                attrClass = null;
                attributeManager = null;
            } else {
                if (!(tableManager instanceof DBEStructEditor)) {
                    throw new DBException("Table create not supported by " + executionContext.getDataSource().getContainer().getDriver().getName());
                }
                Class[] childTypes = ((DBEStructEditor)tableManager).getChildTypes();
                attrClass = BeanUtils.findAssignableType((Class[])childTypes, DBSEntityAttribute.class);
                if (attrClass == null) {
                    throw new DBException("Column manager not found for '" + tableClass.getName() + "'");
                }
                attributeManager = (SQLObjectEditor)editorsRegistry.getObjectManager(attrClass, SQLObjectEditor.class);
            }
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("skip.object.configuration", true);
            TargetCommandContext commandContext = new TargetCommandContext(executionContext);
            SQLObjectEditor.ObjectCreateCommand createCommand = null;
            if (containerMapping.getMappingType() == DatabaseMappingType.create || containerMapping.getMappingType() == DatabaseMappingType.recreate && containerMapping.getTarget() == null) {
                table = (DBSEntity)tableManager.createNewObject(monitor, (DBECommandContext)commandContext, (Object)schema, null, options);
                DatabaseTransferUtils.applyPropertyChanges(monitor, changedProperties, (DBECommandContext)commandContext, containerMapping, table);
                tableFinalName = DatabaseTransferUtils.getTableFinalName(containerMapping.getTargetName(), tableClass, table, true);
                createCommand = tableManager.makeCreateCommand((DBSObject)table, options);
            } else {
                table = (DBSEntity)containerMapping.getTarget();
                if (table == null) {
                    throw new DBException("Internal error - target table not set");
                }
                if (containerMapping.getMappingType() == DatabaseMappingType.recreate) {
                    tableManager.deleteObject((DBECommandContext)commandContext, (DBSObject)table, options);
                    table = (DBSEntity)tableManager.createNewObject(monitor, (DBECommandContext)commandContext, (Object)table.getParentObject(), null, options);
                    DatabaseTransferUtils.applyPropertyChanges(monitor, changedProperties, (DBECommandContext)commandContext, containerMapping, table);
                    tableFinalName = DatabaseTransferUtils.getTableFinalName(containerMapping.getTargetName(), tableClass, table, false);
                    createCommand = tableManager.makeCreateCommand((DBSObject)table, options);
                } else {
                    tableFinalName = table.getName();
                }
            }
            if (attributeManager != null) {
                for (DatabaseMappingAttribute attributeMapping : containerMapping.getAttributeMappings(monitor)) {
                    if (attributeMapping.getMappingType() != DatabaseMappingType.create) continue;
                    DBSEntityAttribute newAttribute = (DBSEntityAttribute)attributeManager.createNewObject(monitor, (DBECommandContext)commandContext, (Object)table, null, options);
                    if (!(newAttribute instanceof DBPNamedObject2)) {
                        throw new DBException("Table column name cannot be set for " + attrClass.getName());
                    }
                    ((DBPNamedObject2)newAttribute).setName(DatabaseTransferUtils.getTransformedName(newAttribute.getDataSource(), attributeMapping.getTargetName(), false));
                    if (newAttribute instanceof DBSTypedObjectExt2) {
                        DBSAttributeBase sourceAttr;
                        DBSTypedObjectExt2 typedAttr = (DBSTypedObjectExt2)newAttribute;
                        boolean typeModifiersSet = false;
                        if (typedAttr instanceof DBSTypedObjectExt3) {
                            String fullTargetTypeName = attributeMapping.getTargetType(executionContext.getDataSource(), true);
                            typeModifiersSet = fullTargetTypeName.contains("(");
                            ((DBSTypedObjectExt3)typedAttr).setFullTypeName(fullTargetTypeName);
                        } else {
                            String targetAttrType = attributeMapping.getTargetType(executionContext.getDataSource(), false);
                            typedAttr.setTypeName(targetAttrType);
                        }
                        if (!typeModifiersSet && (sourceAttr = attributeMapping.getSource()) != null) {
                            typedAttr.setMaxLength(sourceAttr.getMaxLength());
                            typedAttr.setPrecision(sourceAttr.getPrecision());
                            typedAttr.setScale(sourceAttr.getScale());
                            typedAttr.setRequired(sourceAttr.isRequired());
                        }
                    }
                    SQLObjectEditor.ObjectCreateCommand attrCreateCommand = attributeManager.makeCreateCommand((DBSObject)newAttribute, options);
                    if (!(createCommand instanceof DBECommandAggregator)) continue;
                    ((DBECommandAggregator)createCommand).aggregateCommand((DBECommand)attrCreateCommand);
                }
            }
            containerMapping.setTargetName(tableFinalName);
            actions.addAll(DBExecUtils.getActionsListFromCommandContext((DBRProgressMonitor)monitor, (DBECommandContext)commandContext, (DBCExecutionContext)executionContext, options, null));
            return table;
        }
        catch (DBException e) {
            throw new DBException("Can't create or modify target table", (Throwable)e);
        }
    }

    public static void applyPropertyChanges(@Nullable DBRProgressMonitor monitor, @Nullable Map<DBPPropertyDescriptor, Object> changedProperties, @Nullable DBECommandContext commandContext, @Nullable DatabaseMappingContainer containerMapping, @NotNull DBSEntity table) {
        PropertySourceEditable propertySource = new PropertySourceEditable(commandContext, (Object)table, (Object)table);
        if (CommonUtils.isEmpty(changedProperties) && containerMapping != null && !CommonUtils.isEmpty(containerMapping.getRawChangedPropertiesMap())) {
            propertySource.collectProperties();
            Map<String, Object> rawChangedPropertiesMap = containerMapping.getRawChangedPropertiesMap();
            for (Map.Entry<String, Object> entry : rawChangedPropertiesMap.entrySet()) {
                DBPPropertyDescriptor property = propertySource.getProperty(entry.getKey());
                if (property == null) continue;
                propertySource.addChangedProperties(property, entry.getValue());
            }
            changedProperties = propertySource.getChangedPropertiesValues();
        }
        if (!CommonUtils.isEmpty(changedProperties)) {
            for (Map.Entry<DBPPropertyDescriptor, Object> entry : changedProperties.entrySet()) {
                propertySource.setPropertyValue(monitor, (Object)table, (ObjectPropertyDescriptor)entry.getKey(), entry.getValue());
            }
        }
    }

    private static String getTableFinalName(String targetName, @NotNull Class<? extends DBSObject> tableClass, DBSEntity table, boolean extraTransform) throws DBException {
        if (table == null) {
            throw new DBException("Internal error - target table not set");
        }
        if (table.getDataSource() == null) {
            return targetName;
        }
        String tableFinalName = extraTransform ? DatabaseTransferUtils.getTransformedName(table.getDataSource(), targetName, false) : DBObjectNameCaseTransformer.transformName((DBPDataSource)table.getDataSource(), (String)targetName);
        if (!(table instanceof DBPNamedObject2)) {
            throw new DBException("Table name cannot be set for " + tableClass.getName());
        }
        ((DBPNamedObject2)table).setName(tableFinalName);
        return tableFinalName;
    }

    @NotNull
    static DBEPersistAction generateTargetAttributeDDL(DBPDataSource dataSource, DatabaseMappingAttribute attribute) {
        StringBuilder sql = new StringBuilder(500);
        sql.append("ALTER TABLE ").append(DBUtils.getObjectFullName((DBPNamedObject)attribute.getParent().getTarget(), (DBPEvaluationContext)DBPEvaluationContext.DDL)).append(" ADD ");
        DatabaseTransferUtils.appendAttributeClause(dataSource, sql, attribute);
        return new SQLDatabasePersistAction(sql.toString());
    }

    private static void appendAttributeClause(DBPDataSource dataSource, StringBuilder sql, DatabaseMappingAttribute attr) {
        String attrName = DatabaseTransferUtils.getTransformedName(dataSource, attr.getTargetName(), false);
        sql.append(DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)attrName)).append(" ").append(attr.getTargetType(dataSource, true));
        if (SQLUtils.getDialectFromDataSource((DBPDataSource)dataSource).supportsNullability() && attr.getSource().isRequired()) {
            sql.append(" NOT NULL");
        }
    }

    public static void executeDDL(DBCSession session, DBEPersistAction[] actions) throws DBCException {
        if (actions.length == 0) {
            return;
        }
        DatabaseTransferUtils.ensureHasEditMetadataPermission(session.getDataSource().getContainer());
        DBExecUtils.executePersistActions((DBCSession)session, (DBEPersistAction[])actions);
        DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)session.getExecutionContext());
        if (txnManager != null && txnManager.isSupportsTransactions() && !txnManager.isAutoCommit()) {
            txnManager.commit(session);
        }
    }

    static void createTargetDynamicTable(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull DBSObjectContainer schema, @NotNull DatabaseMappingContainer containerMapping, boolean recreate) throws DBException {
        DBSObject targetEntity;
        DatabaseTransferUtils.ensureHasEditMetadataPermission(executionContext.getDataSource().getContainer());
        DBERegistry editorsRegistry = DBWorkbench.getPlatform().getEditorsRegistry();
        Class<? extends DBSObject> tableClass = DatabaseTransferUtils.getTableClass(monitor, schema);
        SQLObjectEditor<DBSEntity, ?> tableManager = DatabaseTransferUtils.getTableManager(editorsRegistry, tableClass);
        TargetCommandContext commandContext = new TargetCommandContext(executionContext);
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("skip.object.configuration", true);
        if (recreate && containerMapping.getTarget() != null) {
            tableManager.deleteObject((DBECommandContext)commandContext, (DBSObject)containerMapping.getTarget(), options);
            commandContext.saveChanges(monitor, options);
        }
        if ((targetEntity = tableManager.createNewObject(monitor, (DBECommandContext)commandContext, (Object)schema, null, options)) == null) {
            throw new DBException("Null target entity returned");
        }
        if (!(targetEntity instanceof DBPNamedObject2)) {
            throw new DBException("Can not set name for target entity '" + targetEntity.getClass().getName() + "'");
        }
        ((DBPNamedObject2)targetEntity).setName(containerMapping.getTargetName());
        commandContext.saveChanges(monitor, options);
    }

    public static Pair<DBPDataKind, String> getDataType(String value) {
        if (CommonUtils.isEmpty((String)value)) {
            return DATA_TYPE_UNKNOWN;
        }
        char firstChar = value.charAt(0);
        if (Character.isDigit(firstChar) || firstChar == '+' || firstChar == '-' || firstChar == '.') {
            try {
                Long.parseLong(value);
                return DATA_TYPE_INTEGER;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Double.parseDouble(value);
                    return DATA_TYPE_REAL;
                }
                catch (NumberFormatException numberFormatException2) {}
            }
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            return DATA_TYPE_BOOLEAN;
        }
        return DATA_TYPE_STRING;
    }

    private static void ensureHasEditMetadataPermission(@NotNull DBPDataSourceContainer container) throws DBCException {
        if (!container.hasModifyPermission(DBPDataSourcePermission.PERMISSION_EDIT_METADATA)) {
            throw new DBCException("New table creation in database [" + container.getName() + "] restricted by connection configuration");
        }
    }

    private static /* synthetic */ DBEPersistAction[] lambda$0(int n) {
        return new DBEPersistAction[n];
    }

    static class TargetCommandContext
    extends AbstractCommandContext {
        TargetCommandContext(DBCExecutionContext executionContext) {
            super(executionContext, true);
        }
    }
}

