/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.extension.datafeed;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.StringTokenizer;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.text.ParseException;
import java.util.Date;
import java.util.Vector;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.datafeed.DataSetAdapter;
import org.eclipse.birt.chart.datafeed.IResultSetDataSet;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.extension.datafeed.GanttEntry;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.impl.GanttDataSetImpl;
import org.eclipse.birt.chart.util.CDateTime;

public final class GanttDataSetProcessorImpl
extends DataSetAdapter {
    public final DataSet populate(Object oResultSetDef, DataSet ds) throws ChartException {
        if (oResultSetDef instanceof IResultSetDataSet) {
            IResultSetDataSet rsds = (IResultSetDataSet)oResultSetDef;
            long lRowCount = rsds.getSize();
            if (lRowCount <= 0L) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 16, "exception.empty.dataset", Messages.getResourceBundle(this.getULocale()));
            }
            int i = 0;
            GanttEntry[] gea = new GanttEntry[(int)lRowCount];
            while (rsds.hasNext()) {
                Object[] oThreeComponents = rsds.next();
                this.validateGanttEntryData(oThreeComponents);
                gea[i++] = new GanttEntry(oThreeComponents);
            }
            if (ds == null) {
                ds = GanttDataSetImpl.create((Object)gea);
            } else {
                ds.setValues((Object)gea);
            }
        } else {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.unknown.custom.dataset", new Object[]{ds, oResultSetDef}, Messages.getResourceBundle(this.getULocale()));
        }
        return ds;
    }

    private void validateGanttEntryData(Object[] obja) throws ChartException {
        boolean valid = true;
        if (obja == null) {
            valid = false;
        } else {
            if (obja.length != 3) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.dataset.ganttseries", Messages.getResourceBundle(this.getULocale()));
            }
            int i = 0;
            while (i < obja.length - 1) {
                if (obja[i] != null && !(obja[i] instanceof CDateTime)) {
                    valid = false;
                    break;
                }
                ++i;
            }
        }
        if (!valid) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 30, "exception.dataset.invalid.ganttentry", Messages.getResourceBundle(this.getULocale()));
        }
    }

    public final Object getMinimum(DataSet ds) throws ChartException {
        DataSetIterator dsi = null;
        try {
            dsi = new DataSetIterator(ds);
            dsi.reset();
        }
        catch (IllegalArgumentException uiex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, (Throwable)uiex);
        }
        if (dsi.size() == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.empty.dataset", Messages.getResourceBundle(this.getULocale()));
        }
        CDateTime[] cala = new CDateTime[2];
        CDateTime calMin = null;
        while (dsi.hasNext()) {
            GanttEntry gde = (GanttEntry)dsi.next();
            if (gde == null) continue;
            cala[0] = gde.getStart();
            cala[1] = gde.getEnd();
            int j = 0;
            while (j < 2) {
                if (cala[j] != null) {
                    if (calMin != null) {
                        if (calMin.after((Object)cala[j])) {
                            calMin = cala[j];
                        }
                    } else if (cala[j] != null) {
                        calMin = cala[j];
                    }
                }
                ++j;
            }
        }
        return calMin;
    }

    public final Object getMaximum(DataSet ds) throws ChartException {
        DataSetIterator dsi = null;
        try {
            dsi = new DataSetIterator(ds);
            dsi.reset();
        }
        catch (IllegalArgumentException uiex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, (Throwable)uiex);
        }
        if (dsi.size() == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.empty.dataset", Messages.getResourceBundle(this.getULocale()));
        }
        CDateTime[] cala = new CDateTime[2];
        CDateTime calMax = null;
        while (dsi.hasNext()) {
            GanttEntry gde = (GanttEntry)dsi.next();
            if (gde == null) continue;
            cala[0] = gde.getStart();
            cala[1] = gde.getEnd();
            int j = 0;
            while (j < 2) {
                if (cala[j] != null) {
                    if (calMax != null) {
                        if (calMax.before((Object)cala[j])) {
                            calMax = cala[j];
                        }
                    } else if (cala[j] != null) {
                        calMax = cala[j];
                    }
                }
                ++j;
            }
        }
        return calMax;
    }

    public final DataSet fromString(String sDataSetRepresentation, DataSet ds) throws ChartException {
        if (sDataSetRepresentation == null) {
            return ds;
        }
        if (ds == null) {
            ds = GanttDataSetImpl.create(null);
        }
        StringTokenizer strTokDataElement = new StringTokenizer(sDataSetRepresentation, ",");
        StringTokenizer strTokComponents = null;
        String strDataElement = null;
        String strComponent = null;
        Vector<GanttEntry> vData = new Vector<GanttEntry>();
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy", ULocale.getDefault());
        int i = 1;
        while (strTokDataElement.hasMoreTokens()) {
            strDataElement = strTokDataElement.nextToken().trim();
            strTokComponents = new StringTokenizer(strDataElement);
            if (strTokComponents.countTokens() == 1) {
                Date startElement = null;
                try {
                    startElement = sdf.parse(strDataElement);
                }
                catch (ParseException parseException) {
                    startElement = Calendar.getInstance((TimeZone)TimeZone.getDefault()).getTime();
                }
                Date endElement = new Date(startElement.getTime() + startElement.getTime() / 20L);
                vData.add(new GanttEntry(new CDateTime(startElement), new CDateTime(endElement), "Label" + i));
                ++i;
                continue;
            }
            GanttEntry entry = new GanttEntry(null, null, null);
            while (strTokComponents.hasMoreTokens()) {
                strComponent = strTokComponents.nextToken().trim();
                try {
                    Date dateComponent;
                    if (strComponent.toUpperCase().startsWith("S")) {
                        dateComponent = sdf.parse(strComponent.substring(1));
                        entry.setStart(new CDateTime(dateComponent));
                        continue;
                    }
                    if (strComponent.toUpperCase().startsWith("E")) {
                        dateComponent = sdf.parse(strComponent.substring(1));
                        entry.setEnd(new CDateTime(dateComponent));
                        continue;
                    }
                    entry.setLabel(strComponent);
                }
                catch (ParseException parseException) {}
            }
            vData.add(entry);
        }
        ds.setValues(vData);
        return ds;
    }

    public String getExpectedStringFormat() {
        return Messages.getString("info.gantt.sample.format", this.getULocale());
    }

    public String toString(Object[] columnData) throws ChartException {
        if (columnData == null || columnData.length == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.base.orthogonal.null.datadefinition", Messages.getResourceBundle(this.getULocale()));
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < columnData.length) {
            if (columnData[i] == null) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.base.orthogonal.null.datadefinition", Messages.getResourceBundle(this.getULocale()));
            }
            if (columnData[i] instanceof Object[]) {
                buffer.append(this.toGanttString((Object[])columnData[i]));
            }
            if (i < columnData.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        return buffer.toString();
    }

    private StringBuffer toGanttString(Object[] ganttArray) throws ChartException {
        if (ganttArray.length != 3 || ganttArray[0] == null) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "Invalid data set column");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("S" + String.valueOf(ganttArray[0]) + " ");
        buffer.append("E" + String.valueOf(ganttArray[1]) + " ");
        buffer.append(String.valueOf(ganttArray[2]));
        return buffer;
    }

    public int[] getDataDefIdsForGrouping(Series series) {
        int[] nArray = new int[2];
        nArray[1] = 1;
        return nArray;
    }
}

